# テスト方針書

## 概要

本ドキュメントは、SQLiteデータベースエンジンのソースコードリポジトリにおけるテスト方針について記載する。SQLiteは世界で最も広く使用されているデータベースエンジンであり、高い信頼性と安定性を確保するために、包括的かつ多層的なテスト戦略を採用している。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のSQL文、関数、モジュールの動作検証 | 開発者 (TCLテストスクリプト) |
| 結合テスト | 複数モジュール間の連携、トランザクション、WAL等の統合検証 | 開発者 (testfixtureによる自動テスト) |
| システムテスト | SQLiteライブラリ全体の機能検証、異常系・境界値テスト | 開発者 (releasetest、fulltest) |
| 受入テスト | リリース前の包括的テスト、全プラットフォーム互換性検証 | リリースマネージャー |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | SQL文法、API、拡張機能の機能検証 (約1,185件の.testファイル) | 開発時・CI |
| 性能テスト | speedtest.md記載のパフォーマンス測定、speed1-4テスト | リリース前 |
| セキュリティテスト | ファジングテスト (fuzzcheck、dbsqlfuzz)、不正入力耐性検証 | CI・継続的実施 |
| 回帰テスト | 過去のバグ修正確認 (tkt*.testファイル) | 全テスト実行時 |
| メモリテスト | mallocテスト、メモリリーク検出、Valgrindによる検証 | CI・リリース前 |
| I/Oエラーテスト | ioerr*.test、ディスク障害シミュレーション | CI |
| 並行性テスト | thread*.test、マルチスレッド/マルチプロセス検証 | CI |
| 破損データテスト | corrupt*.test、データベース破損からの復旧検証 | CI |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| Unix/Linux | 主要開発・テスト環境 | GCC/Clang + TCL 8.5以上 |
| Windows | クロスプラットフォーム検証 | MSVC + TCL |
| macOS | クロスプラットフォーム検証 | Clang + TCL |
| Valgrind環境 | メモリエラー検出 | valgrind + testfixture |
| WASI SDK | WebAssemblyビルド検証 | wasi-sdk |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| TCL (tclsh) | テストスクリプト実行エンジン | 8.5以上推奨 |
| testfixture | SQLite拡張TCLインタプリタ | ビルド生成 |
| fuzzcheck | ファジングテスト実行ツール | ビルド生成 |
| sessionfuzz | セッション拡張ファジングツール | ビルド生成 |
| Valgrind | メモリエラー・リーク検出 | システム提供 |
| Lemon | パーサージェネレータ (ビルドツール) | ソースツリー同梱 |
| JimTCL | 軽量TCL互換インタプリタ (autosetup用) | autosetup同梱 |
| testrunner.tcl | 並列テスト実行スクリプト | ソースツリー同梱 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 100%MC/DC (Modifiedコンディションカバレッジ) を目標 |
| 分岐カバレッジ | 100%MC/DC を目標 |
| API関数カバレッジ | 全公開API関数の網羅的テスト |
| SQL文法カバレッジ | 全SQL構文パターンの網羅的テスト |

SQLiteプロジェクトでは、商用航空ソフトウェアで要求されるレベルのテストカバレッジ (DO-178B) を目標としている。gcovオプションによるカバレッジ測定がMakefileでサポートされている。

## テストデータ

- **自動生成テストデータ**: TCLスクリプトにより動的に生成
- **ファジングテストデータ**: fuzzdata1.db〜fuzzdata8.dbとして事前準備
- **セッションファジングデータ**: sessionfuzz-data1.dbとして同梱
- **破損データベースサンプル**: corrupt*.testで使用される意図的に破損したDBファイル
- **境界値テストデータ**: boundary*.tclスクリプトで生成

## 不具合管理

- **バグトラッキング**: SQLite Fossil Forumによる報告・追跡
- **回帰テスト**: 修正されたバグごとにtkt-*.testまたはtkt[番号].testファイルを作成し、再発防止を確保
- **リリースノート**: 各バージョンのリリースノートに修正内容を記載

## CI/CD連携

### テストターゲット (Makefileベース)

| ターゲット | 説明 | 実行時間目安 |
| --- | --- | --- |
| `make devtest` | 開発者向け標準テスト (チェックイン前必須) | 数分〜十数分 |
| `make quicktest` | 最小限の高速テスト (extraquick.test) | 3分以内 |
| `make tcltest` | veryquick.testによるTCLテスト | 数分 |
| `make test` | 標準テスト (srctree-check + fuzztest + sourcetest + tcltest) | 十数分 |
| `make fulltest` | 全テスト (alltest + fuzztest) | 数時間 |
| `make releasetest` | リリース用包括テスト | 数時間〜1日以上 |
| `make fuzztest` | ファジングテストのみ | 数分〜数十分 |
| `make valgrindtest` | Valgrindによるメモリ検証テスト | 数時間以上 |
| `make smoketest` | 最小限のサニティチェック (main.test) | 数秒〜1分 |

### テストスイート (permutations.test)

| スイート名 | 説明 |
| --- | --- |
| full | 全テスト実行 |
| veryquick | 高速テスト (malloc/ioerr/fault系を除外) |
| quick | 標準テスト |
| no_optimization | 最適化無効での検証 |
| memsubsys1/2 | メモリサブシステムテスト |
| singlethread/multithread | スレッドモードテスト |
| utf16 | UTF-16エンコーディングテスト |
| exclusive | 排他ロックモードテスト |
| wal (mmap) | WALモードテスト |
| autovacuum_* | 自動バキュームテスト |
| pcache0/10/50/90/100 | ページキャッシュサイズ別テスト |

### 実行方法

```bash
# 開発者向けテスト (チェックイン前に実施)
make devtest

# 並列テスト実行
./testfixture test/testrunner.tcl

# 個別テストファイルの実行
./testfixture test/select1.test

# 特定のテストスイート実行
./testfixture test/permutations.test veryquick
```

## 備考

- SQLiteは2000年以降、継続的にテストスイートを拡張しており、現時点で約1,185件のTCLテストファイルが存在する
- テストコードはソースコードの数倍の規模があるとされ、品質保証に多大なリソースを投入している
- Fossilバージョン管理システムと連携し、ソースの真正性検証 (`make verify-source`) もテストプロセスに含まれる
- JimTCLを含むautosetupにより、TCLが未インストールの環境でも基本的なビルドは可能だが、テスト実行にはTCL 8.5以上が必要
- 拡張機能 (FTS3/4/5、RTree、Session、RBU等) は個別のテストディレクトリにテストファイルを持つ
