# ER図

## SQLiteシステムテーブル ER図

本ドキュメントはSQLiteデータベースエンジンの内部システムテーブルおよび拡張機能シャドウテーブル間の関係を示すER図である。

## 1. コアシステムテーブル

```mermaid
erDiagram
    sqlite_schema {
        text type "オブジェクト種類"
        text name "オブジェクト名"
        text tbl_name "関連テーブル名"
        integer rootpage "ルートページ番号"
        text sql "CREATE文"
    }

    sqlite_temp_schema {
        text type "オブジェクト種類"
        text name "オブジェクト名"
        text tbl_name "関連テーブル名"
        integer rootpage "ルートページ番号"
        text sql "CREATE文"
    }

    sqlite_sequence {
        text name PK "テーブル名"
        integer seq "最大ROWID値"
    }

    USER_TABLE {
        integer rowid PK "行ID"
        any columns "ユーザー定義カラム"
    }

    sqlite_schema ||--o{ USER_TABLE : "定義"
    sqlite_sequence ||--o| USER_TABLE : "AUTOINCREMENT追跡"
```

## 2. 統計情報テーブル

```mermaid
erDiagram
    sqlite_stat1 {
        text tbl "テーブル名"
        text idx "インデックス名"
        text stat "統計情報"
    }

    sqlite_stat4 {
        text tbl "テーブル名"
        text idx "インデックス名"
        text neq "一致エントリ数"
        text nlt "より小さいエントリ数"
        text ndlt "異なる小エントリ数"
        blob sample "サンプルキー"
    }

    USER_TABLE {
        integer rowid PK "行ID"
    }

    USER_INDEX {
        text name PK "インデックス名"
    }

    USER_TABLE ||--o{ sqlite_stat1 : "統計対象"
    USER_INDEX ||--o{ sqlite_stat1 : "統計対象"
    USER_TABLE ||--o{ sqlite_stat4 : "詳細統計対象"
    USER_INDEX ||--o{ sqlite_stat4 : "詳細統計対象"
```

## 3. dbstat仮想テーブル

```mermaid
erDiagram
    dbstat {
        text name "テーブル/インデックス名"
        text path "ページパス"
        integer pageno "ページ番号"
        text pagetype "ページ種類"
        integer ncell "セル数"
        integer payload "ペイロードバイト数"
        integer unused "未使用バイト数"
        integer mx_payload "最大ペイロード"
        integer pgoffset "ファイルオフセット"
        integer pgsize "ページサイズ"
    }

    USER_TABLE {
        integer rowid PK "行ID"
    }

    USER_INDEX {
        text name PK "インデックス名"
    }

    dbstat ||--o{ USER_TABLE : "ストレージ情報提供"
    dbstat ||--o{ USER_INDEX : "ストレージ情報提供"
```

## 4. FTS3/4 全文検索テーブル

```mermaid
erDiagram
    FTS_VIRTUAL_TABLE {
        integer docid PK "文書ID"
        text content "検索対象コンテンツ"
    }

    FTS_content {
        integer docid PK "文書ID"
        text c0column "カラム0"
        text c1column "カラム1"
    }

    FTS_segments {
        integer blockid PK "ブロックID"
        blob block "セグメントデータ"
    }

    FTS_segdir {
        integer level PK "レベル"
        integer idx PK "インデックス"
        integer start_block "開始ブロック"
        integer leaves_end_block "リーフ終了ブロック"
        integer end_block "終了ブロック"
        blob root "ルートノード"
    }

    FTS_docsize {
        integer docid PK "文書ID"
        blob size "サイズ情報"
    }

    FTS_VIRTUAL_TABLE ||--|| FTS_content : "コンテンツ格納"
    FTS_VIRTUAL_TABLE ||--o{ FTS_segments : "インデックス格納"
    FTS_segdir ||--o{ FTS_segments : "セグメント管理"
    FTS_VIRTUAL_TABLE ||--|| FTS_docsize : "サイズ情報"
```

## 5. R-Tree 空間インデックステーブル

```mermaid
erDiagram
    RTREE_VIRTUAL_TABLE {
        integer id PK "行ID"
        real minX "X最小値"
        real maxX "X最大値"
        real minY "Y最小値"
        real maxY "Y最大値"
    }

    RTREE_node {
        integer nodeno PK "ノード番号"
        blob data "ノードデータ"
    }

    RTREE_parent {
        integer nodeno PK "ノード番号"
        integer parentnode FK "親ノード番号"
    }

    RTREE_rowid {
        integer rowid PK "行ID"
        integer nodeno FK "ノード番号"
    }

    RTREE_VIRTUAL_TABLE ||--|| RTREE_rowid : "行マッピング"
    RTREE_rowid }o--|| RTREE_node : "格納先"
    RTREE_node ||--o{ RTREE_parent : "親子関係"
    RTREE_parent }o--|| RTREE_node : "親ノード参照"
```

## 6. 全体関係図

```mermaid
erDiagram
    %% Core System Tables
    sqlite_schema {
        text type
        text name
        text tbl_name
        integer rootpage
        text sql
    }

    sqlite_sequence {
        text name PK
        integer seq
    }

    sqlite_stat1 {
        text tbl
        text idx
        text stat
    }

    sqlite_stat4 {
        text tbl
        text idx
        text neq
        text nlt
        text ndlt
        blob sample
    }

    %% User-defined objects
    USER_TABLE {
        integer rowid PK
    }

    %% Relationships
    sqlite_schema ||--o{ USER_TABLE : "テーブル定義"
    sqlite_sequence ||--o| USER_TABLE : "シーケンス追跡"
    sqlite_stat1 ||--o{ USER_TABLE : "基本統計"
    sqlite_stat4 ||--o{ USER_TABLE : "詳細統計"
```

## 備考

### ER図の凡例

- `PK`: 主キー（Primary Key）
- `FK`: 外部キー（Foreign Key）
- `||--||`: 1対1の関係
- `||--o{`: 1対多の関係
- `}o--||`: 多対1の関係
- `||--o|`: 1対0または1の関係

### 注意事項

1. **FTS/R-Treeシャドウテーブル**: `%`はユーザーが定義した仮想テーブル名に置換される。例えば、`CREATE VIRTUAL TABLE docs USING fts4(content)`の場合、`docs_content`, `docs_segments`などのシャドウテーブルが作成される。

2. **sqlite_schemaの特殊性**: sqlite_schemaはすべてのデータベースオブジェクトを定義するメタテーブルであり、他のすべてのテーブルはこのテーブルに定義が格納される。

3. **統計テーブルの生成タイミング**: sqlite_stat1およびsqlite_stat4は、ANALYZEコマンドが実行されたときにのみ作成・更新される。

4. **仮想テーブル**: dbstatは仮想テーブルであり、実際のデータを格納せず、クエリ時に動的に情報を生成する。
