---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **FTS5シャドウテーブル構造**：FTS5の詳細テーブル構造についてソースコード確認が限定的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/prepare.c` 行230-231 - sqlite_schemaテーブル定義
- E-02: `src/sqliteInt.h` 行1239-1242 - スキーマテーブル名定義（LEGACY_SCHEMA_TABLE, PREFERRED_SCHEMA_TABLE）
- E-03: `src/analyze.c` 行20-24 - sqlite_stat1/stat2/stat3/stat4テーブル定義コメント
- E-04: `src/analyze.c` 行176-183 - sqlite_stat1とsqlite_stat4のカラム定義
- E-05: `src/build.c` 行2923 - sqlite_sequence CREATE文
- E-06: `src/shell.c.in` 行3508 - sqlite_sequence構造確認
- E-07: `src/dbstat.c` 行68-83 - dbstat仮想テーブルスキーマ定義
- E-08: `ext/fts3/fts3.c` 行705-730 - FTS3シャドウテーブルCREATE文
- E-09: `ext/rtree/rtree.c` 行25-35 - R-Treeシャドウテーブル構造説明
- E-10: `ext/fts3/fts3.c` 行717-727 - FTS3 %_segdirテーブル構造
- E-11: `src/sqliteInt.h` 行1506 - sqlite_sequence参照
- E-12: `README.md` - プロジェクト概要
- E-13: `doc/trusted-schema.md` - スキーマセキュリティ関連ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite_schemaテーブルは5カラム（type, name, tbl_name, rootpage, sql）を持つ | E-01 | ○ |
| C-02 | sqlite_schemaとsqlite_masterは同一テーブルへのエイリアス | E-02 | ○ |
| C-03 | sqlite_temp_schemaとsqlite_temp_masterも同様のエイリアス関係 | E-02 | ○ |
| C-04 | sqlite_sequenceはname, seqの2カラムを持つ | E-05, E-06 | ○ |
| C-05 | sqlite_sequenceはAUTOINCREMENT使用時に自動作成される | E-05, E-11 | ○ |
| C-06 | sqlite_stat1はtbl, idx, statの3カラムを持つ | E-03, E-04 | ○ |
| C-07 | sqlite_stat4はtbl, idx, neq, nlt, ndlt, sampleの6カラムを持つ | E-03, E-04 | ○ |
| C-08 | sqlite_stat2/stat3は非推奨 | E-03 | ○ |
| C-09 | dbstat仮想テーブルは12カラム構造 | E-07 | ○ |
| C-10 | dbstatはSQLITE_ENABLE_DBSTAT_VTAB有効時に利用可能 | E-07 | ○ |
| C-11 | FTS3/4は%_contentテーブルを作成する | E-08 | ○ |
| C-12 | FTS3/4は%_segmentsテーブルを作成する | E-08 | ○ |
| C-13 | FTS3/4は%_segdirテーブルを作成する | E-08, E-10 | ○ |
| C-14 | FTS3/4は%_docsizeテーブルを作成する | E-08 | ○ |
| C-15 | %_segdirはlevel, idx, start_block, leaves_end_block, end_block, rootカラムを持つ | E-10 | ○ |
| C-16 | R-Treeは%_nodeテーブルを作成する | E-09 | ○ |
| C-17 | R-Treeは%_parentテーブルを作成する | E-09 | ○ |
| C-18 | R-Treeは%_rowidテーブルを作成する | E-09 | ○ |
| C-19 | %_nodeはnodeno, dataカラムを持つ | E-09 | ○ |
| C-20 | %_parentはnodeno, parentnodeカラムを持つ | E-09 | ○ |
| C-21 | %_rowidはrowid, nodenoカラムを持つ | E-09 | ○ |
| C-22 | R-Treeノードデータの先頭2バイトはルートノードでツリー深さを表す | E-09 | ○ |
| C-23 | ANALYZEコマンドでsqlite_statテーブルが生成される | E-03 | ○ |
| C-24 | sqlite_schemaは通常読み取り専用 | E-13 | ○ |
| C-25 | FTS5は%_data, %_content, %_docsize, %_configシャドウテーブルを使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- FTS5シャドウテーブル構造の詳細確認
  - 候補：`ext/fts5/fts5_storage.c` / FTS5関連ソースの詳細調査 / 公式ドキュメント参照

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - コアシステムテーブル（sqlite_schema, sqlite_sequence, sqlite_stat*）の定義は直接ソースコードから確認済み
- **0: 低リスク** - FTS3/4シャドウテーブル構造はCREATE文から直接確認済み
- **0: 低リスク** - R-Treeシャドウテーブル構造はソースコードコメントから確認済み
- **1: 中リスク** - FTS5シャドウテーブルについては間接的な確認のみ

## 6) レビュアーチェックリスト（最小）
- [ ] sqlite_schemaの5カラム構造が正確か確認
- [ ] sqlite_stat1/stat4のカラム定義が現行バージョンと一致するか確認
- [ ] FTS3/4シャドウテーブルのカラム定義が完全か確認
- [ ] FTS5シャドウテーブル構造について公式ドキュメントと照合
- [ ] R-Treeノードデータフォーマットの説明が正確か確認
- [ ] dbstat仮想テーブルのHIDDENカラム扱いが正しいか確認
