# データベース設計書

## 概要

本ドキュメントは、SQLiteデータベースエンジンが内部的に使用するシステムテーブル（メタデータテーブル）および拡張機能が生成するシャドウテーブルの構造を定義するものである。SQLiteはデータベースファイル内にスキーマ情報、統計情報、自動インクリメント情報などを格納するための複数のシステムテーブルを持つ。

## テーブル一覧

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| sqlite_schema (sqlite_master) | スキーマ情報 | データベース内のすべてのテーブル、インデックス、トリガー、ビューの定義を格納 |
| sqlite_temp_schema (sqlite_temp_master) | 一時スキーマ情報 | 一時データベース内のオブジェクト定義を格納 |
| sqlite_sequence | 自動インクリメント | AUTOINCREMENT属性を持つテーブルのシーケンス値を格納 |
| sqlite_stat1 | 統計情報（基本） | ANALYZE実行時に生成されるインデックス統計情報 |
| sqlite_stat4 | 統計情報（拡張） | SQLITE_ENABLE_STAT4有効時の詳細な統計情報 |
| dbstat | ストレージ情報 | データベースのページレベル情報を提供する仮想テーブル |
| FTS3/4 %_content | 全文検索コンテンツ | FTS3/4モジュールの文書コンテンツを格納 |
| FTS3/4 %_segments | 全文検索セグメント | FTS3/4モジュールのインデックスセグメントを格納 |
| FTS3/4 %_segdir | 全文検索セグメントディレクトリ | FTS3/4モジュールのセグメント管理情報を格納 |
| FTS3/4 %_docsize | 全文検索文書サイズ | FTS3/4モジュールの文書サイズ情報を格納 |
| R-Tree %_node | 空間インデックスノード | R-Treeモジュールのノードデータを格納 |
| R-Tree %_parent | 空間インデックス親子関係 | R-Treeモジュールのノード間親子関係を格納 |
| R-Tree %_rowid | 空間インデックスRowID | R-Treeモジュールの行IDとノードのマッピングを格納 |

## 各テーブル定義

### 1. sqlite_schema (sqlite_master)

データベースのスキーマ情報を格納するシステムテーブル。すべてのテーブル、インデックス、トリガー、ビューのSQL定義文が記録される。SQLite 3.33.0以降では`sqlite_schema`が推奨名称だが、後方互換性のため`sqlite_master`も引き続きサポートされる。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| type | TEXT | NO | オブジェクトの種類（'table', 'index', 'trigger', 'view'のいずれか） |
| name | TEXT | NO | オブジェクトの名前 |
| tbl_name | TEXT | NO | 関連するテーブルの名前（インデックスやトリガーの場合） |
| rootpage | INTEGER | NO | B-Treeのルートページ番号（トリガーやビューの場合は0） |
| sql | TEXT | YES | オブジェクトを作成したCREATE文 |

### 2. sqlite_temp_schema (sqlite_temp_master)

一時データベース（TEMP）内のスキーマ情報を格納するシステムテーブル。構造はsqlite_schemaと同一。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| type | TEXT | NO | オブジェクトの種類（'table', 'index', 'trigger', 'view'のいずれか） |
| name | TEXT | NO | オブジェクトの名前 |
| tbl_name | TEXT | NO | 関連するテーブルの名前 |
| rootpage | INTEGER | NO | B-Treeのルートページ番号 |
| sql | TEXT | YES | オブジェクトを作成したCREATE文 |

### 3. sqlite_sequence

AUTOINCREMENT属性を持つテーブルの最大ROWID値を追跡するためのテーブル。AUTOINCREMENTを使用するテーブルが初めて作成されたときに自動的に作成される。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | TEXT | NO | AUTOINCREMENT属性を持つテーブルの名前 |
| seq | INTEGER | NO | そのテーブルで使用された最大のROWID値 |

### 4. sqlite_stat1

ANALYZEコマンドによって生成されるインデックス統計情報テーブル。クエリプランナーが最適なインデックスを選択するために使用する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| tbl | TEXT | NO | テーブル名 |
| idx | TEXT | YES | インデックス名（NULLの場合はテーブル全体の行数を表す） |
| stat | TEXT | NO | 統計情報（スペース区切りの整数リスト） |

**stat カラムの形式:**
- 最初の整数: インデックス内の行数
- 2番目以降: 各カラムの平均重複数
- オプションで "unordered" キーワードを含む場合がある

### 5. sqlite_stat4

SQLITE_ENABLE_STAT4を有効にしてコンパイルした場合に使用される拡張統計情報テーブル。クエリプランナーがより正確な判断を行うためのヒストグラムデータを提供する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| tbl | TEXT | NO | テーブル名 |
| idx | TEXT | NO | インデックス名（tblと同じ場合はINTEGER PRIMARY KEY） |
| neq | TEXT | NO | サンプルと一致するエントリ数のリスト |
| nlt | TEXT | NO | サンプルより小さいエントリ数のリスト |
| ndlt | TEXT | NO | サンプルより小さい異なるエントリ数のリスト |
| sample | BLOB | NO | インデックスキーのバイナリエンコーディング |

### 6. dbstat 仮想テーブル

SQLITE_ENABLE_DBSTAT_VTABを有効にした場合に利用可能な仮想テーブル。データベースの低レベルストレージ情報を提供する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | TEXT | NO | テーブルまたはインデックスの名前 |
| path | TEXT | YES | ルートからページへのパス（集約時はNULL） |
| pageno | INTEGER | NO | ページ番号（集約時はページ数） |
| pagetype | TEXT | YES | 'internal', 'leaf', 'overflow', またはNULL |
| ncell | INTEGER | NO | ページ上のセル数（オーバーフローの場合は0） |
| payload | INTEGER | NO | このページ上のペイロードバイト数 |
| unused | INTEGER | NO | このページ上の未使用バイト数 |
| mx_payload | INTEGER | NO | 全セル中の最大ペイロードサイズ |
| pgoffset | INTEGER | YES | ファイル内のページオフセット（集約時はNULL） |
| pgsize | INTEGER | NO | ページサイズ（集約時は合計） |
| schema | TEXT | HIDDEN | 分析対象のデータベーススキーマ |
| aggregate | BOOLEAN | HIDDEN | 各テーブルの集約情報フラグ |

### 7. FTS3/4 %_content テーブル

FTS3/4全文検索モジュールが作成するシャドウテーブル。%はFTSテーブル名に置換される。元の文書コンテンツを格納する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| docid | INTEGER | NO | 文書ID（PRIMARY KEY） |
| c0{column_name} | TEXT | YES | 最初のコンテンツカラム |
| c1{column_name} | TEXT | YES | 2番目のコンテンツカラム（存在する場合） |
| ... | ... | ... | 以降、FTSテーブル定義のカラム数分続く |

### 8. FTS3/4 %_segments テーブル

FTS3/4の全文検索インデックスセグメントを格納するシャドウテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| blockid | INTEGER | NO | ブロックID（PRIMARY KEY） |
| block | BLOB | YES | セグメントデータ |

### 9. FTS3/4 %_segdir テーブル

FTS3/4のセグメントディレクトリ情報を格納するシャドウテーブル。各セグメントのメタデータを管理する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| level | INTEGER | NO | セグメントのレベル |
| idx | INTEGER | NO | レベル内のインデックス |
| start_block | INTEGER | NO | 開始ブロックID |
| leaves_end_block | INTEGER | NO | リーフ終了ブロックID |
| end_block | INTEGER | NO | 終了ブロックID |
| root | BLOB | YES | ルートノードデータ |

**PRIMARY KEY:** (level, idx)

### 10. FTS3/4 %_docsize テーブル

FTS3/4で各文書のサイズ情報を格納するシャドウテーブル。matchinfo()関数などで使用される。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| docid | INTEGER | NO | 文書ID（PRIMARY KEY） |
| size | BLOB | YES | 文書サイズ情報（varintエンコード） |

### 11. R-Tree %_node テーブル

R-Tree空間インデックスモジュールが作成するシャドウテーブル。R-Treeノードのデータを格納する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| nodeno | INTEGER | NO | ノード番号（PRIMARY KEY） |
| data | BLOB | YES | ノードデータ（バイナリフォーマット） |

**データフォーマット:**
- 最初の2バイト: ルートノードの場合はツリーの深さ、それ以外は未使用
- 次の2バイト: ノード内のエントリ数
- 残り: エントリデータ（8バイト整数 + 座標データ）

### 12. R-Tree %_parent テーブル

R-Treeモジュールのノード間親子関係を格納するシャドウテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| nodeno | INTEGER | NO | ノード番号（PRIMARY KEY） |
| parentnode | INTEGER | YES | 親ノード番号 |

### 13. R-Tree %_rowid テーブル

R-Treeモジュールで行IDとノードのマッピングを格納するシャドウテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| rowid | INTEGER | NO | 行ID（PRIMARY KEY） |
| nodeno | INTEGER | NO | 格納先ノード番号 |
| ... | ... | ... | 補助カラムがある場合は追加される |

## 備考

### システムテーブルの特性

1. **読み取り専用性**: sqlite_schemaテーブルは通常は読み取り専用であり、PRAGMA writable_schemaを有効にしない限り直接変更できない

2. **自動管理**: sqlite_sequenceとsqlite_stat*テーブルはSQLiteエンジンによって自動的に管理される

3. **仮想テーブル**: dbstatは仮想テーブルであり、実データは格納せず動的に情報を生成する

### 拡張機能のシャドウテーブル

1. **FTS3/4**: 全文検索機能は%_content, %_segments, %_segdir, %_docsizeの4種類のシャドウテーブルを使用する（%はユーザー定義のFTSテーブル名）

2. **FTS5**: FTS5は異なるシャドウテーブル構造を使用する（%_data, %_content, %_docsize, %_config）

3. **R-Tree**: 空間インデックス機能は%_node, %_parent, %_rowidの3種類のシャドウテーブルを使用する

### 互換性

- `sqlite_schema`と`sqlite_master`は同一テーブルへのエイリアスである
- `sqlite_temp_schema`と`sqlite_temp_master`も同様のエイリアス関係にある
- sqlite_stat2とsqlite_stat3は非推奨であり、現行バージョンでは使用されない
