---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `make.bat`
- E-02: `tool/build-all-msvc.bat`
- E-03: `tool/GetTclKit.bat`
- E-04: `tool/build-shell.sh`
- E-05: `tool/mkautoconfamal.sh`
- E-06: `tool/warnings.sh`
- E-07: `tool/warnings-clang.sh`
- E-08: `tool/symbols.sh`
- E-09: `tool/symbols-mingw.sh`
- E-10: `tool/cktclsh.sh`
- E-11: `tool/tclConfigShToMake.sh`
- E-12: `ext/wasm/mkdist.sh`
- E-13: `ext/wasm/split-speedtest1-script.sh`
- E-14: `test/run-wordcount.sh`
- E-15: `test/time-wordcount.sh`
- E-16: `ext/fts3/tool/fts3cov.sh`
- E-17: `test/json/json-speed-check.sh`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | make.batはMSVCでのnmakeビルド実行バッチ | E-01 | ○ |
| C-02 | build-all-msvc.batはMSVCマルチプラットフォームビルドツール | E-02 | ○ |
| C-03 | GetTclKit.batはTclKitダウンロードツール | E-03 | ○ |
| C-04 | build-shell.shはsqlite3コマンドラインシェルのフルビルド用 | E-04 | ○ |
| C-05 | mkautoconfamal.shはautoconf用アマルガメーションパッケージ作成スクリプト | E-05 | ○ |
| C-06 | warnings.shはgccを使用したコンパイラ警告チェック | E-06 | ○ |
| C-07 | warnings-clang.shはClang静的解析による警告チェック | E-07 | ○ |
| C-08 | symbols.shはエクスポートシンボル検証スクリプト | E-08 | ○ |
| C-09 | symbols-mingw.shはMinGW環境でのシンボル検証スクリプト | E-09 | ○ |
| C-10 | cktclsh.shはTclシェルバージョンチェック用 | E-10 | ○ |
| C-11 | tclConfigShToMake.shはtclConfig.shからMakefile変数を抽出 | E-11 | ○ |
| C-12 | mkdist.shはWASM配布パッケージ作成スクリプト | E-12 | ○ |
| C-13 | split-speedtest1-script.shはspeedtest1出力分割ツール | E-13 | ○ |
| C-14 | run-wordcount.shはwordcountプログラムテスト実行スクリプト | E-14 | ○ |
| C-15 | time-wordcount.shはwordcountパフォーマンス計測スクリプト | E-15 | ○ |
| C-16 | fts3cov.shはFTS3コードカバレッジ測定スクリプト | E-16 | ○ |
| C-17 | json-speed-check.shはJSONパフォーマンスチェックスクリプト | E-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべてのバッチ/スクリプトファイルの内容を直接確認し、根拠を取得した。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] カテゴリ分類（ビルド/テスト/品質検証/パッケージング/ユーティリティ/環境構築）が適切か確認
- [ ] 各バッチの説明がソースコード内のコメントと整合しているか確認
- [ ] プロジェクト内に他のバッチ/スクリプトファイルが存在しないか確認（.claude/code-to-docs.shは除外済み）
