# バッチ設計書 10-cktclsh.sh

## 概要

本ドキュメントは、SQLiteプロジェクトにおけるTclシェルバージョンチェックスクリプト（cktclsh.sh）の設計仕様を記述したものである。

### 本バッチの処理概要

cktclsh.shは、指定されたTclシェル（tclsh）が必要なバージョン以上であるかを確認するユーティリティスクリプトである。SQLiteのビルドプロセスで使用される前提条件チェックとして機能する。

**業務上の目的・背景**：SQLiteのビルドプロセス（特にアマルガメーション生成やテスト実行）では、特定バージョン以上のTclシェルが必要となる場合がある。バージョンが不足している場合、ビルドが失敗したり予期しない挙動を示す可能性がある。このスクリプトにより、ビルド開始前にTclのバージョン要件を検証し、問題を早期に検出できる。

**バッチの実行タイミング**：Makefile等から呼び出されることを想定。特定のビルドターゲットの前提条件チェックとして使用。

**主要な処理内容**：
1. 一時的なTclスクリプトファイルを生成
2. 指定されたtclshで実行し、バージョンを比較
3. バージョンが不足している場合はエラーを出力して終了
4. 一時ファイルを削除

**前後の処理との関連**：Makefileの特定ターゲットから呼び出される。バージョンチェックが通過すると、後続のTclを使用するビルド処理が実行される。

**影響範囲**：チェック用の一時ファイルがカレントディレクトリに生成・削除される。

## バッチ種別

ユーティリティ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | Makefileから呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| tclsh | 第2引数で指定されたtclshが存在すること |
| 書き込み権限 | カレントディレクトリに一時ファイルを作成できること |

### 実行可否判定

- 引数が2つ指定されていること（バージョン、tclshパス）
- 指定されたtclshが実行可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | 数値 | Yes | なし | 必要な最小Tclバージョン（例：8.5、8.6） |
| $2 | 文字列 | Yes | なし | チェック対象のtclshコマンドパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| なし | - | 外部データソースは使用しない |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| cktclsh{version}.tcl | テキスト | 一時的なTclスクリプト（実行後削除） |
| 標準出力 | テキスト | エラーメッセージ（バージョン不足時） |
| 終了コード | 数値 | 0:成功、1:バージョン不足 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | cktclsh{version}.tcl（例：cktclsh8.6.tcl） |
| 出力先 | カレントディレクトリ |
| 文字コード | ASCII |
| 内容 | バージョンチェック用Tclスクリプト |

## 処理フロー

### 処理シーケンス

```
1. 一時Tclスクリプトの生成
   └─ echo "set vers $1" >cktclsh$1.tcl
   └─ echo 'if {$tcl_version<$vers} {exit 1}' >>cktclsh$1.tcl
2. tclshでスクリプトを実行
   └─ $2 cktclsh$1.tcl
3. 結果判定
   └─ 成功（終了コード0）: 一時ファイル削除、正常終了
   └─ 失敗（終了コード1）: エラーメッセージ出力、一時ファイル削除、exit 1
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[一時Tclスクリプト生成]
    B --> C[tclshで実行]
    C --> D{終了コード}
    D -->|0 成功| E[一時ファイル削除]
    E --> F[正常終了 exit 0]
    D -->|1 失敗| G[エラーメッセージ出力]
    G --> H[一時ファイル削除]
    H --> I[エラー終了 exit 1]
```

## 生成されるTclスクリプトの内容

```tcl
set vers 8.6
if {$tcl_version<$vers} {exit 1}
```

- `$tcl_version` はTclの組み込み変数で、現在のTclバージョンを保持
- バージョン比較は文字列として行われる（8.5 < 8.6 等）

## 使用例

```bash
# Tcl 8.6以上が必要な場合
./cktclsh.sh 8.6 /usr/bin/tclsh

# 環境変数で指定されたtclshを使用
./cktclsh.sh 8.5 $TCLSH_CMD
```

## Makefileでの使用例

```makefile
some_target: check_tcl
	@echo "Tcl version check passed"
	# 後続処理

check_tcl:
	@./tool/cktclsh.sh 8.6 $(TCLSH)
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベース操作を行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | バージョン不足 | Tclバージョンが要求より低い | 新しいバージョンのTclをインストール |
| 非ゼロ | tclsh未検出 | 指定されたtclshが存在しない | tclshのパスを確認、インストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認
2. 現在インストールされているTclのバージョンを確認
   - `tclsh <<< 'puts $tcl_version'`
3. 必要なバージョン以上のTclをインストール
   - Debian/Ubuntu: `apt-get install tcl8.6`
   - RHEL/CentOS: `yum install tcl`
   - macOS: `brew install tcl-tk`
4. GetTclKit.batでTclKitをダウンロード（Windows環境）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のチェック |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 最小限（tclshの起動のみ） |

## 排他制御

一時ファイル名にバージョン番号を含むため、異なるバージョンチェックの同時実行は可能。
同一バージョンのチェックを同時実行する場合は競合の可能性あり。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | バージョン不足時 | "ERROR: This makefile target requires tclsh {version} or later." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- このスクリプトは12行のシンプルなユーティリティスクリプト
- `!` による条件否定を使用（POSIX互換性の注意が必要な場合あり）
- 一時ファイルは成功・失敗どちらの場合も削除される
- Tclのバージョン比較は文字列比較であり、8.10 > 8.9 のような比較では予期しない結果になる可能性がある（ただし、Tclではこのようなバージョン番号は使用されていない）
- このスクリプトはMakefileのターゲットの前提条件チェックとして設計されている
