# バッチ設計書 11-tclConfigShToMake.sh

## 概要

本ドキュメントは、SQLiteプロジェクトにおけるTcl設定情報抽出スクリプト `tclConfigShToMake.sh` の設計仕様を記載したものである。

### 本バッチの処理概要

tclConfigShToMake.shは、Tcl環境の設定ファイル（tclConfig.sh）から、SQLiteのビルドシステム（main.mk）が必要とするMakefile形式の変数定義を抽出・出力するユーティリティスクリプトである。

**業務上の目的・背景**：SQLiteはTclテストフレームワークを使用しており、ビルド時にTclライブラリへのリンク情報が必要となる。このスクリプトは、システムにインストールされているTclの設定情報を自動的に取得し、ビルドシステムに連携することで、手動での設定作業を不要にし、異なるTcl環境間でのポータビリティを確保する。configureスクリプトがTcl設定を提供しない場合の代替手段として機能する。

**バッチの実行タイミング**：SQLiteのビルドプロセス中に、main.mkから呼び出されて実行される。具体的には、configureスクリプトによる設定が行われなかった場合に、Tcl関連の変数を設定するために使用される。

**主要な処理内容**：
1. 引数として渡されたtclConfig.shファイルのパスを検証
2. tclConfig.shをsourceコマンドで読み込み、環境変数として展開
3. TCL_INCLUDE_SPEC、TCL_LIB_SPEC、TCL_STUB_LIB_SPEC、TCL_EXEC_PREFIX、TCL_VERSIONの5つの変数をMakefile形式で標準出力に出力

**前後の処理との関連**：main.mkビルドシステムの一部として動作し、configureスクリプトの補完的な役割を果たす。cktclsh.sh（Tclシェルバージョンチェック）と連携してTcl環境の検証と設定を行う。

**影響範囲**：SQLiteのビルドプロセス全体に影響し、特にTclベースのテストスイート実行に必要なライブラリリンク設定に影響する。

## バッチ種別

ユーティリティ / ビルドシステム補助

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | main.mkからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| tclConfig.shの存在 | 引数で指定されたパスにtclConfig.shが存在すること（呼び出し元で検証済みの前提） |
| ファイルの読み取り権限 | tclConfig.shが読み取り可能であること |
| シェル環境 | POSIX互換のshが利用可能であること |

### 実行可否判定

- 引数が空または未指定の場合：空の設定を出力（設定未検出として処理）
- 引数が指定されている場合：tclConfig.shをsourceして変数を取得

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | string | No | (空) | tclConfig.shファイルへのフルパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tclConfig.sh | シェルスクリプト | Tclインストール時に生成される設定ファイル。TCL_*変数をエクスポートする |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト（Makefile形式） | Makefileで使用可能な変数定義 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | N/A（標準出力） |
| 出力先 | stdout |
| 文字コード | システムデフォルト |
| 区切り文字 | N/A |

出力形式の例：
```makefile
TCL_INCLUDE_SPEC = -I/usr/include/tcl8.6
TCL_LIB_SPEC = -L/usr/lib -ltcl8.6
TCL_STUB_LIB_SPEC = -L/usr/lib -ltclstub8.6
TCL_EXEC_PREFIX = /usr
TCL_VERSION = 8.6
```

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ $1が空かどうかを判定
2. 条件分岐
   └─ 空の場合：TCL_*変数を空として初期化
   └─ 非空の場合：指定されたtclConfig.shをsource
3. 変数出力
   └─ ヒアドキュメントで5つの変数をMakefile形式で出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数$1が空か?}
    B -->|空| C[TCL_*変数を空で初期化]
    B -->|非空| D[tclConfig.shをsource]
    C --> E[Makefile形式で変数出力]
    D --> E
    E --> F[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | ファイル読み取りエラー | tclConfig.shが存在しない/読めない場合 | 呼び出し元で事前検証を想定（スクリプトのコメントに記載） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- スクリプト内でのエラーハンドリングは最小限
- 呼び出し元（main.mk）でtclConfig.shの存在・読み取り可能性を事前に検証する設計
- sourceコマンド失敗時はシェルのデフォルトエラー処理に依存

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（DB操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 即時（1秒未満） |
| メモリ使用量上限 | 最小限（シェル変数のみ） |

## 排他制御

同時実行制御は特に行わない。読み取り専用の処理のため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| N/A | N/A | ログ出力機能なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 監視対象外 |

## 備考

- 本スクリプトはmain.mkの間接的な依存関係として設計されており、単体での使用は想定されていない
- スクリプトのコメントにある通り、呼び出し元がファイルの存在確認・読み取り可能性の検証を行う前提
- TCL_STUB_LIB_SPECはTclのスタブライブラリ（バージョン非依存のAPI）へのリンク情報
- 出力される変数はPOSIX Makefileの標準的な形式に準拠
