# バッチ設計書 12-mkdist.sh

## 概要

本ドキュメントは、SQLite WebAssembly（WASM）版の配布パッケージを作成するスクリプト `mkdist.sh` の設計仕様を記載したものである。

### 本バッチの処理概要

mkdist.shは、SQLiteのJavaScript/WebAssembly版をビルドし、Webブラウザやサーバーサイド環境で使用可能な配布用zipファイルを生成するパッケージングスクリプトである。

**業務上の目的・背景**：SQLiteをブラウザやNode.js環境で動作させるためのWASM版の配布が必要とされている。このスクリプトは、ビルド、ファイル収集、コメント除去、zipパッケージ作成までを一貫して自動化することで、リリースプロセスの効率化と品質の一貫性を確保する。開発者がSQLite WASM版を簡単に導入できるように、必要なファイルを適切に整理した配布パッケージを提供する。

**バッチの実行タイミング**：SQLite WASM版のリリース時、またはスナップショットビルド作成時に手動で実行される。開発中のテスト目的でも随時実行可能。

**主要な処理内容**：
1. コマンドライン引数の解析（ビルド名、最適化レベル、64ビット対応等）
2. makeコマンドによるWASMファイル群のビルド
3. 一時ディレクトリへの必要ファイルのコピー
4. JavaScriptファイルからCスタイルコメントを除去（stripccomments使用）
5. バージョン番号を付与したディレクトリ名への変換
6. zipファイルとしてアーカイブ作成

**前後の処理との関連**：Emscriptenによるビルド環境が事前にセットアップされている必要がある。version-infoツールでSQLiteのバージョン番号を取得する。stripccommentsツールでJSファイルを処理する。

**影響範囲**：生成されたzipファイルはSQLite公式サイトやnpmでの配布に使用される。ファイルサイズや内容がエンドユーザーのWebアプリケーションのパフォーマンスに直接影響する。

## バッチ種別

パッケージング / リリースビルド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Emscripten環境 | emccコンパイラが利用可能であること |
| gmake/make | GNU makeまたは互換makeが利用可能であること |
| zipコマンド | zipアーカイバが利用可能であること |
| version-info | バージョン情報取得ツールがビルド済みであること |
| stripccomments | コメント除去ツールがビルド済みであること |
| ext/wasmディレクトリ | スクリプトの実行ディレクトリがext/wasmであること |

### 実行可否判定

- makeコマンドが見つからない場合はエラー終了（exit 127）
- バージョン番号が空の場合はエラー終了
- 各処理段階でエラー発生時はdie関数で即座に終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| build-name | string | No | sqlite-wasm | 出力ディレクトリ/アーカイブ名のプレフィックス |
| -0 | flag | No | - | 最適化レベルを-O0に設定（デバッグ用） |
| -1 | flag | No | - | make -j1で実行（シングルスレッドビルド） |
| -64 | flag | No | - | 64ビットビルドを含める |
| --noclean | flag | No | - | make cleanをスキップ |
| --snapshot | flag | No | - | アーカイブ名にスナップショットサフィックス追加 |
| -?/--help | flag | No | - | ヘルプ表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ext/wasm/jswasm/ | JS/WASM | ビルド済みのJavaScript/WASMファイル群 |
| ext/wasm/common/ | CSS/JS | 共通スタイルシート・ユーティリティ |
| ext/wasm/*.html | HTML | デモ・テスト用HTMLファイル |
| ext/wasm/*.js | JS | デモ用JavaScriptファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {build-name}-{version}.zip | ZIP | 配布用アーカイブ |
| {build-name}-{version}/ | ディレクトリ | 展開済みファイル群（zipと同内容） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sqlite-wasm-{バージョン番号}.zip または カスタム名 |
| 出力先 | ext/wasm/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

出力zipの構造：
```
sqlite-wasm-X.Y.Z/
├── README.txt
├── index.html
├── demo-*.html
├── demo-*.js
├── tester1*.html
├── tester1*.js
├── common/
│   ├── *.css
│   └── SqliteTestUtil.js
└── jswasm/
    ├── sqlite3.js
    ├── sqlite3.mjs
    ├── sqlite3.wasm
    ├── sqlite3-worker1*.js
    ├── sqlite3-worker1*.mjs
    └── sqlite3-opfs-async-proxy.js
```

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ ビルド名、フラグオプションを解析
2. make検索
   └─ gmake/makeの存在確認
3. クリーン処理
   └─ --nocleanでない場合、make clean実行
4. WASMビルド
   └─ ターゲットファイル群をmakeでビルド
5. 一時ディレクトリ作成
   └─ d.dist/jswasm/, d.dist/common/を作成
6. ファイルコピー
   └─ 各種ファイルを一時ディレクトリにコピー
7. コメント除去
   └─ JSファイルにstripccommentsを適用
8. リネーム
   └─ d.distをバージョン付きディレクトリ名に変更
9. ZIP作成
   └─ zip -rq9でアーカイブ作成
10. 確認出力
    └─ アーカイブ情報を表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{makeが存在?}
    C -->|なし| D[エラー終了 127]
    C -->|あり| E{--noclean?}
    E -->|No| F[make clean]
    E -->|Yes| G[スキップ]
    F --> H[WASMビルド]
    G --> H
    H --> I{ビルド成功?}
    I -->|No| J[エラー終了]
    I -->|Yes| K[一時ディレクトリ作成]
    K --> L[ファイルコピー]
    L --> M[JSコメント除去]
    M --> N[バージョン取得]
    N --> O{バージョン空?}
    O -->|Yes| P[エラー終了]
    O -->|No| Q[ディレクトリリネーム]
    Q --> R[ZIP作成]
    R --> S[完了メッセージ出力]
    S --> T[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 未知の引数が指定された場合 | ヘルプを参照して正しい引数を指定 |
| 127 | 環境エラー | makeコマンドが見つからない | gmakeまたはmakeをインストール |
| 可変 | ビルドエラー | makeコマンド失敗 | ビルドログを確認しEmscripten環境を検証 |
| 可変 | バージョンエラー | version-infoがバージョンを取得できない | version-infoツールの状態を確認 |
| 可変 | コピーエラー | ファイルコピー失敗 | ディスク容量・権限を確認 |
| 可変 | ZIPエラー | zip作成失敗 | zipコマンドの利用可能性を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（手動リトライ） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- die関数によりエラー発生時は即座に終了
- エラーメッセージは標準エラー出力に出力
- 一時ディレクトリ(d.dist)が残る場合は手動削除が必要
- ビルド失敗時は--nocleanを外して再実行を試みる

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（DB操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1パッケージ |
| 目標処理時間 | 数分〜十数分（ビルド規模による） |
| メモリ使用量上限 | Emscriptenビルドに依存（数GB可能性あり） |

## 排他制御

同時実行制御は特に行わない。同一ディレクトリでの複数同時実行は避けるべき。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | バッチ開始時 | "Creating the SQLite wasm dist bundle..." |
| 情報ログ | ビルド後 | 生成されたファイルサイズ（ls -la） |
| 確認ログ | ZIP作成後 | unzip -lv によるアーカイブ内容一覧 |
| 完了ログ | 終了時 | 展開済みディレクトリのパス |
| エラーログ | エラー発生時 | "Error: {メッセージ}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- 最適化フラグのデフォルトは-Oz（サイズ最適化）
- makeの並列度デフォルトは-j4
- --snapshotオプション使用時は日付サフィックス（YYYYMMDD形式）が付与される
- stripccommentsツールの-kオプションはライセンスコメント保持、-k -kはさらに厳密な保持
- 64ビットビルド(-64)は追加のWASMファイルを生成するためビルド時間が増加
- fcp関数はコピー後にファイルを書き込み可能に変更（chmod +w）
