# バッチ設計書 13-split-speedtest1-script.sh

## 概要

本ドキュメントは、SQLiteパフォーマンステストツール（speedtest1）の出力を個別SQLファイルに分割するスクリプト `split-speedtest1-script.sh` の設計仕様を記載したものである。

### 本バッチの処理概要

split-speedtest1-script.shは、speedtest1プログラムの--scriptオプションで出力されたSQL文を含むファイルを解析し、個々のテストケースごとに独立したSQLファイルとして分割出力するユーティリティスクリプトである。

**業務上の目的・背景**：speedtest1はSQLiteのパフォーマンスベンチマークプログラムであり、--scriptオプションを使用すると実行されるSQL文をファイルに出力できる。このスクリプトを使用することで、特定のテストケースのみを抽出して個別に分析・実行したり、WASMビルドのテストや性能比較に活用できる。テストケースの分離により、ボトルネックの特定やデバッグが容易になる。

**バッチの実行タイミング**：speedtest1の--script出力を解析したいとき、またはWASMビルドの性能テスト準備時に手動で実行される。開発者がパフォーマンス分析を行う際に随時使用。

**主要な処理内容**：
1. 入力ファイルから"-- begin test N"形式のマーカーを検索してテスト番号を抽出
2. 各テスト番号に対して、beginマーカーからendマーカーまでの範囲を抽出
3. speedtest1-NNN.sql形式（3桁ゼロパディング）のファイル名で個別出力
4. 処理したテスト番号とファイル名を標準出力に表示

**前後の処理との関連**：speedtest1プログラムの--scriptオプション出力が入力となる。出力されたSQLファイルはsqlite3シェルで個別実行可能。WASMビルドのパフォーマンステストでも活用される。

**影響範囲**：入力ファイルと同じディレクトリに複数のSQLファイルを生成する。既存の同名ファイルは上書きされる。

## バッチ種別

ユーティリティ / データ変換

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力ファイル | speedtest1 --scriptの出力ファイルが存在すること |
| ファイル形式 | "-- begin test N"/"-- end test N"マーカーを含むこと |
| bash環境 | bashシェルが利用可能であること |
| 書き込み権限 | 出力先ディレクトリに書き込み権限があること |

### 実行可否判定

- 引数が未指定の場合はエラーメッセージを出力して終了
- begin/endブロックが解析できない場合はエラーメッセージを出力してexit 1

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | string | Yes | - | speedtest1 --script出力ファイルのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| speedtest1出力ファイル | テキスト | SQL文とテストマーカーを含むファイル |

入力ファイルの形式例：
```sql
-- begin test 1 ...
CREATE TABLE t1(a INTEGER PRIMARY KEY, b TEXT);
INSERT INTO t1 VALUES(1, 'test');
-- end test 1

-- begin test 2 ...
SELECT * FROM t1 WHERE b LIKE '%test%';
-- end test 2
```

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| speedtest1-NNN.sql | SQL | 個別テストケースのSQLファイル（Nはテスト番号） |
| 標準出力 | テキスト | 処理したテスト番号とファイル名の一覧 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | speedtest1-{3桁ゼロパディング番号}.sql |
| 出力先 | 入力ファイルと同じディレクトリ |
| 文字コード | 入力ファイルと同一 |
| 区切り文字 | N/A |

出力ファイル例：
- speedtest1-001.sql
- speedtest1-002.sql
- speedtest1-003.sql
- ...

標準出力の形式：
```
1	./speedtest1-001.sql
2	./speedtest1-002.sql
3	./speedtest1-003.sql
```

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ $1が指定されているか確認
2. テスト番号抽出
   └─ grepで"-- begin test"行を検索
   └─ cutでテスト番号（第4フィールド）を抽出
3. 抽出結果検証
   └─ テスト番号が空の場合はエラー終了
4. 出力ディレクトリ決定
   └─ 入力ファイルのディレクトリパスを取得
5. ループ処理
   └─ 各テスト番号について：
      └─ 出力ファイル名を生成（3桁ゼロパディング）
      └─ sedで該当範囲を抽出してファイル出力
      └─ テスト番号とファイル名をechoで出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数$1が存在?}
    B -->|No| C[エラーメッセージ出力・終了]
    B -->|Yes| D[テスト番号を抽出]
    D --> E{テスト番号あり?}
    E -->|No| F[パースエラー・exit 1]
    E -->|Yes| G[出力ディレクトリ決定]
    G --> H[ループ開始]
    H --> I[ファイル名生成]
    I --> J[sedで該当範囲抽出]
    J --> K[ファイル出力]
    K --> L[番号とファイル名出力]
    L --> M{次のテスト?}
    M -->|Yes| H
    M -->|No| N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 引数未指定 | 正しい引数を指定して再実行 |
| 1 | パースエラー | begin/endブロックが見つからない | 入力ファイルの形式を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（手動リトライ） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- エラー発生時はエラーメッセージを標準エラー出力に出力
- 部分的に出力されたファイルが残る可能性あり（手動削除が必要）
- 入力ファイルがspeedtest1 --script形式であることを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（DB操作なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百テストケース |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小限（ストリーム処理） |

## 排他制御

同時実行制御は特に行わない。同一ディレクトリへの同時出力は避けるべき。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各テスト処理後 | テスト番号とファイル名（タブ区切り） |
| エラーログ | エラー発生時 | "Could not parse any begin/end blocks..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 手動実行のため監視対象外 |

## 備考

- ファイル名は3桁ゼロパディング（printf "%03d"）で生成
- 入力ファイルがディレクトリパスを含む場合、同じディレクトリに出力
- 入力ファイルがカレントディレクトリの場合、"."を出力先とする
- sedの範囲指定（/pattern1/,/pattern2/p）でbeginからendまでを抽出
- echo -eオプションでタブ文字を解釈して出力
- WASM環境でのパフォーマンステストの準備ツールとしてext/wasmディレクトリに配置
