# バッチ設計書 14-run-wordcount.sh

## 概要

本ドキュメントは、SQLiteのwordcountプログラムを複数のモードで実行し、出力結果の整合性を検証するテストスクリプト `run-wordcount.sh` の設計仕様を記載したものである。

### 本バッチの処理概要

run-wordcount.shは、SQLiteを使用した単語カウントプログラム（wordcount）を様々な動作モード（insert/replace/select/query/delete）および設定（通常テーブル/WITHOUT ROWID）で実行し、出力結果を比較検証することでSQLite操作の正確性を確認する回帰テストスクリプトである。

**業務上の目的・背景**：SQLiteの基本的なデータ操作（INSERT、REPLACE、SELECT、DELETE）が、テーブル構造の違い（通常テーブル vs WITHOUT ROWID）に関わらず同一の結果を返すことを確認する必要がある。このスクリプトは、wordcountプログラムを使用して実際のデータ処理を行い、異なる条件下での出力一貫性を自動検証することで、SQLiteの動作品質を保証する。

**バッチの実行タイミング**：SQLiteの開発・テストサイクルにおいて、コード変更後の回帰テストとして実行される。CI/CDパイプラインの一部として、または開発者による手動テストとして随時実行。

**主要な処理内容**：
1. wordcountプログラムを--insertモードで実行し、ベースライン出力を取得
2. --insert --without-rowidモードで実行し、ベースラインと比較
3. --replaceモード（通常/WITHOUT ROWID）で実行し比較
4. --selectモード（通常/WITHOUT ROWID）で実行し比較
5. --queryモードで実行しベースライン更新、WITHOUT ROWIDと比較
6. --deleteモードで実行しベースライン更新、WITHOUT ROWIDと比較
7. 差異がある場合はERRORとdiff出力、なければ静かに終了

**前後の処理との関連**：wordcountプログラムが事前にビルドされている必要がある。time-wordcount.sh（パフォーマンス計測）と補完的な関係にあり、こちらは正確性検証に特化。

**影響範囲**：テスト用の一時データベースファイル（wcdb1.db、wcdb2.db）と一時出力ファイル（wc-out.txt、wc-baseline.txt）を作成・削除する。

## バッチ種別

テスト / 回帰テスト

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（テスト時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| wordcountプログラム | カレントディレクトリに./wordcountが存在し実行可能であること |
| 入力ファイル | 引数で指定されたテキストファイルが存在すること |
| 書き込み権限 | カレントディレクトリに書き込み権限があること |
| シェル環境 | POSIX互換shが利用可能であること |

### 実行可否判定

- 引数が未指定の場合はUsageを表示してexit 1

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (FILENAME) | string | Yes | - | 解析対象のテキストファイルパス |
| $2... (ARGS) | string | No | - | wordcountに渡す追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テキストファイル | テキスト | 単語カウント対象のテキストファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ERRORメッセージおよびdiff（差異がある場合のみ） |
| 一時ファイル | SQLite DB/テキスト | テスト実行中に作成、終了時に削除 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 一時ファイル: wcdb1.db, wcdb2.db, wc-out.txt, wc-baseline.txt |
| 出力先 | カレントディレクトリ（終了時削除） |
| 文字コード | システムデフォルト |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ $1が指定されているか確認
2. INSERT テスト
   └─ --insert でベースライン取得
   └─ --insert --without-rowid で比較
3. REPLACE テスト
   └─ --replace でベースラインと比較
   └─ --replace --without-rowid で比較
4. SELECT テスト
   └─ --select でベースラインと比較
   └─ --select --without-rowid で比較
5. QUERY テスト
   └─ --query でベースライン更新
   └─ --query --without-rowid で比較
6. DELETE テスト
   └─ --delete でベースライン更新
   └─ --delete --without-rowid で比較
7. クリーンアップ
   └─ 一時ファイル削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数あり?}
    B -->|No| C[Usage表示・終了]
    B -->|Yes| D[INSERT通常モード実行]
    D --> E[ベースライン保存]
    E --> F[INSERT WITHOUT ROWID実行]
    F --> G{出力一致?}
    G -->|No| H[ERROR+diff出力]
    G -->|Yes| I[REPLACEテスト]
    H --> I
    I --> J[SELECTテスト]
    J --> K[QUERYテスト]
    K --> L[DELETEテスト]
    L --> M[一時ファイル削除]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| INSERT | wordcount生成テーブル | INSERT | 単語をデータベースに挿入 |
| REPLACE | wordcount生成テーブル | REPLACE | 重複時に置換で挿入 |
| SELECT | wordcount生成テーブル | SELECT | 既存レコードの検索 |
| QUERY | wordcount生成テーブル | SELECT | データの問い合わせ |
| DELETE | wordcount生成テーブル | DELETE | レコードの削除 |

### テーブル別操作詳細

#### wordcount生成テーブル（名称はwordcountプログラムに依存）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/REPLACE/DELETE | 単語・カウント | テキストファイルから抽出した単語 | 通常テーブルとWITHOUT ROWIDの両方でテスト |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | ファイル名未指定 | 正しいファイル名を指定 |
| N/A | 比較エラー | 出力の差異検出 | ERROR表示とdiff出力（テスト失敗を示す） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- 比較エラーはテスト失敗を示すため、SQLiteまたはwordcountの動作を調査
- 一時ファイルは正常終了時に削除されるが、異常終了時は手動削除が必要

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | wordcountプログラム内部で管理 |
| コミットタイミング | wordcountプログラムに依存 |
| ロールバック条件 | wordcountプログラムに依存 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力ファイルサイズに依存 |
| 目標処理時間 | 入力サイズに依存（正確性検証が目的） |
| メモリ使用量上限 | wordcountプログラムに依存 |

## 排他制御

同時実行制御は特に行わない。同一ディレクトリでの同時実行は一時ファイル競合の可能性あり。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 比較失敗時 | "ERROR:" とdiff出力 |
| 情報ログ | 比較成功時 | 出力なし（静かに成功） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | テストスクリプトのため監視対象外 |

## 備考

- wordcountプログラムは--timer、--summaryオプションで実行時間と要約を出力
- WITHOUT ROWIDテーブルはSQLite 3.8.2以降の機能で、主キーのみを持つテーブルの最適化形式
- cmpコマンドで出力を比較し、差異がある場合のみdiff -uで詳細表示
- 各テストでデータベースファイルを削除してから新規作成することで独立性を確保
- "echo hi >/dev/null" は比較成功時の何もしない処理（if文の構文上必要）
