# バッチ設計書 15-time-wordcount.sh

## 概要

本ドキュメントは、SQLiteのwordcountプログラムを複数の設定で実行し、パフォーマンス比較用の出力を生成するスクリプト `time-wordcount.sh` の設計仕様を記載したものである。

### 本バッチの処理概要

time-wordcount.shは、SQLiteを使用した単語カウントプログラム（wordcount）を様々な動作モード（insert/replace/select/query/delete）および設定（通常テーブル/WITHOUT ROWID）で実行し、各実行のタイミング情報を収集してパフォーマンス比較に有用な出力を生成するベンチマークスクリプトである。

**業務上の目的・背景**：SQLiteの異なるデータ操作モード（INSERT、REPLACE、SELECT、QUERY、DELETE）および異なるテーブル構造（通常テーブル vs WITHOUT ROWID）間のパフォーマンス特性を把握する必要がある。このスクリプトは、wordcountプログラムを使用して実際のワークロードを実行し、各条件下での実行時間を測定することで、性能比較や最適化の意思決定に必要なデータを提供する。

**バッチの実行タイミング**：パフォーマンスチューニングや最適化検討時に手動で実行される。SQLiteのバージョン間比較や、設定変更の影響測定にも使用。

**主要な処理内容**：
1. A: --insertモード（通常テーブル）で実行・計測
2. B: --insert --without-rowidモードで実行・計測
3. C: --replaceモード（通常テーブル）で実行・計測
4. D: --replace --without-rowidモードで実行・計測
5. E: --selectモード（通常テーブル）で実行・計測
6. F: --select --without-rowidモードで実行・計測
7. G: --queryモード（通常テーブル）で実行・計測
8. H: --query --without-rowidモードで実行・計測
9. I: --deleteモード（通常テーブル）で実行・計測
10. J: --delete --without-rowidモードで実行・計測

**前後の処理との関連**：wordcountプログラムが事前にビルドされている必要がある。run-wordcount.sh（正確性検証）と補完的な関係にあり、こちらはパフォーマンス計測に特化。

**影響範囲**：テスト用の一時データベースファイル（wcdb1.db、wcdb2.db）を作成・削除する。標準出力にタイミング情報を出力。

## バッチ種別

テスト / パフォーマンス計測

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（性能測定時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| wordcountプログラム | カレントディレクトリに./wordcountが存在し実行可能であること |
| 入力ファイル | 引数で指定されたテキストファイルが存在すること |
| 書き込み権限 | カレントディレクトリに書き込み権限があること |
| シェル環境 | POSIX互換shが利用可能であること |

### 実行可否判定

- 引数が未指定の場合はUsageを表示してexit 1

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (FILENAME) | string | Yes | - | 解析対象のテキストファイルパス |
| $2... (ARGS) | string | No | - | wordcountに渡す追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テキストファイル | テキスト | 単語カウント対象のテキストファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各テスト実行のタイミング情報（タグ付き） |
| 一時ファイル | SQLite DB | テスト実行中に作成、終了時に削除 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 一時ファイル: wcdb1.db, wcdb2.db |
| 出力先 | カレントディレクトリ（終了時削除） |
| 文字コード | システムデフォルト |
| 区切り文字 | N/A |

標準出力の形式例：
```
A: ... (--insertの実行時間情報)
B: ... (--insert --without-rowidの実行時間情報)
C: ... (--replaceの実行時間情報)
D: ... (--replace --without-rowidの実行時間情報)
E: ... (--selectの実行時間情報)
F: ... (--select --without-rowidの実行時間情報)
G: ... (--queryの実行時間情報)
H: ... (--query --without-rowidの実行時間情報)
I: ... (--deleteの実行時間情報)
J: ... (--delete --without-rowidの実行時間情報)
```

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ $1が指定されているか確認
2. INSERT テスト (A, B)
   └─ A: --insert（通常テーブル）
   └─ B: --insert --without-rowid
3. REPLACE テスト (C, D)
   └─ C: --replace（通常テーブル）
   └─ D: --replace --without-rowid
4. SELECT テスト (E, F)
   └─ E: --select（通常テーブル）
   └─ F: --select --without-rowid
5. QUERY テスト (G, H)
   └─ G: --query（通常テーブル、既存DB使用）
   └─ H: --query --without-rowid（既存DB使用）
6. DELETE テスト (I, J)
   └─ I: --delete（通常テーブル）
   └─ J: --delete --without-rowid
7. クリーンアップ
   └─ 一時DBファイル削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数あり?}
    B -->|No| C[Usage表示・終了]
    B -->|Yes| D[DB削除・INSERTテスト A]
    D --> E[DB削除・INSERTテスト B]
    E --> F[DB削除・REPLACEテスト C]
    F --> G[DB削除・REPLACEテスト D]
    G --> H[DB削除・SELECTテスト E]
    H --> I[DB削除・SELECTテスト F]
    I --> J[QUERYテスト G（既存DB）]
    J --> K[QUERYテスト H（既存DB）]
    K --> L[DELETEテスト I]
    L --> M[DELETEテスト J]
    M --> N[DB削除]
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| INSERT (A, B) | wordcount生成テーブル | INSERT | 単語をデータベースに挿入 |
| REPLACE (C, D) | wordcount生成テーブル | REPLACE | 重複時に置換で挿入 |
| SELECT (E, F) | wordcount生成テーブル | SELECT | 既存レコードの検索 |
| QUERY (G, H) | wordcount生成テーブル | SELECT | データの問い合わせ |
| DELETE (I, J) | wordcount生成テーブル | DELETE | レコードの削除 |

### テーブル別操作詳細

#### wordcount生成テーブル（名称はwordcountプログラムに依存）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/REPLACE/DELETE | 単語・カウント | テキストファイルから抽出した単語 | A-Jのタグでパフォーマンス識別 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | ファイル名未指定 | 正しいファイル名を指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- 一時DBファイルは正常終了時に削除されるが、異常終了時は手動削除が必要

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | wordcountプログラム内部で管理 |
| コミットタイミング | wordcountプログラムに依存 |
| ロールバック条件 | wordcountプログラムに依存 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力ファイルサイズに依存 |
| 目標処理時間 | N/A（計測が目的） |
| メモリ使用量上限 | wordcountプログラムに依存 |

## 排他制御

同時実行制御は特に行わない。同一ディレクトリでの同時実行は一時ファイル競合の可能性あり。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| タイミングログ | 各テスト実行後 | タグ付きの実行時間情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | ベンチマークスクリプトのため監視対象外 |

## 備考

- --tagオプションで出力にプレフィックス（A:〜J:）を付与して識別
- QUERY/DELETEテスト（G〜J）は既存DBを使用するためDB削除なし
- run-wordcount.shと異なり、出力比較は行わない（パフォーマンス計測専用）
- 10種類のテスト実行で、通常テーブルとWITHOUT ROWIDの性能差を比較可能
- WITHOUT ROWIDは主キーのみのテーブルで有効な最適化で、一般的にルックアップが高速
- 結果は外部ツールでの分析・可視化に適した形式で出力
