# バッチ設計書 16-fts3cov.sh

## 概要

本ドキュメントは、SQLite FTS3（Full-Text Search 3）モジュールのコードカバレッジを測定するスクリプト `fts3cov.sh` の設計仕様を記載したものである。

### 本バッチの処理概要

fts3cov.shは、SQLiteのFTS3全文検索モジュールに対してテストスイートを実行し、gcovを使用してコードカバレッジ（分岐カバレッジ）を測定・レポートする品質検証スクリプトである。

**業務上の目的・背景**：FTS3モジュールはSQLiteの重要な拡張機能であり、全文検索機能を提供する。このモジュールのコード品質を確保するため、テストスイートがコードのどの程度をカバーしているかを定量的に把握する必要がある。このスクリプトは、FTS3のテストを実行し、各ソースファイルの分岐カバレッジ率を自動的に収集・表示することで、テストカバレッジの可視化と品質管理を支援する。

**バッチの実行タイミング**：FTS3モジュールの開発・メンテナンス時、コード変更後の品質確認として実行される。リリース前の品質検証プロセスの一部としても使用。

**主要な処理内容**：
1. testfixtureプログラムを使用してFTS3テストスイート（fts3.test）を実行
2. テスト出力をfts3cov-out.txtに保存
3. ext/fts3/ディレクトリの各.cファイルに対してgcovを実行
4. 各ファイルの分岐カバレッジ率（"Taken at least once"）を抽出・表示

**前後の処理との関連**：gcovカバレッジ収集が有効なビルド（-fprofile-arcs -ftest-coverage等）が事前に必要。testfixtureプログラムがビルド済みである必要がある。fts3.testテストスクリプトがソースツリーに存在する必要がある。

**影響範囲**：テスト実行結果ファイル（fts3cov-out.txt）と、gcov出力ファイル（*.gcov）を生成する。FTS3モジュールのテストカバレッジ情報を標準出力に出力。

## バッチ種別

品質検証 / コードカバレッジ測定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（品質検証時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| gcovカバレッジビルド | ソースコードがgcov対応オプション（-fprofile-arcs -ftest-coverage）でコンパイルされていること |
| testfixture | カレントディレクトリに./testfixtureが存在し実行可能であること |
| gcov | gcovコマンドが利用可能であること |
| ソースツリー | ext/fts3/*.cおよびtest/fts3.testが存在すること |

### 実行可否判定

- set -eにより、任意のコマンドが失敗した時点でスクリプトは終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 引数は受け取らない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| test/fts3.test | Tclスクリプト | FTS3テストスイート |
| ext/fts3/*.c | Cソース | FTS3モジュールのソースファイル |
| *.gcno/*.gcda | gcovデータ | カバレッジ計測用データファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 各ソースファイルの分岐カバレッジ率 |
| fts3cov-out.txt | テキスト | テスト実行の詳細出力 |
| *.gcov | テキスト | gcov生成の詳細カバレッジファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | fts3cov-out.txt, {各ソースファイル名}.gcov |
| 出力先 | カレントディレクトリ |
| 文字コード | システムデフォルト |
| 区切り文字 | N/A |

標準出力の形式例：
```
fts3.c: 85.00%
fts3_aux.c: 72.50%
fts3_expr.c: 90.25%
fts3_hash.c: 88.00%
...
```

## 処理フロー

### 処理シーケンス

```
1. ソースディレクトリ特定
   └─ スクリプトパスから4階層上のディレクトリを計算
2. テスト実行
   └─ testfixtureでfts3.testを実行
   └─ 出力をfts3cov-out.txtに保存
3. 空行出力
   └─ 区切りとして空行を出力
4. カバレッジ収集ループ
   └─ ext/fts3/*.cの各ファイルに対して：
      └─ ファイル名を出力
      └─ gcov -bを実行
      └─ "Taken at least once"行を抽出・表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ソースディレクトリ特定]
    B --> C[testfixture fts3.test実行]
    C --> D{テスト成功?}
    D -->|No| E[エラー終了]
    D -->|Yes| F[空行出力]
    F --> G[ext/fts3/*.cをリスト]
    G --> H{次のファイル?}
    H -->|Yes| I[ファイル名出力]
    I --> J[gcov -b 実行]
    J --> K[分岐カバレッジ抽出]
    K --> H
    H -->|No| L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テスト実行 | FTS仮想テーブル | 各種 | fts3.test内でFTS3テーブルを作成・操作 |

### テーブル別操作詳細

#### FTS3仮想テーブル（テスト用）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| CREATE/INSERT/SELECT/DROP | テスト依存 | fts3.test内で定義 | テスト終了後に削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 可変 | テスト失敗 | fts3.testの実行失敗 | テスト内容とFTS3実装を確認 |
| 可変 | gcovエラー | .gcno/.gcdaファイル不足 | カバレッジビルドを再実行 |
| 可変 | ファイル不存在 | ソースファイルが見つからない | ソースツリーの構成を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- set -eによりエラー発生時は即座に終了
- gcovデータファイルが不足している場合は、カバレッジ有効のフルビルドが必要

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | テストケース単位（fts3.test内部で管理） |
| コミットタイミング | テストケースに依存 |
| ロールバック条件 | テストケースに依存 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | FTS3ソースファイル全体（約20ファイル） |
| 目標処理時間 | 数分〜十数分（テストスイートサイズによる） |
| メモリ使用量上限 | testfixtureの実行に依存 |

## 排他制御

同時実行制御は特に行わない。.gcda ファイルは同時アクセスに注意が必要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| テスト結果 | テスト実行後 | fts3cov-out.txt（testfixture出力） |
| カバレッジ | gcov実行後 | 各ファイルの分岐カバレッジ率 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 品質検証ツールのため監視対象外 |

## 備考

- スクリプトはext/fts3/tool/ディレクトリに配置されることを前提
- srcdirの計算: スクリプトのパスから4階層上（dirname x 4）
- gcov -bオプションで分岐カバレッジ情報を取得
- "Taken at least once"は分岐が少なくとも1回実行されたかを示す
- echo -neオプションで改行なしの出力を使用
- gccのカバレッジオプション: -fprofile-arcs -ftest-coverage
- testfixtureはSQLiteのTclテストドライバー
