# バッチ設計書 17-json-speed-check.sh

## 概要

本ドキュメントは、SQLiteのJSON処理パフォーマンスを計測するスクリプト `json-speed-check.sh` の設計仕様を記載したものである。

### 本バッチの処理概要

json-speed-check.shは、SQLiteのJSON機能のパフォーマンスを計測するためのベンチマークスクリプトである。cachegrind（Valgrindのツール）を使用してCPU命令レベルでの詳細な性能分析を行い、JSON/JSONB処理の最適化に必要なデータを提供する。

**業務上の目的・背景**：SQLiteのJSON機能は、NoSQLライクなデータ処理を可能にする重要な機能である。この機能のパフォーマンス特性を定量的に把握し、異なるビルド設定や最適化オプション間での性能比較を行う必要がある。このスクリプトは、cachegrindを使用してCPUキャッシュヒット率や命令実行数などの詳細な性能メトリクスを収集し、JSON処理の最適化に役立てる。

**バッチの実行タイミング**：JSON機能の開発・最適化時、パフォーマンスチューニング、バージョン間の性能比較時に手動で実行される。日常的な監視ではなく、特定の分析作業時に使用。

**主要な処理内容**：
1. コマンドライン引数の解析（出力名、コンパイラオプション、ベースライン指定等）
2. SQLiteのsqlite3シェルをカスタムオプションでコンパイル（jsonshellとして）
3. json100mb.dbテストデータベースに対してJSONクエリを実行
4. Valgrind cachegrindでプロファイリング実行
5. cg_anno.tclで結果を解析・フォーマット
6. ベースラインとの差分比較（fossil xdiff）

**前後の処理との関連**：sqlite3.cとshell.cのソースファイルが必要。Valgrindとcachegrindがインストールされている必要がある。cg_anno.tclスクリプトで結果を解析。fossil xdiffで差分表示。

**影響範囲**：複数の出力ファイル（summary-*.txt、json-*.txt/jsonb-*.txt）を生成。一時的にjsonshellバイナリを生成。

## バッチ種別

テスト / パフォーマンス計測

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（性能分析時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Valgrind | valgrind --tool=cachegrindが利用可能であること |
| GCC/Clang | gcc または clang コンパイラが利用可能であること |
| SQLiteソース | sqlite3.c、shell.cがカレントディレクトリに存在すること |
| テストDB | json100mb.db（または_b版）テストデータベースが存在すること |
| cg_anno.tcl | cachegrindアノテーションツールが利用可能であること |
| fossil | 差分比較時にfossilコマンドが利用可能であること（オプション） |

### 実行可否判定

- 引数が未指定の場合はUsageを表示してexit
- 各ツールの存在は実行時に暗黙的にチェック

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (OUTPUTFILE) | string | Yes | - | 出力ファイルのベース名 |
| --lean | flag | No | - | 軽量ビルドオプションを有効化 |
| --clang | flag | No | - | Clangコンパイラを使用 |
| --gcc7 | flag | No | - | GCC 7を使用 |
| --jsonb | flag | No | - | JSONB形式でテスト |
| --nodiff | flag | No | - | 差分比較をスキップ |
| -* | string | No | - | その他のコンパイラオプション |
| その他 | string | No | trunk | ベースライン名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| sqlite3.c | Cソース | SQLiteアマルガメーションソース |
| shell.c | Cソース | SQLiteシェルソース |
| json100mb.db / json100mb_b.db | SQLite DB | JSONテスト用データベース |
| json-q1.txt / jsonb-q1.txt | SQL | テスト用クエリファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| summary-{NAME}.txt | テキスト | 実行サマリー（コンパイラオプション、バイナリサイズ、valgrind出力） |
| json-{NAME}.txt または jsonb-{NAME}.txt | テキスト | cachegrindアノテーション結果 |
| jsonshell | バイナリ | テスト用にビルドされたSQLiteシェル |
| cachegrind.out.* | バイナリ | cachegrind生データ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | summary-{NAME}.txt, {TYPE}-{NAME}.txt |
| 出力先 | カレントディレクトリ |
| 文字コード | システムデフォルト |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ 出力名、フラグオプション、コンパイラオプションを解析
2. 環境設定
   └─ コンパイラ（gcc/clang）、最適化オプションを設定
3. 情報出力
   └─ NAME、CC_OPTSをsummaryファイルに記録
4. 前回データ削除
   └─ cachegrind.out.*, jsonshellを削除
5. ビルド実行
   └─ sqlite3.c、shell.cをコンパイルしてjsonshellを生成
6. バイナリサイズ記録
   └─ ls -l jsonshell をsummaryに追記
7. valgrind実行
   └─ cachegrindでjsonshellを実行、クエリを入力
8. アノテーション生成
   └─ cg_anno.tclでcachegrind出力を解析
9. 結果統合
   └─ アノテーション結果とsummaryを結合
10. 差分比較（オプション）
    └─ fossil xdiffでベースラインと比較
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数あり?}
    B -->|No| C[Usage表示・終了]
    B -->|Yes| D[引数解析]
    D --> E[コンパイラ/オプション設定]
    E --> F[前回データ削除]
    F --> G[jsonshellビルド]
    G --> H[バイナリサイズ記録]
    H --> I[valgrind cachegrind実行]
    I --> J[cg_anno.tclでアノテーション]
    J --> K[結果ファイル統合]
    K --> L{差分比較?}
    L -->|Yes| M[fossil xdiff実行]
    L -->|No| N[バッチ終了]
    M --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| JSONクエリ | json100mb.db内テーブル | SELECT | JSON関数を使用したクエリ実行 |

### テーブル別操作詳細

#### json100mb.db内テーブル（読み取り専用）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | JSON列 | json-q1.txt内のクエリに依存 | パフォーマンス計測のため読み取りのみ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | OUTPUTFILE未指定 | 正しい引数を指定 |
| 可変 | コンパイルエラー | ソースファイル不足/構文エラー | ソースファイルを確認 |
| 可変 | valgrindエラー | valgrind未インストール/実行失敗 | valgrindをインストール |
| 可変 | DBエラー | テストDBが存在しない | json100mb.dbを準備 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- コンパイルエラーはソースファイルとオプションを確認
- valgrindエラーはインストール状態を確認
- 中間ファイル（jsonshell、cachegrind.out.*）は手動削除が必要な場合あり

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取りのみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のベンチマーク実行 |
| 目標処理時間 | 数分〜数十分（cachegrindのオーバーヘッド大） |
| メモリ使用量上限 | valgrindの実行に依存（通常の10〜50倍） |

## 排他制御

同時実行制御は特に行わない。同一ディレクトリでの同時実行はファイル競合の可能性あり。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 設定ログ | 実行開始時 | NAME、CC_OPTS |
| バイナリ情報 | ビルド後 | jsonshellのファイルサイズ |
| valgrind出力 | 実行後 | cachegrind統計情報 |
| アノテーション | 解析後 | 詳細なCPU命令分析 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | 分析ツールのため監視対象外 |

## 備考

- デフォルトコンパイラはgcc、-Os（サイズ最適化）
- LEAN_OPTSは軽量ビルド用の追加オプション群：
  - SQLITE_THREADSAFE=0（スレッドセーフ無効）
  - SQLITE_DEFAULT_MEMSTATUS=0（メモリステータス無効）
  - SQLITE_MAX_EXPR_DEPTH=0（式の深さ制限なし）
  - 各種OMIT_*オプション
- --jsonbオプションでJSONB（バイナリJSON）形式のテストを実行
- ベースラインとの比較にfossil xdiff（Fossil SCMのdiffツール）を使用
- cg_anno.tclはcachegrindの出力を人間が読みやすい形式に変換
- 100MBのJSONテストデータベースを使用して現実的なワークロードを再現
- sedでプロセスIDを正規化（==NNNNN== を ==00000== に置換）
