# バッチ設計書 2-build-all-msvc.bat

## 概要

本ドキュメントは、SQLiteプロジェクトにおけるMSVCマルチプラットフォームビルドツール（build-all-msvc.bat）の設計仕様を記述したものである。

### 本バッチの処理概要

build-all-msvc.batは、Microsoft Visual C++（MSVC）を使用して、複数のプラットフォーム（x86、x64、ARM）および構成（Debug、Retail）向けにSQLite DLLとインポートライブラリを一括でビルドする高機能なビルドツールである。

**業務上の目的・背景**：SQLiteの公式リリースやサードパーティ配布において、複数のWindowsプラットフォーム向けのバイナリを効率的に生成する必要がある。手動で各プラットフォーム向けにビルドを繰り返すのは非効率であり、このバッチファイルにより自動化された一貫したマルチプラットフォームビルドを実現する。CI/CDパイプラインやリリースプロセスの一部として使用される。

**バッチの実行タイミング**：リリースビルド作成時、または複数プラットフォーム向けのバイナリが必要な時に手動実行。CI/CDパイプラインからの自動実行も想定。

**主要な処理内容**：
1. 環境変数の検証（VCINSTALLDIR、ComSpec等）
2. Tclシェルの存在確認（アマルガメーション生成に必要）
3. 各プラットフォーム（x86、x86_amd64、x86_arm）でのビルドループ
4. 各構成（Debug、Retail）でのビルドループ
5. MSVCビルド環境のセットアップ（vcvarsall.bat呼び出し）
6. nmakeによるDLL/LIBビルド
7. オプションでシェル実行ファイルのビルド
8. 出力ファイルの指定ディレクトリへのコピー

**前後の処理との関連**：GetTclKit.batでTcl環境をセットアップした後に実行することが推奨される。make.batと同じMakefile.mscを内部で使用する。

**影響範囲**：指定された出力ディレクトリに、プラットフォーム・構成別のサブディレクトリが作成され、ビルド成果物が配置される。

## バッチ種別

ビルド処理（マルチプラットフォーム）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリース時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Visual Studio Command Prompt | MSVCの環境変数が設定されたコマンドプロンプトから実行 |
| VCINSTALLDIR環境変数 | Visual Studioのインストールディレクトリが設定されていること |
| ComSpec環境変数 | システムのコマンドシェルパスが設定されていること |
| tclsh.exe | PATH上にTclシェルが存在すること（アマルガメーション生成用） |
| 出力ディレクトリ | コマンドライン引数で指定する空のディレクトリ |

### 実行可否判定

- VCINSTALLDIRが未定義の場合、エラー終了
- ComSpecが未定義の場合、エラー終了
- tclsh.exeがPATH上に存在しない場合、エラー終了
- コマンドライン引数（出力ディレクトリ）が未指定の場合、usage表示して終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| binaryDirectory | 文字列 | Yes | なし | 出力先ディレクトリパス |

### 環境変数による設定

| 環境変数名 | 説明 | デフォルト値 |
|-----------|------|-------------|
| PLATFORMS | ビルド対象プラットフォーム | x86 x86_amd64 x86_arm |
| CONFIGURATIONS | ビルド構成 | Debug Retail |
| USE_AUTOCONF_MAKEFILE | autoconf Makefileを使用 | 未設定 |
| NOCLEAN | クリーンスキップ | 未設定 |
| NOSYMBOLS | シンボルファイルスキップ | 未設定 |
| NOMEMDEBUG | MEMDEBUGを無効化 | 未設定 |
| BUILD_ALL_SHELL | シェルもビルド | 未設定 |
| NMAKE_ARGS | 追加nmake引数 | 未設定 |
| NMAKE_ARGS_DEBUG | Debug用追加引数 | 未設定 |
| NMAKE_ARGS_RETAIL | Retail用追加引数 | 未設定 |
| DLL_FILE_NAME | DLLファイル名 | sqlite3.dll |
| LIB_FILE_NAME | LIBファイル名 | sqlite3.lib |
| EXE_FILE_NAME | EXEファイル名 | sqlite3.exe |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Makefile.msc | Makefile | MSVCビルドルール |
| SQLiteソースファイル | C/H | ソースコード |
| vcvarsall.bat | BAT | MSVC環境設定バッチ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {binaryDirectory}\Debug\x86\ | フォルダ | x86 Debugビルド成果物 |
| {binaryDirectory}\Debug\x64\ | フォルダ | x64 Debugビルド成果物 |
| {binaryDirectory}\Debug\ARM\ | フォルダ | ARM Debugビルド成果物 |
| {binaryDirectory}\Retail\x86\ | フォルダ | x86 Retailビルド成果物 |
| {binaryDirectory}\Retail\x64\ | フォルダ | x64 Retailビルド成果物 |
| {binaryDirectory}\Retail\ARM\ | フォルダ | ARM Retailビルド成果物 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sqlite3.dll, sqlite3.lib, sqlite3.pdb（オプション）, sqlite3.exe（オプション） |
| 出力先 | {binaryDirectory}\{Configuration}\{Platform}\ |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化・環境変数設定
   └─ ROOT変数をスクリプト位置から設定
   └─ デフォルト値の設定（PLATFORMS、CONFIGURATIONS等）
2. 引数検証
   └─ binaryDirectoryが指定されているか確認
3. 環境チェック
   └─ ComSpec、VCINSTALLDIR、tclsh.exeの存在確認
4. プラットフォームループ開始（PLATFORMS）
   └─ 各プラットフォームについて：
      4.1. MSVC環境変数をクリア
      4.2. PATHをリセット
      4.3. 構成ループ開始（CONFIGURATIONS）
           └─ 各構成について：
              4.3.1. Debug時はDEBUG=3, MEMDEBUG=1を設定
              4.3.2. vcvarsall.batでMSVC環境をセットアップ
              4.3.3. Windows SDK/UCRTパスを設定（必要な場合）
              4.3.4. nmake cleanを実行（NOCLEANでない場合）
              4.3.5. nmakeでDLLをビルド
              4.3.6. DLL/LIB/PDBを出力ディレクトリにコピー
              4.3.7. BUILD_ALL_SHELL時はEXEもビルド・コピー
5. ディレクトリスタックを復元
6. 終了（成功/失敗）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数初期化]
    B --> C{引数チェック}
    C -->|なし| D[usage表示]
    D --> E[エラー終了]
    C -->|あり| F{環境チェック}
    F -->|NG| E
    F -->|OK| G[プラットフォームループ]
    G --> H[環境クリア・PATH リセット]
    H --> I[構成ループ]
    I --> J[vcvarsall.bat実行]
    J --> K{成功?}
    K -->|NG| E
    K -->|OK| L[nmake clean]
    L --> M[nmake DLL]
    M --> N{成功?}
    N -->|NG| E
    N -->|OK| O[ファイルコピー]
    O --> P{BUILD_ALL_SHELL?}
    P -->|Yes| Q[nmake EXE]
    Q --> R[EXEコピー]
    R --> S{次の構成?}
    P -->|No| S
    S -->|Yes| I
    S -->|No| T{次のプラットフォーム?}
    T -->|Yes| G
    T -->|No| U[成功終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベース操作を行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | binaryDirectoryが未指定 | 出力ディレクトリを指定して再実行 |
| 1 | 環境エラー | VCINSTALLDIRが未定義 | Visual Studio Command Promptから実行 |
| 1 | 環境エラー | ComSpecが未定義 | システム環境変数を確認 |
| 1 | 環境エラー | tclsh.exeが見つからない | GetTclKit.batでTclをセットアップ |
| 1 | ビルドエラー | vcvarsall.bat実行失敗 | Visual Studioインストールを確認 |
| 1 | ビルドエラー | nmake実行失敗 | コンパイルエラーを確認・修正 |
| 1 | コピーエラー | XCOPYに失敗 | 出力ディレクトリのアクセス権を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認し、どのプラットフォーム・構成で失敗したかを特定
2. 環境変数（VCINSTALLDIR等）が正しく設定されているか確認
3. tclsh.exeがPATH上に存在するか確認
4. 出力ディレクトリへの書き込み権限を確認
5. 問題を修正後、再度バッチを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（失敗時は部分的に出力が残る可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 6ビルド（3プラットフォーム x 2構成） |
| 目標処理時間 | 30分〜1時間程度（環境依存） |
| メモリ使用量上限 | 環境依存（nmakeおよびコンパイラによる） |

## 排他制御

- 同一ディレクトリでの同時実行は不可
- 複数のVisual Studio Command Promptから同時実行すると競合する可能性あり
- 出力ディレクトリは実行前に空であることを推奨

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各プラットフォーム・構成開始時 | "Building the {Config} configuration for platform {Platform}..." |
| ビルドログ | nmake実行中 | コンパイル・リンク進捗 |
| 成功ログ | 全ビルド完了時 | "Success, no errors were encountered." |
| エラーログ | エラー発生時 | 具体的なエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- このバッチは864行の大規模なスクリプトで、多数のヘルパー関数を含む
- Visual Studio 2012、2013、2015の特殊なSDKパス処理に対応
- Windows Phone SDK環境での実行にも対応
- クロスコンパイル（x86からx64/ARMへ）をサポート
- USE_AUTOCONF_MAKEFILEを設定するとautoconf/Makefile.mscを使用可能
