# バッチ設計書 3-GetTclKit.bat

## 概要

本ドキュメントは、SQLiteプロジェクトにおけるTclKitダウンロードツール（GetTclKit.bat）の設計仕様を記述したものである。

### 本バッチの処理概要

GetTclKit.batは、SQLiteのビルドに必要なTcl環境（TclKit）をインターネットからダウンロードし、セットアップするためのWindows用ユーティリティスクリプトである。

**業務上の目的・背景**：SQLiteのビルドプロセス（特にアマルガメーション生成）にはTclシェルが必要である。多くの開発環境ではTclがプリインストールされていないため、このバッチファイルにより必要なTcl環境を自動的にダウンロード・セットアップできる。これにより、開発者はTclを手動でインストールすることなく、SQLiteのビルドを開始できる。

**バッチの実行タイミング**：SQLiteビルド環境の初期セットアップ時に一度実行。Tcl環境が未セットアップの場合、build-all-msvc.bat等の実行前に実行が必要。

**主要な処理内容**：
1. プロセッサアーキテクチャ（x86/x64）の引数解析
2. .NET Framework C#コンパイラ（csc.exe）の検出
3. GetFile.csをコンパイルしてダウンローダーを生成
4. TclKit実行ファイルとSDKをダウンロード
5. SDKのZIPファイルを展開
6. 環境変数設定用バッチファイル（SetTclKitEnv.bat）を生成

**前後の処理との関連**：このバッチはbuild-all-msvc.batの前提となるTcl環境をセットアップする。生成されたSetTclKitEnv.batを実行することで、後続のビルドプロセスでTclが使用可能になる。

**影響範囲**：TEMPディレクトリにTclKit関連ファイルがダウンロードされ、指定ディレクトリにSetTclKitEnv.batが生成される。

## バッチ種別

環境構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（初回セットアップ時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| windir環境変数 | Windowsディレクトリパスが設定されていること |
| TEMP環境変数 | テンポラリディレクトリが設定されていること |
| .NET Framework | csc.exeが利用可能な.NET Frameworkがインストールされていること |
| インターネット接続 | TclKitダウンロード元にアクセス可能であること |

### 実行可否判定

- windirが未定義の場合、エラー終了
- TEMPが未定義の場合、エラー終了
- csc.exeが見つからない場合、エラー終了
- プロセッサ引数がx86/x64以外の場合、usage表示して終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| processor | 文字列 | Yes | なし | ターゲットアーキテクチャ（x86またはx64/AMD64） |

### 環境変数による設定

| 環境変数名 | 説明 | デフォルト値 |
|-----------|------|-------------|
| TCLKIT_URI | TclKitダウンロードURI | https://urn.to/r/tclsh/ |
| TCLKIT_PATCHLEVEL | TclKit SDKバージョン | 8.6.6 |
| TCLKIT_EXE_PATCHLEVEL | TclKit実行ファイルバージョン | 8.6.4 |
| TCLKIT_NOENV | 環境設定ファイル生成スキップ | 未設定 |
| TCLKIT_NOSDK | SDKダウンロードスキップ | 未設定 |
| ENVDIR | SetTclKitEnv.bat出力先 | カレントディレクトリ |
| FRAMEWORKDIR | .NET Frameworkディレクトリ | 自動検出 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GetFile.cs | C# | ダウンローダーソースコード（toolディレクトリ） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| %TEMP%\GetFile.exe | EXE | コンパイルされたダウンローダー |
| %TEMP%\tclkit-{version}.exe | EXE | TclKit実行ファイル |
| %TEMP%\unzip.exe | EXE | ZIP展開ツール |
| %TEMP%\libtclkit-sdk-{arch}-{version}.zip | ZIP | TclKit SDK |
| %TEMP%\libtclkit-sdk-{arch}-{version}\ | フォルダ | 展開されたSDK |
| {ENVDIR}\SetTclKitEnv.bat | BAT | 環境変数設定バッチ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | SetTclKitEnv.bat |
| 出力先 | ENVDIRで指定されたディレクトリ（デフォルト：カレント） |
| 文字コード | システムデフォルト |
| 内容 | TCLSH_CMD、TCLINCDIR、TCLLIBDIR等の環境変数設定 |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ processorパラメータをx86/x64に正規化（AMD64→x64変換）
2. 環境変数検証
   └─ windir、TEMPの存在確認
3. TclKitファイル名の設定
   └─ アーキテクチャに応じたファイル名を決定
4. C#コンパイラの検出
   └─ PATHからcsc.exeを検索
   └─ 見つからない場合、.NET Frameworkディレクトリを検索
5. GetFile.exeのコンパイル
   └─ GetFile.csをコンパイルしてダウンローダーを生成
6. TclKitファイルのダウンロード
   └─ tclkit-{version}.exe
   └─ unzip.exe（SDKダウンロード時）
   └─ libtclkit-sdk-{arch}-{version}.zip（SDKダウンロード時）
7. SDKの展開
   └─ ZIPファイルをTEMPディレクトリに展開
8. SetTclKitEnv.batの生成
   └─ 環境変数設定コマンドを書き出し
9. 完了メッセージ表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|なし/不正| C[usage表示]
    C --> D[エラー終了]
    B -->|OK| E{環境変数チェック}
    E -->|NG| D
    E -->|OK| F[TclKit変数設定]
    F --> G{csc.exe存在?}
    G -->|No| H[.NET Framework検索]
    H -->|見つからない| D
    H -->|見つかった| I[PATHに追加]
    G -->|Yes| J{GetFile.exe存在?}
    I --> J
    J -->|No| K[GetFile.csコンパイル]
    K -->|失敗| D
    K -->|成功| L[ファイルダウンロード]
    J -->|Yes| L
    L -->|失敗| D
    L -->|成功| M{SDK必要?}
    M -->|Yes| N[SDKダウンロード]
    N --> O[ZIP展開]
    O --> P[SetTclKitEnv.bat生成]
    M -->|No| P
    P --> Q[成功終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベース操作を行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | processorが未指定または無効 | x86またはx64を指定して再実行 |
| 1 | 環境エラー | windirが未定義 | システム環境変数を確認 |
| 1 | 環境エラー | TEMPが未定義 | TEMP環境変数を設定 |
| 1 | 環境エラー | csc.exeが見つからない | .NET Frameworkをインストール |
| 1 | コンパイルエラー | GetFile.csのコンパイル失敗 | .NET Framework環境を確認 |
| 1 | ダウンロードエラー | ファイルダウンロード失敗 | ネットワーク接続を確認 |
| 1 | 展開エラー | ZIPファイル展開失敗 | TEMPディレクトリの空き容量を確認 |
| 1 | ディレクトリエラー | SDKディレクトリ作成失敗 | TEMPディレクトリのアクセス権を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認し、どの段階で失敗したかを特定
2. ネットワーク接続を確認（ダウンロードエラーの場合）
3. .NET Frameworkのインストール状態を確認
4. TEMPディレクトリの空き容量とアクセス権を確認
5. 問題を修正後、再度バッチを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（失敗時は部分的にファイルが残る可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 3〜4ファイルのダウンロード |
| 目標処理時間 | 数分程度（ネットワーク速度依存） |
| メモリ使用量上限 | 環境依存（C#コンパイラおよびunzipによる） |

## 排他制御

同一TEMPディレクトリへの同時実行は非推奨。ダウンロードファイルが競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | ダウンロード中 | GetFile.exeの出力 |
| 成功ログ | 完了時 | "Wrote SetTclKitEnv.bat" メッセージ |
| エラーログ | エラー発生時 | 具体的なエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- TclKitダウンロードURIはデフォルトで https://urn.to/r/tclsh/ を使用
- x86向けとx64向けで異なるSDKファイルがダウンロードされる
- TCLKIT_NOENVを設定するとSetTclKitEnv.batの生成をスキップできる
- TCLKIT_NOSDKを設定するとSDKのダウンロード・展開をスキップできる
- 生成されたSetTclKitEnv.batを実行することで、TCLSH_CMD、TCLINCDIR、TCLLIBDIR等の環境変数が設定される
- .NET Framework 2.0、3.5、4.0のいずれかが必要
