# バッチ設計書 4-build-shell.sh

## 概要

本ドキュメントは、SQLiteプロジェクトにおけるsqlite3コマンドラインシェルのフルビルドスクリプト（build-shell.sh）の設計仕様を記述したものである。

### 本バッチの処理概要

build-shell.shは、Linux環境においてsqlite3コマンドラインシェルをFTS、RTREE、readline対応でフルビルドするためのシェルスクリプトである。

**業務上の目的・背景**：SQLiteの公式コマンドラインツールである`sqlite3`シェルを、開発者やエンドユーザー向けに機能拡張版としてビルドする。標準ビルドでは無効化されているFTS（全文検索）、RTREE（空間インデックス）、readlineサポートを有効にすることで、より使いやすく高機能なシェルを提供する。

**バッチの実行タイミング**：開発者が手動で実行。高機能なsqlite3シェルが必要な場合、またはSQLiteの拡張機能を含むシェルをテストする際に随時実行される。

**主要な処理内容**：
1. makeコマンドでsqlite3.c（アマルガメーション）を生成
2. gccでsqlite3シェルをコンパイル
3. FTS4、RTREE、VFSTRACEなどの拡張機能を有効化
4. readlineサポートを有効化してインタラクティブな編集機能を提供

**前後の処理との関連**：SQLiteソースコードが`../sqlite`ディレクトリに配置されていることが前提。Makefileが適切に設定されている必要がある。

**影響範囲**：カレントディレクトリにsqlite3実行ファイルが生成される。

## バッチ種別

ビルド処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux環境 | LinuxまたはUnix互換環境で実行 |
| GCCコンパイラ | gccがインストールされていること |
| SQLiteソースコード | `../sqlite`ディレクトリにソースコードが存在 |
| Makefile | カレントディレクトリにMakefileが存在 |
| readline開発ライブラリ | libreadline-devがインストールされていること |
| ncurses開発ライブラリ | libncurses-devがインストールされていること |

### 実行可否判定

- gccが利用可能であること
- makeコマンドが利用可能であること
- sqlite3.cが生成可能であること（Makefileが正しく設定されていること）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ../sqlite/src/shell.c | C | シェルのメインソースコード |
| ../sqlite/ext/misc/vfstrace.c | C | VFSトレース拡張機能 |
| sqlite3.c | C | SQLiteアマルガメーション（makeで生成） |
| Makefile | Makefile | ビルドルール定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| sqlite3 | EXE | SQLiteコマンドラインシェル実行ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sqlite3 |
| 出力先 | カレントディレクトリ |
| 文字コード | バイナリ（ELF実行ファイル） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. sqlite3.cの生成
   └─ make sqlite3.c を実行してアマルガメーションを生成
2. sqlite3シェルのコンパイル
   └─ gccでsqlite3シェルをコンパイル
   └─ 最適化オプション: -g -Os
   └─ インクルードパス: -I.
   └─ 有効化するマクロ:
      - SQLITE_THREADSAFE=0（シングルスレッドモード）
      - SQLITE_ENABLE_VFSTRACE（VFSトレース有効）
      - SQLITE_ENABLE_STAT3（統計情報有効）
      - SQLITE_ENABLE_FTS4（全文検索有効）
      - SQLITE_ENABLE_RTREE（R-Tree有効）
      - HAVE_READLINE（readline有効）
   └─ リンクするライブラリ: -ldl -lreadline -lncurses
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[make sqlite3.c]
    B --> C{成功?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[gcc コンパイル実行]
    E --> F{成功?}
    F -->|No| D
    F -->|Yes| G[sqlite3 生成完了]
    G --> H[スクリプト終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベース操作を行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | make失敗 | sqlite3.c生成に失敗 | Makefileとソースパスを確認 |
| 非ゼロ | コンパイルエラー | ソースコードエラー | ソースコードを確認 |
| 非ゼロ | リンクエラー | ライブラリが見つからない | readline, ncursesをインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認し、コンパイルエラーかリンクエラーかを特定
2. `../sqlite`ディレクトリにSQLiteソースコードが存在するか確認
3. readline、ncursesの開発ライブラリがインストールされているか確認
   - Debian/Ubuntu: `apt-get install libreadline-dev libncurses-dev`
   - RHEL/CentOS: `yum install readline-devel ncurses-devel`
4. 問題を修正後、再度スクリプトを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルド |
| 目標処理時間 | 1〜5分程度（環境依存） |
| メモリ使用量上限 | 環境依存（gccによる） |

## 排他制御

同一ディレクトリでの同時実行は非推奨。出力ファイルが競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ビルドログ | コンパイル中 | gccの出力（標準出力/標準エラー出力） |
| エラーログ | エラー発生時 | コンパイルエラー・リンクエラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- このスクリプトは22行のシンプルなビルドスクリプト
- デバッグ情報（-g）とサイズ最適化（-Os）を同時に有効化
- SQLITE_THREADSAFE=0でシングルスレッドモードとしてビルド（マルチスレッド不要な場合に最適）
- VFSTRACEはファイルシステムアクセスのトレース機能を提供
- SQLITE_ENABLE_STAT3は廃止予定であり、SQLITE_ENABLE_STAT4への移行が推奨される
- ディレクトリ構造の想定：
  ```
  ~/sqlite/sqlite/  <- SQLiteソースコード
  ~/sqlite/bld/     <- ビルドディレクトリ（このスクリプトを実行）
  ```
