# バッチ設計書 5-mkautoconfamal.sh

## 概要

本ドキュメントは、SQLiteプロジェクトにおけるautoconf用アマルガメーションパッケージ作成スクリプト（mkautoconfamal.sh）の設計仕様を記述したものである。

### 本バッチの処理概要

mkautoconfamal.shは、SQLiteのautoconf配布用パッケージ（tarball）を作成するためのシェルスクリプトである。sqlite3.c、sqlite3.h、shell.c等のアマルガメーションファイルとautoconfビルドシステムを含む配布用アーカイブを生成する。

**業務上の目的・背景**：SQLiteを各種Unix/Linux環境で簡単にビルド・インストールできるようにするため、autoconfベースの配布パッケージを提供する必要がある。このスクリプトにより、標準的な`./configure && make && make install`の手順でSQLiteをインストールできるパッケージを自動生成できる。公式リリースやスナップショットビルドの配布に使用される。

**バッチの実行タイミング**：SQLiteの公式リリース時、またはスナップショット配布パッケージを作成する時に手動実行。CI/CDパイプラインからの自動実行も想定。

**主要な処理内容**：
1. バージョン情報（VERSION、manifest.uuid、manifest）の取得
2. 一時ディレクトリ（mkpkg_tmp_dir）の作成
3. autoconf関連ファイルのコピー
4. アマルガメーションファイル（sqlite3.c、sqlite3.h等）のコピー
5. Tcl拡張用ファイルの生成
6. 不要ファイル（バックアップ、オブジェクトファイル等）の削除
7. configureとmake distの実行
8. tarballの作成と名前変更

**前後の処理との関連**：事前にsqlite3.c、sqlite3.h、sqlite3ext.h、shell.c、sqlite3rc.hがカレントディレクトリに生成されている必要がある。環境変数$TOPにSQLiteソースツリーのルートが設定されている必要がある。

**影響範囲**：カレントディレクトリにtarballファイル（sqlite-autoconf-*.tar.gz）が生成される。

## バッチ種別

パッケージング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | リリース時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| $TOP環境変数 | SQLiteソースツリーのルートパスが設定されていること |
| アマルガメーションファイル | sqlite3.c、sqlite3.h、sqlite3ext.h、shell.c、sqlite3rc.hが存在 |
| autoconf/autosetup | $TOP/autoconf、$TOP/autosetupディレクトリが存在 |
| VERSION/manifestファイル | $TOP/VERSION、$TOP/manifest、$TOP/manifest.uuidが存在 |
| makeコマンド | makeまたは$MAKEで指定されたビルドツールが利用可能 |

### 実行可否判定

- $TOPが未設定の場合、スクリプトは失敗する
- 必要なファイルが存在しない場合、スクリプトは失敗する
- set -e により、コマンドが失敗すると即座に終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --snapshot | フラグ | No | なし | スナップショットtarball名を使用 |

### 環境変数による設定

| 環境変数名 | 説明 | デフォルト値 |
|-----------|------|-------------|
| TOP | SQLiteソースツリーのルートパス | なし（必須） |
| MAKE | makeコマンド | make |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| sqlite3.c | C | SQLiteアマルガメーション |
| sqlite3.h | H | SQLiteヘッダ |
| sqlite3ext.h | H | SQLite拡張ヘッダ |
| sqlite3rc.h | H | リソースヘッダ |
| shell.c | C | シェルソース |
| $TOP/VERSION | テキスト | バージョン番号 |
| $TOP/manifest | テキスト | マニフェスト（日付情報含む） |
| $TOP/manifest.uuid | テキスト | チェックアウトハッシュ |
| $TOP/autoconf/ | ディレクトリ | autoconf関連ファイル |
| $TOP/autosetup/ | ディレクトリ | autosetup関連ファイル |
| $TOP/src/tclsqlite.c | C | Tcl拡張ソース |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| sqlite-autoconf-3XXYYZZ.tar.gz | tarball | リリース用パッケージ |
| sqlite-snapshot-YYYYMMDDHHMMSS.tar.gz | tarball | スナップショット用パッケージ（--snapshot時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sqlite-autoconf-3XXYYZZ.tar.gz（バージョンに基づく） |
| 出力先 | カレントディレクトリ |
| 文字コード | gzip圧縮されたtarアーカイブ |
| 内容 | sqlite3.c/h、shell.c、configure、Makefile.in等 |

### tarball内容物

```
sqlite-autoconf-3XXYYZZ/
├── configure
├── Makefile.in
├── sqlite3.c
├── sqlite3.h
├── sqlite3ext.h
├── sqlite3rc.h
├── shell.c
├── sqlite3.1 (manページ)
├── sqlite3.pc.in (pkg-config用)
├── sqlite3.rc (Windowsリソース)
├── autoconf/
├── autosetup/
├── tea/
│   └── generic/
│       └── tclsqlite3.c
└── ...
```

## 処理フロー

### 処理シーケンス

```
1. エラー時即終了設定
   └─ set -e, set -u を設定
2. バージョン情報取得
   └─ VERSION、HASH、DATETIMEを読み取り
3. tarball名の決定
   └─ --snapshotならDATETIMEベース、そうでなければバージョンベース
4. 一時ディレクトリの準備
   └─ ./mkpkg_tmp_dir を削除・再作成
5. ファイルのコピー
   └─ autoconf、autosetup、configureをコピー
   └─ アマルガメーションファイルをコピー
   └─ その他必要ファイルをコピー
6. Tcl拡張ファイルの生成
   └─ tea/generic/tclsqlite3.c を生成
7. クリーンアップ
   └─ バックアップファイル、オブジェクトファイル等を削除
8. configure && make dist実行
   └─ configure実行でMakefile生成
   └─ make distでソースパッケージ作成
9. tarballの名前変更と移動
   └─ バージョン名またはスナップショット名に変更
   └─ 上位ディレクトリに移動
10. 結果表示
    └─ ls -l でファイルサイズを表示
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[set -e, set -u]
    B --> C[バージョン情報取得]
    C --> D{--snapshot?}
    D -->|Yes| E[スナップショット名設定]
    D -->|No| F[バージョン名設定]
    E --> G[一時ディレクトリ準備]
    F --> G
    G --> H[ファイルコピー]
    H --> I[Tcl拡張ファイル生成]
    I --> J[不要ファイル削除]
    J --> K[configure実行]
    K --> L{成功?}
    L -->|No| M[エラー終了]
    L -->|Yes| N[make dist実行]
    N --> O{成功?}
    O -->|No| M
    O -->|Yes| P[tarball名変更・移動]
    P --> Q[結果表示]
    Q --> R[スクリプト終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベース操作を行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | 環境エラー | $TOPが未設定 | TOP環境変数を設定 |
| 非ゼロ | ファイルエラー | 必要なファイルが存在しない | アマルガメーションを先に生成 |
| 非ゼロ | configure失敗 | autoconf環境の問題 | autoconf関連ファイルを確認 |
| 非ゼロ | make失敗 | ビルド環境の問題 | makeコマンドを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認し、どの段階で失敗したかを特定
2. $TOP環境変数が正しく設定されているか確認
3. 必要なアマルガメーションファイルが存在するか確認
4. mkpkg_tmp_dirディレクトリを手動で削除してリトライ
5. 問題を修正後、再度スクリプトを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A（失敗時は一時ディレクトリが残る可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1パッケージ生成 |
| 目標処理時間 | 数分程度 |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一ディレクトリでの同時実行は不可（mkpkg_tmp_dirが競合）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | configure/make実行中 | ビルド進捗（標準出力） |
| 結果ログ | 完了時 | ls -l によるファイル情報 |
| エラーログ | エラー発生時 | シェルのエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- このスクリプトは97行のパッケージング用スクリプト
- set -e と set -u により、エラー時即終了と未定義変数使用時エラーを有効化
- tarball名はバージョン番号から自動生成（例：3.36.0 → sqlite-autoconf-3360000）
- --snapshotオプション使用時は、マニフェストの日付からファイル名を生成
- tree コマンドで一時ディレクトリの内容を表示（デバッグ用）
- Tcl拡張（TEA: Tcl Extension Architecture）用のファイルも生成される
