# バッチ設計書 7-warnings-clang.sh

## 概要

本ドキュメントは、SQLiteプロジェクトにおけるClang静的解析による警告チェックスクリプト（warnings-clang.sh）の設計仕様を記述したものである。

### 本バッチの処理概要

warnings-clang.shは、Clangコンパイラのscan-build静的解析ツールを使用してSQLiteソースコードの品質をチェックするスクリプトである。GCCベースのwarnings.shを補完し、Clang特有の解析機能を活用して潜在的なバグを検出する。

**業務上の目的・背景**：Clangの静的解析ツール（scan-build）は、GCCとは異なる解析アルゴリズムを持ち、メモリリーク、NULL参照、未初期化変数などの問題をより詳細に検出できる。SQLiteの品質保証において、GCCとClangの両方で検証することで、より網羅的な品質チェックを実現する。

**バッチの実行タイミング**：コード変更後の品質チェック時に手動実行。CI/CDパイプラインからの自動実行も想定。warnings.shと併用することが推奨される。

**主要な処理内容**：
1. 既存のsqlite3.c、shell.cを削除し、最新版を再生成
2. scan-buildを使用してFTS4、RTREE設定でコンパイル・解析
3. scan-buildを使用してSTAT3、THREADSAFE=0設定でコンパイル・解析
4. 解析結果から'ANALYZE:'行をフィルタリングして出力

**前後の処理との関連**：有効なMakefileがカレントディレクトリに存在する必要がある。warnings.shと同様の前提条件。

**影響範囲**：カレントディレクトリにsqlite3.o等のオブジェクトファイルが生成される。scan-buildの解析レポートが生成される場合がある。

## バッチ種別

品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（コード変更後） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Clangコンパイラ | clangがインストールされていること |
| scan-build | Clang静的解析ツールがインストールされていること |
| GCCコンパイラ | gccがインストールされていること（scan-buildがgccを呼び出す） |
| Makefile | カレントディレクトリに有効なMakefileが存在 |
| makeコマンド | sqlite3.c、shell.cを生成できること |

### 実行可否判定

- scan-buildが利用可能であること
- gccが利用可能であること
- makeコマンドでsqlite3.c、shell.cを生成できること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Makefile | Makefile | ビルドルール定義 |
| SQLiteソースファイル | C/H | アマルガメーション生成元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| sqlite3.o | OBJ | コンパイルテスト用オブジェクトファイル |
| shell.o | OBJ | シェル用オブジェクトファイル |
| 標準出力 | テキスト | 警告・解析結果（ANALYZE行を除く） |
| scan-build出力ディレクトリ | HTML | 詳細解析レポート（問題検出時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sqlite3.o、shell.o（一時ファイル） |
| 出力先 | カレントディレクトリ |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 既存ファイルの削除と再生成
   └─ rm -f sqlite3.c shell.c
   └─ make sqlite3.c shell.c
2. FTS4/RTREE設定でscan-build解析
   └─ scan-build gcc -c -DHAVE_STDINT_H
      -DSQLITE_ENABLE_FTS4 -DSQLITE_ENABLE_RTREE
      -DSQLITE_DEBUG -DSQLITE_ENABLE_STAT3 sqlite3.c
   └─ grep -v 'ANALYZE:' でフィルタリング
3. STAT3/THREADSAFE=0設定でscan-build解析
   └─ scan-build gcc -c -I.
      -DSQLITE_ENABLE_STAT3 -DSQLITE_THREADSAFE=0
      -DSQLITE_DEBUG sqlite3.c shell.c -ldl
   └─ grep -v 'ANALYZE:' でフィルタリング
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[sqlite3.c shell.c削除]
    B --> C[make sqlite3.c shell.c]
    C --> D{成功?}
    D -->|No| E[エラー終了]
    D -->|Yes| F[FTS4/RTREE設定でscan-build]
    F --> G[ANALYZE行をフィルタ]
    G --> H[STAT3/THREADSAFE=0設定でscan-build]
    H --> I[ANALYZE行をフィルタ]
    I --> J[スクリプト終了]
```

## 解析設定一覧

### テスト1：FTS4/RTREE設定

| 項目 | 値 |
|-----|-----|
| 有効機能 | FTS4, RTREE, STAT3 |
| デバッグ | SQLITE_DEBUG有効 |
| 対象ファイル | sqlite3.c |
| 解析ツール | scan-build + gcc |

### テスト2：STAT3/THREADSAFE=0設定

| 項目 | 値 |
|-----|-----|
| 有効機能 | STAT3 |
| スレッド | THREADSAFE=0 |
| デバッグ | SQLITE_DEBUG有効 |
| 対象ファイル | sqlite3.c, shell.c |
| 解析ツール | scan-build + gcc |
| リンク | -ldl |

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベース操作を行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | コンパイルエラー | 構文エラー | ソースコードを確認・修正 |
| 警告出力 | 静的解析警告 | 潜在的問題検出 | 警告内容を確認・修正 |
| 非ゼロ | make失敗 | sqlite3.c/shell.c生成失敗 | Makefileを確認 |
| 非ゼロ | scan-build未検出 | ツール未インストール | Clangをインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認し、コンパイルエラーか解析警告かを特定
2. scan-buildがインストールされているか確認（`which scan-build`）
3. Clangがインストールされているか確認
4. Makefileが正しく設定されているか確認
5. 警告の場合、内容を分析して必要に応じてコードを修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 2回の解析 |
| 目標処理時間 | 数分〜10分程度（解析は時間がかかる） |
| メモリ使用量上限 | 環境依存（scan-buildによる） |

## 排他制御

同一ディレクトリでの同時実行は非推奨（sqlite3.c、shell.c、オブジェクトファイルが競合）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダー | 各テスト前 | テスト設定の説明（echoで出力） |
| 解析ログ | scan-build実行中 | 静的解析の結果（ANALYZE行除く） |
| HTMLレポート | 問題検出時 | scan-buildの詳細解析レポート |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 解析警告件数 | 0件（理想） | CI/CD通知 |

## 備考

- このスクリプトは15行のコンパクトな品質検証スクリプト
- scan-buildはClang Static Analyzerのコマンドラインインターフェース
- `grep -v 'ANALYZE:'` でscan-buildの解析プログレス出力をフィルタリング
- SQLITE_DEBUG有効により、追加のアサーションチェックが有効化される
- warnings.shと併用することで、GCCとClang両方の観点からコード品質を検証可能
- scan-buildは問題を検出した場合、HTML形式の詳細レポートを生成することがある
- STAT3は廃止予定であり、STAT4への移行が推奨される
