# バッチ設計書 8-symbols.sh

## 概要

本ドキュメントは、SQLiteプロジェクトにおけるエクスポートシンボル検証スクリプト（symbols.sh）の設計仕様を記述したものである。

### 本バッチの処理概要

symbols.shは、SQLiteライブラリからエクスポートされるシンボル（関数名等）を検証し、意図しないシンボルのエクスポートを検出するための品質検証スクリプトである。nmコマンドを使用してオブジェクトファイルのシンボルテーブルを解析する。

**業務上の目的・背景**：SQLiteはライブラリとして多くのプロジェクトに組み込まれるため、シンボル名の衝突を避けることが重要である。公式API（sqlite3_*プレフィックス）以外のシンボルがエクスポートされると、他のライブラリとの競合や予期しない動作の原因となる。このスクリプトにより、意図しないシンボルのエクスポートを早期に検出し、修正できる。

**バッチの実行タイミング**：コード変更後の品質チェック時に手動実行。リリース前のチェックリストの一部として実行。CI/CDパイプラインからの自動実行も想定。

**主要な処理内容**：
1. sqlite3.cの生成
2. 各種拡張機能を有効化したビルドでのエクスポートシンボル一覧表示
3. sqlite3_*以外の意図しないシンボルの検出・表示
4. 外部依存シンボル（未定義シンボル）の一覧表示

**前後の処理との関連**：有効なMakefileがカレントディレクトリに存在する必要がある。

**影響範囲**：カレントディレクトリにsqlite3.oオブジェクトファイルが生成される。

## バッチ種別

品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（コード変更後、リリース前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GCCコンパイラ | gccがインストールされていること |
| nmコマンド | GNU nmまたは互換のnmコマンドが利用可能 |
| Makefile | カレントディレクトリに有効なMakefileが存在 |
| makeコマンド | sqlite3.cを生成できること |

### 実行可否判定

- gccが利用可能であること
- nmが利用可能であること
- makeコマンドでsqlite3.cを生成できること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Makefile | Makefile | ビルドルール定義 |
| SQLiteソースファイル | C/H | アマルガメーション生成元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| sqlite3.o | OBJ | コンパイル済みオブジェクトファイル |
| 標準出力 | テキスト | シンボル一覧・検証結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sqlite3.o（一時ファイル） |
| 出力先 | カレントディレクトリ |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. アマルガメーション生成
   └─ make sqlite3.c
2. フルビルド（拡張機能有効）でのエクスポートシンボル検証
   └─ gcc -c で多数の拡張機能を有効化してコンパイル
      - FTS3, RTREE, MEMORY_MANAGEMENT, STAT3
      - MEMSYS5, UNLOCK_NOTIFY, COLUMN_METADATA
      - ATOMIC_WRITE, PREUPDATE_HOOK, SESSION
      - FTS5, GEOPOLY
   └─ nm sqlite3.o | grep ' [TD] ' | sort -k 3
      （定義済みシンボルを表示）
3. 意図しないシンボルの検出
   └─ nm sqlite3.o | grep ' [TD] ' |
      egrep -v ' .*sqlite3(session|rebaser|changeset|changegroup)?_'
      （sqlite3_*以外のシンボルを検出）
4. コアのみビルドでの外部依存確認
   └─ gcc -c -DSQLITE_OS_OTHER -DSQLITE_THREADSAFE=0
      （OS依存なし、シングルスレッドでコンパイル）
   └─ nm sqlite3.o | grep ' U ' | sort -k 3
      （未定義シンボル＝外部依存を表示）
5. 拡張機能有効ビルドでの外部依存確認
   └─ gcc -c でFTS3, RTREEを有効化してコンパイル
   └─ nm sqlite3.o | grep ' U ' | sort -k 3
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[make sqlite3.c]
    B --> C[フルビルド gcc -c]
    C --> D[nm で定義済みシンボル表示]
    D --> E[意図しないシンボル検出]
    E --> F[コアのみビルド gcc -c]
    F --> G[nm で未定義シンボル表示]
    G --> H[拡張機能有効ビルド gcc -c]
    H --> I[nm で未定義シンボル表示]
    I --> J[スクリプト終了]
```

## 検証設定一覧

### 検証1：エクスポートシンボル検証（フルビルド）

| 項目 | 値 |
|-----|-----|
| 有効機能 | FTS3, RTREE, MEMORY_MANAGEMENT, STAT3, MEMSYS5, UNLOCK_NOTIFY, COLUMN_METADATA, ATOMIC_WRITE, PREUPDATE_HOOK, SESSION, FTS5, GEOPOLY |
| nmフィルタ | ' [TD] '（テキスト/データセクションの定義済みシンボル） |
| ソート | シンボル名でソート（-k 3） |

### 検証2：意図しないシンボル検出

| 項目 | 値 |
|-----|-----|
| 検出対象 | sqlite3_*, sqlite3session_*, sqlite3rebaser_*, sqlite3changeset_*, sqlite3changegroup_* 以外のシンボル |
| egrepパターン | `' .*sqlite3(session\|rebaser\|changeset\|changegroup)?_'` の否定 |

### 検証3：外部依存確認（コアのみ）

| 項目 | 値 |
|-----|-----|
| 有効機能 | MEMORY_MANAGEMENT, STAT3, MEMSYS5, UNLOCK_NOTIFY, COLUMN_METADATA, ATOMIC_WRITE |
| 無効機能 | OS_OTHER（OSインターフェースなし）, THREADSAFE=0 |
| nmフィルタ | ' U '（未定義シンボル＝外部依存） |

### 検証4：外部依存確認（拡張機能有効）

| 項目 | 値 |
|-----|-----|
| 有効機能 | FTS3, RTREE, MEMORY_MANAGEMENT, STAT3, MEMSYS5, UNLOCK_NOTIFY, COLUMN_METADATA, ATOMIC_WRITE |
| nmフィルタ | ' U '（未定義シンボル＝外部依存） |

## nmコマンド出力の見方

| シンボルタイプ | 意味 |
|--------------|------|
| T | テキストセクション（関数）の定義 |
| D | データセクション（グローバル変数）の定義 |
| U | 未定義（外部依存） |

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベース操作を行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | make失敗 | sqlite3.c生成失敗 | Makefileを確認 |
| 非ゼロ | コンパイルエラー | ソースコードエラー | ソースコードを確認 |
| 出力あり | 意図しないシンボル | 不正なシンボルエクスポート | シンボルをstatic化またはプレフィックス変更 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 意図しないシンボルが検出された場合
   - 該当関数をstaticに変更
   - または sqlite3_ プレフィックスを追加
2. 外部依存が予期しないものである場合
   - コードをレビューして依存を削除または条件付きに

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 4回のコンパイル・解析 |
| 目標処理時間 | 数分程度 |
| メモリ使用量上限 | 環境依存（gccによる） |

## 排他制御

同一ディレクトリでの同時実行は非推奨（sqlite3.oが競合）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダー | 各検証前 | 検証内容の説明（echoで出力） |
| シンボル一覧 | nm実行後 | エクスポートシンボル・外部依存の一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 意図しないシンボル数 | 0件（理想） | CI/CD通知 |

## 備考

- このスクリプトは37行の品質検証スクリプト
- egrepで複数のプレフィックスパターン（session, rebaser, changeset, changegroup）を許容
- SQLITE_OS_OTHERにより、OSインターフェースを含まない純粋なSQLiteコアの依存関係を確認可能
- 外部依存（未定義シンボル）は、標準Cライブラリ関数が中心であることが期待される
- 意図しないシンボルエクスポートがあると、他のライブラリと名前空間が衝突する可能性がある
