# バッチ設計書 9-symbols-mingw.sh

## 概要

本ドキュメントは、SQLiteプロジェクトにおけるMinGW環境でのエクスポートシンボル検証スクリプト（symbols-mingw.sh）の設計仕様を記述したものである。

### 本バッチの処理概要

symbols-mingw.shは、symbols.shのMinGW環境版であり、MinGWのGCCとnmを使用してSQLiteライブラリのエクスポートシンボルを検証する。Windows/MinGW環境でのシンボル衝突を防ぐための品質検証を行う。

**業務上の目的・背景**：MinGW環境でSQLiteをビルドする場合、Linux環境とは異なるシンボルエクスポート挙動がある可能性がある。このスクリプトにより、MinGW環境特有のシンボルエクスポート問題を検出できる。symbols.shと同様に、意図しないシンボルのエクスポートを検出し、他のライブラリとの名前空間衝突を防ぐ。

**バッチの実行タイミング**：MinGW環境でのコード変更後の品質チェック時に手動実行。Windows向けリリース前のチェックリストの一部として実行。

**主要な処理内容**：
1. sqlite3.cの生成
2. FTS3、RTREE等を有効化したビルドでのエクスポートシンボル一覧表示
3. sqlite3_*以外の意図しないシンボルの検出・表示
4. 外部依存シンボル（未定義シンボル）の一覧表示

**前後の処理との関連**：symbols.shと同じロジックをMinGW環境向けに調整したもの。有効なMakefileがカレントディレクトリに存在する必要がある。

**影響範囲**：カレントディレクトリにsqlite3.oオブジェクトファイルが生成される。

## バッチ種別

品質検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（コード変更後、リリース前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| MinGW環境 | MinGWがインストールされていること |
| GCCコンパイラ | MinGWのgccがインストールされていること |
| nmコマンド | MinGWのnmコマンドが利用可能 |
| Makefile | カレントディレクトリに有効なMakefileが存在 |
| makeコマンド | sqlite3.cを生成できること |

### 実行可否判定

- MinGW環境のgccが利用可能であること
- MinGW環境のnmが利用可能であること
- makeコマンドでsqlite3.cを生成できること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数は不要 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Makefile | Makefile | ビルドルール定義 |
| SQLiteソースファイル | C/H | アマルガメーション生成元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| sqlite3.o | OBJ | コンパイル済みオブジェクトファイル |
| 標準出力 | テキスト | シンボル一覧・検証結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sqlite3.o（一時ファイル） |
| 出力先 | カレントディレクトリ |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. アマルガメーション生成
   └─ make sqlite3.c
2. フルビルド（拡張機能有効）でのエクスポートシンボル検証
   └─ gcc -c で拡張機能を有効化してコンパイル
      - FTS3, RTREE, MEMORY_MANAGEMENT, STAT3
      - MEMSYS5, UNLOCK_NOTIFY, COLUMN_METADATA, ATOMIC_WRITE
   └─ nm sqlite3.o | grep " [TD] "
      （定義済みシンボルを表示）
3. 意図しないシンボルの検出
   └─ nm sqlite3.o | grep " [TD] " |
      grep -v " .*sqlite3_"
      （sqlite3_*以外のシンボルを検出）
4. コアのみビルドでの外部依存確認
   └─ gcc -c -DSQLITE_OS_OTHER -DSQLITE_THREADSAFE=0
      （OS依存なし、シングルスレッドでコンパイル）
   └─ nm sqlite3.o | grep " U "
      （未定義シンボル＝外部依存を表示）
5. 拡張機能有効ビルドでの外部依存確認
   └─ gcc -c でFTS3, RTREEを有効化してコンパイル
   └─ nm sqlite3.o | grep " U "
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[make sqlite3.c]
    B --> C[フルビルド gcc -c]
    C --> D[nm で定義済みシンボル表示]
    D --> E[意図しないシンボル検出]
    E --> F[コアのみビルド gcc -c]
    F --> G[nm で未定義シンボル表示]
    G --> H[拡張機能有効ビルド gcc -c]
    H --> I[nm で未定義シンボル表示]
    I --> J[スクリプト終了]
```

## symbols.shとの違い

| 項目 | symbols.sh | symbols-mingw.sh |
|-----|-----------|------------------|
| 対象環境 | Linux/Unix | MinGW (Windows) |
| FTS5 | 有効 | 無効 |
| GEOPOLY | 有効 | 無効 |
| PREUPDATE_HOOK | 有効 | 無効 |
| SESSION | 有効 | 無効 |
| シンボルフィルタ | egrep（session等含む） | grep（sqlite3_のみ） |
| ソート | sort -k 3 | なし |

## 検証設定一覧

### 検証1：エクスポートシンボル検証（フルビルド）

| 項目 | 値 |
|-----|-----|
| 有効機能 | FTS3, RTREE, MEMORY_MANAGEMENT, STAT3, MEMSYS5, UNLOCK_NOTIFY, COLUMN_METADATA, ATOMIC_WRITE |
| nmフィルタ | " [TD] "（定義済みシンボル） |

### 検証2：意図しないシンボル検出

| 項目 | 値 |
|-----|-----|
| 検出対象 | sqlite3_* 以外のシンボル |
| grepパターン | `" .*sqlite3_"` の否定 |

### 検証3：外部依存確認（コアのみ）

| 項目 | 値 |
|-----|-----|
| 有効機能 | MEMORY_MANAGEMENT, STAT3, MEMSYS5, UNLOCK_NOTIFY, COLUMN_METADATA, ATOMIC_WRITE |
| 無効機能 | OS_OTHER（OSインターフェースなし）, THREADSAFE=0 |
| nmフィルタ | " U "（未定義シンボル） |

### 検証4：外部依存確認（拡張機能有効）

| 項目 | 値 |
|-----|-----|
| 有効機能 | FTS3, RTREE, MEMORY_MANAGEMENT, STAT3, MEMSYS5, UNLOCK_NOTIFY, COLUMN_METADATA, ATOMIC_WRITE |
| nmフィルタ | " U "（未定義シンボル） |

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベース操作を行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | make失敗 | sqlite3.c生成失敗 | Makefileを確認 |
| 非ゼロ | コンパイルエラー | ソースコードエラー | ソースコードを確認 |
| 出力あり | 意図しないシンボル | 不正なシンボルエクスポート | シンボルをstatic化 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 意図しないシンボルが検出された場合
   - 該当関数をstaticに変更
   - または sqlite3_ プレフィックスを追加
2. MinGW固有の問題がある場合
   - MinGW環境の設定を確認
   - symbols.shの結果と比較

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 4回のコンパイル・解析 |
| 目標処理時間 | 数分程度 |
| メモリ使用量上限 | 環境依存（gccによる） |

## 排他制御

同一ディレクトリでの同時実行は非推奨（sqlite3.oが競合）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ヘッダー | 各検証前 | 検証内容の説明（echoで出力） |
| シンボル一覧 | nm実行後 | エクスポートシンボル・外部依存の一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 意図しないシンボル数 | 0件（理想） | CI/CD通知 |

## 備考

- このスクリプトは34行の品質検証スクリプト
- symbols.shのMinGW版で、よりシンプルな設定を使用
- FTS5、GEOPOLY、SESSION等の新しい拡張機能はテスト対象外
- grepのパターンがsymbols.shより単純（session等の特殊プレフィックスを考慮していない）
- MinGW環境固有のシンボルエクスポート挙動を確認するために使用
- MSYS2やCygwinとの組み合わせでも使用可能
