---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：13-split-speedtest1-script.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **speedtest1の--scriptオプション出力形式**：speedtest1のソースコードを確認していない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/sqlite-master/ext/wasm/split-speedtest1-script.sh` (ソースコード全体)
- E-02: `/Users/tomoka.baba/Work/sqlite-master/ext/wasm/split-speedtest1-script.sh` 行1-3 (コメント部分)
- E-03: `/Users/tomoka.baba/Work/sqlite-master/ext/wasm/split-speedtest1-script.sh` 行4 (引数検証)
- E-04: `/Users/tomoka.baba/Work/sqlite-master/ext/wasm/split-speedtest1-script.sh` 行5-9 (テスト番号抽出・検証)
- E-05: `/Users/tomoka.baba/Work/sqlite-master/ext/wasm/split-speedtest1-script.sh` 行10-11 (出力ディレクトリ決定)
- E-06: `/Users/tomoka.baba/Work/sqlite-master/ext/wasm/split-speedtest1-script.sh` 行13-17 (ループ処理)
- E-07: `/Users/tomoka.baba/Work/sqlite-master/docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧情報)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | speedtest1 --script出力を分割する目的 | E-02 | ○ |
| C-02 | 引数は必須 | E-03 | ○ |
| C-03 | "-- begin test"マーカーからテスト番号抽出 | E-04 | ○ |
| C-04 | テスト番号が空ならエラー終了 | E-04 | ○ |
| C-05 | 入力ファイルと同じディレクトリに出力 | E-05 | ○ |
| C-06 | カレントディレクトリの場合は"."を使用 | E-05 | ○ |
| C-07 | 3桁ゼロパディングでファイル名生成 | E-06 | ○ |
| C-08 | sedで範囲抽出 | E-06 | ○ |
| C-09 | echo -eでタブ区切り出力 | E-06 | ○ |
| C-10 | 出力ファイル名はspeedtest1-NNN.sql | E-06 | ○ |
| C-11 | grepとcutでテスト番号解析 | E-04 | ○ |
| C-12 | エラー時はexit 1 | E-04 | ○ |
| C-13 | ext/wasmディレクトリに配置 | E-01 | ○ |
| C-14 | beginからendまでの範囲を抽出 | E-06 | ○ |
| C-15 | speedtest1の--scriptオプションの詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- speedtest1プログラムのソースコードを確認していないため、--scriptオプションの出力形式の詳細が未検証
  - 候補：test/speedtest1.c / speedtest1のドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプト自体は単純で明確
- 1: 中リスク - 入力ファイル形式の前提条件が実際のspeedtest1出力と一致するか確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] speedtest1 --scriptの実際の出力形式を確認
- [ ] "-- begin test N"/"-- end test N"マーカーの形式を確認
- [ ] 大量のテストケースでのパフォーマンスを確認
- [ ] 特殊文字を含むSQL文の処理を確認
