---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：14-run-wordcount.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **wordcountプログラムの詳細仕様**：wordcount.cのソースコードを確認していない
  2. **wordcountが生成するテーブル構造**：データベーススキーマを確認していない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/sqlite-master/test/run-wordcount.sh` (ソースコード全体)
- E-02: `/Users/tomoka.baba/Work/sqlite-master/test/run-wordcount.sh` 行1-5 (コメント部分)
- E-03: `/Users/tomoka.baba/Work/sqlite-master/test/run-wordcount.sh` 行7-11 (引数検証)
- E-04: `/Users/tomoka.baba/Work/sqlite-master/test/run-wordcount.sh` 行13-24 (INSERTテスト)
- E-05: `/Users/tomoka.baba/Work/sqlite-master/test/run-wordcount.sh` 行26-39 (REPLACEテスト)
- E-06: `/Users/tomoka.baba/Work/sqlite-master/test/run-wordcount.sh` 行41-55 (SELECTテスト)
- E-07: `/Users/tomoka.baba/Work/sqlite-master/test/run-wordcount.sh` 行57-73 (QUERY/DELETEテスト)
- E-08: `/Users/tomoka.baba/Work/sqlite-master/test/run-wordcount.sh` 行76-78 (クリーンアップ)
- E-09: `/Users/tomoka.baba/Work/sqlite-master/docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧情報)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 複数モードで実行し出力を比較検証する目的 | E-02 | ○ |
| C-02 | 引数未指定時はUsage表示 | E-03 | ○ |
| C-03 | --insertモードでベースライン取得 | E-04 | ○ |
| C-04 | --insert --without-rowidと比較 | E-04 | ○ |
| C-05 | --replaceモードのテスト | E-05 | ○ |
| C-06 | --selectモードのテスト | E-06 | ○ |
| C-07 | --queryモードでベースライン更新 | E-07 | ○ |
| C-08 | --deleteモードのテスト | E-07 | ○ |
| C-09 | cmpで出力比較 | E-04 | ○ |
| C-10 | 差異時はERRORとdiff出力 | E-04 | ○ |
| C-11 | wcdb1.db, wcdb2.dbを一時ファイルとして使用 | E-04, E-08 | ○ |
| C-12 | wc-out.txt, wc-baseline.txtを一時ファイルとして使用 | E-04, E-08 | ○ |
| C-13 | 終了時に一時ファイル削除 | E-08 | ○ |
| C-14 | --timer, --summaryオプション使用 | E-04 | ○ |
| C-15 | WITHOUT ROWIDテーブルの説明 | E-01（間接的） | ○ |
| C-16 | "echo hi >/dev/null"は何もしない処理 | E-04 | ○ |
| C-17 | wordcountプログラムの詳細動作 | **根拠なし** | △ |
| C-18 | wordcountが生成するテーブル構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- wordcountプログラムのソースコードを確認していないため、内部動作の詳細が未検証
  - 候補：test/wordcount.c / tool/wordcount.c
- wordcountが作成するデータベーススキーマの詳細が不明
  - 候補：wordcountプログラムのドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストスクリプトの動作自体はコードから明確
- 1: 中リスク - wordcountプログラムの前提条件・動作仕様の確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] wordcountプログラムの存在とビルド方法を確認
- [ ] wordcountの各オプション（--insert, --replace等）の動作を確認
- [ ] WITHOUT ROWIDテーブルの動作差異を確認
- [ ] テストの期待結果（全テスト成功時の出力）を確認
