---
generated_at: 2026-01-21 10:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：16-fts3cov.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **fts3.testの内容と構成**：fts3.testファイルの詳細を確認していない
  2. **ext/fts3/内のソースファイル一覧**：実際のファイル一覧を確認していない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/tool/fts3cov.sh` (ソースコード全体)
- E-02: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/tool/fts3cov.sh` 行1-3 (シバン・set -e)
- E-03: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/tool/fts3cov.sh` 行5-6 (ソースディレクトリ計算・テスト実行)
- E-04: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/tool/fts3cov.sh` 行8 (空行出力)
- E-05: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/tool/fts3cov.sh` 行10-15 (カバレッジ収集ループ)
- E-06: `/Users/tomoka.baba/Work/sqlite-master/docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧情報)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FTS3のコードカバレッジを測定する目的 | E-06 | ○ |
| C-02 | set -eでエラー時即終了 | E-02 | ○ |
| C-03 | srcdirをスクリプトパスから4階層上で計算 | E-03 | ○ |
| C-04 | testfixtureでfts3.testを実行 | E-03 | ○ |
| C-05 | 出力をfts3cov-out.txtに保存 | E-03 | ○ |
| C-06 | ext/fts3/*.cの各ファイルに対してループ | E-05 | ○ |
| C-07 | basenameでファイル名のみ取得 | E-05 | ○ |
| C-08 | echo -neで改行なし出力 | E-05 | ○ |
| C-09 | gcov -bで分岐カバレッジ取得 | E-05 | ○ |
| C-10 | "Taken at least once"をgrepで抽出 | E-05 | ○ |
| C-11 | sedでプレフィックス除去 | E-05 | ○ |
| C-12 | 空行を区切りとして出力 | E-04 | ○ |
| C-13 | カバレッジビルドが前提 | E-01（暗黙） | ○ |
| C-14 | fts3.testの詳細内容 | **根拠なし** | △ |
| C-15 | ext/fts3/*.cの具体的ファイル一覧 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- fts3.testファイルの内容を確認していないため、実行されるテストの詳細が未検証
  - 候補：test/fts3.test
- ext/fts3/ディレクトリのソースファイル一覧を確認していない
  - 候補：ext/fts3/*.c

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの動作はコードから明確
- 1: 中リスク - gcovビルドの前提条件とテスト内容の確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] fts3.testの存在と内容を確認
- [ ] ext/fts3/ディレクトリのソースファイル一覧を確認
- [ ] カバレッジビルドの手順を確認
- [ ] gcov出力の"Taken at least once"形式を確認
