---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：ext-expert 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成されたext-expert モジュールの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **C-004 (UT-EXP-004)**：NULLハンドル時の挙動 - ソースコードで明示的なNULLチェックなし
  2. **C-014 (UT-EXP-014)**：zSql=NULLの処理 - 明示的なドキュメントなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `ext/expert/sqlite3expert.h` - 公開API定義、関数シグネチャとドキュメント
- E-02: `ext/expert/sqlite3expert.c` - 実装コード（2237行）
- E-03: `ext/expert/expert.c` - CLIツール実装
- E-04: `ext/expert/test_expert.c` - Tclテストハーネス
- E-05: `ext/expert/expert1.test` - 統合テストスクリプト

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | sqlite3_expert_newが正常にオブジェクト生成 | E-01 L19-28, E-02 L1988-2064 | ○ |
| C-002 | dbv/dbmインメモリDB生成 | E-02 L2000-2010 | ○ |
| C-003 | iSample=100で初期化 | E-02 L2002 | ○ |
| C-004 | NULLハンドル時の挙動 | **根拠なし** | △ |
| C-005 | スキーマコピー機能 | E-02 L2028-2045 | ○ |
| C-006 | EXPERT_CONFIG_SAMPLEで設定 | E-01 L33-57, E-02 L2069-2088 | ○ |
| C-007 | iVal<0で0に補正 | E-02 L2076 | ○ |
| C-008 | iVal>100で100に補正 | E-02 L2077 | ○ |
| C-009 | 不正op値でSQLITE_NOTFOUND | E-02 L2081-2083 | ○ |
| C-010 | SQL追加の基本機能 | E-01 L62-87, E-02 L2093-2140 | ○ |
| C-011 | 複数SQL文対応 | E-02 L2105-2126 | ○ |
| C-012 | 不正SQL時のエラー | E-02 L2108-2109, 2128-2129 | ○ |
| C-013 | analyze後のMISUSE | E-02 L2103 | ○ |
| C-014 | zSql=NULL時の処理 | **根拠なし** | △ |
| C-015 | 空文字列処理 | E-02 L2105 (whileループ条件) | ○ |
| C-016 | analyze正常完了 | E-01 L91-108, E-02 L2142-2181 | ○ |
| C-017 | 候補インデックス生成 | E-02 L2150-2151, L963-1045 | ○ |
| C-018 | stat1データ生成 | E-02 L2159-2160, L1803-1901 | ○ |
| C-019 | iSample=0で統計スキップ | E-02 L2824 | ○ |
| C-020 | count機能 | E-01 L111-115, E-02 L2187-2191 | ○ |
| C-021 | 空状態で0返却 | E-02 L2188-2189 | ○ |
| C-022 | EXPERT_REPORT_SQL | E-01 L134-136, E-02 L2203-2204 | ○ |
| C-023 | EXPERT_REPORT_INDEXES | E-01 L138-140, E-02 L2206-2207 | ○ |
| C-024 | EXPERT_REPORT_PLAN | E-01 L142-144, E-02 L2209-2210 | ○ |
| C-025 | EXPERT_REPORT_CANDIDATES | E-01 L146-149, E-02 L2212-2213 | ○ |
| C-026 | 未分析時NULL返却 | E-02 L2200 | ○ |
| C-027 | 範囲外iStmtでNULL | E-02 L2201 | ○ |
| C-028 | destroy正常解放 | E-01 L161-166, E-02 L2222-2234 | ○ |
| C-029 | destroy NULL安全 | E-02 L2223 | ○ |
| C-030 | idxHashInit初期化 | E-02 L191-193 | ○ |
| C-031 | idxHashAdd追加 | E-02 L230-261 | ○ |
| C-032 | idxHashAdd重複検出 | E-02 L241-244 | ○ |
| C-033 | idxHashSearch検索成功 | E-02 L287-291 | ○ |
| C-034 | idxHashSearch検索失敗 | E-02 L290 | ○ |
| C-035 | idxHashClear解放 | E-02 L198-210 | ○ |
| C-036 | idxHashString一貫性 | E-02 L216-223 | ○ |
| C-037 | ハッシュ値範囲 | E-02 L222 | ○ |
| C-038 | idxMalloc正常 | E-02 L175-186 | ○ |
| C-039 | idxMalloc OOM | E-02 L182-183 | ○ |
| C-040 | idxNewConstraint生成 | E-02 L297-308 | ○ |
| C-041 | idxPrepareStmt成功 | E-02 L324-336 | ○ |
| C-042 | idxPrepareStmt失敗 | E-02 L331-334 | ○ |
| C-043 | idxGetTableInfo成功 | E-02 L693-779 | ○ |
| C-044 | 列情報取得 | E-02 L742-766 | ○ |
| C-045 | 存在しないテーブル | E-02 L709 (zTab==0チェック), 実行時エラー | ○ |
| C-046 | zTab=NULL | E-02 L709 | ○ |
| C-047 | idxAppendText連結 | E-02 L790-816 | ○ |
| C-048 | idxAppendText新規 | E-02 L794 | ○ |
| C-049 | idxAppendText OOM | E-02 L807-810 | ○ |
| C-050 | 引用不要判定 | E-02 L822-838 | ○ |
| C-051 | 予約語検出 | E-02 L826 | ○ |
| C-052 | 特殊文字検出 | E-02 L828-836 | ○ |
| C-053 | idxCreateCandidates | E-02 L1098-1110 | ○ |
| C-054 | idxFindCompatible検出 | E-02 L882-948 | ○ |
| C-055 | idxFindCompatible非検出 | E-02 L944-947 | ○ |
| C-056 | idxFindIndexes | E-02 L1187-1255 | ○ |
| C-057 | idxPopulateStat1生成 | E-02 L1803-1901 | ○ |
| C-058 | iSample=0スキップ | E-02 L2824 | ○ |
| C-059 | expertConnect成功 | E-02 L412-446 | ○ |
| C-060 | expertConnect引数エラー | E-02 L423-425 | ○ |
| C-061 | expertBestIndex制約収集 | E-02 L454-519 | ○ |
| C-062 | ORDER BY収集 | E-02 L501-514 | ○ |
| C-063 | expertDisconnect | E-02 L448-452 | ○ |
| C-064 | expertOpen | E-02 L537-544 | ○ |
| C-065 | expertClose | E-02 L549-554 | ○ |
| C-066 | expertFilter | E-02 L611-637 | ○ |
| C-067 | expertNext | E-02 L570-584 | ○ |
| C-068 | expertEof EOF | E-02 L562-565 | ○ |
| C-069 | expertEof データあり | E-02 L564 | ○ |
| C-070 | expertColumn | E-02 L598-606 | ○ |
| C-071 | expertRowid | E-02 L589-593 | ○ |
| C-072 | expertDequote | E-02 L380-401 | ○ |
| C-073 | expertDequoteエスケープ | E-02 L391-395 | ○ |
| C-074 | idxAuthCallback検出 | E-02 L1257-1293 | ○ |
| C-075 | DB名フィルタ | E-02 L1269 | ○ |
| C-076 | idxProcessTriggers | E-02 L1378-1393 | ○ |
| C-077 | idxSampleFunc | E-02 L1533-1557 | ○ |
| C-078 | nRow=0初回 | E-02 L1543-1544 | ○ |
| C-079 | idxRemFunc | E-02 L1574-1650 | ○ |
| C-080 | idxRemFunc型対応 | E-02 L1588-1649 | ○ |
| C-081 | idxBuildSampleTable | E-02 L1779-1794 | ○ |
| C-082 | idxLargestIndex | E-02 L1652-1670 | ○ |
| C-083 | idxLargestIndex空 | E-02 L1662 | ○ |
| C-084 | countNonzeros増加 | E-02 L954-961 | ○ |
| C-085 | countNonzeros維持 | E-02 L957 | ○ |
| C-086 | E2E基本テスト | E-05 L110-117 | ○ |
| C-087 | ORDER BY対応 | E-05 L131-135 | ○ |
| C-088 | 複合インデックス | E-05 L137-144 | ○ |
| C-089 | 既存インデックス利用 | E-05 L331-338 | ○ |
| C-090 | トリガー対応 | E-05 L292-303 | ○ |
| C-091 | COLLATE対応 | E-05 L119-126 | ○ |
| C-092 | 特殊テーブル名 | E-05 L195-202 | ○ |
| C-093 | 特殊列名 | E-05 L215-222 | ○ |
| C-094 | OR条件 | E-05 L248-261 | ○ |
| C-095 | rowid最適化 | E-05 L265-272 | ○ |
| C-096 | PK活用 | E-05 L331-338 | ○ |
| C-097 | 生成列対応 | E-05 L383-393 | ○ |
| C-098 | VIEW対応 | E-02 L1488-1490 | ○ |
| C-099 | CLI基本 | E-03 L70-156 | ○ |
| C-100 | ファイル入力 | E-03 L43-68 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-004 (UT-EXP-004)**: sqlite3_expert_newにおけるNULLデータベースハンドル入力時の挙動
  - ソースコード（E-02）には明示的なNULLチェックがない
  - sqlite3_open呼び出し時点でクラッシュする可能性
  - 候補：実機テストによる確認 / SQLite本体のNULL処理仕様確認

- **C-014 (UT-EXP-014)**: sqlite3_expert_sqlにおけるzSql=NULL入力時の挙動
  - E-02 L2105のwhileループでzStmt[0]参照前にNULLチェックなし
  - 候補：実機テストによる確認 / 防御的コーディングの追加検討

## 5) リスクフラグ（レビュー観点）
- **リスク1（高）**: NULLポインタ入力時のクラッシュ可能性
  - 対象: UT-EXP-004, UT-EXP-014
  - 推奨: 実機テストまたはコードレビューで確認

- **リスク0（低）**: その他のテストケースは全てソースコードから直接導出
  - 関数シグネチャ、実装ロジック、既存テストスクリプトと整合

## 6) レビュアーチェックリスト（最小）
- [ ] NULLハンドル入力テスト（UT-EXP-004）の実行可否を確認
- [ ] zSql=NULL入力テスト（UT-EXP-014）の期待結果を実機確認
- [ ] メモリリークテスト（UT-EXP-028, UT-EXP-029）をValgrind等で検証
- [ ] 統合テスト（UT-EXP-086〜UT-EXP-098）がexpert1.testのカバレッジと整合するか確認
- [ ] CLIテスト（UT-EXP-099, UT-EXP-100）の実行環境が利用可能か確認
