---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 138
  claims_with_evidence: 135
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：ext-fts3 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で  の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：135 / 138、根拠なし：3
- 優先レビュー（高）
  1. **UT-FTS3-131**：破損テーブルの具体的な検出ロジックは実装依存
  2. **UT-FTS3-036**：メモリ不足条件の再現が環境依存
  3. **UT-FTS3-034**：fts3Rehashのメモリ不足時の具体的挙動

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/fts3.c` - メインFTS3実装
- E-02: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/fts3Int.h` - 内部ヘッダー
- E-03: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/fts3_write.c` - 書き込み操作
- E-04: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/fts3_expr.c` - クエリ式パーサー
- E-05: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/fts3_snippet.c` - スニペット/matchinfo
- E-06: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/fts3_hash.c` - ハッシュテーブル
- E-07: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/fts3_hash.h` - ハッシュヘッダー
- E-08: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/fts3_tokenizer.c` - トークナイザ管理
- E-09: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/fts3_tokenizer.h` - トークナイザヘッダー
- E-10: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/fts3_porter.c` - Porterステマー
- E-11: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/fts3_unicode.c` - Unicodeトークナイザ
- E-12: `/Users/tomoka.baba/Work/sqlite-master/ext/fts3/fts3_aux.c` - fts4aux仮想テーブル

## 3) Claims と根拠の対応（レビューの主戦場）

### Varint エンコード/デコード (fts3.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | sqlite3Fts3PutVarintが127を1バイトでエンコード | E-01 (行331-341) | ○ |
| C-002 | sqlite3Fts3PutVarintが128を2バイトでエンコード | E-01 (行331-341) | ○ |
| C-003 | 64ビット最大値が最大10バイトでエンコード | E-02 (FTS3_VARINT_MAX=10) | ○ |
| C-004 | sqlite3Fts3GetVarintが1バイトvarintをデコード | E-01 (行377-379) | ○ |
| C-005 | sqlite3Fts3GetVarintが2バイトvarintをデコード | E-01 (行377-379) | ○ |
| C-006 | sqlite3Fts3GetVarintUが符号なし整数をデコード | E-01 (行350-370) | ○ |
| C-007 | sqlite3Fts3GetVarintBoundedが境界チェック付きデコード | E-01 (行387-405) | ○ |
| C-008 | 境界終端での安全なデコード | E-01 (行398) | ○ |
| C-009 | sqlite3Fts3GetVarint32が32ビットに切り捨て | E-01 (行411-429) | ○ |
| C-010 | オーバーフロー防止の切り捨て | E-01 (行426-427) | ○ |
| C-011 | sqlite3Fts3VarintLenが長さ1を返す | E-01 (行435-442) | ○ |
| C-012 | sqlite3Fts3VarintLenが長さ2を返す | E-01 (行435-442) | ○ |
| C-013 | 最大長10の計算 | E-01, E-02 | ○ |

### 文字列処理 (fts3.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-014 | sqlite3Fts3Dequoteがダブルクォートを処理 | E-01 (行458-480) | ○ |
| C-015 | sqlite3Fts3Dequoteがシングルクォートを処理 | E-01 (行462) | ○ |
| C-016 | sqlite3Fts3Dequoteがブラケットを処理 | E-01 (行467) | ○ |
| C-017 | sqlite3Fts3Dequoteがバッククォートを処理 | E-01 (行462) | ○ |
| C-018 | エスケープされたクォートの処理 | E-01 (行470-473) | ○ |
| C-019 | クォートなし文字列のno-op | E-01 (行462) | ○ |

### ハッシュテーブル (fts3_hash.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-020 | sqlite3Fts3HashInitの初期化 | E-06 (行59-68) | ○ |
| C-021 | バイナリキーモードの初期化 | E-06 (行61) | ○ |
| C-022 | sqlite3Fts3HashClearの全削除 | E-06 (行74-92) | ○ |
| C-023 | copyKeyでのキーメモリ解放 | E-06 (行85-87) | ○ |
| C-024 | sqlite3Fts3HashInsertの挿入 | E-06 | ○ |
| C-025 | 既存キーの上書き | E-06 | ○ |
| C-026 | data=NULLでの削除 | E-06 | ○ |
| C-027 | sqlite3Fts3HashFindの検索 | E-06 | ○ |
| C-028 | 存在しないキーでNULL | E-06 | ○ |
| C-029 | sqlite3Fts3HashFindElemの要素取得 | E-06 (行282-296) | ○ |
| C-030 | fts3StrHashの文字列ハッシュ | E-06 (行97-106) | ○ |
| C-031 | nKey<=0でのstrlen使用 | E-06 (行100) | ○ |
| C-032 | fts3BinHashのバイナリハッシュ | E-06 (行115-122) | ○ |
| C-033 | fts3Rehashのリサイズ | E-06 (行196-214) | ○ |
| C-034 | リハッシュのメモリ不足エラー | E-06 (行203) | △ |

### 式パーサー (fts3_expr.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-035 | sqlite3Fts3MallocZeroのゼロ初期化 | E-04 (行125-129) | ○ |
| C-036 | メモリ不足時のNULL | E-04 (行126) | △ |
| C-037 | sqlite3Fts3OpenTokenizerのカーソル開始 | E-04 (行131-156) | ○ |
| C-038 | 言語IDの設定 | E-04 (行146-152) | ○ |
| C-039 | 単一トークンのパース | E-04 | ○ |
| C-040 | AND式のパース | E-04 | ○ |
| C-041 | OR式のパース | E-04 | ○ |
| C-042 | NOT式のパース | E-04 | ○ |
| C-043 | NEAR式のパース | E-04 | ○ |
| C-044 | フレーズクエリのパース | E-04 (行300-400) | ○ |
| C-045 | プレフィックス検索のパース | E-04 (行239-242) | ○ |
| C-046 | カラム指定のパース | E-04 | ○ |
| C-047 | 最大深度エラー | E-02 (SQLITE_FTS3_MAX_EXPR_DEPTH) | ○ |
| C-048 | sqlite3Fts3ExprFreeの解放 | E-02 (行649) | ○ |
| C-049 | fts3isspaceの空白検出 | E-04 (行116-118) | ○ |
| C-050 | タブ文字の検出 | E-04 (行117) | ○ |
| C-051 | 非空白で0返却 | E-04 (行116-118) | ○ |

### トークナイザ (fts3_tokenizer.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-052 | sqlite3Fts3IsIdCharの英字判定 | E-08 (行114-126) | ○ |
| C-053 | 数字の識別子判定 | E-08 (行118) | ○ |
| C-054 | アンダースコアの判定 | E-08 (行121) | ○ |
| C-055 | 特殊文字で0返却 | E-08 (行125) | ○ |
| C-056 | sqlite3Fts3NextTokenのトークン取得 | E-08 (行128-163) | ○ |
| C-057 | クォート内トークンの取得 | E-08 (行138-144) | ○ |
| C-058 | 空文字列でNULL | E-08 (行137) | ○ |
| C-059 | sqlite3Fts3InitTokenizerの初期化 | E-08 (行165-224) | ○ |
| C-060 | 未登録トークナイザエラー | E-08 (行191-193) | ○ |
| C-061 | sqlite3Fts3InitHashTableの初期化 | E-08 | ○ |

### スニペット/Matchinfo (fts3_snippet.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-062 | sqlite3Fts3Offsetsのオフセット取得 | E-02 (行638), E-05 | ○ |
| C-063 | sqlite3Fts3Snippetのスニペット生成 | E-02 (行639-641), E-05 | ○ |
| C-064 | sqlite3Fts3Matchinfoのマッチ情報 | E-02 (行642), E-05 | ○ |
| C-065 | sqlite3Fts3ExprIterateの走査 | E-05 (行281-288) | ○ |
| C-066 | NOT右辺のスキップ | E-05 (行261-262) | ○ |
| C-067 | fts3MIBufferNewのバッファ作成 | E-05 (行135-153) | ○ |
| C-068 | sqlite3Fts3MIBufferFreeの解放 | E-05 (行205-213) | ○ |

### Porterステマー (fts3_porter.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-069 | porterCreateのトークナイザ作成 | E-10 (行59-73) | ○ |
| C-070 | porterDestroyの破棄 | E-10 (行78-81) | ○ |
| C-071 | porterOpenのカーソル開始 | E-10 (行89-116) | ○ |
| C-072 | 空入力でのカーソル作成 | E-10 (行102-103) | ○ |
| C-073 | nInput<0でstrlen使用 | E-10 (行104-105) | ○ |
| C-074 | porterCloseのカーソル終了 | E-10 (行122-127) | ○ |
| C-075 | isConsonantの子音判定 | E-10 (行150-158) | ○ |
| C-076 | isVowelの母音判定 | E-10 (行159-167) | ○ |
| C-077 | 'y'の特別ルール | E-10 (行156-157) | ○ |
| C-078 | m_gt_0の判定 | E-10 (行188-193) | ○ |
| C-079 | m_eq_1の判定 | E-10 (行198-207) | ○ |
| C-080 | m_gt_1の判定 | E-10 (行212-221) | ○ |
| C-081 | hasVowelの母音存在 | E-10 (行226-229) | ○ |
| C-082 | doubleConsonantの二重子音 | E-10 (行237-239) | ○ |
| C-083 | star_ohのCVC条件 | E-10 (行249-255) | ○ |
| C-084 | stemの語尾置換 | E-10 (行269-284) | ○ |
| C-085 | copy_stemmerの大文字変換 | E-10 (行294-300) | ○ |

### Unicodeトークナイザ (fts3_unicode.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-086 | unicodeCreateのトークナイザ作成 | E-11 (行218-263) | ○ |
| C-087 | remove_diacriticsオプション | E-11 (行236-243) | ○ |
| C-088 | tokencharsオプション | E-11 (行245-246) | ○ |
| C-089 | separatorsオプション | E-11 (行248-249) | ○ |
| C-090 | 不明オプションエラー | E-11 (行251-253) | ○ |
| C-091 | unicodeDestroyの破棄 | E-11 (行104-111) | ○ |
| C-092 | unicodeOpenのカーソル開始 | E-11 (行271-298) | ○ |
| C-093 | NULL入力での空文字列設定 | E-11 (行286-288) | ○ |
| C-094 | unicodeIsExceptionの例外検出 | E-11 (行185-204) | ○ |
| C-095 | 非例外で0返却 | E-11 (行200-202) | ○ |
| C-096 | unicodeIsAlnumの英数字判定 | E-11 (行210-213) | ○ |
| C-097 | 例外による判定反転 | E-11 (行212) | ○ |

### fts4aux仮想テーブル (fts3_aux.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-098 | fts3auxConnectMethodの接続 | E-12 (行57-121) | ○ |
| C-099 | 2引数形式の接続 | E-12 (行84-91) | ○ |
| C-100 | 引数不正エラー | E-12 (行80, 118-120) | ○ |
| C-101 | fts3auxDisconnectMethodの切断 | E-12 (行128-140) | ○ |
| C-102 | fts3auxBestIndexMethodの最適化 | E-12 (行149-214) | ○ |
| C-103 | fts3auxOpenMethodのカーソル開始 | E-12 (行219-230) | ○ |
| C-104 | fts3auxCloseMethodのカーソル終了 | E-12 (行235-246) | ○ |
| C-105 | fts3auxNextMethodの行進行 | E-12 (行267-300) | ○ |
| C-106 | fts3auxGrowStatArrayの配列拡張 | E-12 (行248-262) | ○ |
| C-107 | 配列拡張のメモリ不足 | E-12 (行254) | ○ |

### 書き込み操作 (fts3_write.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | sqlite3Fts3UpdateMethodのINSERT | E-02 (行516), E-03 | ○ |
| C-109 | DELETE操作 | E-03 | ○ |
| C-110 | UPDATE操作 | E-03 | ○ |
| C-111 | sqlite3Fts3PendingTermsFlush | E-02 (行517), E-03 | ○ |
| C-112 | sqlite3Fts3PendingTermsClear | E-02 (行518), E-03 | ○ |
| C-113 | sqlite3Fts3Optimize | E-02 (行519), E-03 | ○ |
| C-114 | sqlite3Fts3SegReaderNew | E-02 (行520-521), E-03 | ○ |
| C-115 | sqlite3Fts3SegReaderFree | E-02 (行524), E-03 | ○ |
| C-116 | sqlite3Fts3SegReaderPending | E-02 (行522-523), E-03 | ○ |
| C-117 | sqlite3Fts3AllSegdirs | E-02 (行525), E-03 | ○ |
| C-118 | sqlite3Fts3ReadBlock | E-02 (行526), E-03 | ○ |
| C-119 | sqlite3Fts3SelectDoctotal | E-03 (行475-494) | ○ |
| C-120 | sqlite3Fts3SelectDocsize | E-03 (行496-500) | ○ |
| C-121 | sqlite3Fts3Incrmerge | E-02 (行598), E-03 | ○ |
| C-122 | sqlite3Fts3MaxLevel | E-02 (行546), E-03 | ○ |
| C-123 | sqlite3Fts3SegReaderStart | E-02 (行552), E-03 | ○ |
| C-124 | sqlite3Fts3SegReaderStep | E-02 (行553), E-03 | ○ |
| C-125 | sqlite3Fts3SegReaderFinish | E-02 (行554), E-03 | ○ |
| C-126 | sqlite3Fts3SegmentsClose | E-02 (行545), E-03 | ○ |
| C-127 | fts3SqlStmtのSQL文取得 | E-03 (行305-447) | ○ |
| C-128 | キャッシュされた文の再利用 | E-03 (行417-418) | ○ |
| C-129 | sqlite3Fts3PrepareStmt | E-03 (行280-292) | ○ |

### 整合性チェック (fts3.c)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | sqlite3Fts3IntegrityCheckの成功 | E-02 (行686), E-01 | ○ |
| C-131 | 破損テーブルでのエラー検出 | E-02 (行686), E-01 | △ |
| C-132 | sqlite3Fts3ReadIntの整数読取 | E-02 (行627), E-01 | ○ |
| C-133 | sqlite3Fts3DoclistPrevの逆走査 | E-02 (行622), E-01 | ○ |
| C-134 | sqlite3Fts3EvalPhraseStatsの統計 | E-02 (行623), E-01 | ○ |
| C-135 | sqlite3Fts3FirstFilterのフィルタ | E-02 (行624), E-01 | ○ |
| C-136 | sqlite3Fts3CreateStatTableの作成 | E-02 (行625), E-01 | ○ |
| C-137 | sqlite3Fts3EvalTestDeferredのテスト | E-02 (行626), E-01 | ○ |
| C-138 | sqlite3Fts3ErrMsgのエラー設定 | E-02 (行614), E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-034**: fts3Rehashのメモリ不足時の戻り値は`return 1`だが、呼び出し元での具体的なエラーハンドリングパスの確認が必要
  - 候補：fts3_hash.cの呼び出し元 / テストコード
- **C-036**: sqlite3_malloc64がNULLを返す条件は環境依存であり、テストでの再現方法の確認が必要
  - 候補：SQLiteのテストフレームワーク / メモリフォールト注入
- **C-131**: 破損検出の具体的なロジックはfts3.c内の複雑な処理に依存し、すべてのパスを網羅するテストケース設計が必要
  - 候補：既存のcorruptテスト / fts3_test.c

## 5) リスクフラグ（レビュー観点）
- **リスクレベル0（低リスク）**: テストケースの大半（約98%）
  - ソースコードから直接導出可能な関数シグネチャと期待動作
- **リスクレベル1（中リスク）**: メモリ不足エラーのテスト
  - 環境依存のエラーパスであり、テスト環境での再現性に注意
- **リスクレベル1（中リスク）**: 破損検出テスト
  - 実際の破損シナリオの網羅性に注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] UT-FTS3-001〜013: varintエンコード/デコードの境界値テストが十分か
- [ ] UT-FTS3-020〜034: ハッシュテーブル操作のメモリ管理が正しいか
- [ ] UT-FTS3-039〜047: クエリパーサーの全演算子（AND/OR/NOT/NEAR）がカバーされているか
- [ ] UT-FTS3-069〜085: Porterステマーのステミングルールが正しいか
- [ ] UT-FTS3-086〜097: Unicodeトークナイザのオプション処理が正しいか
- [ ] UT-FTS3-108〜129: 書き込み操作のトランザクション安全性が考慮されているか
- [ ] UT-FTS3-130〜131: 整合性チェックのカバレッジが十分か
