---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：ext-fts5 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-FTS5-049**：矛盾オプション検出の詳細動作要確認
  2. **UT-FTS5-084**：空テーブルエラーの実際の動作要確認
  3. **UT-FTS5-086**：整合性エラー検出の網羅性要確認
  4. **UT-FTS5-093**：contentless_delete機能の境界条件要確認
  5. **UT-FTS5-099**：文検出ロジックの詳細動作要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/fts5/fts5.h` - FTS5パブリックAPI定義
- E-02: `ext/fts5/fts5Int.h` - FTS5内部構造体・定数定義
- E-03: `ext/fts5/fts5_buffer.c` - バッファ管理関数実装
- E-04: `ext/fts5/fts5_varint.c` - 可変長整数エンコード/デコード実装
- E-05: `ext/fts5/fts5_hash.c` - ハッシュテーブル実装
- E-06: `ext/fts5/fts5_config.c` - 設定解析実装
- E-07: `ext/fts5/fts5_tokenize.c` - トークナイザ実装（ascii, unicode61, porter, trigram）
- E-08: `ext/fts5/fts5_aux.c` - 補助関数実装（highlight, snippet, bm25）
- E-09: `ext/fts5/fts5_storage.c` - ストレージ管理実装

## 3) Claims と根拠の対応（レビューの主戦場）

### バッファ管理（fts5_buffer.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3Fts5BufferSizeでバッファサイズ拡張 | E-03 L28-50 | ○ |
| C-02 | メモリ確保失敗時SQLITE_NOMEM | E-03 L35-40 | ○ |
| C-03 | sqlite3Fts5BufferAppendBlobでバイナリ追加 | E-03 L52-70 | ○ |
| C-04 | 空データ追加時の動作 | E-03 | ○ |
| C-05 | sqlite3Fts5BufferAppendStringで文字列追加 | E-03 L72-85 | ○ |
| C-06 | sqlite3Fts5BufferAppendVarintでvarintエンコード | E-03 L87-110 | ○ |
| C-07 | 大きな整数のエンコード | E-03, E-04 | ○ |
| C-08 | sqlite3Fts5BufferZeroでクリア | E-03 L20-26 | ○ |
| C-09 | sqlite3Fts5BufferFreeで解放 | E-03 L112-120 | ○ |

### 可変長整数（fts5_varint.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | sqlite3Fts5GetVarintでデコード | E-04 L30-80 | ○ |
| C-11 | 最大値varintデコード | E-04 L50-80 | ○ |
| C-12 | sqlite3Fts5PutVarintでエンコード | E-04 L85-130 | ○ |
| C-13 | sqlite3Fts5GetVarint32で32bitデコード | E-04 L135-160 | ○ |

### ハッシュテーブル（fts5_hash.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | sqlite3Fts5HashNewでハッシュ作成 | E-05 L60-90 | ○ |
| C-15 | メモリ不足時NULL返却 | E-05 L75 | ○ |
| C-16 | sqlite3Fts5HashFreeで解放 | E-05 L95-110 | ○ |
| C-17 | sqlite3Fts5HashWriteでトークン追加 | E-05 L150-250 | ○ |
| C-18 | 同一トークンの複数行追加 | E-05 L180-220 | ○ |
| C-19 | sqlite3Fts5HashClearでクリア | E-05 L115-130 | ○ |
| C-20 | sqlite3Fts5HashQueryでクエリ | E-05 L260-300 | ○ |
| C-21 | 存在しないトークンでNULL | E-05 L280 | ○ |

### 設定解析（fts5_config.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | sqlite3Fts5ConfigParseで基本設定解析 | E-06 L100-300 | ○ |
| C-23 | contentless設定解析 | E-06 L180-200 | ○ |
| C-24 | prefix設定解析 | E-06 L220-250 | ○ |
| C-25 | 不正オプションでエラー | E-06 L300-320 | ○ |
| C-26 | sqlite3Fts5ConfigFreeで解放 | E-06 L350-380 | ○ |
| C-27 | sqlite3Fts5ConfigSetValueで動的変更 | E-06 L400-450 | ○ |

### トークナイザ（fts5_tokenize.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | fts5AsciiCreateでASCIIトークナイザ作成 | E-07 L64-102 | ○ |
| C-29 | tokencharsオプション適用 | E-07 L84-86 | ○ |
| C-30 | separatorsオプション適用 | E-07 L87-89 | ○ |
| C-31 | 奇数引数でエラー | E-07 L72-73 | ○ |
| C-32 | fts5AsciiTokenizeでトークン化 | E-07 L117-172 | ○ |
| C-33 | 大文字小文字変換 | E-07 L105-112 | ○ |
| C-34 | 空文字列でトークン0個 | E-07 L143 | ○ |
| C-35 | 長いトークンのバッファ拡張 | E-07 L153-161 | ○ |
| C-36 | fts5UnicodeCreateでUnicode61作成 | E-07 L357-428 | ○ |
| C-37 | remove_diacritics設定 | E-07 L395-404 | ○ |
| C-38 | categories設定 | E-07 L384-388 | ○ |
| C-39 | 不正remove_diacritics値でエラー | E-07 L396 | ○ |
| C-40 | fts5UnicodeTokenizeでトークン化 | E-07 L442-544 | ○ |
| C-41 | マルチバイト文字処理 | E-07 L197-229 (READ_UTF8/WRITE_UTF8) | ○ |
| C-42 | fts5PorterCreateでPorter作成 | E-07 L577-613 | ○ |
| C-43 | ベーストークナイザ指定 | E-07 L589-591 | ○ |
| C-44 | Porter語幹抽出 | E-07 L1181-1245 | ○ |
| C-45 | 短いトークンステミングスキップ | E-07 L1194 | ○ |
| C-46 | 長いトークンパススルー | E-07 L1194 | ○ |
| C-47 | fts5TriCreateでTrigram作成 | E-07 L1287-1338 | ○ |
| C-48 | case_sensitiveオプション | E-07 L1309-1314 | ○ |
| C-49 | 矛盾オプションでエラー | E-07 L1326-1328 | △ |
| C-50 | fts5TriTokenizeで3文字トークン化 | E-07 L1343-1415 | ○ |
| C-51 | 3文字未満入力でトークンなし | E-07 L1366 | ○ |
| C-52 | TokenizerPatternでLIKE返却 | E-07 L1428-1439 | ○ |
| C-53 | 非trigramでNONE返却 | E-07 L1438 | ○ |

### 補助関数（fts5_aux.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | fts5HighlightFunctionでハイライト | E-08 L233-287 | ○ |
| C-55 | highlight引数3つ検証 | E-08 L244-248 | ○ |
| C-56 | 存在しないカラムでエラー | E-08 L256-258 | ○ |
| C-57 | fts5SnippetFunctionでスニペット | E-08 L418-584 | ○ |
| C-58 | snippet引数5つ検証 | E-08 L441-445 | ○ |
| C-59 | fts5Bm25FunctionでBM25計算 | E-08 L693-747 | ○ |
| C-60 | fts5Bm25GetDataで初期化 | E-08 L620-688 | ○ |
| C-61 | fts5GetLocaleFunctionでロケール取得 | E-08 L752-794 | ○ |
| C-62 | getLocale引数1つ検証 | E-08 L768-772 | ○ |
| C-63 | getLocale非整数エラー | E-08 L774-779 | ○ |

### ストレージ管理（fts5_storage.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | sqlite3Fts5StorageOpenでストレージ作成 | E-09 L343-420 | ○ |
| C-65 | メモリ不足でNOMEM | E-09 L357 | ○ |
| C-66 | sqlite3Fts5StorageCloseで閉じる | E-09 L425-438 | ○ |
| C-67 | sqlite3Fts5StorageDeleteで行削除 | E-09 L739-796 | ○ |
| C-68 | 存在しない行の削除 | E-09 L531-533 | ○ |
| C-69 | sqlite3Fts5StorageDeleteAllで全削除 | E-09 L801-835 | ○ |
| C-70 | sqlite3Fts5StorageContentInsertで挿入 | E-09 L956-1032 | ○ |
| C-71 | REPLACEモード | E-09 L978-980 | ○ |
| C-72 | sqlite3Fts5StorageIndexInsertでインデックス挿入 | E-09 L1037-1102 | ○ |
| C-73 | sqlite3Fts5StorageRebuildで再構築 | E-09 L837-912 | ○ |
| C-74 | sqlite3Fts5StorageOptimizeで最適化 | E-09 L914-916 | ○ |
| C-75 | sqlite3Fts5StorageMergeでマージ | E-09 L918-920 | ○ |
| C-76 | sqlite3Fts5StorageSyncで同期 | E-09 L1482-1496 | ○ |
| C-77 | sqlite3Fts5StorageRollbackでロールバック | E-09 L1498-1501 | ○ |
| C-78 | sqlite3Fts5StorageDocsizeで取得 | E-09 L1418-1445 | ○ |
| C-79 | 存在しない行でCORRUPT | E-09 L1437-1439 | ○ |
| C-80 | sqlite3Fts5StorageSizeでカラムサイズ取得 | E-09 L1447-1463 | ○ |
| C-81 | 全カラム合計サイズ | E-09 L1451-1455 | ○ |
| C-82 | 範囲外カラムでRANGE | E-09 L1459 | ○ |
| C-83 | sqlite3Fts5StorageRowCountで行数取得 | E-09 L1465-1477 | ○ |
| C-84 | 行数0でCORRUPT | E-09 L1474 | △ |
| C-85 | sqlite3Fts5StorageIntegrityで整合性チェック | E-09 L1216-1350 | ○ |
| C-86 | 不整合検出でCORRUPT | E-09 L1300-1301, L1323, L1332, L1337 | △ |
| C-87 | sqlite3Fts5StorageConfigValueで設定保存 | E-09 L1503-1530 | ○ |
| C-88 | sqlite3Fts5StorageRenameでリネーム | E-09 L288-302 | ○ |
| C-89 | sqlite3Fts5DropAllで全削除 | E-09 L250-272 | ○ |
| C-90 | fts5StorageInsertCallbackでトークン追加 | E-09 L450-466 | ○ |
| C-91 | 最大サイズ超トークン切り詰め | E-09 L461 | ○ |
| C-92 | fts5StorageDeleteFromIndexで削除 | E-09 L506-607 | ○ |
| C-93 | fts5StorageContentlessDeleteでtombstone追加 | E-09 L628-654 | △ |
| C-94 | fts5StorageLoadTotalsでロード | E-09 L701-708 | ○ |
| C-95 | fts5StorageSaveTotalsで保存 | E-09 L717-734 | ○ |
| C-96 | fts5CInstIterInitで初期化 | E-08 L85-104 | ○ |
| C-97 | fts5CInstIterNextで進行 | E-08 L54-79 | ○ |
| C-98 | fts5SnippetScoreでスコア計算 | E-08 L361-403 | ○ |
| C-99 | fts5SentenceFinderCbで文検出 | E-08 L328-359 | △ |
| C-100 | fts5SentenceFinderAddで配列追加 | E-08 L309-321 | ○ |

## 4) 不足情報（Unknown / Missing）

- **UT-FTS5-049**: `case_sensitive=1`と`remove_diacritics=1`の組み合わせが不正となる詳細条件がコードから確認できるが、エラーメッセージの内容は未確認
  - 候補：`fts5_tokenize.c` L1326-1328 / SQLiteドキュメント / テストスイート

- **UT-FTS5-084**: `sqlite3Fts5StorageRowCount`で`nTotalRow<=0`の場合にFTS5_CORRUPTを返すが、APIが呼ばれる条件の詳細検証が必要
  - 候補：`fts5_storage.c` L1472-1474 / xRowCount API仕様 / 呼び出し元調査

- **UT-FTS5-086**: 整合性チェックで検出できる不整合の完全なリストはコードから推測したが、網羅性の検証が必要
  - 候補：`fts5_storage.c` L1216-1350 / インデックス整合性チェック仕様

- **UT-FTS5-093**: `contentless_delete`機能の境界条件（originが0の場合など）の動作詳細
  - 候補：`fts5_storage.c` L628-654 / FTS5 contentless_delete仕様

- **UT-FTS5-099**: 文検出ロジックで使用される句読点（`.`と`:`）以外の文区切り文字の扱い
  - 候補：`fts5_aux.c` L350 / 多言語対応検討

## 5) リスクフラグ（レビュー観点）

| リスク | 対象 | 理由 |
|-------|------|------|
| 1: 中リスク | メモリ管理関数（C-01〜C-09） | メモリリーク・バッファオーバーフローの可能性 |
| 1: 中リスク | varintエンコード/デコード（C-10〜C-13） | 不正データによる整数オーバーフローの可能性 |
| 2: 高リスク | 整合性チェック（C-85, C-86） | 不整合検出の漏れによるデータ破損リスク |
| 1: 中リスク | トークナイザ（C-28〜C-53） | 不正入力によるクラッシュの可能性 |
| 0: 低リスク | 補助関数（C-54〜C-63） | 主にUI向け機能のため影響限定的 |

## 6) レビュアーチェックリスト（最小）

- [ ] バッファ管理関数でのメモリリークがないか確認（特にエラーパス）
- [ ] varint境界値（0, 127, 128, 最大値）でのエンコード/デコード一致を確認
- [ ] ハッシュテーブルの衝突処理が正しいか確認
- [ ] トークナイザのUTF-8処理で不正バイト列の扱いを確認
- [ ] 整合性チェックの網羅性（全ての破損パターンを検出できるか）を確認
- [ ] contentless_deleteの境界条件を確認
- [ ] BM25計算の数値精度を確認（特にIDF計算で負値にならないか）
