---
generated_at: 2026-01-21 12:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：ext-icu単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UT-ICU-041**：不正なロケールの動作はICUライブラリ依存で挙動が異なる可能性
  2. **UT-ICU-049**：関数登録失敗のシナリオは限定的で実際の発生条件が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/icu/icu.c` (メインソースファイル、589行)
- E-02: `ext/icu/sqliteicu.h` (ヘッダファイル、27行)
- E-03: `ext/icu/README.txt` (ドキュメント、169行)
- E-04: ICU公式ドキュメント (u_foldCase, ucol_open, uregex_open等のAPI仕様)
- E-05: SQLite公式ドキュメント (sqlite3_create_function, sqlite3_result_* API仕様)

## 3) Claims と根拠の対応（レビューの主戦場）

### エラーハンドリング関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-ICU-001) | icuFunctionErrorがエラーメッセージを正しく生成 | E-01 (行57-66) | ○ |
| C-02 (UT-ICU-002) | 128バイトでメッセージが切り詰められる | E-01 (行62-64: zBuf[128], zBuf[127]='\0') | ○ |

### メモリ管理関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-03 (UT-ICU-003) | xFreeがsqlite3_freeを呼び出す | E-01 (行81-83) | ○ |
| C-18 (UT-ICU-018) | icuRegexpDeleteがuregex_closeを呼び出す | E-01 (行253-256) | ○ |
| C-32 (UT-ICU-032) | icuCollationDelがucol_closeを呼び出す | E-01 (行421-424) | ○ |

### LIKE演算子関連 (icuLikeCompare)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 (UT-ICU-004) | 完全一致パターンがマッチ | E-01 (行122-195) | ○ |
| C-05 (UT-ICU-005) | %ワイルドカードがマッチ | E-01 (行146-170: MATCH_ALL処理) | ○ |
| C-06 (UT-ICU-006) | _ワイルドカードがマッチ | E-01 (行172-175: MATCH_ONE処理) | ○ |
| C-07 (UT-ICU-007) | エスケープ文字が処理される | E-01 (行177-179: prevEscape処理) | ○ |
| C-08 (UT-ICU-008) | 大文字小文字を区別しない比較 | E-01 (行185-186: u_foldCase呼び出し) | ○ |
| C-09 (UT-ICU-009) | パターンが長く文字列が短い場合 | E-01 (行194: *zString==0チェック) | ○ |
| C-10 (UT-ICU-010) | 空文字列の場合 | E-01 (行194) | ○ |
| C-11 (UT-ICU-011) | %のみのパターン | E-01 (行162: *zPattern==0チェック) | ○ |
| C-12 (UT-ICU-012) | マルチバイトUTF-8文字 | E-01 (行90-114: icuUtf8Trans1テーブルとマクロ) | ○ |
| C-57 (UT-ICU-057) | 複合パターン(%と_) | E-01 (行122-195) | ○ |
| C-58 (UT-ICU-058) | 連続した% | E-01 (行154-160) | ○ |
| C-59 (UT-ICU-059) | %の後の_ | E-01 (行154-158) | ○ |
| C-60 (UT-ICU-060) | %_パターンで空文字列 | E-01 (行156) | ○ |

### LIKE SQL関数 (icuLikeFunc)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 (UT-ICU-013) | 2引数でLIKE関数が動作 | E-01 (行210-247) | ○ |
| C-14 (UT-ICU-014) | 3引数(エスケープ付き)で動作 | E-01 (行228-242) | ○ |
| C-15 (UT-ICU-015) | パターンが長すぎる場合のエラー | E-01 (行222-225: SQLITE_MAX_LIKE_PATTERN_LENGTH) | ○ |
| C-16 (UT-ICU-016) | エスケープ文字が複数文字の場合のエラー | E-01 (行237-241) | ○ |
| C-17 (UT-ICU-017) | NULL入力時のNULL返却 | E-01 (行244-246: zA && zB チェック) | ○ |

### REGEXP演算子 (icuRegexpFunc)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 (UT-ICU-019) | 正規表現マッチが成功 | E-01 (行277-333) | ○ |
| C-20 (UT-ICU-020) | 正規表現マッチが失敗 | E-01 (行318: uregex_matches) | ○ |
| C-21 (UT-ICU-021) | 左辺がNULLの場合 | E-01 (行288-290) | ○ |
| C-22 (UT-ICU-022) | パターンがNULLの場合 | E-01 (行295-297) | ○ |
| C-23 (UT-ICU-023) | 不正な正規表現パターンの場合 | E-01 (行304-307) | ○ |
| C-24 (UT-ICU-024) | キャッシュされた正規表現の再利用 | E-01 (行292-302: sqlite3_get_auxdata/sqlite3_set_auxdata) | ○ |

### upper/lower関数 (icuCaseFunc16)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 (UT-ICU-025) | upper()で小文字が大文字に変換 | E-01 (行361-413, 行396-397: u_strToUpper) | ○ |
| C-26 (UT-ICU-026) | lower()で大文字が小文字に変換 | E-01 (行399: u_strToLower) | ○ |
| C-27 (UT-ICU-027) | ロケール指定時の言語固有変換 | E-01 (行373-375), E-03 (行44-51) | ○ |
| C-28 (UT-ICU-028) | NULL入力時のNULL返却 | E-01 (行378-380) | ○ |
| C-29 (UT-ICU-029) | 空文字列の場合 | E-01 (行382-385) | ○ |
| C-30 (UT-ICU-030) | バッファオーバーフロー時の再割り当て | E-01 (行387-411, 行404-406: U_BUFFER_OVERFLOW_ERROR) | ○ |
| C-31 (UT-ICU-031) | メモリ確保失敗時のエラー | E-01 (行389-393) | ○ |

### コレーション比較 (icuCollationColl)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 (UT-ICU-033) | 左辺が小さい場合に-1が返却 | E-01 (行430-447, 行441: UCOL_LESS) | ○ |
| C-34 (UT-ICU-034) | 左辺が大きい場合に+1が返却 | E-01 (行442: UCOL_GREATER) | ○ |
| C-35 (UT-ICU-035) | 等しい場合に0が返却 | E-01 (行443: UCOL_EQUAL) | ○ |
| C-36 (UT-ICU-036) | ロケール固有のソート順序 | E-01 (行439: ucol_strcoll), E-03 (行66-88) | ○ |

### コレーション登録 (icuLoadCollation)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 (UT-ICU-037) | 2引数でコレーション登録 | E-01 (行462-529, 行474: assert(nArg==2 || nArg==3)) | ○ |
| C-38 (UT-ICU-038) | 3引数(強度指定付き)で登録 | E-01 (行489-521) | ○ |
| C-39 (UT-ICU-039) | ロケールがNULLの場合 | E-01 (行479-481) | ○ |
| C-40 (UT-ICU-040) | 名前がNULLの場合 | E-01 (行479-481) | ○ |
| C-41 (UT-ICU-041) | 不正なロケールの場合 | E-01 (行483-486), **ICUライブラリ依存** | △ |
| C-42 (UT-ICU-042) | 不正な強度オプションの場合 | E-01 (行509-520) | ○ |
| C-43 (UT-ICU-043) | SECONDARY強度 | E-01 (行496: UCOL_SECONDARY) | ○ |
| C-44 (UT-ICU-044) | TERTIARY強度 | E-01 (行497: UCOL_TERTIARY) | ○ |
| C-45 (UT-ICU-045) | QUARTERNARY強度 | E-01 (行499: UCOL_QUATERNARY) | ○ |
| C-46 (UT-ICU-046) | IDENTICAL強度 | E-01 (行500: UCOL_IDENTICAL) | ○ |
| C-47 (UT-ICU-047) | DEFAULT強度 | E-01 (行498: UCOL_DEFAULT_STRENGTH) | ○ |

### 初期化関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 (UT-ICU-048) | 全スカラー関数が登録される | E-01 (行534-572, 行542-557: scalars配列) | ○ |
| C-49 (UT-ICU-049) | 関数登録失敗時のエラー返却 | E-01 (行562), **具体的な失敗条件は不明確** | △ |
| C-50 (UT-ICU-050) | 拡張エントリポイントの動作 | E-01 (行578-586) | ○ |

### UTF-8マクロ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 (UT-ICU-051) | 1バイトUTF-8文字の読み取り | E-01 (行101-108: SQLITE_ICU_READ_UTF8) | ○ |
| C-52 (UT-ICU-052) | 2バイトUTF-8文字の読み取り | E-01 (行90-99, 行101-108) | ○ |
| C-53 (UT-ICU-053) | 3バイトUTF-8文字の読み取り | E-01 (行90-99, 行101-108) | ○ |
| C-54 (UT-ICU-054) | 4バイトUTF-8文字の読み取り | E-01 (行90-99, 行101-108) | ○ |
| C-55 (UT-ICU-055) | 1バイトUTF-8文字のスキップ | E-01 (行110-114: SQLITE_ICU_SKIP_UTF8) | ○ |
| C-56 (UT-ICU-056) | マルチバイトUTF-8文字のスキップ | E-01 (行110-114) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-ICU-041（不正なロケール）**：ICUライブラリ(ucol_open)が不正なロケール文字列をどう処理するかは、ICUバージョンや設定に依存する可能性がある。テスト時には実際のICUの動作を確認する必要がある。
  - 候補：ICU公式ドキュメント / ICUソースコード / 実機テスト
- **UT-ICU-049（関数登録失敗）**：sqlite3_create_functionがSQLITE_OK以外を返すシナリオは限定的（メモリ不足、同名関数の重複等）で、具体的なテスト条件の設計が必要。
  - 候補：SQLite公式ドキュメント / SQLiteソースコード

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：UTF-8デコード/スキップマクロ - コードから動作が明確
- **リスク0（低）**：メモリ管理関数 - 単純なラッパー関数
- **リスク1（中）**：LIKE/REGEXP演算子 - ワイルドカードやエスケープの組み合わせテストが複雑になる可能性
- **リスク1（中）**：upper/lower関数 - ロケール依存の動作確認が必要
- **リスク2（高）**：コレーション関連 - ICUライブラリとSQLiteの連携が複雑で、バージョン依存の問題が発生しうる

## 6) レビュアーチェックリスト（最小）
- [ ] ICUライブラリのバージョンを確認し、テスト環境との互換性を検証
- [ ] SQLITE_MAX_LIKE_PATTERN_LENGTH の値がプロジェクト要件と一致しているか確認
- [ ] トルコ語ロケール（tr_TR）のテストケースが実際のICU環境で期待通り動作するか確認
- [ ] コレーション強度オプションの綴り「QUARTERNARY」（コード内のtypo）がICU側と一致しているか確認
- [ ] メモリ不足状態のテスト（UT-ICU-031, UT-ICU-049）の実現可能性を検討
- [ ] UT-ICU-041、UT-ICU-049の具体的なテスト条件を補完
