---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 94
  claims_with_evidence: 91
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：ext-intck単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：91 / 94、根拠なし：3
- 優先レビュー（高）
  1. **UT-INTCK-005**：メモリ確保失敗のテスト方法が環境依存
  2. **UT-INTCK-006**：関数登録失敗の再現方法が不明確
  3. **UT-INTCK-041**：メモリ確保失敗のテスト方法が環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/sqlite-master/ext/intck/sqlite3intck.h` - APIヘッダファイル（公開API定義）
- E-02: `/Users/tomoka.baba/Work/sqlite-master/ext/intck/sqlite3intck.c` - 実装ソースコード（942行）
- E-03: `/Users/tomoka.baba/Work/sqlite-master/ext/intck/test_intck.c` - Tclテストラッパー（234行）
- E-04: `/Users/tomoka.baba/Work/sqlite-master/ext/intck/intck1.test` - テストファイル（存在確認済み）
- E-05: `/Users/tomoka.baba/Work/sqlite-master/ext/intck/intck2.test` - テストファイル（存在確認済み）
- E-06: `/Users/tomoka.baba/Work/sqlite-master/ext/intck/intckcorrupt.test` - 破損テストファイル（存在確認済み）
- E-07: `/Users/tomoka.baba/Work/sqlite-master/ext/intck/intckfault.test` - フォールトテストファイル（存在確認済み）
- E-08: `/Users/tomoka.baba/Work/sqlite-master/ext/intck/intckbusy.test` - ビジーテストファイル（存在確認済み）

## 3) Claims と根拠の対応（レビューの主戦場）

### 公開API関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3_intck_open: 正常オープン機能 | E-01 (L85-89), E-02 (L781-810) | ○ |
| C-02 | sqlite3_intck_open: デフォルトDB名 | E-02 (L788: `zDb ? zDbArg : "main"`) | ○ |
| C-03 | sqlite3_intck_open: tempデータベース対応 | E-01 (L79: "main", "temp", or attached) | ○ |
| C-04 | sqlite3_intck_open: アタッチDB対応 | E-01 (L79: "main", "temp", or attached) | ○ |
| C-05 | sqlite3_intck_open: SQLITE_NOMEMエラー | E-02 (L792-793) | △ |
| C-06 | sqlite3_intck_open: 関数登録失敗 | E-02 (L799-805) | △ |
| C-07 | sqlite3_intck_close: 正常クローズ | E-01 (L91-96), E-02 (L815-828) | ○ |
| C-08 | sqlite3_intck_close: NULL安全性 | E-02 (L816: `if( p )`) | ○ |
| C-09 | sqlite3_intck_close: pCheckファイナライズ | E-02 (L817: `sqlite3_finalize(p->pCheck)`) | ○ |
| C-10 | sqlite3_intck_step: 基本機能 | E-01 (L100-117), E-02 (L833-885) | ○ |
| C-11 | sqlite3_intck_step: SQLITE_DONE | E-02 (L854-856) | ○ |
| C-12 | sqlite3_intck_step: 破損検出 | E-01 (L104-105), E-02 (L857-863, L874-879) | ○ |
| C-13 | sqlite3_intck_step: インデックスチェック | E-02 (L631-684) | ○ |
| C-14 | sqlite3_intck_step: WITHOUT ROWID | E-02 (L523-529: `without_rowid(b)` CTE) | ○ |
| C-15 | sqlite3_intck_step: 部分インデックス | E-02 (L591-593, L703) | ○ |
| C-16 | sqlite3_intck_step: エラー状態継続 | E-02 (L834: `if( p->rc==SQLITE_OK )`) | ○ |
| C-17 | sqlite3_intck_step: スキーマ破損メッセージ | E-02 (L857-863) | ○ |
| C-18 | sqlite3_intck_step: sqlite_schemaチェック | E-02 (L285: `UNION ALL SELECT 'sqlite_schema'`) | ○ |
| C-19 | sqlite3_intck_message: 破損メッセージ | E-01 (L120-127), E-02 (L891-900) | ○ |
| C-20 | sqlite3_intck_message: 正常時NULL | E-02 (L893-898) | ○ |
| C-21 | sqlite3_intck_message: 初期状態NULL | E-02 (L893-898) | ○ |
| C-22 | sqlite3_intck_message: 余剰エントリ | E-02 (L650-654: `surplus entry ... in index`) | ○ |
| C-23 | sqlite3_intck_message: エントリ欠落 | E-02 (L700-701: `entry ... missing from index`) | ○ |
| C-24 | sqlite3_intck_error: エラー情報取得 | E-01 (L144-155), E-02 (L905-908) | ○ |
| C-25 | sqlite3_intck_error: 正常時SQLITE_OK | E-02 (L907: `p->rc==SQLITE_DONE ? SQLITE_OK : p->rc`) | ○ |
| C-26 | sqlite3_intck_error: DONE時SQLITE_OK | E-02 (L907) | ○ |
| C-27 | sqlite3_intck_error: pzErr NULL安全 | E-02 (L906: `if( pzErr )`) | ○ |
| C-28 | sqlite3_intck_unlock: トランザクション解放 | E-01 (L130-141), E-02 (L914-922) | ○ |
| C-29 | sqlite3_intck_unlock: 再開機能 | E-01 (L51-55), E-02 (L917-918) | ○ |
| C-30 | sqlite3_intck_unlock: キー値保存 | E-02 (L917: `intckSaveKey(p)`) | ○ |
| C-31 | sqlite3_intck_unlock: エラー状態継続 | E-02 (L915: `if( p->rc==SQLITE_OK && p->pCheck )`) | ○ |
| C-32 | sqlite3_intck_unlock: pCheck NULL時 | E-02 (L915) | ○ |
| C-33 | sqlite3_intck_test_sql: オブジェクト指定 | E-01 (L158-163), E-02 (L928-941) | ○ |
| C-34 | sqlite3_intck_test_sql: 現在オブジェクト | E-02 (L933-934) | ○ |
| C-35 | sqlite3_intck_test_sql: 初期状態NULL | E-02 (L935-937) | ○ |

### 内部関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | intckSaveErrmsg: エラー保存 | E-02 (L62-66) | ○ |
| C-37 | intckPrepare: 正常プリペア | E-02 (L76-86) | ○ |
| C-38 | intckPrepare: 不正SQL | E-02 (L80-81) | ○ |
| C-39 | intckPrepare: エラー状態スキップ | E-02 (L78: `if( p->rc==SQLITE_OK )`) | ○ |
| C-40 | intckPrepareFmt: フォーマットプリペア | E-02 (L98-111) | ○ |
| C-41 | intckPrepareFmt: SQLITE_NOMEM | E-02 (L104-106) | △ |
| C-42 | intckFinalize: 正常ファイナライズ | E-02 (L118-123) | ○ |
| C-43 | intckFinalize: ファイナライズエラー | E-02 (L120-122) | ○ |
| C-44 | intckStep: ステップ実行 | E-02 (L129-132) | ○ |
| C-45 | intckStep: エラー状態即座返却 | E-02 (L130: `if( p->rc ) return p->rc`) | ○ |
| C-46 | intckExec: SQL実行 | E-02 (L139-144) | ○ |
| C-47 | intckMprintf: 文字列生成 | E-02 (L150-165) | ○ |
| C-48 | intckMprintf: SQLITE_NOMEM | E-02 (L156-158) | ○ |
| C-49 | intckMprintf: エラー状態メモリ解放 | E-02 (L159-161) | ○ |
| C-50 | intckSaveKey: テーブルキー保存 | E-02 (L172-265, L196-200) | ○ |
| C-51 | intckSaveKey: インデックスキー保存 | E-02 (L201-250) | ○ |
| C-52 | intckSaveKey: DESCキー処理 | E-02 (L206-218) | ○ |
| C-53 | intckSaveKey: NULLキー処理 | E-02 (L213-215) | ○ |
| C-54 | intckFindObject: オブジェクト検索 | E-02 (L272-308) | ○ |
| C-55 | intckFindObject: アルファベット順 | E-02 (L289: `ORDER BY 1`) | ○ |
| C-56 | intckFindObject: 完了検出 | E-02 (L295-297) | ○ |
| C-57 | intckFindObject: 再開位置 | E-02 (L290: `p->zKey ? ">=" : ">"`) | ○ |
| C-58 | intckGetToken: シングルクォート | E-02 (L318-340, L321-328) | ○ |
| C-59 | intckGetToken: ダブルクォート | E-02 (L321) | ○ |
| C-60 | intckGetToken: 角括弧 | E-02 (L330-331) | ○ |
| C-61 | intckGetToken: アルファベット | E-02 (L333-336) | ○ |
| C-62 | intckGetToken: エスケープクォート | E-02 (L323-326) | ○ |
| C-63 | intckIsSpace: スペース | E-02 (L345-347) | ○ |
| C-64 | intckIsSpace: タブ | E-02 (L346) | ○ |
| C-65 | intckIsSpace: 改行 | E-02 (L346) | ○ |
| C-66 | intckIsSpace: 非空白 | E-02 (L345-347) | ○ |
| C-67 | intckParseCreateIndex: 列抽出 | E-02 (L364-442) | ○ |
| C-68 | intckParseCreateIndex: WHERE句 | E-02 (L422-429) | ○ |
| C-69 | intckParseCreateIndex: ASC/DESC除外 | E-02 (L409-415) | ○ |
| C-70 | intckParseCreateIndex: WHERE句なし | E-02 (L422-429) | ○ |
| C-71 | intckParseCreateIndex: 範囲外列番号 | E-02 (L392-403) | ○ |
| C-72 | intckParseCreateIndexFunc: UDF動作 | E-02 (L449-464) | ○ |
| C-73 | intckParseCreateIndexFunc: NULL入力 | E-02 (L460: `if( zSql )`) | ○ |
| C-74 | intckGetAutoIndex: 取得 | E-02 (L470-479) | ○ |
| C-75 | intckGetAutoIndex: 無効時 | E-02 (L470-479) | ○ |
| C-76 | intckIsIndex: インデックス判定 | E-02 (L484-496) | ○ |
| C-77 | intckIsIndex: テーブル判定 | E-02 (L484-496) | ○ |
| C-78 | intckCheckObjectSql: テーブルSQL | E-02 (L508-776, L685-764) | ○ |
| C-79 | intckCheckObjectSql: インデックスSQL | E-02 (L631-684) | ○ |
| C-80 | intckCheckObjectSql: 再開SQL | E-02 (L683, L742-748) | ○ |
| C-81 | intckCheckObjectSql: キー値数取得 | E-02 (L768-770) | ○ |
| C-82 | intckCheckObjectSql: 自動インデックス無効化 | E-02 (L627-628, L774) | ○ |

### Tclテストラッパー

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | testIntckCmd: close | E-03 (L70-72) | ○ |
| C-84 | testIntckCmd: step | E-03 (L75-78) | ○ |
| C-85 | testIntckCmd: message | E-03 (L81-84) | ○ |
| C-86 | testIntckCmd: error | E-03 (L87-101) | ○ |
| C-87 | testIntckCmd: unlock | E-03 (L103-106) | ○ |
| C-88 | testIntckCmd: test_sql | E-03 (L109-113) | ○ |
| C-89 | testIntckCmd: 引数エラー | E-03 (L54-67) | ○ |
| C-90 | test_sqlite3_intck: ハンドル作成 | E-03 (L132-174) | ○ |
| C-91 | test_sqlite3_intck: 空DBNAME | E-03 (L158: `if( zDb[0]=='\0' ) zDb = 0`) | ○ |
| C-92 | test_do_intck: 完全チェック | E-03 (L179-227) | ○ |
| C-93 | test_do_intck: NULLクローズ | E-03 (L225: `sqlite3_intck_close(0)`) | ○ |
| C-94 | Sqlitetestintck_Init: 初期化 | E-03 (L229-233) | ○ |

## 4) 不足情報（Unknown / Missing）

### 根拠不足の項目

1. **UT-INTCK-005, UT-INTCK-041: メモリ確保失敗テスト**
   - コード上はSQLITE_NOMEM処理が実装されている（E-02 L792-793, L104-106）
   - テスト環境でメモリ確保失敗を再現する方法が不明確
   - 候補：sqlite3_testmallocfailure / カスタムアロケータ / フォールトインジェクション

2. **UT-INTCK-006: 関数登録失敗テスト**
   - コード上はエラー処理が実装されている（E-02 L802-805）
   - sqlite3_create_functionが失敗するケースの再現方法が不明確
   - 候補：既に同名関数が登録されている状態 / メモリ不足

## 5) リスクフラグ（レビュー観点）

| リスク | 項目 | 説明 |
|--------|------|------|
| 0 | 公開API全般 | ヘッダファイルと実装が一致、ドキュメントコメントも充実 |
| 0 | 内部関数全般 | 実装コードから直接抽出、根拠明確 |
| 1 | メモリエラー系テスト | テスト実行環境の構築方法が環境依存 |
| 0 | Tclラッパー | test_intck.cから直接抽出、明確 |

**リスクレベル凡例:**
- 0: 低リスク（根拠明確、そのまま使用可能）
- 1: 中リスク（要確認、追加調査推奨）
- 2: 高リスク（要修正、根拠不十分）

## 6) レビュアーチェックリスト（最小）

- [ ] 公開API（sqlite3_intck_open/close/step/message/error/unlock/test_sql）のテストケースが網羅されているか
- [ ] WITHOUT ROWIDテーブル、部分インデックス、DESCインデックスなど特殊ケースがカバーされているか
- [ ] エラー状態の継続（p->rcチェック）に関するテストケースが含まれているか
- [ ] 内部関数の境界値テスト（NULL入力、空入力）が含まれているか
- [ ] Tclテストラッパーの全サブコマンドがテストされているか
- [ ] メモリ確保失敗テスト（UT-INTCK-005, UT-INTCK-041）の実行方法を確認したか
- [ ] intckParseCreateIndexのトークン解析が全パターン（'、"、`、[、アルファベット）をカバーしているか

## 7) 補足情報

### モジュール概要
ext-intckモジュールは「Incremental Integrity-Check Extension」として、SQLiteデータベースの整合性チェックを段階的に実行するためのAPIを提供しています。標準の`PRAGMA integrity_check`と比較して以下の特徴があります：

- チェック操作を複数トランザクションに分割可能
- データベースの長時間ロックを回避
- 速度は遅いが、中断・再開が可能

### ソースファイル構成
| ファイル | 行数 | 内容 |
|----------|------|------|
| sqlite3intck.h | 172行 | 公開APIヘッダ |
| sqlite3intck.c | 942行 | 実装本体 |
| test_intck.c | 234行 | Tclテストラッパー |

### 主要データ構造
```c
struct sqlite3_intck {
  sqlite3 *db;           // データベースハンドル
  const char *zDb;       // データベース名
  char *zObj;            // 現在のチェック対象オブジェクト
  sqlite3_stmt *pCheck;  // 現在のチェックステートメント
  char *zKey;            // 再開用キー値
  int nKeyVal;           // キー値の数
  char *zMessage;        // 破損メッセージ
  int bCorruptSchema;    // スキーマ破損フラグ
  int rc;                // エラーコード
  char *zErr;            // エラーメッセージ
  char *zTestSql;        // テストSQL（デバッグ用）
};
```
