---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 180
  claims_with_evidence: 175
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：ext-jni 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：175 / 180、根拠なし：5
- 優先レビュー（高）
  1. **UT-JNI-160〜164（FTS5関連）**：FTS5 APIの詳細動作はCソースコードに依存
  2. **UT-JNI-165〜167（CApi静的メソッド）**：ネイティブ実装の詳細確認が必要
  3. **UT-JNI-079（Authorizer）**：セキュリティ関連のため詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/jni/src/org/sqlite/jni/capi/NativePointerHolder.java` - ポインタホルダー基盤クラス
- E-02: `ext/jni/src/org/sqlite/jni/capi/sqlite3.java` - DBハンドルラッパー
- E-03: `ext/jni/src/org/sqlite/jni/capi/sqlite3_stmt.java` - ステートメントラッパー
- E-04: `ext/jni/src/org/sqlite/jni/capi/sqlite3_blob.java` - BLOBラッパー
- E-05: `ext/jni/src/org/sqlite/jni/capi/sqlite3_backup.java` - バックアップラッパー
- E-06: `ext/jni/src/org/sqlite/jni/capi/sqlite3_context.java` - UDFコンテキスト
- E-07: `ext/jni/src/org/sqlite/jni/capi/sqlite3_value.java` - 値ラッパー
- E-08: `ext/jni/src/org/sqlite/jni/capi/OutputPointer.java` - 出力ポインタクラス群
- E-09: `ext/jni/src/org/sqlite/jni/capi/ResultCode.java` - 結果コードenum
- E-10: `ext/jni/src/org/sqlite/jni/capi/TableColumnMetadata.java` - テーブルメタデータ
- E-11: `ext/jni/src/org/sqlite/jni/capi/ValueHolder.java` - 値ホルダー
- E-12: `ext/jni/src/org/sqlite/jni/capi/SQLFunction.java` - SQLFunction基底インターフェース
- E-13: `ext/jni/src/org/sqlite/jni/capi/ScalarFunction.java` - スカラー関数基底クラス
- E-14: `ext/jni/src/org/sqlite/jni/capi/AggregateFunction.java` - 集約関数基底クラス
- E-15: `ext/jni/src/org/sqlite/jni/capi/WindowFunction.java` - ウィンドウ関数基底クラス
- E-16: `ext/jni/src/org/sqlite/jni/capi/CApi.java` - JNI CAPIバインディング（部分読み込み）
- E-17: `ext/jni/src/org/sqlite/jni/wrapper1/Sqlite.java` - 高レベルラッパークラス
- E-18: `ext/jni/src/org/sqlite/jni/wrapper1/SqliteException.java` - 例外クラス
- E-19: `ext/jni/src/org/sqlite/jni/wrapper1/SqlFunction.java` - 高レベルUDFインターフェース
- E-20: `ext/jni/src/org/sqlite/jni/wrapper1/ValueHolder.java` - 高レベル値ホルダー
- E-21: `ext/jni/src/org/sqlite/jni/fts5/Fts5ExtensionApi.java` - FTS5拡張API

## 3) Claims と根拠の対応（レビューの主戦場）

### capi パッケージ（基盤クラス）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-JNI-001) | NativePointerHolder.getNativePointer() がポインタ値を返却 | E-01 (line 45) | ○ |
| C-02 (UT-JNI-002) | clearNativePointer() が旧値を返却しクリア | E-01 (lines 39-43) | ○ |
| C-03 (UT-JNI-003) | 初期値が0である | E-01 (line 31) | ○ |
| C-04 (UT-JNI-004) | sqlite3.toString() がDB情報を含む文字列を返却 | E-02 (lines 28-38) | ○ |
| C-05 (UT-JNI-005) | クローズ済みDBでnull表記 | E-02 (lines 30-31) | ○ |
| C-06 (UT-JNI-006) | sqlite3.close() がsqlite3_close_v2を呼び出す | E-02 (lines 40-42) | ○ |
| C-07 (UT-JNI-007) | sqlite3_stmt.close() がsqlite3_finalizeを呼び出す | E-03 (lines 27-29) | ○ |
| C-08 (UT-JNI-008) | sqlite3_blob.close() がsqlite3_blob_closeを呼び出す | E-04 (lines 27-29) | ○ |
| C-09 (UT-JNI-009) | sqlite3_backup.close() がsqlite3_backup_finishを呼び出す | E-05 (lines 27-29) | ○ |
| C-10 (UT-JNI-010〜012) | sqlite3_context.getAggregateContext() の動作 | E-06 (lines 72-78) | ○ |
| C-11 (UT-JNI-013〜021) | OutputPointer各種クラスの動作 | E-08 (全体) | ○ |
| C-12 (UT-JNI-022〜023) | ResultCode.getEntryForInt() の動作 | E-09 (lines 139-153) | ○ |
| C-13 (UT-JNI-024〜028) | TableColumnMetadata のアクセサ | E-10 (lines 30-35) | ○ |
| C-14 (UT-JNI-029〜030) | ValueHolder コンストラクタ | E-11 (lines 24-26) | ○ |

### capi パッケージ（UDF関連）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 (UT-JNI-031〜033) | ScalarFunction のメソッド | E-13 (lines 20-32) | ○ |
| C-16 (UT-JNI-034〜040) | AggregateFunction のメソッドと PerContextState | E-14 (全体) | ○ |
| C-17 (UT-JNI-041〜042) | WindowFunction のメソッド | E-15 (lines 24-38) | ○ |

### wrapper1 パッケージ（高レベルAPI）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 (UT-JNI-043〜045) | Sqlite.open() の動作 | E-17 (lines 331-355) | ○ |
| C-19 (UT-JNI-046〜047) | Sqlite.close() の動作 | E-17 (lines 490-498) | ○ |
| C-20 (UT-JNI-048〜049) | Sqlite.fromNative() の動作 | E-17 (lines 317-321) | ○ |
| C-21 (UT-JNI-050〜054) | Sqlite.prepare() / prepareMulti() の動作 | E-17 (lines 586-715) | ○ |
| C-22 (UT-JNI-055〜057) | Sqlite.createFunction() の動作 | E-17 (lines 717-745) | ○ |
| C-23 (UT-JNI-058〜060) | changes/totalChanges/lastInsertRowId | E-17 (lines 747-761) | ○ |
| C-24 (UT-JNI-061〜062) | interrupt/isInterrupted | E-17 (lines 763-769) | ○ |
| C-25 (UT-JNI-063〜065) | isAutoCommit/transactionState | E-17 (lines 771-783) | ○ |
| C-26 (UT-JNI-066〜072) | dbName/dbFileName/dbConfig/readOnly/limit | E-17 (lines 785-871) | ○ |
| C-27 (UT-JNI-073〜080) | ビジーハンドラ・各種フック・トレース | E-17 (lines 1576-1991) | ○ |
| C-28 (UT-JNI-081〜083) | createCollation | E-17 (lines 1507-1535) | ○ |
| C-29 (UT-JNI-084〜085) | blobOpen/initBackup | E-17 (lines 1907-1480) | ○ |
| C-30 (UT-JNI-086) | initBackup のnullチェック | E-17 (lines 1474-1478) | ○ |
| C-31 (UT-JNI-087〜090) | AutoExtension 関連 | E-17 (lines 1348-1375) | ○ |

### wrapper1.Sqlite.Stmt 内部クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 (UT-JNI-091〜094) | Stmt.step() の動作 | E-17 (lines 1096-1121) | ○ |
| C-33 (UT-JNI-095〜097) | Stmt.reset/finalizeStmt | E-17 (lines 1132-1072) | ○ |
| C-34 (UT-JNI-098〜108) | Stmt.bind系メソッド | E-17 (lines 1179-1220) | ○ |
| C-35 (UT-JNI-109〜125) | Stmt.column系メソッド | E-17 (lines 1222-1285) | ○ |

### wrapper1.Sqlite.Backup / Blob 内部クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 (UT-JNI-126〜130) | Backup クラスの動作 | E-17 (lines 1381-1459) | ○ |
| C-37 (UT-JNI-131〜135) | Blob クラスの動作 | E-17 (lines 1826-1915) | ○ |

### SqliteException
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 (UT-JNI-136〜142) | SqliteException のコンストラクタとアクセサ | E-18 (全体) | ○ |

### SqlFunction.Arguments
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 (UT-JNI-143〜159) | Arguments クラスの各メソッド | E-19 (lines 39-203) | ○ |

### FTS5
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 (UT-JNI-160) | Fts5ExtensionApi.getInstance() | E-21 (line 33) | ○ |
| C-41 (UT-JNI-161〜164) | FTS5 各種メソッド | E-21 (lines 35-94) | △ |

### CApi 静的メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 (UT-JNI-165〜167) | sqlite3_java_uncache_thread / sqlite3_jni_supports_nio | E-16 (lines 98-129) | △ |
| C-43 (UT-JNI-168〜180) | Sqlite 静的メソッド群 | E-17 (lines 357-443, 448-488) | ○ |

## 4) 不足情報（Unknown / Missing）

### FTS5関連（UT-JNI-160〜164）
- FTS5 APIの詳細な動作仕様はCソースコード（sqlite3-jni.c）に依存
- Javaインターフェースからはnativeメソッド宣言のみ確認可能
- 候補：`ext/jni/src/c/sqlite3-jni.c` の解析 / SQLite FTS5公式ドキュメント参照

### CApi静的メソッド（UT-JNI-165〜167）
- JNI実装の詳細はCソースコードに記述
- Javaインターフェースからはnativeメソッド宣言のみ確認可能
- 候補：`ext/jni/src/c/sqlite3-jni.c` の解析

### NIO Buffer関連
- sqlite3_bind_nio_buffer等のNIO関連APIは@Experimental注釈付き
- 一部のJVMでサポートされない可能性あり
- 候補：JVMバージョン別の動作検証

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 対象 | 理由 |
|---|---|---|
| 2: 高リスク | UT-JNI-079（Authorizer） | セキュリティ関連機能であり、不正なSQL実行を防ぐ重要機能 |
| 1: 中リスク | UT-JNI-043〜047（open/close） | リソースリーク防止の観点で重要 |
| 1: 中リスク | UT-JNI-098〜108（bind系） | SQLインジェクション防止の観点で重要 |
| 1: 中リスク | UT-JNI-034〜040（集約関数状態管理） | マルチスレッド環境での状態競合リスク |
| 0: 低リスク | その他 | 通常のAPI動作確認 |

## 6) レビュアーチェックリスト（最小）

- [ ] FTS5テストケース（UT-JNI-160〜164）のCソースコード根拠を確認
- [ ] JNI native メソッドの戻り値がJava側で正しくハンドリングされているか確認
- [ ] AutoCloseable実装のリソース解放が確実に行われるか確認
- [ ] 例外処理のテストケースで、期待される例外型が適切か確認
- [ ] マルチスレッドシナリオのテストケースが十分か確認
- [ ] 境界値テストケースで、Integer.MAX_VALUE, Long.MAX_VALUE等の極端な値を考慮しているか確認
- [ ] セキュリティ関連（Authorizer）のテストケースが十分に網羅的か確認
