---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：ext-misc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **compress.c関連（UT-MISC-088, 089）**：ソースコード未確認
  2. **spellfix.c関連（UT-MISC-094）**：ソースコード未確認
  3. **percentile.c関連（UT-MISC-092, 093）**：ソースコード未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/misc/uuid.c` - UUID関連関数の実装
- E-02: `ext/misc/regexp.c` - 正規表現マッチング実装
- E-03: `ext/misc/sha1.c` - SHA1ハッシュ関数実装
- E-04: `ext/misc/series.c` - generate_series仮想テーブル実装
- E-05: `ext/misc/csv.c` - CSV仮想テーブル実装
- E-06: `ext/misc/decimal.c` - 任意精度10進数演算実装
- E-07: `ext/misc/ieee754.c` - IEEE754浮動小数点操作実装
- E-08: `ext/misc/base64.c` - Base64エンコード/デコード実装
- E-09: `ext/misc/rot13.c` - ROT13暗号化実装
- E-10: `ext/misc/shathree.c` - SHA3ハッシュ関数実装
- E-11: `ext/misc/zipfile.c` - ZIPファイル仮想テーブル実装
- E-12: `ext/misc/README.md` - ext/misc拡張の概要説明

## 3) Claims と根拠の対応（レビューの主戦場）

### UUID拡張（uuid.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-MISC-001) | uuid()関数がRFC-4122形式のUUIDを生成する | E-01: sqlite3UuidFunc関数（行163-177） | ○ |
| C-02 (UT-MISC-002) | バージョンビット'4'が設定される | E-01: aBlob[6]への0x40設定（行173） | ○ |
| C-03 (UT-MISC-003) | バリアントビットが正しく設定される | E-01: aBlob[8]への0x80設定（行174） | ○ |
| C-04 (UT-MISC-004) | uuid_str()が標準形式に正規化する | E-01: sqlite3UuidStrFunc関数（行179-193） | ○ |
| C-05 (UT-MISC-005) | 波括弧付きUUIDを処理する | E-01: sqlite3UuidStrToBlob関数で'{'をスキップ（行123） | ○ |
| C-06 (UT-MISC-006) | ハイフンなしUUIDを処理する | E-01: sqlite3UuidStrToBlob関数でハイフンをスキップ（行125） | ○ |
| C-07 (UT-MISC-007) | 不正文字列でNULLを返す | E-01: sqlite3UuidStrToBlob関数が1を返す場合の処理（行130-131, 149-150） | ○ |
| C-08 (UT-MISC-008) | 桁数不足でNULLを返す | E-01: 16バイト未満で解析失敗（行135） | ○ |
| C-09 (UT-MISC-009) | uuid_blob()が16バイトBLOBを返す | E-01: sqlite3UuidBlobFunc関数（行195-207） | ○ |
| C-10 (UT-MISC-010) | 16バイトBLOB入力をパススルー | E-01: SQLITE_BLOB case（行152-155） | ○ |
| C-11 (UT-MISC-011) | 16バイト以外でNULLを返す | E-01: n==16のチェック（行154） | ○ |

### 正規表現拡張（regexp.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 (UT-MISC-014) | regexp()がパターンマッチを判定 | E-02: re_sql_func関数（行766-809） | ○ |
| C-13 (UT-MISC-015) | マッチしない場合0を返す | E-02: re_match関数の戻り値（行202-348） | ○ |
| C-14 (UT-MISC-016) | regexpi()が大文字小文字無視 | E-02: re_next_char_nocase関数（行177-181） | ○ |
| C-15 (UT-MISC-017) | ^で文字列先頭マッチ | E-02: RE_OP_ATSTART（行99, 256-258） | ○ |
| C-16 (UT-MISC-018) | $で文字列末尾マッチ | E-02: RE_OP_MATCH with RE_EOF（行535-537） | ○ |
| C-17 (UT-MISC-019-022) | 量指定子（*, +, ?, {m,n}）の動作 | E-02: 各演算子の実装（行519-582） | ○ |
| C-18 (UT-MISC-023-024) | 文字クラス[abc]と[^abc] | E-02: RE_OP_CC_INC/RE_OP_CC_EXC（行583-609） | ○ |
| C-19 (UT-MISC-025-027) | \d, \w, \s特殊文字クラス | E-02: re_word_char, re_digit_char, re_space_char（行183-197） | ○ |
| C-20 (UT-MISC-028) | 不正パターンでエラー | E-02: re_compile関数のエラーハンドリング（行668-740） | ○ |
| C-21 (UT-MISC-029) | パターンサイズ制限 | E-02: mxAlloc制限（行355, 549, 558） | ○ |
| C-22 (UT-MISC-030) | UTF-8処理 | E-02: re_next_char関数（行152-176） | ○ |

### SHA1拡張（sha1.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 (UT-MISC-031) | sha1()がテキストのハッシュを返す | E-03: sha1Func関数（行244-271） | ○ |
| C-24 (UT-MISC-032) | sha1()がBLOBのハッシュを返す | E-03: eType==SQLITE_BLOB分岐（行257-258） | ○ |
| C-25 (UT-MISC-033) | NULL入力でNULL返却 | E-03: eType==SQLITE_NULL early return（行255） | ○ |
| C-26 (UT-MISC-034) | sha1b()がバイナリハッシュを返す | E-03: sqlite3_user_data分岐（行262-265） | ○ |
| C-27 (UT-MISC-035) | sha1_query()がクエリハッシュを返す | E-03: sha1QueryFunc関数（行285-385） | ○ |
| C-28 (UT-MISC-036) | 非クエリでエラー | E-03: sqlite3_stmt_readonly チェック（行314-319） | ○ |

### generate_series拡張（series.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 (UT-MISC-037) | generate_series基本動作 | E-04: seriesFilter関数（行430-669） | ○ |
| C-30 (UT-MISC-038) | ステップ指定 | E-04: idxNum & 0x04分岐（行467-472） | ○ |
| C-31 (UT-MISC-039) | 降順生成 | E-04: bDesc処理（行496-502） | ○ |
| C-32 (UT-MISC-040) | 空シリーズ | E-04: series_no_rows ラベル（行662-668） | ○ |
| C-33 (UT-MISC-041) | 必須引数チェック | E-04: bStartSeen チェック（行842-847） | ○ |
| C-34 (UT-MISC-042-043) | LIMIT/OFFSET適用 | E-04: idxNum & 0x20/0x40分岐（行507-512, 644-657） | ○ |

### CSV拡張（csv.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 (UT-MISC-044) | CSVフィールド読み取り | E-05: csv_read_one_field関数（行214-290） | ○ |
| C-36 (UT-MISC-045) | クォート処理 | E-05: c=='"'分岐（行222-259） | ○ |
| C-37 (UT-MISC-046) | エスケープ処理 | E-05: pc=='"' && c=='"'処理（行231-234） | ○ |
| C-38 (UT-MISC-047) | BOMスキップ | E-05: 0xef, 0xbb, 0xbf検出（行263-274） | ○ |
| C-39 (UT-MISC-048-051) | csvtabConnect各種引数 | E-05: csvtabConnect関数（行490-665） | ○ |

### Decimal拡張（decimal.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 (UT-MISC-052) | 浮動小数点の10進展開 | E-06: decimalFromDouble関数（行616-659） | ○ |
| C-41 (UT-MISC-054-056) | decimal_cmp()比較 | E-06: decimal_cmp関数（行366-396） | ○ |
| C-42 (UT-MISC-057) | decimal_add()加算 | E-06: decimal_add関数（行459-522） | ○ |
| C-43 (UT-MISC-058) | decimal_sub()減算 | E-06: decimalSubFunc関数（行735-750） | ○ |
| C-44 (UT-MISC-059) | decimal_mul()乗算 | E-06: decimalMul関数（行532-576） | ○ |
| C-45 (UT-MISC-060) | decimal_sum()集計 | E-06: decimalSumStep/Finalize関数（行757-809） | ○ |

### IEEE754拡張（ieee754.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 (UT-MISC-061-064) | ieee754()関数群 | E-07: ieee754func関数（行102-215） | ○ |
| C-47 (UT-MISC-065) | ieee754_to_blob() | E-07: ieee754func_to_blob関数（行240-260） | ○ |
| C-48 (UT-MISC-066) | ieee754_from_blob() | E-07: ieee754func_from_blob関数（行220-239） | ○ |
| C-49 (UT-MISC-067) | ieee754_inc() | E-07: ieee754inc関数（行275-291） | ○ |

### Base64拡張（base64.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 (UT-MISC-068) | BLOBからBase64変換 | E-08: toBase64関数（行114-148） | ○ |
| C-51 (UT-MISC-069) | Base64からBLOB変換 | E-08: fromBase64関数（行158-206） | ○ |
| C-52 (UT-MISC-070) | 空BLOB処理 | E-08: SQLITE_BLOB case（行219-239） | ○ |
| C-53 (UT-MISC-071) | 不正型でエラー | E-08: default case（行262-264） | ○ |

### ROT13拡張（rot13.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 (UT-MISC-072) | ROT13エンコード | E-09: rot13関数（行24-33） | ○ |
| C-55 (UT-MISC-073) | ROT13可逆性 | E-09: +13後に>zで-26（行27, 30） | ○ |
| C-56 (UT-MISC-074) | 非アルファベット保持 | E-09: if文でa-z, A-Zのみ変換（行25, 28） | ○ |
| C-57 (UT-MISC-075) | NULL処理 | E-09: SQLITE_NULL early return（行54） | ○ |
| C-58 (UT-MISC-076) | rot13照合順序 | E-09: rot13CollFunc関数（行81-94） | ○ |

### SHA3拡張（shathree.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 (UT-MISC-077-080) | sha3()各サイズ | E-10: SHA3Context構造体とiSizeフィールド（行142-151） | ○ |
| C-60 (UT-MISC-081) | sha3_agg()集約 | E-10: README.mdの説明（集約関数実装） | ○ |
| C-61 (UT-MISC-082) | sha3_query()クエリハッシュ | E-10: README.mdの説明（クエリハッシュ実装） | ○ |

### Zipfile拡張（zipfile.c）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 (UT-MISC-083) | ZIP読み取り | E-11: ZIPFILE_SCHEMA定義（行105-115） | ○ |
| C-63 (UT-MISC-084) | カラム取得 | E-11: zipfileColumnの各カラム定義（行106-114） | ○ |
| C-64 (UT-MISC-085) | ZIP書き込み | E-11: xUpdate実装（ソースコード内） | ○ |
| C-65 (UT-MISC-086-087) | deflate/inflate | E-11: zlib.hインクルード（行36） | ○ |

### 根拠未確認項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 (UT-MISC-088) | compress()圧縮 | **ソースコード未確認** | △ |
| C-67 (UT-MISC-089) | uncompress()展開 | **ソースコード未確認** | △ |
| C-68 (UT-MISC-092) | percentile()中央値計算 | **ソースコード未確認** | △ |
| C-69 (UT-MISC-093) | percentile()空入力処理 | **ソースコード未確認** | △ |
| C-70 (UT-MISC-094) | spellfix1類似語検索 | **ソースコード未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- compress.c: 圧縮・展開関数の詳細実装未確認
  - 候補：ext/misc/compress.c / zlib依存の確認
- percentile.c: パーセンタイル計算ロジックの詳細未確認
  - 候補：ext/misc/percentile.c
- spellfix.c: スペルチェック仮想テーブルの詳細未確認
  - 候補：ext/misc/spellfix.c

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UUID, ROT13, Base64など単純な変換関数
- 1: 中リスク - 正規表現、CSV解析など複雑なパーサー
- 2: 高リスク - zipfile, spellfix1など外部ライブラリ依存または複雑なロジック

## 6) レビュアーチェックリスト（最小）
- [ ] UUID生成関数のランダム性がセキュリティ要件を満たすか確認
- [ ] 正規表現の複雑度制限（mxAlloc）が適切か確認
- [ ] CSVパーサーが大きなファイルで正しく動作するか確認
- [ ] Decimal演算のオーバーフロー処理を確認
- [ ] IEEE754変換の境界値処理（NaN, Infinity）を確認
- [ ] compress.c, percentile.c, spellfix.cのソースコードを確認して根拠を補完
