---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 160
  claims_with_evidence: 158
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：ext-qrf 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成されたext-qrfモジュールの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：158 / 160、根拠なし：2
- 優先レビュー（高）
  1. **UT-QRF-158/159**: SQLITE_ENABLE_STMT_SCANSTATUSコンパイルオプションが必要
  2. **UT-QRF-160**: bytecode仮想テーブルのコンパイルオプション依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/sqlite-master/ext/qrf/qrf.c` - QRFモジュールの実装コード
- E-02: `/Users/tomoka.baba/Work/sqlite-master/ext/qrf/qrf.h` - QRFモジュールのヘッダーファイル（API定義）
- E-03: `/Users/tomoka.baba/Work/sqlite-master/ext/qrf/README.md` - QRFモジュールのドキュメント
- E-04: `/Users/tomoka.baba/Work/sqlite-master/ext/qrf/dev-notes.md` - 開発メモ
- E-05: `/Users/tomoka.baba/Work/sqlite-master/test/qrf01.test` - テストファイル（存在確認済み）
- E-06: `/Users/tomoka.baba/Work/sqlite-master/test/qrf02.test` - テストファイル（存在確認済み）
- E-07: `/Users/tomoka.baba/Work/sqlite-master/test/qrf03.test` - テストファイル（存在確認済み）
- E-08: `/Users/tomoka.baba/Work/sqlite-master/test/qrf04.test` - テストファイル（存在確認済み）
- E-09: `/Users/tomoka.baba/Work/sqlite-master/test/qrf05.test` - テストファイル（存在確認済み）
- E-10: `/Users/tomoka.baba/Work/sqlite-master/test/qrf06.test` - テストファイル（存在確認済み）

## 3) Claims と根拠の対応（レビューの主戦場）

### 主要インターフェース関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3_format_query_result()はpStmt=NULLでSQLITE_OKを返す | E-01 (L2864) | ○ |
| C-02 | pSpec=NULLでSQLITE_MISUSEを返す | E-01 (L2865) | ○ |
| C-03 | iVersion!=1でSQLITE_ERRORを返す | E-01 (L2624-2628) | ○ |
| C-04-C-20 | 各出力スタイル（Box/Csv/Json等）の動作 | E-01, E-02 (スタイル定義), E-03 (仕様) | ○ |

### Unicode幅計算関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | sqlite3_qrf_wcwidth()はASCII文字で1を返す | E-01 (L490-494) | ○ |
| C-22 | ゼロ幅文字で0を返す | E-01 (L415-478 aQrfUWidth配列) | ○ |
| C-23 | 全角文字で2を返す | E-01 (L415-478 aQrfUWidth配列) | ○ |
| C-24-C-25 | 境界値テスト | E-01 (L494 高速パス条件) | ○ |
| C-26-C-30 | sqlite3_qrf_wcswidth()の各テスト | E-01 (L571-593) | ○ |

### UTF-8デコード関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | 2バイトUTF-8デコード | E-01 (L522-524) | ○ |
| C-32 | 3バイトUTF-8デコード | E-01 (L526-528) | ○ |
| C-33 | 4バイトUTF-8デコード | E-01 (L530-536) | ○ |
| C-34 | 不正シーケンス処理 | E-01 (L537-538) | ○ |

### VT100エスケープ検出

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35-C-38 | qrfIsVt100()の動作 | E-01 (L548-556) | ○ |

### テキストエンコーディング

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39-C-43 | qrfEscape()の制御文字エスケープ | E-01 (L660-724) | ○ |
| C-44-C-51 | qrfEncodeText()の各エンコーディング | E-01 (L793-891) | ○ |
| C-52-C-58 | qrfRelaxable()の判定ロジック | E-01 (L737-765) | ○ |

### JSONB処理

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59-C-61 | qrfJsonbQuickCheck()の検証 | E-01 (L899-913) | ○ |
| C-62-C-63 | qrfJsonbToJson()の変換 | E-01 (L926-959) | ○ |

### 値レンダリング

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64-C-66 | qrfTitleLimit()のタイトル制限 | E-01 (L970-1005) | ○ |
| C-67-C-75 | qrfRenderValue()の型別レンダリング | E-01 (L1011-1168) | ○ |
| C-76-C-78 | qrfWidthPrint()の幅指定印刷 | E-01 (L1187-1231) | ○ |

### 行ラップと表示幅

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79-C-83 | qrfWrapLine()の行分割ロジック | E-01 (L1244-1333) | ○ |
| C-84-C-86 | qrfDisplayWidth()の表示幅計算 | E-01 (L606-643) | ○ |
| C-87-C-90 | qrfPrintAligned()の配置印刷 | E-01 (L1432-1454) | ○ |

### カラム形式出力

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91-C-100 | qrfColumnar()の各設定動作 | E-01 (L1847-2195) | ○ |
| C-101-C-102 | qrfSplitColumn()の列分割 | E-01 (L1680-1765) | ○ |
| C-103-C-104 | qrfRestrictScreenWidth()の画面幅制限 | E-01 (L1770-1840) | ○ |
| C-105-C-107 | qrfLoadAlignment()の配置ロード | E-01 (L1610-1627) | ○ |
| C-108-C-111 | セパレータ出力関数 | E-01 (L1505-1605) | ○ |

### EQP/EXPLAIN処理

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112-C-118 | EQPグラフ関連関数 | E-01 (L157-255) | ○ |
| C-119-C-120 | qrfExplain()のインデント付き出力 | E-01 (L2236-2366) | ○ |
| C-121-C-123 | qrfStringInArray()の配列検索 | E-01 (L2204-2211) | ○ |

### 識別子引用符判定

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124-C-128 | qrf_need_quote()の判定 | E-01 (L2413-2422) | ○ |

### 行出力

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129-C-130 | JSON/シンプル行出力 | E-01 (L2429-2610) | ○ |

### 初期化と終了処理

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131-C-140 | qrfInitialize()/qrfFinalize()の動作 | E-01 (L2615-2849) | ○ |
| C-141-C-149 | エラー処理/リセット/書き込み関数 | E-01 (L117-407) | ○ |

### ユーティリティ関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-150-C-157 | 各種ユーティリティ関数 | E-01 (該当箇所) | ○ |

### コンパイルオプション依存

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-158 | qrfEqpStats()のスキャンステータス出力 | E-01 (L294, SQLITE_ENABLE_STMT_SCANSTATUS) | △ |
| C-159 | StatsEst形式のrpl/est出力 | E-01 (L358-360) | △ |
| C-160 | qrfScanStatusVm()のVM統計出力 | E-01 (L2376-2402, bytecode仮想テーブル依存) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-158/C-159**: `SQLITE_ENABLE_STMT_SCANSTATUS`コンパイルオプションが有効な場合のみテスト可能。通常ビルドでは該当コードがコンパイルされない可能性がある。
  - 候補：コンパイルオプションを有効にしたテストビルド / 条件付きテストスキップの実装
- **C-160**: `SQLITE_ENABLE_BYTECODE_VTAB`コンパイルオプションが必要。bytecode()仮想テーブルが利用可能な環境でのみテスト可能。
  - 候補：コンパイルオプションを有効にしたテストビルド / 条件付きテストスキップの実装

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードから直接導出されており、信頼性が高い
- **1（中リスク）**: C-158/C-159/C-160はコンパイルオプション依存であり、テスト環境によっては実行できない可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] sqlite3_format_query_result()のNULL/不正入力テスト（C-01〜C-03）が実装可能か確認
- [ ] Unicode幅計算（sqlite3_qrf_wcwidth, sqlite3_qrf_wcswidth）のテストデータが適切か確認
- [ ] UTF-8デコードテストが多バイト文字を適切にカバーしているか確認
- [ ] 各出力スタイル（Box/Csv/Json等）のテストが網羅的か確認
- [ ] SQLITE_ENABLE_STMT_SCANSTATUS/SQLITE_ENABLE_BYTECODE_VTABが必要なテストの扱いを決定
- [ ] 既存テストファイル（qrf01.test〜qrf06.test）との整合性を確認
