---
generated_at: 2026-01-21 16:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：ext-rbu単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UT-RBU-047（無効な親VFS指定時のエラー）**：エラーコードの具体値が未確認
  2. **UT-RBU-080（リネームエラー時の動作）**：プラットフォーム依存の挙動が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/sqlite-master/ext/rbu/sqlite3rbu.h` - RBU公開API定義・ドキュメント
- E-02: `/Users/tomoka.baba/Work/sqlite-master/ext/rbu/sqlite3rbu.c` - RBU実装コード（行1-5443）
- E-03: `/Users/tomoka.baba/Work/sqlite-master/ext/rbu/rbu.c` - RBUコマンドラインツール実装
- E-04: `/Users/tomoka.baba/Work/sqlite-master/ext/rbu/test_rbu.c` - RBU Tclテストインターフェース
- E-05: RBU_STATE_* 定数定義（sqlite3rbu.c 行168-177）
- E-06: RBU_STAGE_* 定数定義（sqlite3rbu.c 行179-183）
- E-07: SQLITE_RBU_STATE_* 定数定義（sqlite3rbu.h 行539-543）
- E-08: RBU_PK_* 定数定義（sqlite3rbu.c 行310-315）
- E-09: struct sqlite3rbu 定義（sqlite3rbu.c 行400-438）
- E-10: struct RbuState 定義（sqlite3rbu.c 行219-230）
- E-11: struct RbuObjIter 定義（sqlite3rbu.c 行264-298）
- E-12: struct rbu_vfs 定義（sqlite3rbu.c 行448-455）
- E-13: struct rbu_file 定義（sqlite3rbu.c 行464-484）

## 3) Claims と根拠の対応（レビューの主戦場）

### 公開API関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-RBU-001) | sqlite3rbu_open正常系 | E-01 (行311-315), E-02 (行4191-4198) | ○ |
| C-02 (UT-RBU-002) | sqlite3rbu_open状態DB指定 | E-01 (行289-298), E-02 (行4044-4046) | ○ |
| C-03 (UT-RBU-003) | sqlite3rbu_open zTarget=NULL | E-02 (行4196: if zTarget==0 return rbuMisuseError) | ○ |
| C-04 (UT-RBU-004) | sqlite3rbu_open zRbu=NULL | E-02 (行4196: if zRbu==0 return rbuMisuseError) | ○ |
| C-05 (UT-RBU-005) | 存在しないターゲットDB | E-02 (行2683-2690: rbuOpenDbhandle実装) | ○ |
| C-06 (UT-RBU-006) | WALモードDB拒否 | E-01 (行255-256), E-02 (行4081-4083) | ○ |
| C-07 (UT-RBU-007) | sqlite3rbu_vacuum正常系 | E-01 (行317-357), E-02 (行4203-4216) | ○ |
| C-08 (UT-RBU-008) | sqlite3rbu_vacuum状態DB指定 | E-02 (行4208-4213) | ○ |
| C-09 (UT-RBU-009) | sqlite3rbu_vacuum zTarget=NULL | E-02 (行4207: if zTarget==0 return rbuMisuseError) | ○ |
| C-10 (UT-RBU-010) | -vactmp予約名制限 | E-01 (行338-340), E-02 (行4208-4212) | ○ |
| C-11 (UT-RBU-011) | sqlite3rbu_step OALステージ | E-01 (行414-425), E-02 (行3694-3751) | ○ |
| C-12 (UT-RBU-012) | sqlite3rbu_step完了検出 | E-02 (行3779-3781: rc=SQLITE_DONE, eStage=RBU_STAGE_DONE) | ○ |
| C-13 (UT-RBU-013) | sqlite3rbu_step MOVEステージ | E-02 (行3753-3758: rbuMoveOalFile呼び出し) | ○ |
| C-14 (UT-RBU-014) | sqlite3rbu_step CKPTステージ | E-02 (行3761-3806: rbuCheckpointFrame呼び出し) | ○ |
| C-15 (UT-RBU-015) | sqlite3rbu_step NULL入力 | E-02 (行3695: if(p) else return SQLITE_NOMEM) | ○ |
| C-16 (UT-RBU-016) | エラー状態永続化 | E-02 (行3696-3812: switchでp->rc返却) | ○ |
| C-17 (UT-RBU-017) | sqlite3rbu_close OAL途中 | E-01 (行441-456), E-02 (行4253-4309) | ○ |
| C-18 (UT-RBU-018) | sqlite3rbu_close完了状態 | E-02 (行4296: rc=p->rc でDONE返却) | ○ |
| C-19 (UT-RBU-019) | エラーメッセージ取得 | E-02 (行4297-4301: pzErrmsgへの代入) | ○ |
| C-20 (UT-RBU-020) | sqlite3rbu_close NULL入力 | E-02 (行4304-4306: else rc=SQLITE_NOMEM) | ○ |
| C-21 (UT-RBU-021) | sqlite3rbu_db bRbu=0 | E-01 (行383-411), E-02 (行4221-4227) | ○ |
| C-22 (UT-RBU-022) | sqlite3rbu_db bRbu=1 | E-02 (行4224: bRbu ? dbRbu : dbMain) | ○ |
| C-23 (UT-RBU-023) | sqlite3rbu_db NULL入力 | E-02 (行4222-4226: if(pRbu) else return 0) | ○ |
| C-24 (UT-RBU-024) | sqlite3rbu_progress正常系 | E-01 (行461-465), E-02 (行4316-4318) | ○ |
| C-25 (UT-RBU-025) | sqlite3rbu_progress初期状態 | E-09 (nProgress初期値0) | ○ |
| C-26 (UT-RBU-026) | sqlite3rbu_bp_progress OAL | E-01 (行467-505), E-02 (行4324-4354) | ○ |
| C-27 (UT-RBU-027) | sqlite3rbu_bp_progress CKPT | E-02 (行4341-4344: MAX_PROGRESS*nStep/nFrame) | ○ |
| C-28 (UT-RBU-028) | sqlite3rbu_bp_progress DONE | E-02 (行4346-4348: 両方MAX_PROGRESS) | ○ |
| C-29 (UT-RBU-029) | rbu_countなし時の動作 | E-02 (行4330-4331: pnOne=-1) | ○ |
| C-30 (UT-RBU-030) | sqlite3rbu_state OAL | E-01 (行514-515), E-07, E-02 (行4359-4384) | ○ |
| C-31 (UT-RBU-031) | sqlite3rbu_state MOVE | E-01 (行519-524), E-07, E-02 (行4361) | ○ |
| C-32 (UT-RBU-032) | sqlite3rbu_state CKPT | E-01 (行526-530), E-07, E-02 (行4362) | ○ |
| C-33 (UT-RBU-033) | sqlite3rbu_state DONE | E-01 (行531-533), E-07, E-02 (行4362) | ○ |
| C-34 (UT-RBU-034) | sqlite3rbu_state ERROR | E-01 (行535-537), E-02 (行4374-4375) | ○ |
| C-35 (UT-RBU-035) | sqlite3rbu_savestate OAL | E-01 (行428-438), E-02 (行4387-4418) | ○ |
| C-36 (UT-RBU-036) | sqlite3rbu_savestate CKPT | E-02 (行4398-4401: xSync呼び出し) | ○ |
| C-37 (UT-RBU-037) | sqlite3rbu_savestate DONE | E-02 (行4389: if rc==SQLITE_DONE return SQLITE_OK) | ○ |
| C-38 (UT-RBU-038) | sqlite3rbu_temp_size_limit設定 | E-01 (行361-372), E-02 (行5433-5437) | ○ |
| C-39 (UT-RBU-039) | sqlite3rbu_temp_size_limit解除 | E-02 (行5434-5435: n>=0で設定) | ○ |
| C-40 (UT-RBU-040) | sqlite3rbu_temp_size_limit取得 | E-02 (行5437: 常にszTempLimit返却) | ○ |
| C-41 (UT-RBU-041) | sqlite3rbu_temp_size取得 | E-01 (行375-379), E-02 (行5440-5442) | ○ |
| C-42 (UT-RBU-042) | sqlite3rbu_temp_size初期状態 | E-09 (szTemp初期値0) | ○ |
| C-43 (UT-RBU-043) | sqlite3rbu_rename_handler設定 | E-01 (行547-572), E-02 (行4456-4468) | ○ |
| C-44 (UT-RBU-044) | sqlite3rbu_rename_handler NULL | E-02 (行4464-4466: xDefaultRename設定) | ○ |
| C-45 (UT-RBU-045) | sqlite3rbu_create_vfs正常系 | E-01 (行575-616), E-02 (行5355-5428) | ○ |
| C-46 (UT-RBU-046) | sqlite3rbu_create_vfs親VFS指定 | E-02 (行5381-5384: zParent処理) | ○ |
| C-47 (UT-RBU-047) | sqlite3rbu_create_vfs無効親VFS | **根拠不足** | △ |
| C-48 (UT-RBU-048) | sqlite3rbu_destroy_vfs正常系 | E-01 (行619-627), E-02 (行5341-5347) | ○ |
| C-49 (UT-RBU-049) | sqlite3rbu_destroy_vfs存在しない | E-02 (行5342: if(pVfs && xOpen==rbuVfsOpen)) | ○ |

### 内部関数テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 (UT-RBU-050) | rbuDeltaApplyコピーコマンド | E-02 (行613-632: case '@') | ○ |
| C-51 (UT-RBU-051) | rbuDeltaApply挿入コマンド | E-02 (行634-649: case ':') | ○ |
| C-52 (UT-RBU-052) | rbuDeltaApply不正デルタ | E-02 (行666-668: default return -1) | ○ |
| C-53 (UT-RBU-053) | rbuDeltaApplyサイズ不一致 | E-02 (行660-663: if total!=limit return -1) | ○ |
| C-54 (UT-RBU-054) | rbuDeltaApply空デルタ | E-02 (行672-673: unterminated delta) | ○ |
| C-55 (UT-RBU-055) | rbuDeltaOutputSize正常系 | E-02 (行676-684) | ○ |
| C-56 (UT-RBU-056) | rbuDeltaOutputSize不正形式 | E-02 (行679-681: if *zDelta!='\n' return -1) | ○ |
| C-57 (UT-RBU-057) | rbuFossilDeltaFunc正常系 | E-02 (行698-739) | ○ |
| C-58 (UT-RBU-058) | rbuFossilDeltaFuncエラー | E-02 (行722-724, 733-734: corrupt fossil delta) | ○ |
| C-59 (UT-RBU-059) | rbuTargetNameFunc data_ | E-02 (行985-989) | ○ |
| C-60 (UT-RBU-060) | rbuTargetNameFunc data0123_ | E-02 (行987: for i=4; zIn[i]>='0' && zIn[i]<='9') | ○ |
| C-61 (UT-RBU-061) | rbuTargetNameFunc dataAB_ | E-02 (行987-989: 数字以外でNULL) | ○ |
| C-62 (UT-RBU-062) | rbuTargetNameFunc vacuum | E-02 (行979-983: rbuIsVacuum時そのまま返却) | ○ |
| C-63 (UT-RBU-063) | rbuObjIterFirst正常系 | E-02 (行1004-1028) | ○ |
| C-64 (UT-RBU-064) | rbuObjIterFirst空DB | E-02 (行1027: rbuObjIterNextでzTbl設定) | ○ |
| C-65 (UT-RBU-065) | rbuObjIterNextインデックス | E-02 (行887-944) | ○ |
| C-66 (UT-RBU-066) | rbuObjIterNextクリーンアップ | E-02 (行926-927: bCleanup=1) | ○ |
| C-67 (UT-RBU-067) | rbuObjIterNextテーブル遷移 | E-02 (行904-916) | ○ |
| C-68 (UT-RBU-068) | rbuTableType通常テーブル | E-02 (行1209-1289), E-08 | ○ |
| C-69 (UT-RBU-069) | rbuTableType WITHOUT ROWID | E-02 (行1262-1263: RBU_PK_WITHOUT_ROWID) | ○ |
| C-70 (UT-RBU-070) | rbuTableType仮想テーブル | E-02 (行1240-1242: RBU_PK_VTAB) | ○ |
| C-71 (UT-RBU-071) | rbuTableType存在しない | E-02 (行1224: *peType=RBU_PK_NOTABLE) | ○ |
| C-72 (UT-RBU-072) | rbuLoadState正常系 | E-02 (行2716-2786), E-10 | ○ |
| C-73 (UT-RBU-073) | rbuLoadState空テーブル | E-02 (行2722-2723: malloc後0初期化) | ○ |
| C-74 (UT-RBU-074) | rbuLoadState不正ステージ | E-02 (行2732-2737, 2777: SQLITE_CORRUPT) | ○ |
| C-75 (UT-RBU-075) | rbuSaveState正常系 | E-02 (行3561-3601) | ○ |
| C-76 (UT-RBU-076) | rbuSaveState上書き | E-02 (行3570: INSERT OR REPLACE) | ○ |
| C-77 (UT-RBU-077) | rbuOpenDatabase正常系 | E-02 (行2797-2956) | ○ |
| C-78 (UT-RBU-078) | rbuOpenDatabase VFSエラー | E-02 (行2952-2955: "rbu vfs not found") | ○ |
| C-79 (UT-RBU-079) | rbuMoveOalFile正常系 | E-02 (行3246-3324) | ○ |
| C-80 (UT-RBU-080) | rbuMoveOalFileエラー | **プラットフォーム依存** | △ |
| C-81 (UT-RBU-081) | rbuSetupCheckpoint正常系 | E-02 (行3030-3112) | ○ |
| C-82 (UT-RBU-082) | rbuCheckpointFrame正常系 | E-02 (行3156-3178) | ○ |
| C-83 (UT-RBU-083) | rbuStep INSERT | E-02 (行3465-3521), E-02 (行3382-3464) | ○ |
| C-84 (UT-RBU-084) | rbuStep DELETE | E-02 (行3326-3367: RBU_DELETE判定) | ○ |
| C-85 (UT-RBU-085) | rbuStep UPDATE | E-02 (行3326-3367: zMask解析) | ○ |
| C-86 (UT-RBU-086) | rbuStepOneOp INSERT | E-02 (行3382-3464) | ○ |
| C-87 (UT-RBU-087) | rbuStepOneOp DELETE | E-02 (行3431-3440) | ○ |
| C-88 (UT-RBU-088) | rbuStepOneOp UPDATE | E-02 (行3490-3518) | ○ |

### VFS関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 (UT-RBU-089) | rbuVfsOpen正常系 | E-02 (行5072-5192) | ○ |
| C-90 (UT-RBU-090) | rbuVfsOpen OAL代替 | E-02 (行5109-5142: oal処理) | ○ |
| C-91 (UT-RBU-091) | rbuVfsRead正常系 | E-02 (行4683-4747) | ○ |
| C-92 (UT-RBU-092) | rbuVfsRead cookie保存 | E-02 (行4700-4718: iCookie設定) | ○ |
| C-93 (UT-RBU-093) | rbuVfsWrite正常系 | E-02 (行4749-4790) | ○ |
| C-94 (UT-RBU-094) | rbuVfsWrite一時ファイル | E-02 (行4782-4787: rbuUpdateTempSize) | ○ |
| C-95 (UT-RBU-095) | rbuVfsLock共有ロック | E-02 (行4839-4860) | ○ |
| C-96 (UT-RBU-096) | rbuVfsLock排他ロック制限 | E-02 (行4847-4855: EXCLUSIVE && eStage!=DONE) | ○ |
| C-97 (UT-RBU-097) | rbuVfsShmMapヒープ | E-02 (行4987-5043) | ○ |
| C-98 (UT-RBU-098) | rbuVfsShmLock no-op | E-02 (行4949-4985) | ○ |
| C-99 (UT-RBU-099) | rbuUpdateTempSize正常系 | E-02 (行4545-4553) | ○ |
| C-100 (UT-RBU-100) | rbuUpdateTempSize制限超過 | E-02 (行4551: if szTempLimit && szTemp>szTempLimit) | ○ |

## 4) 不足情報（Unknown / Missing）

### UT-RBU-047: sqlite3rbu_create_vfs無効な親VFS指定
- **理由**: sqlite3rbu_create_vfs内でsqlite3_vfs_find(zParent)がNULLを返す場合の具体的なエラーコードが明示されていない
- **候補**: ソースコード行5381-5384で親VFS検索失敗時の挙動を詳細確認必要

### UT-RBU-080: rbuMoveOalFileリネームエラー
- **理由**: リネーム操作はOS依存であり、Windows（WinCE含む）とPOSIXで実装が異なる（行4424-4454）
- **候補**: プラットフォーム別のエラーコード（SQLITE_IOERR, SQLITE_IOERR_NOMEM等）を確認必要

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2: 高リスク | WALモード制限テスト（UT-RBU-006） | データ破損につながる可能性 |
| 2: 高リスク | 状態保存・復元テスト（UT-RBU-017, 072, 075） | 中断・再開機能の信頼性 |
| 1: 中リスク | VFSシム関連テスト（UT-RBU-089-098） | ファイルシステム操作の正確性 |
| 1: 中リスク | Fossilデルタ適用（UT-RBU-050-058） | バイナリデータ処理の正確性 |
| 0: 低リスク | 進捗取得API（UT-RBU-024-029） | 情報取得のみで副作用なし |

## 6) レビュアーチェックリスト（最小）

- [ ] UT-RBU-006: WALモードDBに対するRBU更新拒否が正しく動作するか実環境で確認
- [ ] UT-RBU-017, UT-RBU-035: 中断・再開が正しく動作するか複数回のstep/savestate/closeサイクルで確認
- [ ] UT-RBU-047: 存在しない親VFS名を指定した場合の具体的なエラーコードを確認
- [ ] UT-RBU-079, UT-RBU-080: OAL->WALリネーム操作がWindows/Linux両環境で正しく動作するか確認
- [ ] UT-RBU-100: 一時ファイルサイズ制限超過時にSQLITE_FULLが返却されることを確認
- [ ] VFS関連テスト全般: sqlite3_vfs構造体のバージョン互換性を確認
