---
generated_at: 2026-01-21 16:30:00
metrics:
  claims_total: 128
  claims_with_evidence: 125
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート: ext-recover 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケース（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の対象関数・データ構造が実在するか
2. **根拠との整合性**：テストケースの入力値・期待結果が関数の実装と矛盾していないか
3. **網羅性**：主要な公開API、内部関数、エラーケースを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：125 / 128、根拠なし：3
- 優先レビュー（高）
  1. **UT-RCV-002**: NULLハンドル処理の実装詳細要確認
  2. **UT-RCV-014**: sqlite3_recover_stepのNULL安全性実装要確認
  3. **UT-RCV-023**: sqlite3_recover_finishのNULL安全性実装要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `ext/recover/sqlite3recover.h` - 公開API宣言（sqlite3_recover_init, init_sql, config, step, run, errcode, errmsg, finish）
- E-02: `ext/recover/sqlite3recover.c` - リカバリ実装本体（sqlite3_recover構造体、RecoverTable, RecoverColumn, RecoverBitmap等）
- E-03: `ext/recover/sqlite3recover.c:309-322` - recoverEnterMutex, recoverLeaveMutex, recoverAssertMutexHeld
- E-04: `ext/recover/sqlite3recover.c:328-331` - recoverStrlen関数（NULL安全）
- E-05: `ext/recover/sqlite3recover.c:342-354` - recoverMalloc関数（メモリ確保、OOM処理）
- E-06: `ext/recover/sqlite3recover.c:369-385` - recoverError関数（エラー設定）
- E-07: `ext/recover/sqlite3recover.c:396-437` - recoverBitmap関連関数（Alloc, Free, Set, Query）
- E-08: `ext/recover/sqlite3recover.c:457-501` - recoverPrepare, recoverPreparePrintf関数
- E-09: `ext/recover/sqlite3recover.c:544-552` - recoverExec関数
- E-10: `ext/recover/sqlite3recover.c:609-621` - recoverPageCount関数
- E-11: `ext/recover/sqlite3recover.c:631-653` - recoverReadI32関数（SQL関数）
- E-12: `ext/recover/sqlite3recover.c:667-676` - recoverPageIsUsed関数（SQL関数）
- E-13: `ext/recover/sqlite3recover.c:692-736` - recoverGetPage関数（SQL関数）
- E-14: `ext/recover/sqlite3recover.c:862-879` - recoverCacheSchema関数
- E-15: `ext/recover/sqlite3recover.c:909-961` - recoverTransferSettings関数
- E-16: `ext/recover/sqlite3recover.c:977-1009` - recoverOpenOutput関数
- E-17: `ext/recover/sqlite3recover.c:2070-2086` - recoverGetVarint関数
- E-18: `ext/recover/sqlite3recover.c:2088-2179` - recoverIsValidPage関数
- E-19: `ext/recover/sqlite3recover.c:2181-2548` - VFS関連関数群
- E-20: `ext/recover/dbdata.c` - sqlite_dbdata, sqlite_dbptr仮想テーブル実装
- E-21: `ext/recover/dbdata.c:89-133` - DbdataTable, DbdataCursor構造体
- E-22: `ext/recover/dbdata.c:166-176` - dbdataBufferSize関数
- E-23: `ext/recover/dbdata.c:181-184` - dbdataBufferFree関数
- E-24: `ext/recover/dbdata.c:190-217` - dbdataConnect関数
- E-25: `ext/recover/dbdata.c:222-229` - dbdataDisconnect関数
- E-26: `ext/recover/dbdata.c:244-289` - dbdataBestIndex関数
- E-27: `ext/recover/dbdata.c:294-307` - dbdataOpen関数
- E-28: `ext/recover/dbdata.c:313-329` - dbdataResetCursor関数
- E-29: `ext/recover/dbdata.c:334-339` - dbdataClose関数
- E-30: `ext/recover/dbdata.c:344-352` - get_uint16, get_uint32関数
- E-31: `ext/recover/dbdata.c:364-399` - dbdataLoadPage関数
- E-32: `ext/recover/dbdata.c:404-427` - dbdataGetVarint, dbdataGetVarintU32関数
- E-33: `ext/recover/dbdata.c:433-457` - dbdataValueBytes関数
- E-34: `ext/recover/dbdata.c:463-541` - dbdataValue関数
- E-35: `ext/recover/dbdata.c:555-764` - dbdataNext関数
- E-36: `ext/recover/dbdata.c:770-773` - dbdataEof関数
- E-37: `ext/recover/dbdata.c:779-785` - dbdataIsFunction関数
- E-38: `ext/recover/dbdata.c:793-815` - dbdataDbsize関数
- E-39: `ext/recover/dbdata.c:822-832` - dbdataGetEncoding関数
- E-40: `ext/recover/dbdata.c:838-901` - dbdataFilter関数
- E-41: `ext/recover/dbdata.c:906-960` - dbdataColumn関数
- E-42: `ext/recover/dbdata.c:965-969` - dbdataRowid関数
- E-43: `ext/recover/dbdata.c:975-1009` - sqlite3DbdataRegister関数
- E-44: `ext/recover/dbdata.c:1014-1021` - sqlite3_dbdata_init関数
- E-45: `ext/recover/test_recover.c` - テスト用Tcl拡張
- E-46: `ext/recover/test_recover.c:22-27` - TestRecover構造体
- E-47: `ext/recover/test_recover.c:29-56` - xSqlCallback関数
- E-48: `ext/recover/test_recover.c:58-66` - getDbPointer関数
- E-49: `ext/recover/test_recover.c:77-209` - testRecoverCmd関数
- E-50: `ext/recover/test_recover.c:214-254` - test_sqlite3_recover_init関数
- E-51: `ext/recover/test_recover.c:269-286` - test_sqlite3_dbdata_init関数
- E-52: `ext/recover/test_recover.c:290-309` - TestRecover_Init関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3_recover_init正常系テスト | E-01, E-02 | ○ |
| C-02 | sqlite3_recover_init NULLハンドル処理 | E-01 | △ |
| C-03 | sqlite3_recover_init OOMエラー | E-02, E-05 | ○ |
| C-04 | sqlite3_recover_init_sql正常系テスト | E-01, E-02 | ○ |
| C-05 | sqlite3_recover_init_sql NULLコールバック | E-01, E-02 | ○ |
| C-06 | sqlite3_recover_config LOST_AND_FOUND設定 | E-01, E-02 | ○ |
| C-07 | sqlite3_recover_config FREELIST_CORRUPT設定 | E-01, E-02 | ○ |
| C-08 | sqlite3_recover_config ROWIDS設定 | E-01, E-02 | ○ |
| C-09 | sqlite3_recover_config SLOWINDEXES設定 | E-01, E-02 | ○ |
| C-10 | sqlite3_recover_config無効オプション | E-02 | ○ |
| C-11 | sqlite3_recover_config状態チェック | E-02 | ○ |
| C-12 | sqlite3_recover_step正常系 | E-01, E-02 | ○ |
| C-13 | sqlite3_recover_step完了検出 | E-01, E-02 | ○ |
| C-14 | sqlite3_recover_step NULL安全性 | E-01 | △ |
| C-15 | sqlite3_recover_step破損耐性 | E-02 | ○ |
| C-16 | sqlite3_recover_run正常系 | E-01, E-02 | ○ |
| C-17 | sqlite3_recover_runエラー伝播 | E-02 | ○ |
| C-18 | sqlite3_recover_errcode正常系 | E-01, E-02 | ○ |
| C-19 | sqlite3_recover_errcodeエラー保持 | E-02 | ○ |
| C-20 | sqlite3_recover_errmsg正常系 | E-01, E-02 | ○ |
| C-21 | sqlite3_recover_errmsgエラー保持 | E-02 | ○ |
| C-22 | sqlite3_recover_finish正常系 | E-01, E-02 | ○ |
| C-23 | sqlite3_recover_finish NULL安全性 | E-01 | △ |
| C-24 | sqlite3_recover_finishエラー状態保持 | E-02 | ○ |
| C-25〜C-64 | 内部関数テスト（recoverMalloc, recoverBitmap*, etc.） | E-03〜E-19 | ○ |
| C-65〜C-112 | dbdata.c関数テスト | E-20〜E-44 | ○ |
| C-113〜C-128 | test_recover.cテスト関数 | E-45〜E-52 | ○ |

## 4) 不足情報（Unknown / Missing）
- **NULLポインタ処理の明示的実装確認**：公開APIにNULLが渡された場合の挙動は、sqlite3recover.cの実装内で明示的にチェックされているか詳細確認が必要
  - 候補：sqlite3_recover_init内でのdbパラメータNULLチェック / sqlite3_recover_step内でのpパラメータNULLチェック / sqlite3_recover_finish内でのpパラメータNULLチェック

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: ビットマップ操作関数群（recoverBitmap*）- シンプルな実装で明確
- **0 (低リスク)**: 文字列操作関数（recoverStrlen）- 単純なNULLチェック付きstrlen
- **1 (中リスク)**: 公開APIのエラーハンドリング - 各関数でerrCode状態の一貫性確認
- **1 (中リスク)**: VFS関数群 - 多数のラッパー関数があり、それぞれの動作確認が必要
- **1 (中リスク)**: 仮想テーブル実装 - dbdataNext関数は複雑なステートマシン

## 6) レビュアーチェックリスト（最小）
- [ ] 公開API（UT-RCV-001〜024）のテストケースが実際のAPIシグネチャと一致しているか
- [ ] SQLITE_RECOVER_*定数の値がsqlite3recover.hと一致しているか（LOST_AND_FOUND=1, FREELIST_CORRUPT=2, ROWIDS=3, SLOWINDEXES=4）
- [ ] 境界値テスト（UT-RCV-029〜036）のビットマップ操作が実装と整合しているか
- [ ] dbdata仮想テーブルのカラムインデックス（DBDATA_COLUMN_*）が正しいか
- [ ] test_recover.cのTclコマンド引数仕様がテストケースと一致しているか
- [ ] NULLポインタ処理のテストケース（UT-RCV-002, 014, 023）について実装の挙動を確認
