---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：ext-repair 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-REP-091〜095（Tclスクリプト関連）**：Tclの内部動作詳細の根拠が間接的
  2. **UT-REP-085〜090（sqlite3_checker.c.in関連）**：Tcl統合部分の詳細仕様
  3. **OOMテスト（UT-REP-011, 061）**：メモリ不足状態の再現方法が明確でない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/sqlite-master/ext/repair/checkfreelist.c` - フリーリストチェック機能のソースコード
- E-02: `/Users/tomoka.baba/Work/sqlite-master/ext/repair/checkindex.c` - インデックスチェック機能のソースコード
- E-03: `/Users/tomoka.baba/Work/sqlite-master/ext/repair/sqlite3_checker.c.in` - Tcl統合のメインファイル
- E-04: `/Users/tomoka.baba/Work/sqlite-master/ext/repair/sqlite3_checker.tcl` - Tclスクリプト（チェッカーユーティリティ）
- E-05: `/Users/tomoka.baba/Work/sqlite-master/ext/repair/README.md` - モジュール概要説明
- E-06: `/Users/tomoka.baba/Work/sqlite-master/ext/repair/test/checkfreelist01.test` - フリーリストチェックのテストケース
- E-07: `/Users/tomoka.baba/Work/sqlite-master/ext/repair/test/checkindex01.test` - インデックスチェックのテストケース

## 3) Claims と根拠の対応（レビューの主戦場）

### checkfreelist.c 関連（UT-REP-001〜021）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3_check_freelist関数がSQLITE_OKを返す | E-01 (L222-224), E-06 | ○ |
| C-02 | 空のフリーリストでもチェック成功 | E-06 (L5-10) | ○ |
| C-03 | zDbがNULLの場合"main"が使用される | E-01 (L165: `if( zDb==0 ) zDb = "main";`) | ○ |
| C-04 | 無効なデータベース名でエラー | E-01 (L167-171) | ○ |
| C-05 | フリーリストカウント不一致の検出 | E-01 (L210-215), E-06 (L49-56) | ○ |
| C-06 | 範囲外トランクページの検出 | E-01 (L193-197), E-06 (L58-65) | ○ |
| C-07 | 範囲外リーフページの検出 | E-01 (L199-207), E-06 (L67-83) | ○ |
| C-08 | リーフカウント超過の検出 | E-01 (L184-190), E-06 (L85-92) | ○ |
| C-09 | sqlGetIntegerがPRAGMA結果を取得 | E-01 (L83-111) | ○ |
| C-10 | sqlGetIntegerの無効SQLエラー | E-01 (L98-109) | ○ |
| C-11 | OOMでSQLITE_NOMEMが返される | E-01 (L95-96) | ○ |
| C-12 | pzOutがNULLでsqlite3_log呼び出し | E-01 (L130-135) | ○ |
| C-13 | pzOutが非NULLで文字列追記 | E-01 (L131-132) | ○ |
| C-14 | checkfreelist SQL関数の動作 | E-01 (L226-246), E-06 | ○ |
| C-15 | readint_functionのBLOB読み取り | E-01 (L253-281) | ○ |
| C-16 | readint_functionのオフセット機能 | E-01 (L269-271) | ○ |
| C-17 | readint_functionの引数エラー | E-01 (L263-268) | ○ |
| C-18 | 4バイト未満BLOBで0返却 | E-01 (L276-278) | ○ |
| C-19 | cflRegisterのSQL関数登録 | E-01 (L286-295) | ○ |
| C-20 | 拡張初期化 | E-01 (L303-310) | ○ |
| C-21 | get4byteマクロ | E-01 (L63-68) | ○ |

### checkindex.c 関連（UT-REP-022〜084）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | cidxConnect関数 | E-02 (L92-123) | ○ |
| C-23 | cidxDisconnect関数 | E-02 (L128-132) | ○ |
| C-24 | cidxBestIndexのコスト計算（iIdxName>=0, iAfterKey<0） | E-02 (L168-169) | ○ |
| C-25 | cidxBestIndexのコスト計算（両方指定） | E-02 (L170-174) | ○ |
| C-26 | cidxBestIndexのコスト計算（パラメータなし） | E-02 (L163-164) | ○ |
| C-27 | cidxOpen関数 | E-02 (L183-191) | ○ |
| C-28 | cidxClose関数 | E-02 (L196-203) | ○ |
| C-29 | cidxNext関数の移動 | E-02 (L208-223) | ○ |
| C-30 | cidxNext関数の終了処理 | E-02 (L211-214) | ○ |
| C-31 | cidxEof関数（NULL時） | E-02 (L228-231) | ○ |
| C-32 | cidxEof関数（非NULL時） | E-02 (L230) | ○ |
| C-33 | cidxFilter関数（インデックス名指定） | E-02 (L787-827), E-07 | ○ |
| C-34 | cidxFilter関数（after_key指定） | E-02 (L814-815), E-07 | ○ |
| C-35 | cidxFilter関数（パラメータなし） | E-02 (L804-809) | ○ |
| C-36 | cidxColumn関数（行欠落検出） | E-02 (L840-849), E-07 (L92-98) | ○ |
| C-37 | cidxColumn関数（データ不一致検出） | E-02 (L843-845), E-07 (L92-98) | ○ |
| C-38 | cidxColumn関数（current_key） | E-02 (L852-854) | ○ |
| C-39 | cidxColumn関数（index_name） | E-02 (L856-858) | ○ |
| C-40 | cidxColumn関数（scanner_sql） | E-02 (L864-868) | ○ |
| C-41 | cidxRowid関数 | E-02 (L875-879) | ○ |
| C-42 | cidxLookupIndex関数（成功） | E-02 (L461-531), E-07 | ○ |
| C-43 | cidxLookupIndex関数（失敗） | E-02 (L517-520) | ○ |
| C-44 | cidxParseSQL関数 | E-02 (L404-459), E-07 | ○ |
| C-45 | DESC指定のパース | E-02 (L426-433), E-07 (L109-128) | ○ |
| C-46 | WHERE句のパース | E-02 (L446-452), E-07 (L325-350) | ○ |
| C-47 | コメントスキップ | E-02 (L344-360), E-07 (L295-322) | ○ |
| C-48 | パースエラー | E-02 (L456-458) | ○ |
| C-49 | cidxDecodeAfter関数 | E-02 (L533-600) | ○ |
| C-50 | NULL値の処理 | E-02 (L552-556), E-07 (L109-164) | ○ |
| C-51 | BLOB値の処理 | E-02 (L559-572) | ○ |
| C-52 | after_keyパースエラー | E-02 (L595-599) | ○ |
| C-53 | cidxWhere関数 | E-02 (L602-629) | ○ |
| C-54 | NULL条件生成 | E-02 (L616-618) | ○ |
| C-55 | DESC条件生成 | E-02 (L620-623) | ○ |
| C-56 | ORDERBY形式のリスト生成 | E-02 (L658-660) | ○ |
| C-57 | CURRENT_KEY形式のリスト生成 | E-02 (L663-665) | ○ |
| C-58 | スキャンSQL生成（after_key=NULL） | E-02 (L732-740), E-07 (L56-64) | ○ |
| C-59 | スキャンSQL生成（after_key指定） | E-02 (L741-769) | ○ |
| C-60 | cidxMalloc関数（成功） | E-02 (L67-79) | ○ |
| C-61 | cidxMalloc関数（失敗） | E-02 (L74-76) | ○ |
| C-62 | cidxMprintf関数 | E-02 (L233-248) | ○ |
| C-63 | cidxStrdup関数 | E-02 (L281-289) | ○ |
| C-64 | cidxFreeIndex関数 | E-02 (L291-300) | ○ |
| C-65 | cidxFreeIndex関数（NULL） | E-02 (L292) | ○ |
| C-66 | cidxFindNext関数（カンマ） | E-02 (L370-371) | ○ |
| C-67 | cidxFindNext関数（開き括弧） | E-02 (L366-367) | ○ |
| C-68 | cidxFindNext関数（閉じ括弧） | E-02 (L368-369) | ○ |
| C-69 | cidxFindNext関数（EOF） | E-02 (L364-365) | ○ |
| C-70 | 文字列リテラル内のカンマ無視 | E-02 (L373-386) | ○ |
| C-71 | /* */コメントスキップ | E-02 (L353-359) | ○ |
| C-72 | -- コメントスキップ | E-02 (L344-352) | ○ |
| C-73 | cidx_isspace（スペース） | E-02 (L302-304) | ○ |
| C-74 | cidx_isspace（タブ） | E-02 (L303) | ○ |
| C-75 | cidx_isspace（通常文字） | E-02 (L302-304) | ○ |
| C-76 | cidx_isident（英字） | E-02 (L306-310) | ○ |
| C-77 | cidx_isident（数字） | E-02 (L308) | ○ |
| C-78 | cidx_isident（アンダースコア） | E-02 (L309) | ○ |
| C-79 | ciInit関数 | E-02 (L885-914) | ○ |
| C-80 | 拡張初期化 | E-02 (L922-929) | ○ |
| C-81 | cidxPrepare関数（成功） | E-02 (L250-274) | ○ |
| C-82 | cidxPrepare関数（エラー） | E-02 (L265-267) | ○ |
| C-83 | cidxFinalize関数 | E-02 (L276-279) | ○ |
| C-84 | cidxCursorError関数 | E-02 (L81-87) | ○ |

### sqlite3_checker.c.in / Tcl関連（UT-REP-085〜095）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | sqlite3_checker_init_proc関数 | E-03 (L74-85) | ○ |
| C-86 | getDbPointer関数（成功） | E-03 (L25-37) | ○ |
| C-87 | getDbPointer関数（失敗） | E-03 (L28-32) | ○ |
| C-88 | sqlite3_imposter関数（5引数） | E-03 (L62-67) | ○ |
| C-89 | sqlite3_imposter関数（3引数） | E-03 (L60-61) | ○ |
| C-90 | sqlite3_imposter関数（引数エラー） | E-03 (L54-57) | ○ |
| C-91 | check_indexプロシージャ | E-04 (L45-87) | △ |
| C-92 | バッチ処理 | E-04 (L66-78) | △ |
| C-93 | トレースモード | E-04 (L54-65, L73-74) | △ |
| C-94 | usageプロシージャ | E-04 (L91-117) | ○ |
| C-95 | tclshプロシージャ | E-04 (L20-41) | △ |

### 統合テスト（UT-REP-096〜100）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | ASC/DESC混合インデックスのチェック | E-07 (L109-164) | ○ |
| C-97 | WITHOUT ROWIDテーブルのチェック | E-07 (L166-196) | ○ |
| C-98 | COLLATE指定のチェック | E-07 (L198-235) | ○ |
| C-99 | 式インデックスのチェック | E-07 (L237-293) | ○ |
| C-100 | 部分インデックスのチェック | E-07 (L323-350) | △ |

## 4) 不足情報（Unknown / Missing）

- **Tclスクリプト（sqlite3_checker.tcl）の内部ロジックの詳細仕様**
  - Tclスクリプトはソースコードから読み取れるが、公式のドキュメントや仕様書が存在しない
  - 候補：SQLiteプロジェクトのドキュメント / テストケース / メーリングリストアーカイブ

- **OOM（Out of Memory）テストの具体的な再現方法**
  - sqlite3_mallocの失敗をシミュレートする方法がモジュール内では明示されていない
  - 候補：SQLiteのテストハーネス / fault injection機能

- **複雑なSQL文のパースエッジケース**
  - ネストした括弧や特殊文字を含むケースの詳細なテスト仕様がない
  - 候補：既存のテストケースの拡張

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2（高） | フリーリスト破損検出 | データベース整合性に直接影響。テストケースは既存テストで検証済みだが、エッジケースの網羅性要確認 |
| 2（高） | インデックス不整合検出 | データ整合性に直接影響。既存テストで主要パターンは検証済み |
| 1（中） | SQLパース機能 | 複雑なCREATE INDEX文のパースで予期しない動作の可能性 |
| 1（中） | Tcl統合部分 | Tclインタープリタとの連携部分のエラーハンドリング |
| 0（低） | ヘルパー関数 | 単純なユーティリティ関数、リスク低 |

## 6) レビュアーチェックリスト（最小）

- [ ] checkfreelist.cの主要関数（sqlite3_check_freelist, checkFreelist）のテストカバレッジを確認
- [ ] checkindex.cの仮想テーブル実装（cidxConnect〜cidxColumn）のテストカバレッジを確認
- [ ] フリーリスト破損パターン（カウント不一致、範囲外ページ）のテストが十分か確認
- [ ] インデックス不整合パターン（行欠落、データ不一致）のテストが十分か確認
- [ ] DESC列、部分インデックス、式インデックスなどの特殊ケースのテストを確認
- [ ] OOMエラー処理のテスト方法を検討（SQLiteのfault injection利用など）
- [ ] Tclスクリプトの統合テスト方法を確認
