---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 138
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：ext-rtree 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：138 / 140、根拠なし：2
- 優先レビュー（高）
  1. **UT-RTR-138（geopolySine）**：三角関数近似の精度検証が必要
  2. **UT-RTR-140（box_query）**：Tclテストインターフェースの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/sqlite-master/ext/rtree/rtree.c` - R-Tree主要実装（約4000行）
- E-02: `/Users/tomoka.baba/Work/sqlite-master/ext/rtree/geopoly.c` - Geopolyポリゴン処理実装（約1840行）
- E-03: `/Users/tomoka.baba/Work/sqlite-master/ext/rtree/test_rtreedoc.c` - Tclテストインターフェース（約345行）
- E-04: `/Users/tomoka.baba/Work/sqlite-master/ext/rtree/rtree.h` - R-Tree公開ヘッダ
- E-05: `/Users/tomoka.baba/Work/sqlite-master/ext/rtree/sqlite3rtree.h` - SQLite R-Tree API定義
- E-06: `/Users/tomoka.baba/Work/sqlite-master/ext/rtree/README` - モジュール説明文書

## 3) Claims と根拠の対応（レビューの主戦場）

### rtree.c - シリアライズ/デシリアライズ関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | readInt16が16ビット整数を正しくデシリアライズする | E-01 (L525-527) | ○ |
| C-02 | readCoordが座標値を正しくデシリアライズする | E-01 (L528-544) | ○ |
| C-03 | readInt64が64ビット整数を正しくデシリアライズする | E-01 (L545-570) | ○ |
| C-04 | writeInt16が16ビット整数を正しくシリアライズする | E-01 (L577-580) | ○ |
| C-05 | writeCoordが座標値を正しくシリアライズする | E-01 (L581-603) | ○ |
| C-06 | writeInt64が64ビット整数を正しくシリアライズする | E-01 (L604-624) | ○ |

### rtree.c - ハッシュテーブル管理
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | nodeHashがノード番号からハッシュ値を計算する | E-01 (L648-650) | ○ |
| C-08 | nodeHashLookupがハッシュテーブルからノードを検索する | E-01 (L656-660) | ○ |
| C-09 | nodeHashInsertがノードをハッシュテーブルに挿入する | E-01 (L665-671) | ○ |
| C-10 | nodeHashDeleteがノードをハッシュテーブルから削除する | E-01 (L676-684) | ○ |

### rtree.c - ノード管理
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | nodeNewが新しいノードを生成する | E-01 (L692-705) | ○ |
| C-12 | nodeReferenceが参照カウントを増加させる | E-01 (L629-634) | ○ |
| C-13 | nodeZeroがノードデータをゼロクリアする | E-01 (L639-642) | ○ |
| C-14 | nodeAcquireがノードを取得する | E-01 (L719-825) | ○ |
| C-15 | nodeReleaseがノードを解放する | E-01 (L913-935) | ○ |
| C-16 | nodeWriteがノードをDBに書き込む | E-01 (L887-907) | ○ |

### rtree.c - セル操作
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | nodeGetRowidがセルからrowidを取得する | E-01 (L942-949) | ○ |
| C-18 | nodeGetCoordがセルから座標を取得する | E-01 (L954-963) | ○ |
| C-19 | nodeGetCellがセル全体をデシリアライズする | E-01 (L969-987) | ○ |
| C-20 | nodeInsertCellがセルを挿入する | E-01 (L863-882) | ○ |
| C-21 | nodeDeleteCellがセルを削除する | E-01 (L848-855) | ○ |
| C-22 | nodeOverwriteCellがセルを上書きする | E-01 (L830-843) | ○ |

### rtree.c - 仮想テーブルメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | rtreeCreateがテーブルを作成する | E-01 (L1000-1008) | ○ |
| C-24 | rtreeConnectがテーブルに接続する | E-01 (L1013-1021) | ○ |
| C-25 | rtreeDisconnectがテーブルから切断する | E-01 (L1058-1061) | ○ |
| C-26 | rtreeDestroyがテーブルを削除する | E-01 (L1066-1089) | ○ |
| C-27 | rtreeOpenがカーソルを開く | E-01 (L1094-1109) | ○ |
| C-28 | rtreeCloseがカーソルを閉じる | E-01 (L1149-1161) | ○ |
| C-29 | rtreeEofがEOF状態を返す | E-01 (L1169-1172) | ○ |
| C-30 | rtreeFilterがスキャンを初期化する | E-01 (L1869-2000) | ○ |
| C-31 | rtreeNextが次のレコードに移動する | E-01 (L1720-1733) | ○ |
| C-32 | rtreeRowidがrowidを返す | E-01 (L1738-1751) | ○ |
| C-33 | rtreeColumnがカラム値を返す | E-01 (L1756-1802) | ○ |
| C-34 | rtreeBestIndexがクエリプランを最適化する | E-01 (L2036-2125) | ○ |
| C-35 | rtreeUpdateがINSERT/UPDATE/DELETEを処理する | E-01 (L3102-3244) | ○ |

### rtree.c - R-Treeアルゴリズム
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | cellAreaがセルの面積/体積を計算する | E-01 (L2130-2154) | ○ |
| C-37 | cellMarginがセルのマージンを計算する | E-01 (L2160-2168) | ○ |
| C-38 | cellUnionが2セルの和を計算する | E-01 (L2173-2188) | ○ |
| C-39 | cellContainsが包含関係を判定する | E-01 (L2194-2210) | ○ |
| C-40 | cellOverlapが重複領域を計算する | E-01 (L2212-2237) | ○ |
| C-41 | ChooseLeafが挿入先リーフを選択する | E-01 (L2244-2311) | ○ |
| C-42 | AdjustTreeが祖先のバウンディングボックスを更新する | E-01 (L2318-2351) | ○ |
| C-43 | SplitNodeがノードを分割する | E-01 (L2569-2703) | ○ |
| C-44 | splitNodeStartreeがR*-tree分割を実行する | E-01 (L2447-2542) | ○ |
| C-45 | rtreeDeleteRowidがレコードを削除する | E-01 (L2936-3020) | ○ |
| C-46 | findLeafNodeがrowidからリーフを検索する | E-01 (L1811-1829) | ○ |
| C-47 | rtreeNewRowidが新しいrowidを生成する | E-01 (L2923-2931) | ○ |

### rtree.c - トランザクション/その他
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | rtreeBeginTransactionがトランザクションを開始する | E-01 (L3249-3254) | ○ |
| C-49 | rtreeEndTransactionがトランザクションを終了する | E-01 (L3260-3265) | ○ |
| C-50 | rtreeRenameがテーブル名を変更する | E-01 (L3273-3290) | ○ |
| C-51 | rtreeShadowNameがシャドウテーブル名を判定する | E-01 (L3355-3364) | ○ |
| C-52 | rtreeQueryStat1が統計情報を取得する | E-01 (L3321-3348) | ○ |
| C-53 | rtreeValueDown/Upが丸め変換を行う | E-01 (L3033-3048) | ○ |
| C-54 | rtreenodeがノードを人間可読形式に変換する | E-01 (L3759-3800) | ○ |
| C-55 | rtreedepthがノードの深度を返す | E-01 (L3811-3826) | ○ |

### rtree.c - 整合性チェック
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | rtreeCheckGetNodeがノードを取得する | E-01 (L3930-3959) | ○ |
| C-57 | rtreeCheckMappingがマッピングを検証する | E-01 (L3974-4000+) | ○ |

### geopoly.c - パース/変換
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | geopolyParseJsonがJSONをパースする | E-02 (L221-290) | ○ |
| C-59 | geopolyFuncParamがBLOB/JSONを解釈する | E-02 (L298-350) | ○ |
| C-60 | geopolySwab32がバイトスワップする | E-02 (L145-152) | ○ |
| C-61 | geopolySkipSpaceが空白をスキップする | E-02 (L155-158) | ○ |
| C-62 | geopolyParseNumberが数値をパースする | E-02 (L163-211) | ○ |

### geopoly.c - 幾何計算
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | geopolyAreaがポリゴン面積を計算する | E-02 (L490-502) | ○ |
| C-64 | geopolyBBoxがバウンディングボックスを計算する | E-02 (L632-698) | ○ |
| C-65 | pointBeneathLineが点と線分の関係を判定する | E-02 (L784-806) | ○ |
| C-66 | geopolyOverlapがポリゴン重複を判定する | E-02 (L1068-1177) | ○ |

### geopoly.c - SQL関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | geopolyBlobFuncがBLOBを出力する | E-02 (L359-371) | ○ |
| C-68 | geopolyJsonFuncがJSONを出力する | E-02 (L379-398) | ○ |
| C-69 | geopolySvgFuncがSVGを出力する | E-02 (L406-435) | ○ |
| C-70 | geopolyXformFuncがアフィン変換を適用する | E-02 (L453-481) | ○ |
| C-71 | geopolyCcwFuncが回転方向を正規化する | E-02 (L538-561) | ○ |
| C-72 | geopolyRegularFuncが正多角形を生成する | E-02 (L588-620) | ○ |
| C-73 | geopolyContainsPointFuncが点包含を判定する | E-02 (L815-847) | ○ |
| C-74 | geopolyWithinFuncがWithin関係を判定する | E-02 (L860-878) | ○ |
| C-75 | geopolyOverlapFuncがOverlap関係を判定する | E-02 (L1191-1209) | ○ |
| C-76 | geopolyBBoxStep/Finalがグループ集約する | E-02 (L730-767) | ○ |

### geopoly.c - 仮想テーブル
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | geopolyInitがGeopolyテーブルを初期化する | E-02 (L1237-1320) | ○ |
| C-78 | geopolyFilterがスキャンを初期化する | E-02 (L1362-1480) | ○ |
| C-79 | geopolyUpdateがINSERT/UPDATE/DELETEを処理する | E-02 (L1603-1733) | ○ |

### geopoly.c - 補助関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | geopolySineが正弦近似を計算する | E-02 (L567-579) | △ |

### test_rtreedoc.c - テストインターフェース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | box_geomがジオメトリコールバックを処理する | E-03 (L141-167) | ○ |
| C-82 | box_queryがクエリコールバックを処理する | E-03 (L199-298) | △ |

## 4) 不足情報（Unknown / Missing）
- **geopolySine関数の精度検証**：近似アルゴリズムの精度範囲が文書化されていない
  - 候補：数学的証明 / 精度テスト結果 / 既知の近似誤差範囲
- **box_query Tclコールバック**：Tclスクリプト側の処理詳細が不明
  - 候補：Tclテストスクリプト / Tclインターフェース仕様書

## 5) リスクフラグ（レビュー観点）
| リスクレベル | 項目 | 理由 |
|---|---|---|
| 0 | シリアライズ/デシリアライズ関数 | コードが明確で副作用なし |
| 0 | ハッシュテーブル管理 | 標準的なデータ構造操作 |
| 1 | ノード分割アルゴリズム | 複雑なロジック、境界条件の確認が必要 |
| 1 | ポリゴン重複判定 | 幾何計算の精度に依存 |
| 0 | 仮想テーブルメソッド | SQLite仮想テーブルAPI準拠 |
| 1 | 整合性チェック | 破損データの全パターン網羅が困難 |

## 6) レビュアーチェックリスト（最小）
- [ ] シリアライズ関数のエンディアン処理が全プラットフォームで正しいか確認
- [ ] ハッシュテーブルのサイズ（HASHSIZE=97）が適切か確認
- [ ] ノード分割アルゴリズムの境界条件（RTREE_MINCELLS）が正しく処理されるか確認
- [ ] 座標制約（min <= max）のエラーメッセージが適切か確認
- [ ] ポリゴン頂点数の最小値（4）と最大値の制限が適切か確認
- [ ] 浮動小数点座標の丸め方向（rtreeValueDown/Up）が空間クエリに影響しないか確認
- [ ] 同時読み取り中のロック（SQLITE_LOCKED_VTAB）が適切に処理されるか確認
