---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 115
  claims_with_evidence: 112
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：ext-session 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：112 / 115、根拠なし：3
- 優先レビュー（高）
  1. **UT-SES-003**: NULL db ハンドルの動作 - 実装依存の可能性
  2. **UT-SES-005**: NULL セッション削除の安全性 - ドキュメント未記載
  3. **UT-SES-040**: 破損 changeset の検出 - エッジケース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ext/session/sqlite3session.h` - Session API ヘッダファイル（行 1-1864）
- E-02: `ext/session/sqlite3session.c` - Session API 実装ファイル（行 1-999+）
- E-03: `ext/session/changeset.c` - changeset コマンドラインツール（行 1-473）
- E-04: `ext/session/changesetfuzz.c` - changeset fuzz ツール（行 1-300+）
- E-05: `ext/session/test_session.c` - Tcl テストヘルパー（行 1-999+）
- E-06: `ext/session/session1.test` - セッションテストスクリプト
- E-07: `ext/session/session2.test` - セッションテストスクリプト
- E-08: `ext/session/sessionfault.test` - フォールトインジェクションテスト

## 3) Claims と根拠の対応（レビューの主戦場）

### Session オブジェクト API (UT-SES-001 〜 UT-SES-034)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-SES-001) | sqlite3session_create で正常にセッション作成 | E-01 (行 31-65), E-02 (行 44-61) | ○ |
| C-02 (UT-SES-002) | temp データベースへのセッション作成 | E-01 (行 56-59) | ○ |
| C-03 (UT-SES-003) | NULL db ハンドルでエラー | **根拠不足** | △ |
| C-04 (UT-SES-004) | sqlite3session_delete で正常に削除 | E-01 (行 67-79), E-05 (行 410-415) | ○ |
| C-05 (UT-SES-005) | NULL セッション削除の安全性 | **根拠不足** | △ |
| C-06 (UT-SES-006) | sqlite3session_enable で有効化 | E-01 (行 128-146) | ○ |
| C-07 (UT-SES-007) | sqlite3session_enable で無効化 | E-01 (行 139-141) | ○ |
| C-08 (UT-SES-008) | 負の値で状態照会 | E-01 (行 141-142) | ○ |
| C-09 (UT-SES-009) | sqlite3session_indirect で設定 | E-01 (行 148-176) | ○ |
| C-10 (UT-SES-010) | sqlite3session_indirect でクリア | E-01 (行 167-170) | ○ |
| C-11 (UT-SES-011) | sqlite3session_attach でテーブルアタッチ | E-01 (行 178-239) | ○ |
| C-12 (UT-SES-012) | NULL でワイルドカードアタッチ | E-01 (行 187-191) | ○ |
| C-13 (UT-SES-013) | 存在しないテーブルでもエラーにならない | E-01 (行 196-199) | ○ |
| C-14 (UT-SES-014) | PK なしテーブルのアタッチ | E-01 (行 192-195) | ○ |
| C-15 (UT-SES-015) | sqlite3session_table_filter 設定 | E-01 (行 241-258) | ○ |
| C-16 (UT-SES-016) | フィルタで false 時の除外 | E-01 (行 248-249), E-05 (行 175-197) | ○ |
| C-17 (UT-SES-017) | sqlite3session_changeset 生成 | E-01 (行 260-370) | ○ |
| C-18 (UT-SES-018) | 変更なしで空の changeset | E-01 (行 269-270) | ○ |
| C-19 (UT-SES-019) | INSERT 変更の記録 | E-01 (行 271-279) | ○ |
| C-20 (UT-SES-020) | UPDATE 変更の記録 | E-01 (行 274-279) | ○ |
| C-21 (UT-SES-021) | DELETE 変更の記録 | E-01 (行 271-274) | ○ |
| C-22 (UT-SES-022) | NULL PK の行は記録されない | E-01 (行 280-289, 200-203) | ○ |
| C-23 (UT-SES-023) | sqlite3session_patchset 生成 | E-01 (行 454-487) | ○ |
| C-24 (UT-SES-024) | patchset で DELETE は PK のみ | E-01 (行 460-462) | ○ |
| C-25 (UT-SES-025) | sqlite3session_isempty 変更なし判定 | E-01 (行 489-503) | ○ |
| C-26 (UT-SES-026) | sqlite3session_isempty 変更あり判定 | E-01 (行 494-496) | ○ |
| C-27 (UT-SES-027) | sqlite3session_memory_used | E-01 (行 506-512), E-05 (行 366-369) | ○ |
| C-28 (UT-SES-028) | sqlite3session_changeset_size 有効時 | E-01 (行 372-386), E-05 (行 372-375) | ○ |
| C-29 (UT-SES-029) | sqlite3session_changeset_size 無効時 | E-01 (行 376-377) | ○ |
| C-30 (UT-SES-030) | sqlite3session_diff テーブル差分 | E-01 (行 388-451), E-05 (行 352-363) | ○ |
| C-31 (UT-SES-031) | sqlite3session_diff スキーマ不一致 | E-01 (行 408-412) | ○ |
| C-32 (UT-SES-032) | OBJCONFIG_SIZE 設定 | E-01 (行 82-126), E-05 (行 377-403) | ○ |
| C-33 (UT-SES-033) | OBJCONFIG_ROWID 設定 | E-01 (行 113-124), E-05 (行 76-77) | ○ |
| C-34 (UT-SES-034) | テーブルアタッチ後の設定変更エラー | E-01 (行 110-111, 122-124) | ○ |

### Changeset Iterator API (UT-SES-035 〜 UT-SES-060)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 (UT-SES-035) | sqlite3changeset_start イテレータ作成 | E-01 (行 514-559), E-02 (行 97-112) | ○ |
| C-36 (UT-SES-036) | 空 changeset でイテレータ作成 | E-01 (行 519-521) | ○ |
| C-37 (UT-SES-037) | sqlite3changeset_start_v2 フラグ付き | E-01 (行 560-578) | ○ |
| C-38 (UT-SES-038) | sqlite3changeset_next で進行 | E-01 (行 581-603) | ○ |
| C-39 (UT-SES-039) | 走査完了で SQLITE_DONE | E-01 (行 596-598) | ○ |
| C-40 (UT-SES-040) | 破損 changeset で SQLITE_CORRUPT | **根拠不足** - エラー処理は E-01 (行 600-602) に記載あるが具体的動作は実装依存 | △ |
| C-41 (UT-SES-041) | sqlite3changeset_op 操作タイプ取得 | E-01 (行 606-644) | ○ |
| C-42 (UT-SES-042) | テーブル名取得 | E-01 (行 624-627) | ○ |
| C-43 (UT-SES-043) | カラム数取得 | E-01 (行 621-622) | ○ |
| C-44 (UT-SES-044) | 間接フラグ取得 | E-01 (行 629-632) | ○ |
| C-45 (UT-SES-045) | sqlite3changeset_pk PK 情報取得 | E-01 (行 646-676) | ○ |
| C-46 (UT-SES-046) | 無効位置で SQLITE_MISUSE | E-01 (行 667-670) | ○ |
| C-47 (UT-SES-047) | sqlite3changeset_old DELETE 値取得 | E-01 (行 678-707), E-05 (行 746-756) | ○ |
| C-48 (UT-SES-048) | sqlite3changeset_old UPDATE 値取得 | E-01 (行 685-687) | ○ |
| C-49 (UT-SES-049) | INSERT で old 取得は MISUSE | E-01 (行 687-688), E-05 (行 746-749) | ○ |
| C-50 (UT-SES-050) | 範囲外で SQLITE_RANGE | E-01 (行 690-692), E-05 (行 750-755) | ○ |
| C-51 (UT-SES-051) | sqlite3changeset_new INSERT 値取得 | E-01 (行 709-741), E-05 (行 735-745) | ○ |
| C-52 (UT-SES-052) | sqlite3changeset_new UPDATE 値取得 | E-01 (行 715-717) | ○ |
| C-53 (UT-SES-053) | DELETE で new 取得は MISUSE | E-01 (行 717-718), E-05 (行 735-738) | ○ |
| C-54 (UT-SES-054) | 未変更カラムは NULL | E-01 (行 728-730) | ○ |
| C-55 (UT-SES-055) | sqlite3changeset_conflict 競合値取得 | E-01 (行 743-769), E-05 (行 706-717) | ○ |
| C-56 (UT-SES-056) | 競合ハンドラ外で MISUSE | E-01 (行 749-751), E-05 (行 722-734) | ○ |
| C-57 (UT-SES-057) | sqlite3changeset_fk_conflicts FK 違反数 | E-01 (行 771-785), E-05 (行 648-651) | ○ |
| C-58 (UT-SES-058) | 非 FK 競合で MISUSE | E-01 (行 779-780), E-05 (行 757-762) | ○ |
| C-59 (UT-SES-059) | sqlite3changeset_finalize 正常終了 | E-01 (行 787-817) | ○ |
| C-60 (UT-SES-060) | エラー発生時のエラーコード返却 | E-01 (行 800-816) | ○ |

### Changeset 変換 API (UT-SES-061 〜 UT-SES-076)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 (UT-SES-061) | sqlite3changeset_invert 反転 | E-01 (行 820-851), E-03 (行 350-370) | ○ |
| C-62 (UT-SES-062) | INSERT が DELETE に変換 | E-01 (行 828-829) | ○ |
| C-63 (UT-SES-063) | DELETE が INSERT に変換 | E-01 (行 827-828) | ○ |
| C-64 (UT-SES-064) | UPDATE の old/new 交換 | E-01 (行 830) | ○ |
| C-65 (UT-SES-065) | patchset で SQLITE_CORRUPT | E-01 (行 468-471) | ○ |
| C-66 (UT-SES-066) | sqlite3changeset_concat 結合 | E-01 (行 853-886), E-03 (行 277-301) | ○ |
| C-67 (UT-SES-067) | 空との結合 | E-01 (行 856-858) | ○ |
| C-68 (UT-SES-068) | sqlite3changeset_apply 適用 | E-01 (行 1110-1279), E-03 (行 195-270) | ○ |
| C-69 (UT-SES-069) | 競合ハンドラ呼び出し | E-01 (行 1165-1172), E-05 (行 628-785) | ○ |
| C-70 (UT-SES-070) | フィルタ除外 | E-01 (行 1126-1135), E-05 (行 582-603) | ○ |
| C-71 (UT-SES-071) | OMIT でスキップ | E-01 (行 1442-1445) | ○ |
| C-72 (UT-SES-072) | REPLACE で置換 | E-01 (行 1447-1460) | ○ |
| C-73 (UT-SES-073) | ABORT でロールバック | E-01 (行 1462-1464) | ○ |
| C-74 (UT-SES-074) | apply_v2 フラグ付き | E-01 (行 1295-1311, 1330-1373) | ○ |
| C-75 (UT-SES-075) | NOSAVEPOINT フラグ | E-01 (行 1337-1344) | ○ |
| C-76 (UT-SES-076) | rebase 情報出力 | E-01 (行 1263-1271, 1309) | ○ |

### Changegroup API (UT-SES-077 〜 UT-SES-084)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 (UT-SES-077) | sqlite3changegroup_new 作成 | E-01 (行 896-931) | ○ |
| C-78 (UT-SES-078) | sqlite3changegroup_add 追加 | E-01 (行 966-1046) | ○ |
| C-79 (UT-SES-079) | changeset/patchset 混在エラー | E-01 (行 973-977) | ○ |
| C-80 (UT-SES-080) | スキーマ不一致エラー | E-01 (行 1031-1038) | ○ |
| C-81 (UT-SES-081) | sqlite3changegroup_schema 設定 | E-01 (行 934-963) | ○ |
| C-82 (UT-SES-082) | sqlite3changegroup_add_change 単一追加 | E-01 (行 1049-1069) | ○ |
| C-83 (UT-SES-083) | sqlite3changegroup_output 出力 | E-01 (行 1073-1102) | ○ |
| C-84 (UT-SES-084) | sqlite3changegroup_delete 削除 | E-01 (行 1104-1108) | ○ |

### Rebaser API (UT-SES-085 〜 UT-SES-088)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 (UT-SES-085) | sqlite3rebaser_create 作成 | E-01 (行 1571-1579) | ○ |
| C-86 (UT-SES-086) | sqlite3rebaser_configure 設定 | E-01 (行 1582-1594) | ○ |
| C-87 (UT-SES-087) | sqlite3rebaser_rebase リベース | E-01 (行 1596-1614) | ○ |
| C-88 (UT-SES-088) | sqlite3rebaser_delete 削除 | E-01 (行 1616-1624) | ○ |

### Streaming API (UT-SES-089 〜 UT-SES-094)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 (UT-SES-089) | sqlite3session_changeset_strm | E-01 (行 1790-1794), E-05 (行 291-297) | ○ |
| C-90 (UT-SES-090) | sqlite3session_patchset_strm | E-01 (行 1795-1799), E-05 (行 293-294) | ○ |
| C-91 (UT-SES-091) | sqlite3changeset_start_strm | E-01 (行 1779-1789) | ○ |
| C-92 (UT-SES-092) | sqlite3changeset_apply_strm | E-01 (行 1716-1730), E-05 (行 951-957) | ○ |
| C-93 (UT-SES-093) | sqlite3changeset_invert_strm | E-01 (行 1773-1778) | ○ |
| C-94 (UT-SES-094) | sqlite3changeset_concat_strm | E-01 (行 1765-1772) | ○ |

### Internal Functions (UT-SES-095 〜 UT-SES-100)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 (UT-SES-095) | sessionVarintPut エンコード | E-02 (行 333-335) | ○ |
| C-96 (UT-SES-096) | sessionVarintGet デコード | E-02 (行 348-350) | ○ |
| C-97 (UT-SES-097) | sessionSerializeValue シリアライズ | E-02 (行 393-462) | ○ |
| C-98 (UT-SES-098) | sessionPreupdateHash ハッシュ | E-02 (行 540-604) | ○ |
| C-99 (UT-SES-099) | sessionChangeHash ハッシュ | E-02 (行 631-672) | ○ |
| C-100 (UT-SES-100) | sessionChangeEqual 比較 | E-02 (行 680-708) | ○ |

### Config / Special Cases (UT-SES-101 〜 UT-SES-108)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 (UT-SES-101) | sqlite3session_config 設定 | E-01 (行 1816-1854) | ○ |
| C-102 (UT-SES-102) | sqlite_stat1 特別処理 | E-01 (行 207-234) | ○ |
| C-103 (UT-SES-103) | sqlite_stat1 NULL 変換 | E-01 (行 223-229) | ○ |
| C-104 (UT-SES-104) | DATA 競合検出 | E-01 (行 1381-1389) | ○ |
| C-105 (UT-SES-105) | NOTFOUND 競合検出 | E-01 (行 1391-1397) | ○ |
| C-106 (UT-SES-106) | CONFLICT 競合検出 | E-01 (行 1399-1405) | ○ |
| C-107 (UT-SES-107) | CONSTRAINT 競合検出 | E-01 (行 1420-1427) | ○ |
| C-108 (UT-SES-108) | FOREIGN_KEY 競合検出 | E-01 (行 1407-1418) | ○ |

### CLI Tools (UT-SES-109 〜 UT-SES-115)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 (UT-SES-109) | changeset dump コマンド | E-03 (行 306-345) | ○ |
| C-110 (UT-SES-110) | changeset sql コマンド | E-03 (行 375-466) | ○ |
| C-111 (UT-SES-111) | changeset invert コマンド | E-03 (行 350-370) | ○ |
| C-112 (UT-SES-112) | changeset concat コマンド | E-03 (行 277-301) | ○ |
| C-113 (UT-SES-113) | changeset apply コマンド | E-03 (行 195-270) | ○ |
| C-114 (UT-SES-114) | changesetfuzz ダンプ | E-04 (行 17-27) | ○ |
| C-115 (UT-SES-115) | changesetfuzz 生成 | E-04 (行 33-40) | ○ |

## 4) 不足情報（Unknown / Missing）

### UT-SES-003: NULL db ハンドルでエラーになること
- **理由**: sqlite3session_create の実装で NULL チェックが明示的に記載されていない
- **候補**: sqlite3session.c の実装を詳細確認 / テストケースで動作確認

### UT-SES-005: NULL セッションで安全に処理されること
- **理由**: sqlite3session_delete の NULL 安全性がドキュメントに明記されていない
- **候補**: 実装コードで NULL チェックの有無を確認 / 実行時テストで検証

### UT-SES-040: 破損した changeset で SQLITE_CORRUPT が返ること
- **理由**: エラーコードは記載されているが、どのような破損が検出されるかの詳細は実装依存
- **候補**: sessionfault.test 等の既存テストで検証方法を確認

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 1: 中リスク | UT-SES-003 | エラー処理のエッジケース、クラッシュの可能性 |
| 1: 中リスク | UT-SES-005 | NULL 安全性、防御的プログラミングの確認必要 |
| 0: 低リスク | UT-SES-040 | changeset 検証は通常のユースケースでは発生しにくい |

## 6) レビュアーチェックリスト（最小）

- [ ] UT-SES-003: sqlite3session_create に NULL db を渡した場合の動作を実装で確認
- [ ] UT-SES-005: sqlite3session_delete に NULL を渡した場合の動作を実装で確認
- [ ] UT-SES-040: 破損 changeset の検出パターンを sessionfault.test で確認
- [ ] テストケースの優先度「高」の項目が既存テストでカバーされているか確認
- [ ] ストリーミング API のテストケースが十分な境界値をカバーしているか確認
- [ ] 競合タイプ（DATA/NOTFOUND/CONFLICT/CONSTRAINT/FOREIGN_KEY）の全パターンがテストされるか確認
