---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：ext-wasm 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の関数定義・実装が根拠として存在するか
2. **根拠との整合性**：テストケースの期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：参照すべき関数・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-WASM-060〜062**: WASMFS関連（コンパイル時フラグ依存のため実環境テスト要確認）
  2. **UT-WASM-106〜113**: テスト用関数（SQLITE_WASM_ENABLE_C_TESTS依存）
  3. **UT-WASM-022**: sqlite3__wasm_db_reset（データ破壊の可能性）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/sqlite-master/ext/wasm/api/sqlite3-wasm.c` - メインWASMバインディング実装
- E-02: `/Users/tomoka.baba/Work/sqlite-master/ext/wasm/mkwasmbuilds.c` - Makefileコード生成ツール
- E-03: `/Users/tomoka.baba/Work/sqlite-master/ext/wasm/c-pp-lite.c` - Cプリプロセッサ実装
- E-04: `/Users/tomoka.baba/Work/sqlite-master/ext/wasm/example_extra_init.c` - 拡張初期化サンプル
- E-05: `/Users/tomoka.baba/Work/sqlite-master/ext/wasm/SQLTester/touint8array.c` - バイト配列変換ツール

## 3) Claims と根拠の対応（レビューの主戦場）

### sqlite3-wasm.c 関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-WASM-001) | sqlite3__wasm_pstack_ptr が PStack.pPos を返却 | E-01 L296-298 | ○ |
| C-02 (UT-WASM-002) | sqlite3__wasm_pstack_restore がポインタ復元 | E-01 L303-309 | ○ |
| C-03 (UT-WASM-003) | 範囲外ポインタで復元されない | E-01 L304-307 条件チェック | ○ |
| C-04 (UT-WASM-004) | 8バイトアラインメントチェック | E-01 L305 assert文 | ○ |
| C-05 (UT-WASM-005) | sqlite3__wasm_pstack_alloc でメモリ確保 | E-01 L318-325 | ○ |
| C-06 (UT-WASM-006) | 確保メモリがゼロクリア | E-01 L323 memset呼び出し | ○ |
| C-07 (UT-WASM-007) | n<=0 で NULL 返却 | E-01 L319 | ○ |
| C-08 (UT-WASM-008) | 負値で NULL 返却 | E-01 L319 | ○ |
| C-09 (UT-WASM-009) | 空き領域超過で NULL | E-01 L321-322 | ○ |
| C-10 (UT-WASM-010) | 8バイト境界アライン | E-01 L320 `(n + 7) & ~7` | ○ |
| C-11 (UT-WASM-011) | sqlite3__wasm_pstack_remaining | E-01 L330-334 | ○ |
| C-12 (UT-WASM-012) | sqlite3__wasm_pstack_quota | E-01 L341-343 | ○ |
| C-13 (UT-WASM-013) | sqlite3__wasm_enum_json がJSON返却 | E-01 L394-1243 | ○ |
| C-14 (UT-WASM-014) | 2回目以降キャッシュ返却 | E-01 L404 条件チェック | ○ |
| C-15 (UT-WASM-015) | SQLite定数含む | E-01 L434-953 DefInt/DefStr マクロ | ○ |
| C-16 (UT-WASM-016) | sqlite3__wasm_vfs_unlink | E-01 L1255-1262 | ○ |
| C-17 (UT-WASM-017) | 両方NULL で MISUSE | E-01 L1256-1258 | ○ |
| C-18 (UT-WASM-018) | xDelete NULL で MISUSE | E-01 L1258 条件 | ○ |
| C-19 (UT-WASM-019) | sqlite3__wasm_db_vfs | E-01 L1272-1277 | ○ |
| C-20 (UT-WASM-020) | zDbName NULL で main | E-01 L1274 三項演算子 | ○ |
| C-21 (UT-WASM-021) | 無効DB名で 0 | E-01 L1273 初期値0 | ○ |
| C-22 (UT-WASM-022) | sqlite3__wasm_db_reset | E-01 L1294-1305 | ○ |
| C-23 (UT-WASM-023) | pDb NULL で MISUSE | E-01 L1295-1296 | ○ |
| C-24 (UT-WASM-024) | sqlite3__wasm_db_export_chunked | E-01 L1324-1356 | ○ |
| C-25 (UT-WASM-025) | pDb NULL で NOTFOUND | E-01 L1332-1335 | ○ |
| C-26 (UT-WASM-026) | コールバックエラー伝播 | E-01 L1353 | ○ |
| C-27 (UT-WASM-027) | sqlite3__wasm_db_serialize | E-01 L1375-1389 | ○ |
| C-28 (UT-WASM-028) | pDb NULL で MISUSE | E-01 L1380 | ○ |
| C-29 (UT-WASM-029) | pOut NULL で MISUSE | E-01 L1380 | ○ |
| C-30 (UT-WASM-030) | NOCOPY で NULL 可 | E-01 L1383-1384 | ○ |
| C-31 (UT-WASM-031) | sqlite3__wasm_vfs_create_file 作成 | E-01 L1439-1516 | ○ |
| C-32 (UT-WASM-032) | 既存ファイル上書き | E-01 L1488 xTruncate | ○ |
| C-33 (UT-WASM-033) | zFilename NULL で MISUSE | E-01 L1464 | ○ |
| C-34 (UT-WASM-034) | nData 負で MISUSE | E-01 L1464 | ○ |
| C-35 (UT-WASM-035) | pData NULL, nData=0 | E-01 L1491 条件 | ○ |
| C-36 (UT-WASM-036) | sqlite3__wasm_posix_create_file | E-01 L1527-1543 | ○ |
| C-37 (UT-WASM-037) | zFilename NULL で MISUSE | E-01 L1535 | ○ |
| C-38 (UT-WASM-038) | pData NULL, nData>0 で MISUSE | E-01 L1535 | ○ |
| C-39 (UT-WASM-039) | sqlite3__wasm_kvvfsMakeKey | E-01 L1552-1573 | ○ |
| C-40 (UT-WASM-040) | zClass NULL で zKeyIn | E-01 L1556-1563 | ○ |
| C-41 (UT-WASM-041) | sqlite3__wasm_kvvfs_methods | E-01 L1582-1584 | ○ |
| C-42 (UT-WASM-042) | vtab_config DIRECTONLY | E-01 L1597-1608 | ○ |
| C-43 (UT-WASM-043) | vtab_config INNOCUOUS | E-01 L1600-1602 | ○ |
| C-44 (UT-WASM-044) | vtab_config CONSTRAINT_SUPPORT | E-01 L1603-1604 | ○ |
| C-45 (UT-WASM-045) | 不正op で MISUSE | E-01 L1605-1606 | ○ |
| C-46 (UT-WASM-046) | db_config_ip ENABLE_FKEY | E-01 L1618-1645 | ○ |
| C-47 (UT-WASM-047) | db_config_ip 不正op | E-01 L1643 | ○ |
| C-48 (UT-WASM-048) | db_config_pii LOOKASIDE | E-01 L1654-1662 | ○ |
| C-49 (UT-WASM-049) | db_config_pii 不正op | E-01 L1661 | ○ |
| C-50 (UT-WASM-050) | db_config_s MAINDBNAME | E-01 L1671-1678 | ○ |
| C-51 (UT-WASM-051) | db_config_s 不正op | E-01 L1677 | ○ |
| C-52 (UT-WASM-052) | config_i | E-01 L1688-1690 | ○ |
| C-53 (UT-WASM-053) | config_ii | E-01 L1699-1701 | ○ |
| C-54 (UT-WASM-054) | config_j | E-01 L1710-1712 | ○ |
| C-55 (UT-WASM-055) | qfmt_token %Q | E-01 L1722-1730 | ○ |
| C-56 (UT-WASM-056) | qfmt_token %q | E-01 L1726-1728 | ○ |
| C-57 (UT-WASM-057) | qfmt_token z NULL | E-01 L1724 | ○ |
| C-58 (UT-WASM-058) | kvvfs_decode | E-01 L1739-1741 | ○ |
| C-59 (UT-WASM-059) | kvvfs_encode | E-01 L1742-1744 | ○ |
| C-60 (UT-WASM-060) | init_wasmfs 正常 | E-01 L1772-1789 | △ |
| C-61 (UT-WASM-061) | init_wasmfs デフォルト | E-01 L1774 | △ |
| C-62 (UT-WASM-062) | init_wasmfs NOTFOUND | E-01 L1791-1795 | ○ |
| C-63〜C-73 | mkwasmbuilds.c 関連 | E-02 | ○ |
| C-74〜C-100 | c-pp-lite.c 関連 | E-03 | ○ |
| C-101〜C-102 | example_extra_init.c | E-04 | ○ |
| C-103〜C-105 | touint8array.c | E-05 | ○ |
| C-106〜C-120 | テスト用関数 | E-01 L1798-1953 | ○ |

### mkwasmbuilds.c 関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 (UT-WASM-063) | BuildDef_jsext ESM で .mjs | E-02 L586-588 | ○ |
| C-64 (UT-WASM-064) | BuildDef_jsext 非ESM で .js | E-02 L586-588 | ○ |
| C-65 (UT-WASM-065) | BuildDef_basename 取得 | E-02 L590-592 | ○ |
| C-66 (UT-WASM-066) | BuildDef_basename デフォルト | E-02 L591 | ○ |
| C-67 (UT-WASM-067) | mk_prologue | E-02 L433-562 | ○ |
| C-68 (UT-WASM-068) | mk_pre_post | E-02 L603-715 | ○ |
| C-69 (UT-WASM-069) | mk_lib_mode | E-02 L755-950 | ○ |
| C-70 (UT-WASM-070) | mk_fiddle | E-02 L967-1047 | ○ |
| C-71 (UT-WASM-071) | main 引数なし | E-02 L1049-1081 | ○ |
| C-72 (UT-WASM-072) | main 特定ビルド | E-02 L1054-1071 | ○ |
| C-73 (UT-WASM-073) | main 不正ビルド名 | E-02 L1066-1068 | ○ |

### c-pp-lite.c 関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 (UT-WASM-074) | cmpp_realloc 成功 | E-03 L397-401 | ○ |
| C-75 (UT-WASM-075) | cmpp_realloc 失敗 | E-03 L399 fatal | ○ |
| C-76 (UT-WASM-076) | cmpp_free | E-03 L393-395 | ○ |
| C-77 (UT-WASM-077) | FILE_open 正常 | E-03 L411-420 | ○ |
| C-78 (UT-WASM-078) | FILE_open stdin | E-03 L413-414 | ○ |
| C-79 (UT-WASM-079) | FILE_open 失敗 | E-03 L417 fatal | ○ |
| C-80 (UT-WASM-080) | FILE_close | E-03 L422-426 | ○ |
| C-81 (UT-WASM-081) | FILE_close stdout | E-03 L423 条件 | ○ |
| C-82 (UT-WASM-082) | FILE_slurp | E-03 L428-451 | ○ |
| C-83 (UT-WASM-083) | FileWrapper_open | E-03 L459-463 | ○ |
| C-84 (UT-WASM-084) | FileWrapper_close | E-03 L453-457 | ○ |
| C-85 (UT-WASM-085) | FileWrapper_slurp | E-03 L466-470 | ○ |
| C-86 (UT-WASM-086) | FileWrapper_chomp LF | E-03 L472-481 | ○ |
| C-87 (UT-WASM-087) | FileWrapper_chomp CRLF | E-03 L475-477 | ○ |
| C-88 (UT-WASM-088) | FileWrapper_chomp なし | E-03 L479 | ○ |
| C-89 (UT-WASM-089) | db_affirm_rc OK | E-03 L928-939 | ○ |
| C-90 (UT-WASM-090) | db_affirm_rc エラー | E-03 L935-937 | ○ |
| C-91 (UT-WASM-091) | db_step ROW | E-03 L941-951 | ○ |
| C-92 (UT-WASM-092) | db_step DONE | E-03 L943-946 | ○ |
| C-93 (UT-WASM-093) | db_prepare | E-03 L968-984 | ○ |
| C-94 (UT-WASM-094) | db_bind_int | E-03 L986-989 | ○ |
| C-95 (UT-WASM-095) | db_bind_text | E-03 L996-1000 | ○ |
| C-96 (UT-WASM-096) | db_define_add | E-03 GStmt_map defIns | ○ |
| C-97 (UT-WASM-097) | db_define_has 存在 | E-03 GStmt_map defHas | ○ |
| C-98 (UT-WASM-098) | db_define_has 未定義 | E-03 GStmt_map defHas | ○ |
| C-99 (UT-WASM-099) | AtPolicy_fromStr 正常 | E-03 L682-692 | ○ |
| C-100 (UT-WASM-100) | AtPolicy_fromStr 不正 | E-03 L687-690 | ○ |

### その他ファイル

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 (UT-WASM-101) | sqlite3_wasm_extra_init 0返却 | E-04 L20-23 | ○ |
| C-102 (UT-WASM-102) | stderr出力 | E-04 L21 fprintf | ○ |
| C-103 (UT-WASM-103) | touint8array 変換 | E-05 L17-29 | ○ |
| C-104 (UT-WASM-104) | 空入力 | E-05 L21,27 | ○ |
| C-105 (UT-WASM-105) | 改行挿入 | E-05 L24 colWidth | ○ |

## 4) 不足情報（Unknown / Missing）

- **WASMFS関連テスト (UT-WASM-060〜061)**: WASMFS有効環境でのテストは、Emscripten環境かつ`SQLITE_ENABLE_WASMFS`定義時のみ有効。一般的なテスト環境では検証困難。
  - 候補：Emscripten環境でのCI / Docker環境構築 / モック利用

## 5) リスクフラグ（レビュー観点）

| リスク | 項目 | 説明 |
|--------|------|------|
| 2 (高) | UT-WASM-022 | db_reset はデータ消去を伴う。vtab の xDestroy が呼ばれない警告あり |
| 1 (中) | UT-WASM-031〜035 | ファイル作成/上書き機能。ファイルシステムへの副作用 |
| 1 (中) | UT-WASM-060〜062 | WASMFS依存。環境依存性が高い |
| 1 (中) | UT-WASM-106〜120 | SQLITE_WASM_ENABLE_C_TESTS フラグ依存 |
| 0 (低) | その他 | 標準的なユニットテスト可能 |

## 6) レビュアーチェックリスト（最小）

- [ ] 高優先度テストケース（pstack, serialize, vfs_create_file）の期待結果がソースコードと一致しているか
- [ ] 境界値テスト（n=0, n=-1, NULL入力）が網羅されているか
- [ ] SQLITE_WASM_ENABLE_C_TESTS 条件付きコンパイルの関数がテスト対象外になっていないか
- [ ] WASMFS関連テストの実行環境要件が明確か
- [ ] テストIDの連番に欠番がないか
- [ ] 各テストケースの前提条件が実現可能か
- [ ] db_reset のデータ消去に関する警告がテストケースに反映されているか
