---
generated_at: 2026-01-21 16:30:00
metrics:
  claims_total: 125
  claims_with_evidence: 118
  claims_without_evidence: 7
confidence_derived: 0.94
---

# 根拠レポート：src モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・ヘッダファイル・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：118 / 125、根拠なし：7
- 優先レビュー（高）
  1. **UT-SRC-105〜109（WAL関連）**：wal.hが未読のため詳細API確認が必要
  2. **UT-SRC-116〜117（prepare関連）**：prepare.cの詳細実装未確認
  3. **UT-SRC-124〜125（tokenize関連）**：tokenize.cの詳細実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/btree.h` - B-Tree APIの関数宣言
- E-02: `src/btree.c` - B-Tree実装（ファイル存在確認済み、404KB）
- E-03: `src/pager.h` - Pager APIの関数宣言
- E-04: `src/pager.c` - Pager実装（ファイル存在確認済み）
- E-05: `src/hash.c` - ハッシュテーブル実装（全体読み込み済み）
- E-06: `src/hash.h` - ハッシュテーブル構造体定義
- E-07: `src/bitvec.c` - Bitvec実装（全体読み込み済み）
- E-08: `src/malloc.c` - メモリ管理実装（部分読み込み済み）
- E-09: `src/func.c` - SQL関数実装（部分読み込み済み）
- E-10: `src/utf.c` - UTF-8/UTF-16変換実装（部分読み込み済み）
- E-11: `src/random.c` - 乱数生成実装（全体読み込み済み）
- E-12: `src/util.c` - ユーティリティ関数実装（部分読み込み済み）
- E-13: `src/vdbe.h` - VDBE APIの関数宣言
- E-14: `src/pcache1.c` - ページキャッシュ実装（部分読み込み済み）
- E-15: `src/sqlite3ext.h` - 拡張API定義
- E-16: `docs/code-to-docs/単体テストケース一覧/plan.md` - モジュール計画書

## 3) Claims と根拠の対応（レビューの主戦場）

### B-Tree関連（UT-SRC-001〜020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sqlite3BtreeOpenはVFSとファイル名を受け取りBtreeをオープンする | E-01 (btree.h:45-52) | ○ |
| C-02 | sqlite3BtreeCloseでBtreeをクローズする | E-01 (btree.h:65) | ○ |
| C-03 | sqlite3BtreeBeginTransでトランザクション開始 | E-01 (btree.h:81) | ○ |
| C-04 | sqlite3BtreeCommitでコミット | E-01 (btree.h:84) | ○ |
| C-05 | sqlite3BtreeRollbackでロールバック | E-01 (btree.h:85) | ○ |
| C-06 | sqlite3BtreeCursorでカーソル作成 | E-01 (btree.h:234-240) | ○ |
| C-07 | sqlite3BtreeInsertでレコード挿入 | E-01 (btree.h:317-318) | ○ |
| C-08 | sqlite3BtreeDeleteでレコード削除 | E-01 (btree.h:266) | ○ |
| C-09 | sqlite3BtreeFirst/Last/Nextでカーソル移動 | E-01 (btree.h:319-324) | ○ |
| C-10 | sqlite3BtreeIntegrityCheckで整合性チェック | E-01 (btree.h:334-343) | ○ |

### Pager関連（UT-SRC-021〜030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | sqlite3PagerOpenでPagerをオープン | E-03 (pager.h:133-141) | ○ |
| C-12 | sqlite3PagerCloseでPagerをクローズ | E-03 (pager.h:142) | ○ |
| C-13 | sqlite3PagerGetでページ取得 | E-03 (pager.h:163) | ○ |
| C-14 | sqlite3PagerWriteでページ書き込み | E-03 (pager.h:171) | ○ |
| C-15 | sqlite3PagerBeginでトランザクション開始 | E-03 (pager.h:180) | ○ |
| C-16 | sqlite3PagerCommitPhaseOne/Twoでコミット | E-03 (pager.h:181,184) | ○ |
| C-17 | sqlite3PagerRollbackでロールバック | E-03 (pager.h:185) | ○ |
| C-18 | sqlite3PagerSetJournalModeでジャーナルモード設定 | E-03 (pager.h:155) | ○ |

### Hash関連（UT-SRC-031〜038）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | sqlite3HashInitでハッシュテーブル初期化 | E-05 (hash.c:23-29) | ○ |
| C-20 | sqlite3HashClearでハッシュテーブルクリア | E-05 (hash.c:35-50) | ○ |
| C-21 | sqlite3HashFindで要素検索 | E-05 (hash.c:222-226) | ○ |
| C-22 | sqlite3HashInsertで要素挿入/更新/削除 | E-05 (hash.c:242-272) | ○ |
| C-23 | rehash関数でハッシュテーブルのリサイズ | E-05 (hash.c:113-146) | ○ |

### Bitvec関連（UT-SRC-039〜048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | sqlite3BitvecCreateでBitvec作成 | E-07 (bitvec.c:116-124) | ○ |
| C-25 | sqlite3BitvecSetでビットセット | E-07 (bitvec.c:170-235) | ○ |
| C-26 | sqlite3BitvecTestでビットテスト | E-07 (bitvec.c:131-156) | ○ |
| C-27 | sqlite3BitvecClearでビットクリア | E-07 (bitvec.c:243-275) | ○ |
| C-28 | sqlite3BitvecDestroyでBitvec破棄 | E-07 (bitvec.c:280-289) | ○ |
| C-29 | sqlite3BitvecSizeでサイズ取得 | E-07 (bitvec.c:295-297) | ○ |

### Malloc関連（UT-SRC-049〜058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | sqlite3MallocInitでメモリアロケータ初期化 | E-08 (malloc.c:159-173) | ○ |
| C-31 | sqlite3_soft_heap_limit64でソフトリミット設定 | E-08 (malloc.c:95-119) | ○ |
| C-32 | sqlite3_hard_heap_limit64でハードリミット設定 | E-08 (malloc.c:137-153) | ○ |
| C-33 | sqlite3_memory_usedでメモリ使用量取得 | E-08 (malloc.c:197-200) | ○ |
| C-34 | sqlite3HeapNearlyFullでヒープ状態チェック | E-08 (malloc.c:180-182) | ○ |

### Func関連（UT-SRC-059〜075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | typeofFuncで型判定 | E-09 (func.c:79-98) | ○ |
| C-36 | lengthFuncで文字列長計算 | E-09 (func.c:116-150) | ○ |
| C-37 | bytelengthFuncでバイト長計算 | E-09 (func.c:155-186) | ○ |
| C-38 | absFuncで絶対値計算 | E-09 (func.c:194-200) | ○ |
| C-39 | minmaxFuncで最小/最大値計算 | E-09 (func.c:49-74) | ○ |

### UTF関連（UT-SRC-076〜083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | sqlite3Utf8ReadでUTF-8デコード | E-10 (utf.c:175-194) | ○ |
| C-41 | sqlite3AppendOneUtf8CharacterでUTF-8エンコード | E-10 (utf.c:114-135) | ○ |
| C-42 | WRITE_UTF8マクロでUTF-8書き込み | E-10 (utf.c:64-82) | ○ |

### Random関連（UT-SRC-084〜087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | sqlite3_randomnessでランダムバイト生成 | E-11 (random.c:59-130) | ○ |
| C-44 | chacha_blockでChaCha20ブロック関数 | E-11 (random.c:39-54) | ○ |
| C-45 | N<=0またはpBuf=NULLでPRNGリセット | E-11 (random.c:88-92) | ○ |

### Util関連（UT-SRC-088〜094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | sqlite3Strlen30で文字列長計算 | E-12 (util.c:92-95) | ○ |
| C-47 | sqlite3IsNaNでNaN判定 | E-12 (util.c:57-68) | ○ |
| C-48 | sqlite3Errorでエラーコード設定 | E-12 (util.c:130-138) | ○ |
| C-49 | sqlite3ErrorClearでエラークリア | E-12 (util.c:144-149) | ○ |

### VDBE関連（UT-SRC-095〜099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | sqlite3VdbeCreateでVDBE作成 | E-13 (vdbe.h:195) | ○ |
| C-51 | sqlite3VdbeAddOp系で命令追加 | E-13 (vdbe.h:197-207) | ○ |
| C-52 | sqlite3VdbeFinalizeでVDBE終了 | E-13 (vdbe.h:275) | ○ |
| C-53 | sqlite3VdbeResetでVDBEリセット | E-13 (vdbe.h:283) | ○ |

### PCache関連（UT-SRC-100〜104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | PCache1構造体でページキャッシュ管理 | E-14 (pcache1.c:175-200) | ○ |
| C-55 | PgHdr1構造体でページヘッダ管理 | E-14 (pcache1.c:117-127) | ○ |
| C-56 | PGroup構造体でキャッシュグループ管理 | E-14 (pcache1.c:158-165) | ○ |

### WAL関連（UT-SRC-105〜109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | WALオープン/クローズ機能 | **根拠なし** | △ |
| C-58 | WALトランザクション機能 | **根拠なし** | △ |
| C-59 | WALチェックポイント機能 | **根拠なし** | △ |

### Main関連（UT-SRC-110〜115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | sqlite3_openでDB接続 | E-15 (sqlite3ext.h:113) | ○ |
| C-61 | sqlite3_closeでDB切断 | E-15 (sqlite3ext.h:49) | ○ |
| C-62 | sqlite3_execでSQL実行 | E-15 (sqlite3ext.h:98) | ○ |

### Prepare関連（UT-SRC-116〜117）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | sqlite3_prepare_v2でプリペア | E-15 (sqlite3ext.h:164) | ○ |
| C-64 | プリペアエラー処理 | **根拠なし** | △ |

### VdbeAPI関連（UT-SRC-118〜123）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | sqlite3_stepでステップ実行 | E-15 (sqlite3ext.h:138) | ○ |
| C-66 | sqlite3_finalizeでファイナライズ | E-15 (sqlite3ext.h:100) | ○ |
| C-67 | sqlite3_bind系でパラメータバインド | E-15 (sqlite3ext.h:35-45) | ○ |
| C-68 | sqlite3_column系で結果取得 | E-15 (sqlite3ext.h:54-74) | ○ |

### Tokenize関連（UT-SRC-124〜125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | sqlite3GetTokenでトークン識別 | **根拠なし** | △ |
| C-70 | 数値リテラル識別 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **wal.c/wal.h**：WAL関連APIの詳細実装を確認していない
  - 候補：`src/wal.c` / `src/wal.h` を読み込んで関数シグネチャを確認
- **prepare.c**：prepare関連の詳細実装を確認していない
  - 候補：`src/prepare.c` を読み込んでエラー処理を確認
- **tokenize.c**：字句解析の詳細実装を確認していない
  - 候補：`src/tokenize.c` を読み込んでトークン処理を確認

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：B-Tree、Pager、Hash、Bitvec、Malloc、Func、UTF、Random、Util関連
  - ヘッダファイルおよび実装ファイルを直接確認済み
- **リスク1（中）**：VDBE、PCache、Main、VdbeAPI関連
  - ヘッダファイルで関数宣言を確認、実装詳細は部分的
- **リスク2（高）**：WAL、Tokenize関連
  - ヘッダファイル未読、実装詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] WAL関連テストケース（UT-SRC-105〜109）のAPIシグネチャが正しいか確認
- [ ] tokenize関連テストケース（UT-SRC-124〜125）の関数名と引数が正しいか確認
- [ ] 各テストケースの「期待結果」が実装の戻り値と一致しているか確認
- [ ] テスト優先度（高/中/低）の妥当性を確認
- [ ] 境界値テストのカバレッジが十分か確認（特にNULL、0、最大値）
