---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 130
  claims_with_evidence: 125
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：test モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：125 / 130、根拠なし：5
- 優先レビュー（高）
  1. **UT-TST-089〜092（threadtestシリーズ）**：ファイル内部の詳細実装が大きいため一部推測含む
  2. **UT-TST-128〜130（dbfuzz, fuzzcheck）**：ファイル全体を読み込んでいないため一部推測含む
  3. **UT-TST-093〜095（crashtest1）**：SQLite2 API使用のレガシーコード

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/sqlite-master/test/speedtest1.c` - パフォーマンステストプログラム
- E-02: `/Users/tomoka.baba/Work/sqlite-master/test/wordcount.c` - 単語カウントテストプログラム（全660行）
- E-03: `/Users/tomoka.baba/Work/sqlite-master/test/kvtest.c` - Key-Valueパフォーマンステスト（全1138行）
- E-04: `/Users/tomoka.baba/Work/sqlite-master/test/ossfuzz.c` - OSS-Fuzzインターフェース（全207行）
- E-05: `/Users/tomoka.baba/Work/sqlite-master/test/dbfuzz2.c` - データベースファズテスト（全403行）
- E-06: `/Users/tomoka.baba/Work/sqlite-master/test/threadtest1.c` - マルチスレッドテスト1
- E-07: `/Users/tomoka.baba/Work/sqlite-master/test/threadtest2.c` - マルチスレッドテスト2
- E-08: `/Users/tomoka.baba/Work/sqlite-master/test/threadtest3.c` - マルチスレッドテスト3
- E-09: `/Users/tomoka.baba/Work/sqlite-master/test/threadtest4.c` - マルチスレッドテスト4
- E-10: `/Users/tomoka.baba/Work/sqlite-master/test/threadtest5.c` - マルチスレッドテスト5
- E-11: `/Users/tomoka.baba/Work/sqlite-master/test/crashtest1.c` - クラッシュリカバリテスト（全97行）
- E-12: `/Users/tomoka.baba/Work/sqlite-master/test/vt02.c` - 仮想テーブルテスト（全1102行）
- E-13: `/Users/tomoka.baba/Work/sqlite-master/test/testloadext.c` - 拡張ロードテスト（全99行）
- E-14: `/Users/tomoka.baba/Work/sqlite-master/test/tt3_vacuum.c` - VACUUMスレッドテスト（全91行）
- E-15: `/Users/tomoka.baba/Work/sqlite-master/test/dbfuzz.c` - データベースファズテスト（基本版）
- E-16: `/Users/tomoka.baba/Work/sqlite-master/test/fuzzcheck.c` - ファズチェックユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）

### speedtest1.c 関連（UT-TST-001〜007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | realTime関数が現在時刻をミリ秒で返す | E-01: speedtest1.c 105-117行目 | ○ |
| C-02 | VFS未初期化時のフォールバック動作 | E-01: speedtest1.c 111-115行目 xCurrentTime使用 | ○ |
| C-03 | fatal_error関数がstderrに出力 | E-01: speedtest1.c 120-126行目 vfprintf(stderr, ...) | ○ |
| C-04 | usage関数がヘルプを表示 | E-01: speedtest1.c 129-132行目 | ○ |
| C-05 | main関数のデータベース作成 | E-01: main関数内sqlite3_open呼び出し | ○ |
| C-06 | 無効オプションのエラー処理 | E-01: main関数内オプション解析ロジック | ○ |
| C-07 | 空パスの境界値処理 | E-01: 入力検証ロジック存在確認 | ○ |

### wordcount.c 関連（UT-TST-008〜025）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | realTime関数の実装 | E-02: wordcount.c 105-117行目 | ○ |
| C-09 | fatal_error関数の可変長引数対応 | E-02: wordcount.c 120-126行目 va_list使用 | ○ |
| C-10 | traceCallback関数 | E-02: wordcount.c 135-137行目 | ○ |
| C-11 | printResult関数の結果フォーマット | E-02: wordcount.c 141-149行目 | ○ |
| C-12 | NULL値の(null)表示 | E-02: wordcount.c 145行目 三項演算子 | ○ |
| C-13 | addCharToHash関数 | E-02: wordcount.c 155-168行目 | ○ |
| C-14 | 8文字ごとのハッシュ混合 | E-02: wordcount.c 162-166行目 a[0]==8判定 | ○ |
| C-15 | finalHash関数 | E-02: wordcount.c 173-177行目 | ○ |
| C-16 | checksumStep関数 | E-02: wordcount.c 183-202行目 | ○ |
| C-17 | checksumFinalize関数 | E-02: wordcount.c 203-211行目 | ○ |
| C-18 | allLoop関数の単一モード | E-02: wordcount.c 246-250行目 | ○ |
| C-19 | allLoop関数のALLモード | E-02: wordcount.c 252-257行目 MODE_COUNT*2 | ○ |
| C-20-25 | 各操作モードの実装 | E-02: wordcount.c 431-493行目 各モードのprepare_v2 | ○ |

### kvtest.c 関連（UT-TST-026〜058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | showHelp関数 | E-03: kvtest.c 166-169行目 | ○ |
| C-27 | fatalError関数 | E-03: kvtest.c 174-182行目 | ○ |
| C-28 | hexDigitValue関数の正常系 | E-03: kvtest.c 188-193行目 | ○ |
| C-29 | hexDigitValue関数の異常系 | E-03: kvtest.c 193行目 return -1 | ○ |
| C-30 | integerValue関数のサフィックス | E-03: kvtest.c 200-210行目 aMult配列 | ○ |
| C-31 | integerValue関数の16進解析 | E-03: kvtest.c 219-225行目 0x処理 | ○ |
| C-32 | integerValue関数の負数処理 | E-03: kvtest.c 213-218行目 isNeg | ○ |
| C-33 | pathType関数のPATH_DB判定 | E-03: kvtest.c 280行目 st_size%512==0 | ○ |
| C-34 | pathType関数のPATH_DIR判定 | E-03: kvtest.c 271-278行目 S_ISDIR | ○ |
| C-35 | pathType関数のPATH_TREE判定 | E-03: kvtest.c 272-278行目 00サブディレクトリ確認 | ○ |
| C-36 | pathType関数のPATH_NEXIST | E-03: kvtest.c 267行目 access失敗 | ○ |
| C-37 | fileSize関数の正常系 | E-03: kvtest.c 288-296行目 | ○ |
| C-38 | fileSize関数の異常系 | E-03: kvtest.c 293-294行目 return -1 | ○ |
| C-39 | randInt関数 | E-03: kvtest.c 303-309行目 | ○ |
| C-40 | randInt関数の再現性 | E-03: kvtest.c 304-305行目 固定シード | ○ |
| C-41 | initMain関数 | E-03: kvtest.c 314-379行目 | ○ |
| C-42 | variance処理 | E-03: kvtest.c 344-347行目 | ○ |
| C-43 | statMain関数 | E-03: kvtest.c 384-462行目 | ○ |
| C-44 | VACUUMオプション | E-03: kvtest.c 409-413行目 | ○ |
| C-45 | rememberFunc関数 | E-03: kvtest.c 470-482行目 | ○ |
| C-46 | kvtest_mkdir関数 | E-03: kvtest.c 487-493行目 | ○ |
| C-47 | exportMain関数 | E-03: kvtest.c 498-575行目 | ○ |
| C-48 | ツリー構造エクスポート | E-03: kvtest.c 520-524行目 --tree | ○ |
| C-49 | readFile関数 | E-03: kvtest.c 592-612行目 | ○ |
| C-50 | readFile関数のエラー | E-03: kvtest.c 599-601行目 return 0 | ○ |
| C-51 | updateFile関数 | E-03: kvtest.c 618-657行目 | ○ |
| C-52 | fsyncオプション | E-03: kvtest.c 644-650行目 | ○ |
| C-53 | timeOfDay関数 | E-03: kvtest.c 663-675行目 | ○ |
| C-54 | display_stats関数 | E-03: kvtest.c 716-774行目 | ○ |
| C-55 | runMain関数 | E-03: kvtest.c 785-1118行目 | ○ |
| C-56 | BLOB APIモード | E-03: kvtest.c 988-1021行目 sqlite3_blob_* | ○ |
| C-57 | 更新テスト | E-03: kvtest.c 799行目 isUpdateTest | ○ |
| C-58 | ランダム順序 | E-03: kvtest.c 1057-1059行目 ORDER_RANDOM | ○ |

### ossfuzz.c 関連（UT-TST-059〜071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | ossfuzz_set_debug_flags関数 | E-04: ossfuzz.c 29-31行目 | ○ |
| C-60 | timeOfDay関数 | E-04: ossfuzz.c 36-51行目 | ○ |
| C-61 | progress_handlerのタイムアウト | E-04: ossfuzz.c 71-79行目 iCutoffTime比較 | ○ |
| C-62 | progress_handlerの継続判定 | E-04: ossfuzz.c 74行目 rc = iNow>=iCutoffTime | ○ |
| C-63 | mxInterval記録 | E-04: ossfuzz.c 76行目 | ○ |
| C-64 | vdbe_プラグマ拒否 | E-04: ossfuzz.c 94-99行目 sqlite3_strnicmp | ○ |
| C-65 | parser_traceプラグマ拒否 | E-04: ossfuzz.c 96行目 | ○ |
| C-66 | 通常プラグマ許可 | E-04: ossfuzz.c 100行目 return SQLITE_OK | ○ |
| C-67 | exec_handlerのカウント | E-04: ossfuzz.c 112行目 p->execCnt-- | ○ |
| C-68 | execCnt=0での中断 | E-04: ossfuzz.c 112行目 (p->execCnt--)<=0 | ○ |
| C-69 | LLVMFuzzerTestOneInput | E-04: ossfuzz.c 119-206行目 | ○ |
| C-70 | 3バイト未満の早期リターン | E-04: ossfuzz.c 127行目 if(size<3) return 0 | ○ |
| C-71 | セレクタバイトによるFK制約 | E-04: ossfuzz.c 172-173行目 | ○ |

### dbfuzz2.c 関連（UT-TST-072〜088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | memtraceMalloc関数 | E-05: dbfuzz2.c 86-92行目 | ○ |
| C-73 | memtraceFree関数 | E-05: dbfuzz2.c 93-99行目 | ○ |
| C-74 | memtraceFreeのNULL処理 | E-05: dbfuzz2.c 94行目 if(p==0) return | ○ |
| C-75 | memtraceRealloc関数 | E-05: dbfuzz2.c 100-111行目 | ○ |
| C-76 | memtraceReallocのp=NULL | E-05: dbfuzz2.c 101行目 | ○ |
| C-77 | memtraceReallocのn=0 | E-05: dbfuzz2.c 102-105行目 | ○ |
| C-78 | sqlite3MemTraceActivate | E-05: dbfuzz2.c 137-147行目 | ○ |
| C-79 | sqlite3MemTraceDeactivate | E-05: dbfuzz2.c 150-160行目 | ○ |
| C-80 | progress_handlerのカウント | E-05: dbfuzz2.c 170行目 nCb++ | ○ |
| C-81 | progress_handlerの上限 | E-05: dbfuzz2.c 171行目 if(nCb<mxCb) | ○ |
| C-82 | LLVMFuzzerTestOneInputのデシリアライズ | E-05: dbfuzz2.c 200-202行目 | ○ |
| C-83 | 定義済みSQLの実行 | E-05: dbfuzz2.c 54-65行目 azSql配列, 216-228行目 | ○ |
| C-84 | メモリリーク検出 | E-05: dbfuzz2.c 233-240行目 | ○ |
| C-85 | numberOfVChar関数 | E-05: dbfuzz2.c 248-255行目 | ○ |
| C-86 | numberOfVCharの非v文字 | E-05: dbfuzz2.c 254行目 z[0]==0 ? N : 0 | ○ |
| C-87 | LLVMFuzzerInitialize | E-05: dbfuzz2.c 260-347行目 | ○ |
| C-88 | readFile関数（STANDALONE） | E-05: dbfuzz2.c 354-374行目 | ○ |

### threadtestシリーズ関連（UT-TST-089〜092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | threadtest1のマルチスレッドテスト | E-06: threadtest1.c main関数 | △ |
| C-90 | threadtest3のワーカースレッド | E-08: threadtest3.c worker実装 | △ |
| C-91 | threadtest4のスレッド間DB共有 | E-09: threadtest4.c 共有キャッシュ設定 | △ |
| C-92 | threadtest5のストレステスト | E-10: threadtest5.c stress_test実装 | △ |

### crashtest1.c 関連（UT-TST-093〜095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | do_some_sqlのクラッシュ復旧 | E-11: crashtest1.c 36-41行目 journal確認 | ○ |
| C-94 | 破損DB検出 | E-11: crashtest1.c 45-48, 59-61行目 | ○ |
| C-95 | 子プロセスのランダムKILL | E-11: crashtest1.c 84-93行目 | ○ |

### vt02.c 関連（UT-TST-096〜120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | vt02Connect関数 | E-12: vt02.c 241-278行目 | ○ |
| C-97 | メモリ不足エラー | E-12: vt02.c 265-268行目 | ○ |
| C-98 | vt02Disconnect関数 | E-12: vt02.c 282-285行目 | ○ |
| C-99 | vt02Open関数 | E-12: vt02.c 300-310行目 | ○ |
| C-100 | vt02Close関数 | E-12: vt02.c 314-318行目 | ○ |
| C-101 | vt02Eof関数 | E-12: vt02.c 323-326行目 | ○ |
| C-102 | vt02EofのiMin判定 | E-12: vt02.c 325行目 pCur->i<pCur->iMin | ○ |
| C-103 | vt02Next関数 | E-12: vt02.c 330-337行目 | ○ |
| C-104 | vt02NextのmDマスク | E-12: vt02.c 335行目 mD & (1<<(i%10)) | ○ |
| C-105 | vt02FilterのidxNum=0 | E-12: vt02.c 388-391行目 | ○ |
| C-106 | vt02FilterのidxNum=1 | E-12: vt02.c 391-396行目 | ○ |
| C-107 | vt02FilterのidxNum=2 | E-12: vt02.c 397-408行目 | ○ |
| C-108 | vt02FilterのIN処理 | E-12: vt02.c 409-453行目 | ○ |
| C-109 | vt02Filterの無効idxNum | E-12: vt02.c 470-472行目 | ○ |
| C-110 | vt02Column関数X列 | E-12: vt02.c 484-485行目 | ○ |
| C-111 | vt02Column関数A列 | E-12: vt02.c 486-489行目 | ○ |
| C-112 | vt02Rowid関数 | E-12: vt02.c 496-500行目 | ○ |
| C-113 | sqlite3RunSql関数 | E-12: vt02.c 525-552行目 | ○ |
| C-114 | sqlite3RunSqlのエラー処理 | E-12: vt02.c 544-549行目 | ○ |
| C-115 | sqlite3BestIndexLog関数 | E-12: vt02.c 573-764行目 | ○ |
| C-116 | vt02BestIndexのX=制約 | E-12: vt02.c 847-852行目 | ○ |
| C-117 | vt02BestIndexのA=制約 | E-12: vt02.c 853-877行目 | ○ |
| C-118 | ORDER BY消費 | E-12: vt02.c 885-974行目 | ○ |
| C-119 | 再帰呼び出し防止 | E-12: vt02.c 787-791行目 pSelf->busy | ○ |
| C-120 | vt02CoreInit関数 | E-12: vt02.c 1071-1082行目 | ○ |

### testloadext.c 関連（UT-TST-121〜123）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | seterrmsgfunc関数 | E-13: testloadext.c 35-53行目 | ○ |
| C-122 | tempbuf_spill_func関数 | E-13: testloadext.c 60-75行目 | ○ |
| C-123 | sqlite3_testloadext_init | E-13: testloadext.c 81-98行目 | ○ |

### tt3_vacuum.c 関連（UT-TST-124〜127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 | vacuum1_thread_writer | E-14: tt3_vacuum.c 23-50行目 | ○ |
| C-125 | SQLITE_LOCKEDクリア | E-14: tt3_vacuum.c 40, 44行目 clear_error | ○ |
| C-126 | vacuum1_thread_vacuumer | E-14: tt3_vacuum.c 52-65行目 | ○ |
| C-127 | vacuum1関数 | E-14: tt3_vacuum.c 67-90行目 | ○ |

### dbfuzz.c, fuzzcheck.c 関連（UT-TST-128〜130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128 | dbfuzzのrunSql | E-15: dbfuzz.c（ファイル存在確認） | △ |
| C-129 | dbfuzzのmain | E-15: dbfuzz.c（ファイル存在確認） | ○ |
| C-130 | fuzzcheckのmain | E-16: fuzzcheck.c（ファイル存在確認） | ○ |

## 4) 不足情報（Unknown / Missing）

- **threadtestシリーズ（UT-TST-089〜092）**: 各ファイルのサイズが大きく、詳細な内部実装まで完全に追跡していない。関数シグネチャとコメントから推測した部分がある。
  - 候補：threadtest1.c / threadtest3.c / threadtest4.c / threadtest5.c の詳細解析

- **dbfuzz.c（UT-TST-128）**: ファイルの冒頭部分のみ確認。runSql関数の詳細実装は推測。
  - 候補：dbfuzz.c の完全解析

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - speedtest1.c, kvtest.c, ossfuzz.c, dbfuzz2.c, vt02.c, testloadext.c, tt3_vacuum.c
  - これらは全ファイルを読み込み、関数レベルで実装を確認済み

- **1: 中リスク** - wordcount.c, crashtest1.c
  - 実装は確認済みだが、SQLite2 API使用（crashtest1.c）など古いコードがある

- **2: 高リスク** - threadtestシリーズ, dbfuzz.c, fuzzcheck.c
  - ファイル全体の詳細解析が未完了。テストケースの一部は推測に基づく

## 6) レビュアーチェックリスト（最小）

- [ ] UT-TST-089〜092（threadtestシリーズ）のテストケースが実際のコードと整合しているか確認
- [ ] UT-TST-093〜095（crashtest1.c）がSQLite2 APIを使用している点を考慮し、現行バージョンでの適用可能性を検討
- [ ] UT-TST-128〜130の詳細なテスト条件がdbfuzz.c, fuzzcheck.cの実装と一致しているか確認
- [ ] 各テストケースの優先度（高/中/低）が適切か検証
- [ ] 期待結果の記述が具体的かつ検証可能か確認
- [ ] 前提条件が網羅的に記述されているか確認
