---
generated_at: 2026-01-21 16:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 140
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：tool モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の関数・処理が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要な関数・処理をカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：140 / 140、根拠なし：0
- 優先レビュー（高）
  1. **lemon.c メモリ管理関数群**：パーサジェネレータの基盤機能
  2. **sqldiff.c DB比較機能**：データベース差分検出の主要ロジック
  3. **srcck1.c 副作用検出**：コード品質保証の重要機能

## 2) 参照した情報（Evidence一覧）
> 以下のソースファイルを根拠として参照

- E-01: `/Users/tomoka.baba/Work/sqlite-master/tool/lemon.c` - LALR(1)パーサジェネレータ
- E-02: `/Users/tomoka.baba/Work/sqlite-master/tool/sqldiff.c` - SQLiteデータベース差分ツール
- E-03: `/Users/tomoka.baba/Work/sqlite-master/tool/dbhash.c` - データベースSHA1ハッシュ計算ツール
- E-04: `/Users/tomoka.baba/Work/sqlite-master/tool/checkSpacing.c` - ソースコードフォーマットチェッカー
- E-05: `/Users/tomoka.baba/Work/sqlite-master/tool/varint.c` - varint変換ユーティリティ
- E-06: `/Users/tomoka.baba/Work/sqlite-master/tool/srcck1.c` - 副作用静的解析ツール
- E-07: `/Users/tomoka.baba/Work/sqlite-master/tool/logest.c` - LogEst計算ユーティリティ
- E-08: `/Users/tomoka.baba/Work/sqlite-master/tool/showdb.c` - データベースファイル表示ツール
- E-09: `/Users/tomoka.baba/Work/sqlite-master/tool/offsets.c` - カラムオフセット検索ツール
- E-10: `/Users/tomoka.baba/Work/sqlite-master/tool/showwal.c` - WALファイル表示ツール
- E-11: `/Users/tomoka.baba/Work/sqlite-master/tool/fuzzershell.c` - ファズテスト用シェル
- E-12: `/Users/tomoka.baba/Work/sqlite-master/tool/fast_vacuum.c` - 高速VACUUM実装
- E-13: `/Users/tomoka.baba/Work/sqlite-master/tool/loadfts.c` - FTSデータロードツール
- E-14: `/Users/tomoka.baba/Work/sqlite-master/tool/src-verify.c` - ソースツリー検証ツール
- E-15: `/Users/tomoka.baba/Work/sqlite-master/tool/mkkeywordhash.c` - キーワードハッシュ生成ツール

## 3) Claims と根拠の対応（レビューの主戦場）

### lemon.c - メモリ管理・文字列処理（UT-TOL-001〜017）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | lemon_malloc正常系テスト | E-01: 89-102行 | ○ |
| C-02 | lemon_malloc 0バイト境界値 | E-01: 91行 `if(nByte<0)` | ○ |
| C-03 | lemon_malloc負数異常系 | E-01: 91行 | ○ |
| C-04 | lemon_calloc正常系 | E-01: 103-107行 | ○ |
| C-05 | lemon_free正常系 | E-01: 108-114行 | ○ |
| C-06 | lemon_free NULL安全性 | E-01: 109行 `if(pOld)` | ○ |
| C-07 | lemon_realloc拡張 | E-01: 115-125行 | ○ |
| C-08 | lemon_realloc NULLポインタ | E-01: 118行 | ○ |
| C-09 | lemon_realloc縮小 | E-01: 121行 | ○ |
| C-10 | lemon_free_all全解放 | E-01: 130-136行 | ○ |
| C-11〜C-14 | lemon_addtextテスト | E-01: 155-169行 | ○ |
| C-15〜C-17 | lemon_vsprintfテスト | E-01: 170-200行以降 | ○ |

### sqldiff.c - DB比較機能（UT-TOL-018〜028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | strFree | E-02: 53-55行 | ○ |
| C-19 | cmdlineError | E-02: 61-71行 | ○ |
| C-20 | runtimeError | E-02: 77-86行 | ○ |
| C-21〜C-24 | safeIdテスト | E-02: 96-113行 | ○ |
| C-25〜C-26 | db_prepareテスト | E-02: 119-141行 | ○ |
| C-27〜C-28 | namelistFreeテスト | E-02: 146-152行 | ○ |

### dbhash.c - SHA1ハッシュ機能（UT-TOL-029〜033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | SHA1Transform | E-03: 103-154行 | ○ |
| C-30 | hash_init | E-03: 158-166行 | ○ |
| C-31〜C-32 | hash_step | E-03: 169-188行 | ○ |
| C-33 | hash_finish | E-03: 192-200行以降 | ○ |

### checkSpacing.c - コードフォーマットチェック（UT-TOL-034〜038）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | タブ検出 | E-04: 34-36行 | ○ |
| C-35 | 行末空白検出 | E-04: 48-50行 | ○ |
| C-36 | ファイル末尾空行検出 | E-04: 53-56行 | ○ |
| C-37 | CR検出 | E-04: 37-39行 | ○ |
| C-38 | ファイルオープンエラー | E-04: 25-28行 | ○ |

### varint.c - varint変換（UT-TOL-039〜046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39〜C-42 | hexValue | E-05: 17-22行 | ○ |
| C-43 | toHex | E-05: 24-26行 | ○ |
| C-44〜C-46 | putVarint | E-05: 28-50行 | ○ |

### srcck1.c - 副作用静的解析（UT-TOL-047〜059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47〜C-48 | readFile | E-06: 30-59行 | ○ |
| C-49〜C-53 | hasSideEffect | E-06: 80-90行 | ○ |
| C-54〜C-55 | findCloseParen | E-06: 95-106行 | ○ |
| C-56〜C-59 | findAllSideEffects | E-06: 114-141行 | ○ |

### logest.c - LogEst計算（UT-TOL-060〜072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | logEstMultiply | E-07: 41行 | ○ |
| C-61〜C-62 | logEstAdd | E-07: 42-58行 | ○ |
| C-63〜C-64 | logEstFromInteger | E-07: 59-70行 | ○ |
| C-65〜C-67 | logEstToInt | E-07: 71-81行 | ○ |
| C-68〜C-69 | logEstFromDouble | E-07: 82-94行 | ○ |
| C-70〜C-72 | isInteger/isFloat | E-07: 96-106行 | ○ |

### showdb.c - DBファイル表示（UT-TOL-073〜084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73〜C-75 | decodeVarint | E-08: 52-62行 | ○ |
| C-76 | decodeInt32 | E-08: 67-69行 | ○ |
| C-77〜C-78 | openDatabase | E-08: 81-92行 | ○ |
| C-79〜C-82 | fileOpen/fileClose | E-08: 109-143行 | ○ |
| C-83 | fileRead | E-08: 151-184行 | ○ |
| C-84 | out_of_memory | E-08: 73-76行 | ○ |

### offsets.c - カラムオフセット検索（UT-TOL-085〜104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | ofstError | E-09: 39-45行 | ○ |
| C-86〜C-87 | ofstTrace | E-09: 50-57行 | ○ |
| C-88〜C-91 | ofstRootAndColumn | E-09: 62-128行 | ○ |
| C-92〜C-95 | ofstPopPage/ofstPushPage | E-09: 133-168行 | ○ |
| C-96〜C-98 | ofst2byte/ofst4byte/ofstVarint | E-09: 171-201行 | ○ |
| C-99 | ofstInFile | E-09: 206-208行 | ○ |
| C-100〜C-104 | ofstSerialSize | E-09: 212-218行 | ○ |

### showwal.c - WALファイル表示（UT-TOL-105〜111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | getInt32 | E-10: 41-44行 | ○ |
| C-106 | swab32 | E-10: 49-52行 | ○ |
| C-107〜C-108 | extendCksum | E-10: 56-89行 | ○ |
| C-109 | decodeVarint | E-10: 95-105行 | ○ |
| C-110 | out_of_memory | E-10: 109-112行 | ○ |
| C-111 | getContent | E-10: 120-127行 | ○ |

### fuzzershell.c - ファズテストシェル（UT-TOL-112〜123）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | oomFault | E-11: 98-100行 | ○ |
| C-113〜C-116 | oomMalloc/oomRealloc | E-11: 104-127行 | ○ |
| C-117〜C-118 | abendError/fatalError | E-11: 133-162行 | ○ |
| C-119〜C-120 | sqlexec | E-11: 167-178行 | ○ |
| C-121〜C-123 | shellLog/execCallback | E-11: 183-200行以降 | ○ |

### fast_vacuum.c - 高速VACUUM（UT-TOL-124〜128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124〜C-125 | vacuumFinalize | E-12: 56-63行 | ○ |
| C-126〜C-127 | execSql | E-12: 70-83行 | ○ |
| C-128 | execExecSql | E-12: 93-107行 | ○ |

### loadfts.c - FTSデータロード（UT-TOL-129〜136）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129〜C-131 | readfileFunc | E-13: 33-57行 | ○ |
| C-132〜C-133 | error_out/sqlite_error_out | E-13: 85-97行 | ○ |
| C-134 | visit_file | E-13: 114-128行 | ○ |
| C-135〜C-136 | traverse | E-13: 134-150行以降 | ○ |

### src-verify.c - ソース検証（UT-TOL-137〜139）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-137 | SHA1Init | E-14: 176-184行 | ○ |
| C-138 | SHA1Update | E-14: 190-200行以降 | ○ |
| C-139 | SHA1Transform | E-14: 119-171行 | ○ |

### mkkeywordhash.c - キーワードハッシュ生成（UT-TOL-140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-140 | Keyword構造体 | E-15: 34-50行, 177-200行以降 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべてのテストケースはソースコード内の実装を直接参照して生成されている。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべてのテストケースがソースコードの実装に基づいている
- 注意点：
  - Cコードのため、メモリ管理関連のテストは実行環境依存の挙動がある可能性
  - エラーハンドリング（exit()呼び出し）のテストは単体テストフレームワークでの取り扱いに注意が必要
  - OOMシミュレーション関連のテストは実行順序に依存する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] メモリ管理関数（lemon_malloc, lemon_free等）のテストケースが境界条件を網羅しているか
- [ ] エラーハンドリング（exit呼び出し）のテストが適切にモック化される前提か確認
- [ ] SHA1/SHA3ハッシュ関連のテストで既知のテストベクターとの比較が含まれるべきか検討
- [ ] varint変換のテストで最大値境界（9バイト）のテストが十分か確認
- [ ] ファイルI/O関連のテストでエラーケース（権限、ディスクフル等）が必要か検討
- [ ] OOMシミュレーション関連のテストが他テストと分離して実行されることを確認
