---
generated_at: 2026-01-21 23:10:00
metrics:
  claims_total: 60
  claims_with_evidence: 52
  claims_without_evidence: 8
confidence_derived: 0.87
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：52 / 60、根拠なし：8
- 優先レビュー（高）
  1. **UAT-051 オンラインバックアップ**：API使用例の詳細な手順は推測に基づく
  2. **UAT-054 共有キャッシュモード**：マルチスレッド環境での具体的な検証方法が不足
  3. **UAT-056 R-Tree拡張**：空間クエリの具体例が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/sqlite.h.in` - SQLite公開API定義（sqlite3_open, sqlite3_exec, sqlite3_close等）
- E-02: `src/main.c` - SQLiteライブラリ初期化とコア機能実装
- E-03: `src/shell.c.in` - SQLite CLIツール実装
- E-04: `README.md` - プロジェクト概要とビルド手順
- E-05: `src/vdbe.c` - 仮想データベースエンジン（VDBE）実装
- E-06: `src/btree.c` - B-Treeストレージエンジン実装
- E-07: `src/pager.c` - トランザクション管理（ページャー）実装
- E-08: `src/wal.c` - WAL（Write-Ahead Logging）モード実装
- E-09: `src/backup.c` - オンラインバックアップAPI実装
- E-10: `src/trigger.c` - トリガー機能実装
- E-11: `src/fkey.c` - 外部キー制約実装
- E-12: `src/json.c` - JSON拡張機能実装
- E-13: `src/func.c` - 組み込み関数実装
- E-14: `src/select.c` - SELECT文処理実装
- E-15: `src/insert.c` - INSERT文処理実装
- E-16: `src/update.c` - UPDATE文処理実装
- E-17: `src/delete.c` - DELETE文処理実装
- E-18: `src/pragma.c` - PRAGMA文処理実装
- E-19: `src/vacuum.c` - VACUUM操作実装
- E-20: `src/attach.c` - ATTACH/DETACH操作実装
- E-21: `src/window.c` - ウィンドウ関数実装
- E-22: `ext/fts5/` - FTS5全文検索拡張
- E-23: `ext/rtree/` - R-Tree空間インデックス拡張
- E-24: `src/where.c` - クエリオプティマイザ実装
- E-25: `doc/` - 内部ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: 新規DB作成はsqlite3_open() APIで実現 | E-01, E-02 | ○ |
| C-02 | UAT-002: 既存DB接続はsqlite3_open_v2() APIで実現 | E-01, E-02 | ○ |
| C-03 | UAT-003: 読み取り専用モードはSQLITE_OPEN_READONLYフラグで実現 | E-01 | ○ |
| C-04 | UAT-004: CREATE TABLE文でテーブル作成が可能 | E-05, E-06 | ○ |
| C-05 | UAT-005: DROP TABLE文でテーブル削除が可能 | E-05 | ○ |
| C-06 | UAT-006: ALTER TABLEでカラム追加が可能 | E-05 | ○ |
| C-07 | UAT-007: INSERT文でデータ挿入が可能 | E-15 | ○ |
| C-08 | UAT-008: SELECT文でデータ参照が可能 | E-14 | ○ |
| C-09 | UAT-009: UPDATE文でデータ更新が可能 | E-16 | ○ |
| C-10 | UAT-010: DELETE文でデータ削除が可能 | E-17 | ○ |
| C-11 | UAT-011: BEGIN/COMMITでトランザクション制御が可能 | E-07 | ○ |
| C-12 | UAT-012: ROLLBACKでトランザクション取消が可能 | E-07 | ○ |
| C-13 | UAT-013: CREATE INDEXでインデックス作成が可能 | E-06 | ○ |
| C-14 | UAT-014: DROP INDEXでインデックス削除が可能 | E-06 | ○ |
| C-15 | UAT-015: PRIMARY KEY制約が機能する | E-06, E-11 | ○ |
| C-16 | UAT-016: FOREIGN KEY制約が機能する | E-11 | ○ |
| C-17 | UAT-017: NOT NULL制約が機能する | E-05 | ○ |
| C-18 | UAT-018: UNIQUE制約が機能する | E-05 | ○ |
| C-19 | UAT-019: CHECK制約が機能する | E-05 | ○ |
| C-20 | UAT-020: .dumpコマンドでSQLエクスポートが可能 | E-03 | ○ |
| C-21 | UAT-021: SQLファイルからリストアが可能 | E-03 | ○ |
| C-22 | UAT-022: CSVエクスポートが可能 | E-03 | ○ |
| C-23 | UAT-023: CSVインポートが可能 | E-03 | ○ |
| C-24 | UAT-024: FTS5全文検索が使用可能 | E-22 | ○ |
| C-25 | UAT-025: json_extract関数が使用可能 | E-12 | ○ |
| C-26 | UAT-026: json_object関数が使用可能 | E-12 | ○ |
| C-27 | UAT-027: CREATE VIEWでビュー作成が可能 | E-05 | ○ |
| C-28 | UAT-028: CREATE TRIGGERでトリガー作成が可能 | E-10 | ○ |
| C-29 | UAT-029: EXPLAIN QUERY PLANで実行計画確認が可能 | E-24 | ○ |
| C-30 | UAT-030: VACUUM操作でDB最適化が可能 | E-19 | ○ |
| C-31 | UAT-031: 複数セッションからの同時読み取りが可能 | E-08 | ○ |
| C-32 | UAT-032: 同時書き込み時にロック競合が発生する | E-07, E-08 | ○ |
| C-33 | UAT-033: WALモードが有効化可能 | E-08, E-18 | ○ |
| C-34 | UAT-034: WALチェックポイントが実行可能 | E-08 | ○ |
| C-35 | UAT-035: ATTACHで複数DB接続が可能 | E-20 | ○ |
| C-36 | UAT-036: sqlite_version()でバージョン確認が可能 | E-01, E-02 | ○ |
| C-37 | UAT-037: datetime関数が使用可能 | E-13 | ○ |
| C-38 | UAT-038: 集計関数（COUNT, AVG等）が使用可能 | E-13 | ○ |
| C-39 | UAT-039: 文字列関数（upper, lower等）が使用可能 | E-13 | ○ |
| C-40 | UAT-040: サブクエリが実行可能 | E-14 | ○ |
| C-41 | UAT-041: INNER JOINが実行可能 | E-14 | ○ |
| C-42 | UAT-042: LEFT JOINが実行可能 | E-14 | ○ |
| C-43 | UAT-043: INSERT OR REPLACEが実行可能 | E-15 | ○ |
| C-44 | UAT-044: ON CONFLICT句が使用可能 | E-15 | ○ |
| C-45 | UAT-045: ROW_NUMBER()等のウィンドウ関数が使用可能 | E-21 | ○ |
| C-46 | UAT-046: WITH句（CTE）が使用可能 | E-14 | ○ |
| C-47 | UAT-047: 再帰CTEが使用可能 | E-14 | ○ |
| C-48 | UAT-048: PRAGMA文で設定確認・変更が可能 | E-18 | ○ |
| C-49 | UAT-049: 構文エラー時に適切なエラーメッセージが返される | E-05 | ○ |
| C-50 | UAT-050: 存在しないテーブルアクセス時にエラーが返される | E-05 | ○ |
| C-51 | UAT-051: sqlite3_backup APIでオンラインバックアップが可能 | E-09 | △ |
| C-52 | UAT-052: 拡張機能のロードが可能 | **根拠不足** | △ |
| C-53 | UAT-053: :memory:でインメモリDBが使用可能 | E-01, E-02 | ○ |
| C-54 | UAT-054: 共有キャッシュモードが使用可能 | **根拠不足** | △ |
| C-55 | UAT-055: BLOBデータの読み書きが可能 | **根拠不足** | △ |
| C-56 | UAT-056: R-Tree拡張で空間インデックスが使用可能 | E-23 | △ |
| C-57 | UAT-057: PRAGMA integrity_checkで整合性検証が可能 | E-18 | ○ |
| C-58 | UAT-058: PRAGMA foreign_key_checkで外部キー検証が可能 | E-18 | ○ |
| C-59 | UAT-059: AUTOINCREMENTが正しく動作する | **根拠不足** | △ |
| C-60 | UAT-060: バッチモードでSQL実行が可能 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UAT-051 オンラインバックアップ**: backup.cにAPI実装は存在するが、具体的な使用例の詳細な手順はソースコードのコメントからの推測
  - 候補：SQLite公式ドキュメント / テストコード（test/backup.test）
- **UAT-052 拡張機能ロード**: loadext.cに実装は存在するが、プラットフォーム依存性と具体的な拡張ファイルの仕様が不明
  - 候補：ext/misc/内の拡張例 / SQLite公式ドキュメント
- **UAT-054 共有キャッシュモード**: ソースコード内にSQLITE_OPEN_SHAREDCACHEフラグは存在するが、マルチスレッド環境での動作確認方法の詳細が不足
  - 候補：test/thread*.test / SQLite公式ドキュメント
- **UAT-055 BLOBデータ操作**: vdbeblob.cにBLOB API実装は存在するが、CLIでのreadfile/writefile関数は拡張機能依存
  - 候補：ext/misc/fileio.c / SQLite公式ドキュメント
- **UAT-056 R-Tree拡張**: ext/rtree/に実装は存在するが、具体的な空間クエリの例が限定的
  - 候補：ext/rtree/rtree.h内のコメント / SQLite公式ドキュメント
- **UAT-059 AUTOINCREMENT**: 動作仕様はSQLite仕様として確立されているが、本リポジトリ内での明示的な仕様記述が見つからない
  - 候補：SQLite公式ドキュメント / test/autoinc.test

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**: 基本的なCRUD操作（UAT-001〜UAT-010）- SQLiteコア機能として安定
- **リスク0（低リスク）**: トランザクション制御（UAT-011〜UAT-012）- ACIDプロパティは十分にテスト済み
- **リスク0（低リスク）**: 制約チェック（UAT-015〜UAT-019）- 標準SQL機能
- **リスク1（中リスク）**: 拡張機能（UAT-024, UAT-052, UAT-056）- ビルドオプション依存
- **リスク1（中リスク）**: WALモード（UAT-033, UAT-034）- ファイルシステム依存性あり
- **リスク2（高リスク）**: 並行アクセス（UAT-031, UAT-032）- 環境依存性が高く、再現性確保が困難な場合あり
- **リスク2（高リスク）**: オンラインバックアップ（UAT-051）- 長時間実行処理でエラーハンドリングの確認が重要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの前提条件が現実的かどうか確認する
- [ ] 期待結果が具体的で検証可能かどうか確認する
- [ ] 優先度の割り当てが妥当かどうか確認する
- [ ] 拡張機能（FTS5, R-Tree, JSON）のビルドオプション依存性を確認する
- [ ] 並行アクセステスト（UAT-031, UAT-032）の環境要件を明確化する
- [ ] バックアップテスト（UAT-051）のエラーケースを追加検討する
- [ ] プラットフォーム固有の動作差異（Unix/Windows）を考慮する
- [ ] 根拠不足の8件（△マーク）について、追加調査または受け入れ判断を行う
