---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **BR-036 コンパイルオプション診断**：詳細なAPIドキュメントは外部サイトに依存
  2. **BR-054 トレースコールバック**：sqlite3_trace_v2の詳細仕様は外部ドキュメント参照

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.c` - SQLiteメインエントリポイント、初期化処理
- E-02: `src/sqlite.h.in` - 公開APIヘッダー定義
- E-03: `src/btree.c` - B-Treeストレージエンジン実装
- E-04: `src/pager.c` - ページキャッシュ・トランザクション管理
- E-05: `src/wal.c` - Write-Ahead Logging実装
- E-06: `src/select.c` - SELECT文処理
- E-07: `src/insert.c` - INSERT文処理
- E-08: `src/update.c` - UPDATE文処理
- E-09: `src/delete.c` - DELETE文処理
- E-10: `src/where.c` - クエリオプティマイザ
- E-11: `src/vdbe.c` - 仮想マシン実行エンジン
- E-12: `src/auth.c` - 認可コールバック
- E-13: `src/fkey.c` - 外部キー制約
- E-14: `src/vtab.c` - 仮想テーブル
- E-15: `src/json.c` - JSON関数
- E-16: `src/pragma.c` - PRAGMA処理
- E-17: `src/attach.c` - ATTACH/DETACH処理
- E-18: `src/alter.c` - ALTER TABLE処理
- E-19: `src/build.c` - スキーマ構築
- E-20: `src/func.c` - 組み込み関数
- E-21: `src/date.c` - 日付時刻関数
- E-22: `src/utf.c` - Unicode処理
- E-23: `src/malloc.c` - メモリ管理
- E-24: `src/prepare.c` - ステートメント準備
- E-25: `src/analyze.c` - 統計情報収集
- E-26: `ext/fts5/` - FTS5全文検索拡張
- E-27: `ext/fts3/` - FTS3/FTS4全文検索拡張
- E-28: `ext/rtree/rtree.c` - R-Tree空間インデックス
- E-29: `ext/rtree/geopoly.c` - Geopoly地理空間機能
- E-30: `ext/rtree/README` - R-Tree拡張ドキュメント
- E-31: `ext/fts5/fts5.h` - FTS5 APIヘッダー
- E-32: `ext/misc/csv.c` - CSV仮想テーブル
- E-33: `ext/misc/fileio.c` - ファイルI/O関数
- E-34: `ext/misc/base64.c` - Base64エンコーディング
- E-35: `ext/misc/decimal.c` - Decimal精度計算
- E-36: `src/os_unix.c` - Unix VFS実装
- E-37: `src/os_win.c` - Windows VFS実装（存在確認）
- E-38: `src/mutex.c` - ミューテックス管理
- E-39: `src/loadext.c` - 動的拡張ロード
- E-40: `src/callback.c` - コールバック・照合順序
- E-41: `README.md` - プロジェクト概要ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (BR-001) | データベース接続管理 | E-01, E-02 | ○ |
| C-02 (BR-002) | 複数データベース接続 | E-17 | ○ |
| C-03 (BR-003) | SQLステートメント解析 | E-41（parse.y記述） | ○ |
| C-04 (BR-004) | クエリ最適化 | E-10 | ○ |
| C-05 (BR-005) | SQL実行エンジン | E-11 | ○ |
| C-06 (BR-006) | SELECT文実行 | E-06 | ○ |
| C-07 (BR-007) | INSERT文実行 | E-07 | ○ |
| C-08 (BR-008) | UPDATE文実行 | E-08 | ○ |
| C-09 (BR-009) | DELETE文実行 | E-09 | ○ |
| C-10 (BR-010) | B-Treeストレージ管理 | E-03 | ○ |
| C-11 (BR-011) | ページキャッシュ管理 | E-04 | ○ |
| C-12 (BR-012) | ACID特性保証 | E-04, E-05 | ○ |
| C-13 (BR-013) | ロールバックジャーナル | E-04 | ○ |
| C-14 (BR-014) | WAL（Write-Ahead Logging） | E-05 | ○ |
| C-15 (BR-015) | セーブポイント管理 | E-04 | ○ |
| C-16 (BR-016) | ファイルロック制御 | E-36 | ○ |
| C-17 (BR-017) | 共有キャッシュ | E-03 | ○ |
| C-18 (BR-018) | テーブル作成・削除 | E-19 | ○ |
| C-19 (BR-019) | インデックス管理 | E-19 | ○ |
| C-20 (BR-020) | テーブル変更 | E-18 | ○ |
| C-21 (BR-021) | ビュー管理 | E-19 | ○ |
| C-22 (BR-022) | トリガー管理 | E-19 | ○ |
| C-23 (BR-023) | 外部キー制約 | E-13 | ○ |
| C-24 (BR-024) | CHECK制約 | E-19 | ○ |
| C-25 (BR-025) | UNIQUE制約 | E-19 | ○ |
| C-26 (BR-026) | NOT NULL制約 | E-19 | ○ |
| C-27 (BR-027) | 認可コールバック | E-12 | ○ |
| C-28 (BR-028) | 信頼スキーマ制御 | E-16 | ○ |
| C-29 (BR-029) | FTS5全文検索 | E-26, E-31 | ○ |
| C-30 (BR-030) | FTS3/FTS4全文検索 | E-27 | ○ |
| C-31 (BR-031) | R-Tree空間インデックス | E-28, E-30 | ○ |
| C-32 (BR-032) | Geopoly地理空間機能 | E-29 | ○ |
| C-33 (BR-033) | JSON関数群 | E-15 | ○ |
| C-34 (BR-034) | JSONB形式 | E-15 | ○ |
| C-35 (BR-035) | PRAGMA設定 | E-16 | ○ |
| C-36 (BR-036) | コンパイルオプション診断 | **根拠不足** | △ |
| C-37 (BR-037) | 仮想テーブル | E-14 | ○ |
| C-38 (BR-038) | ユーザー定義関数 | E-20, E-02 | ○ |
| C-39 (BR-039) | 照合順序カスタマイズ | E-40 | ○ |
| C-40 (BR-040) | 動的拡張ロード | E-39 | ○ |
| C-41 (BR-041) | 日付時刻関数 | E-21 | ○ |
| C-42 (BR-042) | 数学関数 | E-20 | ○ |
| C-43 (BR-043) | 文字列関数 | E-20 | ○ |
| C-44 (BR-044) | 集計関数 | E-20 | ○ |
| C-45 (BR-045) | メモリ管理 | E-23 | ○ |
| C-46 (BR-046) | プリペアドステートメント | E-24 | ○ |
| C-47 (BR-047) | 統計情報収集 | E-25 | ○ |
| C-48 (BR-048) | バックアップAPI | E-02 | ○ |
| C-49 (BR-049) | データベース整合性チェック | E-16 | ○ |
| C-50 (BR-050) | VACUUM処理 | E-41 | ○ |
| C-51 (BR-051) | Unicode対応 | E-22 | ○ |
| C-52 (BR-052) | 照合順序 | E-40 | ○ |
| C-53 (BR-053) | EXPLAIN機能 | E-11 | ○ |
| C-54 (BR-054) | トレースコールバック | **根拠不足** | △ |
| C-55 (BR-055) | スレッドセーフモード | E-38, E-01 | ○ |
| C-56 (BR-056) | CSV仮想テーブル | E-32 | ○ |
| C-57 (BR-057) | ファイルI/O関数 | E-33 | ○ |
| C-58 (BR-058) | Base64/Base85エンコーディング | E-34 | ○ |
| C-59 (BR-059) | Decimal精度計算 | E-35 | ○ |
| C-60 (BR-060) | 仮想ファイルシステム | E-36, E-37 | ○ |

## 4) 不足情報（Unknown / Missing）
- **BR-036 コンパイルオプション診断**：sqlite3_compileoption_used()、sqlite3_compileoption_get()のAPI詳細はsqlite.h.inに定義があるが、具体的な実装詳細は別ファイル（global.c等）に分散している可能性がある
  - 候補：`src/global.c` / `src/ctime.c` / 外部ドキュメント（sqlite.org）
- **BR-054 トレースコールバック**：sqlite3_trace_v2()の詳細仕様は公開APIヘッダーに記載されているが、実装詳細の確認が必要
  - 候補：`src/main.c` / `src/vdbeapi.c` / 外部ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分の要件はソースコードと直接対応しており、信頼性が高い
- **1: 中リスク** - 一部の拡張機能（ext/misc/配下）は、プロジェクトの主要機能ではなくオプション扱い。実際の使用状況を確認する必要がある
- **1: 中リスク** - コンパイルオプションにより機能の有効/無効が切り替わるため、ビルド構成に依存する要件が存在する（例：SQLITE_OMIT_*マクロ）

## 6) レビュアーチェックリスト（最小）
- [ ] BR-001〜BR-015（コアデータベース機能）の要件が実際の運用要件と整合しているか確認
- [ ] BR-023（外部キー制約）がPRAGMA foreign_keys設定と連動して正しく動作するか確認
- [ ] BR-029〜BR-032（全文検索・空間検索）の拡張機能が必要かどうか確認
- [ ] BR-033〜BR-034（JSON機能）のバージョン要件を確認（3.45.0以降でJSONB対応）
- [ ] BR-055（スレッドセーフモード）のコンパイル設定が運用環境と整合しているか確認
- [ ] 拡張モジュール（BR-056〜BR-059）の必要性と有効化状況を確認
