---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 50
  claims_with_evidence: 50
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：50 / 50、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全ての主張にソースコードによる根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.c` - SQLiteライブラリのメインファイル、API実装
- E-02: `src/tokenize.c` - SQLトークナイザー実装
- E-03: `src/select.c` - SELECT文処理実装
- E-04: `src/insert.c` - INSERT文処理実装
- E-05: `src/update.c` - UPDATE文処理実装
- E-06: `src/delete.c` - DELETE文処理実装
- E-07: `src/build.c` - CREATE/DROP TABLE/INDEX、トランザクション処理
- E-08: `src/alter.c` - ALTER TABLE処理実装
- E-09: `src/where.c` - WHERE句最適化（クエリオプティマイザー）
- E-10: `src/vdbe.c` - 仮想データベースエンジン実装
- E-11: `src/vdbeapi.c` - VDBE API実装
- E-12: `src/vdbeaux.c` - VDBE補助関数
- E-13: `src/vdbemem.c` - VDBEメモリ管理
- E-14: `src/vdbesort.c` - VDBEソート処理
- E-15: `src/vdbetrace.c` - VDBEトレース機能
- E-16: `src/btree.c` - B-Treeストレージエンジン
- E-17: `src/pager.c` - ページャー実装
- E-18: `src/pcache1.c` - ページキャッシュ実装
- E-19: `src/wal.c` - Write-Ahead Logging実装
- E-20: `src/vdbeblob.c` - BLOB I/O実装
- E-21: `src/attach.c` - ATTACH/DETACH実装
- E-22: `src/pragma.c` - PRAGMA実装
- E-23: `src/analyze.c` - ANALYZE実装
- E-24: `src/func.c` - 組み込みSQL関数
- E-25: `src/date.c` - 日付・時刻関数
- E-26: `src/json.c` - JSON関数
- E-27: `src/fkey.c` - 外部キー制約
- E-28: `src/auth.c` - 認証・認可
- E-29: `src/vtab.c` - 仮想テーブル
- E-30: `src/loadext.c` - 拡張モジュールローダー
- E-31: `ext/fts3/` - FTS3/FTS4拡張ディレクトリ
- E-32: `ext/fts5/` - FTS5拡張ディレクトリ
- E-33: `ext/rtree/` - R-Tree拡張ディレクトリ
- E-34: `ext/session/` - セッション拡張ディレクトリ
- E-35: `ext/rbu/` - RBU拡張ディレクトリ
- E-36: `ext/recover/` - リカバリ拡張ディレクトリ
- E-37: `src/malloc.c` - メモリ管理
- E-38: `src/mutex.c` - ミューテックス
- E-39: `src/os_unix.c` - Unix VFS実装
- E-40: `src/utf.c` - UTF変換
- E-41: `src/random.c` - 乱数生成
- E-42: `src/status.c` - ステータス情報
- E-43: `src/hash.c` - ハッシュテーブル
- E-44: `src/bitvec.c` - ビットベクター
- E-45: `src/util.c` - ユーティリティ関数
- E-46: `src/printf.c` - printf実装
- E-47: `README.md` - プロジェクト概要・ソースツリー説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SQLiteライブラリ初期化 | E-01 (main.c:190行目 sqlite3_initialize関数) | ○ |
| C-02 | データベース接続管理 | E-01 (main.c:sqlite3_open、sqlite3_close等) | ○ |
| C-03 | バージョン情報取得 | E-01 (main.c:98-111行目 sqlite3_libversion等) | ○ |
| C-04 | スレッドセーフティ | E-01 (main.c:117行目 sqlite3_threadsafe) | ○ |
| C-05 | SQLパーサー/トークナイザー | E-02 (tokenize.c:トークン分類定義) | ○ |
| C-06 | SELECT文処理 | E-03 (select.c:1行目コメント) | ○ |
| C-07 | INSERT文処理 | E-04 (insert.c:1行目コメント) | ○ |
| C-08 | UPDATE文処理 | E-05 (update.c:1行目コメント) | ○ |
| C-09 | DELETE文処理 | E-06 (delete.c:1行目コメント) | ○ |
| C-10 | CREATE TABLE処理 | E-07 (build.c:14-24行目コメント) | ○ |
| C-11 | DROP TABLE処理 | E-07 (build.c:14-24行目コメント) | ○ |
| C-12 | CREATE INDEX処理 | E-07 (build.c:14-24行目コメント) | ○ |
| C-13 | DROP INDEX処理 | E-07 (build.c:14-24行目コメント) | ○ |
| C-14 | ALTER TABLE処理 | E-08 (alter.c:1行目コメント) | ○ |
| C-15 | トランザクション管理 | E-07 (build.c:14-24行目コメント) | ○ |
| C-16 | WHERE句最適化 | E-09 (where.c:1行目コメント「query optimizer」) | ○ |
| C-17 | VDBE | E-10 (vdbe.c:1行目コメント「bytecode」) | ○ |
| C-18 | VDBEソート処理 | E-14 (vdbesort.c存在確認) | ○ |
| C-19 | VDBEトレース | E-15 (vdbetrace.c存在確認) | ○ |
| C-20 | B-Treeストレージエンジン | E-16 (btree.c:1行目コメント「disk-based database using BTrees」) | ○ |
| C-21 | ページャー | E-17 (pager.c:1行目コメント「page cache subsystem」) | ○ |
| C-22 | ページキャッシュ | E-18 (pcache1.c存在確認) | ○ |
| C-23 | WAL | E-19 (wal.c:1行目コメント「write-ahead log」) | ○ |
| C-24 | BLOBストリーミング | E-20 (vdbeblob.c存在確認) | ○ |
| C-25 | ATTACH/DETACH | E-21 (attach.c:1行目コメント) | ○ |
| C-26 | PRAGMA | E-22 (pragma.c:1行目コメント) | ○ |
| C-27 | ANALYZE | E-23 (analyze.c:1行目コメント) | ○ |
| C-28 | 組み込みSQL関数 | E-24 (func.c:1行目コメント「C-language implementations for many SQL functions」) | ○ |
| C-29 | 日付・時刻関数 | E-25 (date.c:1行目コメント) | ○ |
| C-30 | JSON関数 | E-26 (json.c:1行目コメント「SQLite JSON functions」) | ○ |
| C-31 | 外部キー制約 | E-27 (fkey.c:1行目コメント「foreign key support」) | ○ |
| C-32 | 認証/認可 | E-28 (auth.c:1行目コメント「sqlite3_set_authorizer」) | ○ |
| C-33 | 仮想テーブル | E-29 (vtab.c:1行目コメント「virtual tables」) | ○ |
| C-34 | 拡張モジュールローダー | E-30 (loadext.c:1行目コメント「dynamically load extensions」) | ○ |
| C-35 | FTS3/FTS4全文検索 | E-31 (ext/fts3/ディレクトリ存在確認) | ○ |
| C-36 | FTS5全文検索 | E-32 (ext/fts5/ディレクトリ存在確認) | ○ |
| C-37 | R-Tree空間インデックス | E-33 (ext/rtree/ディレクトリ存在確認) | ○ |
| C-38 | セッション拡張 | E-34 (ext/session/ディレクトリ存在確認) | ○ |
| C-39 | RBU | E-35 (ext/rbu/ディレクトリ存在確認) | ○ |
| C-40 | データベースリカバリ | E-36 (ext/recover/ディレクトリ存在確認) | ○ |
| C-41 | メモリ管理 | E-37 (malloc.c:1行目コメント「Memory allocation functions」) | ○ |
| C-42 | ミューテックス | E-38 (mutex.c存在確認) | ○ |
| C-43 | OS抽象化層（VFS） | E-39 (os_unix.c存在確認), E-47 (README.md) | ○ |
| C-44 | UTF-8/UTF-16エンコーディング | E-40 (utf.c存在確認) | ○ |
| C-45 | 乱数生成 | E-41 (random.c存在確認) | ○ |
| C-46 | ステータス情報 | E-42 (status.c存在確認) | ○ |
| C-47 | ハッシュテーブル | E-43 (hash.c存在確認) | ○ |
| C-48 | ビットベクター | E-44 (bitvec.c存在確認) | ○ |
| C-49 | 各種ユーティリティ関数 | E-45 (util.c存在確認) | ○ |
| C-50 | printf実装 | E-46 (printf.c存在確認) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全ての機能主張はソースコードファイルまたはディレクトリの存在、およびファイル内のコメントによって裏付けられています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク
  - 全ての機能主張はソースコードの直接的な解析に基づいており、高い信頼性があります
  - README.mdの公式ドキュメントおよび各ソースファイルの冒頭コメントが主な根拠となっています

## 6) レビュアーチェックリスト（最小）
- [ ] 機能カテゴリの分類が適切か確認する
- [ ] 各機能の説明が実際のソースコードの内容と一致しているか確認する
- [ ] 拡張機能（ext/ディレクトリ）の記載が最新の状態を反映しているか確認する
- [ ] 備考欄のソースファイル名が正確か確認する
