# 機能設計書 17-VDBE（仮想データベースエンジン）

## 概要

本ドキュメントは、SQLiteにおけるVDBE（Virtual Database Engine）機能について記述する。VDBEは、SQL文をコンパイルして生成されたバイトコードを実行するインタープリターであり、SQLiteの実行エンジンの中核を担う。

### 本機能の処理概要

**業務上の目的・背景**：SQLiteはSQL文を直接実行せず、一度バイトコード（VDBEプログラム）にコンパイルしてから実行する。このアーキテクチャにより、プリペアドステートメントの再利用、効率的なメモリ管理、移植性の高い実行環境を実現している。VDBEは約170種類のオペコードをサポートし、データベース操作のあらゆる側面を制御する。

**機能の利用シーン**：
- すべてのSQL文の実行
- プリペアドステートメントの再実行
- トランザクション制御
- カーソル操作（B-Tree走査）
- 集約関数の計算

**主要な処理内容**：
1. VDBEプログラム（バイトコード配列）の実行
2. レジスタ（Mem構造体）でのデータ操作
3. カーソル管理（テーブル/インデックスへのアクセス）
4. 関数呼び出し（組み込み関数、ユーザー定義関数）
5. 比較・演算処理
6. 制御フロー（ジャンプ、ループ）
7. 結果行の返却

**関連システム・外部連携**：B-Treeストレージエンジン、ページャー、メモリアロケーター

**権限による制御**：sqlite3_set_authorizer()は SQL解析時に呼ばれ、VDBEプログラム生成を制御

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | Speedtest1（メインスレッド版） | 主機能 | ベンチマーク対象のVDBE実行 |
| 10 | Speedtest1（Worker版） | 主機能 | Worker内でのVDBE実行ベンチマーク |

## 機能種別

バイトコードインタープリター / 実行エンジン

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| p | Vdbe* | Yes | VDBEプログラム | 有効なプログラム |

### 入力データソース

- VDBEプログラム（Op構造体の配列）
- バインド変数（sqlite3_bind_*で設定）
- データベースファイル（B-Tree経由）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | int | 実行結果（SQLITE_ROW/SQLITE_DONE/エラーコード） |
| 結果行 | Mem[] | SELECT結果のレジスタ |

### 出力先

- 呼び出し元（結果行データ）
- データベースファイル（INSERT/UPDATE/DELETE時）

## 処理フロー

### 処理シーケンス

```
1. 実行準備
   └─ カーソル、レジスタの初期化確認

2. メインループ開始
   └─ プログラムカウンタ（pc）からオペコード取得

3. オペコード実行
   └─ switch文で各オペコードにディスパッチ
   └─ オペコード固有の処理実行

4. 次命令への移行
   └─ pc++（通常）またはジャンプ先pcへ

5. 終了条件チェック
   └─ OP_Halt: 実行終了
   └─ OP_ResultRow: 結果行返却（SQLITE_ROW）
   └─ エラー発生: エラーコード返却

6. クリーンアップ
   └─ カーソルクローズ
   └─ メモリ解放
```

### フローチャート

```mermaid
flowchart TD
    A[VDBE実行開始] --> B[実行準備]
    B --> C{オペコード取得}
    C --> D[オペコード実行]
    D --> E{実行結果}
    E -->|継続| F[pc更新]
    F --> C
    E -->|OP_ResultRow| G[SQLITE_ROW返却]
    G --> H[呼び出し元へ]
    E -->|OP_Halt| I[SQLITE_DONE返却]
    I --> J[クリーンアップ]
    E -->|エラー| K[エラーコード返却]
    K --> J
    J --> Z[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-17-01 | レジスタベース | VDBEはレジスタマシンとして動作 | 常時 |
| BR-17-02 | 型アフィニティ | Mem構造体でSQLiteの動的型を表現 | 常時 |
| BR-17-03 | カーソル管理 | 各テーブル/インデックスに対してカーソルを使用 | DB操作時 |
| BR-17-04 | 中断可能 | sqlite3_interrupt()で実行中断可能 | 常時 |
| BR-17-05 | 進捗コールバック | sqlite3_progress_handler()で定期コールバック | 設定時 |

### 計算ロジック

**オペコードディスパッチ**: switch文による直接ジャンプ（コンパイラ最適化によりジャンプテーブル化）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象 | 操作種別 | 概要 |
|-----|-----|---------|------|
| OP_OpenRead | B-Tree | カーソルオープン | 読み取り用カーソル |
| OP_OpenWrite | B-Tree | カーソルオープン | 書き込み用カーソル |
| OP_Insert | B-Tree | 行挿入 | レコード挿入 |
| OP_Delete | B-Tree | 行削除 | レコード削除 |
| OP_SeekXX | B-Tree | シーク | カーソル位置決め |
| OP_Next/Prev | B-Tree | 移動 | カーソル移動 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| SQLITE_INTERRUPT | 中断 | sqlite3_interrupt()呼び出し | 再実行または破棄 |
| SQLITE_BUSY | ロック | データベースロック | リトライ |
| SQLITE_CONSTRAINT | 制約違反 | UNIQUE/CHECK/FK違反 | データ修正 |
| SQLITE_MISMATCH | 型不一致 | データ型エラー | データ確認 |
| SQLITE_ABORT | アボート | RAISE(ABORT,...)実行 | トランザクション確認 |

### リトライ仕様

SQLITE_BUSYの場合、busy handlerの設定に従ってリトライ。

## トランザクション仕様

- OP_Transactionでトランザクション開始
- OP_AutoCommitで自動コミット制御
- OP_Savepointでセーブポイント管理

## パフォーマンス要件

- オペコードディスパッチは数ナノ秒
- 全体性能はI/O（B-Tree操作）に依存
- インメモリDBでは高速動作

## セキュリティ考慮事項

- VDBEプログラムは内部生成のため、直接的なインジェクションリスクなし
- sqlite3_limit()でリソース制限可能

## 備考

- PRAGMA vdbe_trace=ON でVDBE実行トレース出力
- sqlite3_stmt_status()で実行統計取得可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | vdbeInt.h | `src/vdbeInt.h` | Vdbe構造体、Mem構造体、VdbeCursor構造体 |
| 1-2 | vdbe.h | `src/vdbe.h` | オペコード定義 |

**読解のコツ**:
- Vdbe: VDBEプログラム全体を表す構造体（Op配列、レジスタ配列等）
- Mem: レジスタの値を表す構造体（整数/実数/文字列/BLOB/NULL）
- VdbeCursor: B-Treeカーソルのラッパー

#### Step 2: 実行エンジンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | vdbe.c | `src/vdbe.c` | sqlite3VdbeExec()がメイン実行ループ |

**主要処理フロー**:
1. **実行ループ**: switch(pOp->opcode)で各オペコードにディスパッチ
2. **OP_Init**: プログラム開始
3. **OP_Goto**: 無条件ジャンプ
4. **OP_Column**: 列値取得
5. **OP_ResultRow**: 結果行返却
6. **OP_Halt**: プログラム終了

#### Step 3: 補助関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | vdbeaux.c | `src/vdbeaux.c` | VDBEプログラム構築、準備、クリーンアップ |
| 3-2 | vdbeapi.c | `src/vdbeapi.c` | 公開API（sqlite3_step等） |
| 3-3 | vdbemem.c | `src/vdbemem.c` | Mem構造体の操作関数 |

### プログラム呼び出し階層図

```
sqlite3_step() [vdbeapi.c]
    │
    └─ sqlite3VdbeExec() [vdbe.c]
           │
           ├─ (メインループ)
           │      switch(pOp->opcode)
           │
           ├─ OP_Init
           │      └─ 初期化処理
           │
           ├─ OP_Transaction
           │      └─ sqlite3BtreeBeginTrans()
           │
           ├─ OP_OpenRead/OpenWrite
           │      └─ sqlite3BtreeCursor()
           │
           ├─ OP_SeekXX
           │      └─ sqlite3BtreeMovetoUnpacked()
           │
           ├─ OP_Column
           │      └─ sqlite3VdbeSerialGet()
           │
           ├─ OP_ResultRow
           │      └─ SQLITE_ROW返却
           │
           ├─ OP_Insert
           │      └─ sqlite3BtreeInsert()
           │
           ├─ OP_Delete
           │      └─ sqlite3BtreeDelete()
           │
           └─ OP_Halt
                  └─ 終了処理
```

### データフロー図

```
[入力]                       [処理]                      [出力]

VDBEプログラム ─────▶ sqlite3VdbeExec()
(Op配列)                      │
                              ▼
                      ┌───────┴───────┐
                      ▼               ▼
              オペコード取得     レジスタ参照
                      │               │
                      ▼               ▼
              switch dispatch    Mem操作
                      │               │
                      └───────┬───────┘
                              ▼
                ┌─────────────┼─────────────┐
                ▼             ▼             ▼
           B-Tree操作    関数呼び出し   制御フロー
                │             │             │
                └─────────────┼─────────────┘
                              ▼
                      結果/継続/終了 ──────▶ 呼び出し元
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| vdbe.c | `src/vdbe.c` | ソース | メイン実行エンジン、sqlite3VdbeExec() |
| vdbeapi.c | `src/vdbeapi.c` | ソース | 公開API、sqlite3_step()等 |
| vdbeaux.c | `src/vdbeaux.c` | ソース | プログラム構築、準備、クリーンアップ |
| vdbemem.c | `src/vdbemem.c` | ソース | Mem構造体操作 |
| vdbeInt.h | `src/vdbeInt.h` | ヘッダー | 内部データ構造定義 |
| vdbe.h | `src/vdbe.h` | ヘッダー | オペコード定義、公開インターフェース |
| btree.c | `src/btree.c` | ソース | B-Tree操作（VDBEから呼び出される） |
