# 機能設計書 3-バージョン情報取得

## 概要

本ドキュメントは、SQLiteライブラリのバージョン情報を取得するための機能について、その設計と実装の詳細を記述する。sqlite3_version定数、sqlite3_libversion()、sqlite3_libversion_number()、sqlite3_sourceid()関数によるバージョン情報提供の仕組みについて解説する。

### 本機能の処理概要

**業務上の目的・背景**：SQLiteを使用するアプリケーションは、実行時に使用しているSQLiteのバージョンを確認することで、機能の可用性確認、デバッグ、互換性チェックなどを行う必要がある。また、開発者はビルドに使用したヘッダーファイルとリンクされたライブラリのバージョンが一致しているか確認できる。

**機能の利用シーン**：
- アプリケーション起動時のバージョン確認と表示
- 特定機能が利用可能かどうかのバージョンチェック
- デバッグ・トラブルシューティング時の環境情報収集
- バグレポート作成時のバージョン情報記録
- ヘッダーファイルとライブラリの整合性チェック
- WASMテストページでのバージョン表示

**主要な処理内容**：
1. sqlite3_version定数によるバージョン文字列の提供
2. sqlite3_libversion()によるバージョン文字列ポインタの返却
3. sqlite3_libversion_number()による数値形式バージョンの返却
4. sqlite3_sourceid()によるソースコード識別子の返却

**関連システム・外部連携**：
- コンパイル時定数SQLITE_VERSION、SQLITE_VERSION_NUMBER、SQLITE_SOURCE_IDとの連携
- sqlite3.hヘッダーファイルで定義されるマクロとの整合性

**権限による制御**：本機能に権限制御は存在しない。任意のコードから呼び出し可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | WASM テストページインデックス | 補助画面 | テストページ一覧でのバージョン確認 |
| 3 | 基本デモ（UIスレッド版） | 補助画面 | capi.sqlite3_libversion()でのバージョン表示 |
| 12 | Tester1（メインスレッド版） | 補助画面 | テスト実行時のバージョン確認 |
| 19 | モジュールシンボル一覧 | 主画面 | sqlite3.version情報の表示 |

## 機能種別

情報取得機能（読み取り専用）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| （なし） | - | - | 全関数は引数を取らない | - |

### 入力データソース

- コンパイル時に埋め込まれた定数値（SQLITE_VERSION、SQLITE_VERSION_NUMBER、SQLITE_SOURCE_ID）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sqlite3_version | const char[] | バージョン文字列（例："3.46.0"） |
| sqlite3_libversion()戻り値 | const char* | sqlite3_versionへのポインタ |
| sqlite3_libversion_number()戻り値 | int | バージョン番号（例：3046000） |
| sqlite3_sourceid()戻り値 | const char* | ソースID文字列 |

### 出力先

- 呼び出し元への戻り値

## 処理フロー

### 処理シーケンス

```
sqlite3_version定数:
1. コンパイル時にSQLITE_VERSIONマクロの値で初期化
   └─ 静的領域に格納された文字列定数

sqlite3_libversion():
1. sqlite3_version配列へのポインタを返却
   └─ 単純な戻り値返却（計算なし）

sqlite3_libversion_number():
1. SQLITE_VERSION_NUMBERマクロの値を返却
   └─ 単純な戻り値返却（計算なし）

sqlite3_sourceid():
1. SQLITE_SOURCE_IDマクロの値（文字列）を返却
   └─ 単純な戻り値返却（計算なし）
```

### フローチャート

```mermaid
flowchart TD
    A[バージョン情報要求] --> B{取得方法}
    B -->|文字列| C[sqlite3_libversion]
    B -->|数値| D[sqlite3_libversion_number]
    B -->|ソースID| E[sqlite3_sourceid]
    B -->|直接参照| F[sqlite3_version]
    C --> G[バージョン文字列返却]
    D --> H[バージョン番号返却]
    E --> I[ソースID返却]
    F --> J[文字列定数参照]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | バージョン番号形式 | X*1000000 + Y*1000 + Z形式（X.Y.Z） | 常時 |
| BR-002 | ソースID形式 | "YYYY-MM-DD HH:MM:SS commit-hash"形式 | 常時 |
| BR-003 | ヘッダー/ライブラリ整合性 | SQLITE_VERSION_NUMBER == sqlite3_libversion_number()で確認可能 | ビルド検証時 |
| BR-004 | 定数の不変性 | 返却される値は実行中に変化しない | 常時 |

### 計算ロジック

**バージョン番号の計算（SQLITE_VERSION_NUMBER）**:
```
バージョン番号 = メジャー * 1000000 + マイナー * 1000 + パッチ

例: バージョン 3.46.0 の場合
  = 3 * 1000000 + 46 * 1000 + 0
  = 3000000 + 46000 + 0
  = 3046000
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない（情報取得のみ）。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

本機能はエラーを発生させない。全ての関数は常に有効な値を返却する。

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| （なし） | - | - | - |

### リトライ仕様

リトライは不要（エラーが発生しない）。

## トランザクション仕様

本機能はトランザクション処理を伴わない。

## パフォーマンス要件

- 全関数は定数値を返却するのみで、実質的にオーバーヘッドなし
- 関数呼び出しのコストは数ナノ秒程度

## セキュリティ考慮事項

- バージョン情報の公開自体にセキュリティ上の問題はない
- ただし、攻撃者がバージョン情報を利用して既知の脆弱性を狙う可能性があるため、本番環境でのバージョン情報の外部公開は慎重に検討する

## 備考

- sqlite3_version定数は、アマルガメーション（単一ファイル）ビルドとマルチファイルビルドで定義場所が異なる
- SQLITE_AMの定義有無によりexternキーワードの扱いが変わる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 定数定義を理解する

まず、バージョン情報の定数がどこで定義されているかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | sqlite3.h | `src/sqlite3.h` | SQLITE_VERSION、SQLITE_VERSION_NUMBER、SQLITE_SOURCE_IDマクロの定義 |
| 1-2 | sqliteInt.h | `src/sqliteInt.h` | 内部での定数参照方法 |

**読解のコツ**: sqlite3.hはSQLiteの公開APIヘッダーで、全てのバージョン関連マクロがここで定義される。マクロ値はビルド時に自動生成される。

#### Step 2: 実装を理解する

バージョン取得関数の実装を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.c | `src/main.c` | sqlite3_version、sqlite3_libversion()、sqlite3_libversion_number()、sqlite3_sourceid()の実装 |

**主要処理フロー**:
1. **89-92行目**: sqlite3_version定数の定義（SQLITE_AMALGAMATION未定義時）
2. **95-98行目**: sqlite3_libversion()の実装（sqlite3_versionを返却）
3. **100-106行目**: sqlite3_sourceid()の実装（SQLITE_SOURCE_IDを返却）
4. **108-111行目**: sqlite3_libversion_number()の実装（SQLITE_VERSION_NUMBERを返却）

#### Step 3: 条件付きコンパイルを理解する

アマルガメーションビルドとの違いを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.c | `src/main.c` | #ifndef SQLITE_AMの制御 |

**主要処理フロー**:
- **88行目**: #ifndef SQLITE_AMALGAMATION による条件分岐
- アマルガメーションビルドでは別の場所で定義される

### プログラム呼び出し階層図

```
sqlite3_libversion()              [main.c:98]
    └─ sqlite3_version            [main.c:92]
           └─ SQLITE_VERSION      [sqlite3.h]

sqlite3_libversion_number()       [main.c:111]
    └─ SQLITE_VERSION_NUMBER      [sqlite3.h]

sqlite3_sourceid()                [main.c:106]
    └─ SQLITE_SOURCE_ID           [sqlite3.h]
```

### データフロー図

```
[コンパイル時]                    [実行時]

SQLITE_VERSION ──────▶ sqlite3_version ──────▶ sqlite3_libversion()
(マクロ)                 (定数配列)              (関数)
                                                    │
                                                    ▼
                                             const char* 戻り値

SQLITE_VERSION_NUMBER ──────────────────────▶ sqlite3_libversion_number()
(マクロ)                                            │
                                                    ▼
                                                 int 戻り値

SQLITE_SOURCE_ID ───────────────────────────▶ sqlite3_sourceid()
(マクロ)                                            │
                                                    ▼
                                             const char* 戻り値
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.c | `src/main.c` | ソース | バージョン取得関数の実装 |
| sqlite3.h | `src/sqlite3.h` | ヘッダー | バージョンマクロの定義、公開API宣言 |
| sqliteInt.h | `src/sqliteInt.h` | ヘッダー | 内部ヘッダー（マクロ参照） |
