# 機能設計書 4-スレッドセーフティ

## 概要

本ドキュメントは、SQLiteのスレッドセーフティモードを確認する機能について、その設計と実装の詳細を記述する。sqlite3_threadsafe()関数によるスレッドセーフモード確認機能、およびSQLiteのスレッディングモデルについて解説する。

### 本機能の処理概要

**業務上の目的・背景**：マルチスレッド環境でSQLiteを使用するアプリケーションは、ライブラリがどのスレッドセーフティモードでコンパイルされているかを確認する必要がある。これにより、適切な同期処理の実装や、スレッド間でのデータベース接続の共有方針を決定できる。

**機能の利用シーン**：
- マルチスレッドアプリケーションの初期化時にスレッドセーフモードを確認
- デバッグ時にSQLiteのビルド設定を確認
- 条件分岐によるスレッド同期処理の有無を決定
- WASMモジュールでのコンパイルオプション確認

**主要な処理内容**：
1. sqlite3_threadsafe()関数によるSQLITE_THREADSAFE定数の返却
2. スレッドセーフティモード（0、1、2）の判定

**関連システム・外部連携**：
- コンパイル時定数SQLITE_THREADSAFEとの連携
- ミューテックスサブシステム（mutex.c）との連携

**権限による制御**：本機能に権限制御は存在しない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | モジュールシンボル一覧 | 補助画面 | コンパイルオプションの確認表示 |

## 機能種別

情報取得機能（読み取り専用）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| （なし） | - | - | sqlite3_threadsafe()は引数を取らない | - |

### 入力データソース

- コンパイル時に決定されたSQLITE_THREADSAFE定数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 戻り値 | int | 0：シングルスレッド、1：シリアライズ、2：マルチスレッド |

### 出力先

- 呼び出し元への戻り値

## 処理フロー

### 処理シーケンス

```
1. SQLITE_THREADSAFE定数の値を返却
   └─ 単純な戻り値返却（計算なし）
```

### フローチャート

```mermaid
flowchart TD
    A[sqlite3_threadsafe呼び出し] --> B[SQLITE_THREADSAFE返却]
    B --> C{戻り値}
    C -->|0| D[シングルスレッドモード]
    C -->|1| E[シリアライズモード]
    C -->|2| F[マルチスレッドモード]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | モード0（シングルスレッド） | ミューテックスコードが省略される。複数スレッドからの同時使用不可 | SQLITE_THREADSAFE=0でコンパイル |
| BR-002 | モード1（シリアライズ） | 全てのAPI呼び出しがシリアライズされる。同一接続を複数スレッドで安全に使用可能 | SQLITE_THREADSAFE=1でコンパイル（デフォルト） |
| BR-003 | モード2（マルチスレッド） | 異なる接続は並行使用可能だが、同一接続の並行使用は不可 | SQLITE_THREADSAFE=2でコンパイル |
| BR-004 | 実行時変更不可 | 戻り値はコンパイル時に決定され、実行時に変更不可 | 常時 |

### 計算ロジック

特に計算ロジックは存在しない。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない（情報取得のみ）。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

本機能はエラーを発生させない。常に有効な値（0、1、または2）を返却する。

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| （なし） | - | - | - |

### リトライ仕様

リトライは不要（エラーが発生しない）。

## トランザクション仕様

本機能はトランザクション処理を伴わない。

## パフォーマンス要件

- 定数値を返却するのみで、実質的にオーバーヘッドなし
- 関数呼び出しのコストは数ナノ秒程度

## セキュリティ考慮事項

- スレッドセーフモードの情報公開自体にセキュリティ上の問題はない
- ただし、シングルスレッドモードで複数スレッドから使用した場合、データ破損やクラッシュの原因となる

## 備考

- sqlite3_threadsafe()の戻り値は、sqlite3_config(SQLITE_CONFIG_SINGLETHREAD/MULTITHREAD/SERIALIZED)による実行時設定とは異なる
- 実行時設定は接続単位で変更可能だが、コンパイル時設定（この関数の戻り値）は変更できない
- SQLITE_THREADSAFE=0でコンパイルされた場合、実行時にスレッドセーフモードを有効にすることはできない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 定数定義を理解する

まず、スレッドセーフ設定がどこで定義されているかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | sqlite3.h | `src/sqlite3.h` | SQLITE_THREADSAFEマクロの公開定義 |
| 1-2 | sqliteInt.h | `src/sqliteInt.h` | 内部でのスレッドセーフ設定参照 |

**読解のコツ**: SQLITE_THREADSAFEはコンパイル時オプションとして外部から定義可能。デフォルト値は1（シリアライズモード）。

#### Step 2: 実装を理解する

sqlite3_threadsafe()関数の実装を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.c | `src/main.c` | sqlite3_threadsafe()の実装 |

**主要処理フロー**:
1. **113-117行目**: sqlite3_threadsafe()の実装
2. **113-116行目**: 関数ドキュメント（IMPLEMENTATION-OF参照）
3. **117行目**: SQLITE_THREADSAFE定数を直接返却

#### Step 3: ミューテックスとの関連を理解する

スレッドセーフ設定がミューテックス実装にどう影響するかを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mutex.c | `src/mutex.c` | スレッドセーフ設定によるミューテックス実装の選択 |
| 3-2 | mutex_noop.c | `src/mutex_noop.c` | SQLITE_THREADSAFE=0時の空実装 |
| 3-3 | mutex_unix.c | `src/mutex_unix.c` | UNIX系でのpthreadミューテックス実装 |

**主要処理フロー**:
- SQLITE_THREADSAFE=0時：mutex_noop.cの空実装が使用される
- SQLITE_THREADSAFE>0時：プラットフォーム固有の実装が使用される

### プログラム呼び出し階層図

```
sqlite3_threadsafe()              [main.c:117]
    └─ SQLITE_THREADSAFE          [コンパイル時定数]
           │
           └─ ミューテックス実装選択
                  │
                  ├─ SQLITE_THREADSAFE=0 → mutex_noop.c
                  │
                  └─ SQLITE_THREADSAFE>0 → mutex_unix.c / mutex_w32.c
```

### データフロー図

```
[コンパイル時]                    [実行時]

-DSQLITE_THREADSAFE=N ──▶ SQLITE_THREADSAFE ──▶ sqlite3_threadsafe()
(コンパイルオプション)      (定数)                      │
                                                        ▼
                                                    int 戻り値 (0, 1, or 2)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.c | `src/main.c` | ソース | sqlite3_threadsafe()の実装 |
| sqlite3.h | `src/sqlite3.h` | ヘッダー | 公開API宣言 |
| sqliteInt.h | `src/sqliteInt.h` | ヘッダー | 内部定数定義 |
| mutex.c | `src/mutex.c` | ソース | ミューテックスAPIディスパッチャ |
| mutex_noop.c | `src/mutex_noop.c` | ソース | シングルスレッド用空実装 |
| mutex_unix.c | `src/mutex_unix.c` | ソース | UNIX系ミューテックス実装 |
