---
generated_at: 2026-01-21 22:20:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：10-CREATE TABLE処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（数十ミリ秒以内）**：具体的な実測値の根拠なし
  2. **型アフィニティ決定ロジックの詳細**：アルゴリズムの完全な検証

## 2) 参照した情報（Evidence一覧）

- E-01: `src/build.c` 全体 - CREATE TABLE処理の実装
- E-02: `src/build.c` 27-37行目 - TableLock構造体
- E-03: `src/build.c` 49-96行目 - lockTable()、sqlite3TableLock()
- E-04: `src/build.c` 141-278行目 - sqlite3FinishCoding()
- E-05: `src/sqliteInt.h` - Table、Column、Index構造体
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CREATE TABLE文によるテーブル作成処理 | E-01, E-07 | ○ |
| C-02 | build.cに実装されている | E-01, E-07 | ○ |
| C-03 | TableLock構造体でロック管理 | E-02 | ○ |
| C-04 | lockTable()とsqlite3TableLock()でロック | E-03 | ○ |
| C-05 | sqlite3FinishCoding()でVDBE完成 | E-04 | ○ |
| C-06 | Table、Column、Index構造体の使用 | E-05 | ○ |
| C-07 | sqlite3StartTable()でTable構造体初期化 | E-01 | ○ |
| C-08 | sqlite3AddColumn()でカラム追加 | E-01 | ○ |
| C-09 | sqlite3EndTable()でテーブル定義確定 | E-01 | ○ |
| C-10 | 関連画面が2画面存在 | E-06 | ○ |
| C-11 | sqlite_schemaへのスキーマ登録 | E-01 | ○ |
| C-12 | B-Tree作成 | E-01 | ○ |
| C-13 | WITHOUT ROWID制約（PRIMARY KEY必須） | E-01 | ○ |
| C-14 | STRICT制約（型指定必須） | E-01 | ○ |
| C-15 | AUTOINCREMENT制約 | E-01 | ○ |
| C-16 | 処理シーケンス（9ステップ） | E-01 | ○ |
| C-17 | プログラム呼び出し階層図が正確 | E-01, E-03, E-04 | ○ |
| C-18 | 行番号27-37、49-96、141-278の範囲が正確 | E-02, E-03, E-04 | ○ |
| C-19 | SQLITE_ERRORエラー（テーブル重複） | E-01 | ○ |
| C-20 | sqlite_プレフィックス禁止 | E-01 | ○ |
| C-21 | IF NOT EXISTS対応 | E-01 | ○ |
| C-22 | CREATE TABLE AS SELECT対応 | E-01 | ○ |
| C-23 | 生成列（GENERATED ALWAYS AS）対応 | E-01 | ○ |
| C-24 | authorizerによる許可制御 | E-01 | ○ |
| C-25 | 関連ファイル一覧が正確 | E-01 | ○ |
| C-26 | 仮想テーブルは別処理（vtab.c） | E-07 | ○ |
| C-27 | テーブル作成は数十ミリ秒以内 | **根拠なし** | △ |
| C-28 | 型アフィニティ決定ロジックの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「数十ミリ秒以内」の具体的な実測データ
  - 候補：ベンチマーク結果 / SQLite公式ドキュメント
- 型アフィニティ決定アルゴリズムの完全な検証
  - 候補：build.cの型アフィニティ決定コード / SQLite公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：主要なCREATE TABLE処理は十分に文書化されている
- 1（中リスク）：パフォーマンス要件は環境依存のため実測確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] CREATE TABLE処理フローがソースコードと一致しているか確認
- [ ] 関連画面一覧が画面機能マッピング.csvと整合しているか確認
- [ ] 型アフィニティ決定ロジックが正確に説明されているか確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
