---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-DROP_TABLE処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **auto_vacuumモード時の動作**：詳細動作の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/build.c` 3490-3594行目 sqlite3DropTable()関数
- E-02: `src/build.c` 3382-3449行目 sqlite3CodeDropTable()関数
- E-03: `src/build.c` 3359-3377行目 sqlite3ClearStatTables()関数
- E-04: `src/build.c` 3471-3484行目 tableMayNotBeDropped()関数
- E-05: `src/build.c` 14-24行目 ファイルヘッダーコメント（DROP TABLEの記載）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 画面No.8との関連
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.11の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DROP TABLEはbuild.cで実装される | E-05 | ○ |
| C-02 | sqlite3DropTable()がエントリーポイント | E-01 | ○ |
| C-03 | 認証チェックはsqlite3AuthCheck()で実行 | E-01 (3531行目) | ○ |
| C-04 | システムテーブルは削除不可 | E-04 | ○ |
| C-05 | sqlite_stat*は例外的に削除可能 | E-04 (3473行目) | ○ |
| C-06 | sqlite_parametersは例外的に削除可能 | E-04 (3474行目) | ○ |
| C-07 | シャドウテーブルはDefensiveモードで保護 | E-04 (3477-3479行目) | ○ |
| C-08 | エポニマステーブルは削除不可 | E-04 (3480-3481行目) | ○ |
| C-09 | VIEW/TABLE区別チェックが存在 | E-01 (3565-3576行目) | ○ |
| C-10 | IF EXISTS指定時はエラーを抑制 | E-01 (3504, 3510-3514行目) | ○ |
| C-11 | sqlite3BeginWriteOperation()で書き込み開始 | E-01 (3584行目) | ○ |
| C-12 | sqlite3ClearStatTables()で統計削除 | E-01 (3586行目), E-03 | ○ |
| C-13 | sqlite3FkDropTable()で外部キー処理 | E-01 (3587行目) | ○ |
| C-14 | sqlite3CodeDropTable()で削除コード生成 | E-01 (3589行目), E-02 | ○ |
| C-15 | トリガーはループで削除される | E-02 (3402-3408行目) | ○ |
| C-16 | AUTOINCREMENTはsqlite_sequenceから削除 | E-02 (3416-3421行目) | ○ |
| C-17 | TF_Autoincrementフラグでチェック | E-02 (3416行目) | ○ |
| C-18 | OP_DropTable命令が生成される | E-02 (3446行目) | ○ |
| C-19 | スキーマクッキーが更新される | E-02 (3447行目) | ○ |
| C-20 | 仮想テーブル時OP_VDestroyが生成される | E-02 (3443行目) | ○ |
| C-21 | sqlite_stat1〜4が対象 | E-03 (3367行目) | ○ |
| C-22 | 画面No.8 SQLite3 Fiddleと関連 | E-06 | ○ |
| C-23 | 機能No.11として定義 | E-07 | ○ |
| C-24 | テーブルサイズに比例した処理時間 | **根拠なし** | △ |
| C-25 | auto_vacuumモードでページ再編成発生 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件について具体的なベンチマーク結果やドキュメントが見つからない
  - 候補：SQLite公式ドキュメント / パフォーマンステスト結果 / ソースコード内コメント
- auto_vacuumモード時の詳細動作について
  - 候補：pager.c / btree.c 内のauto_vacuum関連コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本的な動作説明（コードから直接確認可能）
- 1: 中リスク - パフォーマンス要件（推測に基づく記述）
- 0: 低リスク - セキュリティ考慮事項（コードから確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の記述が実際の動作と一致するか確認
- [ ] auto_vacuumモード時の動作を実機で検証
- [ ] 外部キー制約処理（sqlite3FkDropTable）の詳細動作を確認
- [ ] 仮想テーブル削除時のxDestroy呼び出しタイミングを確認
