---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：12-CREATE_INDEX処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（インデックス構築時間）**：具体的なベンチマークなし
  2. **sqlite3RefillIndex()の詳細動作**：関数本体の詳細解析が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/build.c` 3936-4499行目 sqlite3CreateIndex()関数
- E-02: `src/build.c` 3908-3922行目 sqlite3HasExplicitNulls()関数
- E-03: `src/build.c` 18行目 ファイルヘッダーコメント（CREATE INDEXの記載）
- E-04: `src/build.c` 4067-4107行目 インデックス名決定ロジック
- E-05: `src/build.c` 4159-4182行目 Index構造体割り当て
- E-06: `src/build.c` 4455-4462行目 sqlite_schema INSERT文
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.12の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CREATE INDEXはbuild.cで実装される | E-03 | ○ |
| C-02 | sqlite3CreateIndex()がエントリーポイント | E-01 | ○ |
| C-03 | NULLS FIRST/LASTはサポート外 | E-02 | ○ |
| C-04 | sqlite_*テーブルはインデックス不可 | E-01 (4034-4039行目) | ○ |
| C-05 | VIEWはインデックス不可 | E-01 (4042-4045行目) | ○ |
| C-06 | VIRTUAL TABLEはインデックス不可 | E-01 (4048-4051行目) | ○ |
| C-07 | 自動インデックス名はsqlite_autoindex_テーブル名_N | E-04 (4096行目) | ○ |
| C-08 | IN_SPECIAL_PARSE時は名前変更 | E-04 (4106行目) | ○ |
| C-09 | 認証チェックはSQLITE_CREATE_INDEX | E-01 (4117行目) | ○ |
| C-10 | TEMP時はSQLITE_CREATE_TEMP_INDEX | E-01 (4118行目) | ○ |
| C-11 | pList==NULL時は最後の列を使用 | E-01 (4129-4138行目) | ○ |
| C-12 | sqlite3AllocateIndexObject()で割り当て | E-05 | ○ |
| C-13 | aiColumnに列インデックスを格納 | E-01 (4244行目) | ○ |
| C-14 | XN_EXPR(-2)は式インデックス | E-01 (4227行目) | ○ |
| C-15 | 重複インデックスチェックが存在 | E-01 (4333-4374行目) | ○ |
| C-16 | OP_CreateBtreeでルートページ作成 | E-01 (4435行目) | ○ |
| C-17 | INSERT INTO sqlite_schemaで登録 | E-06 | ○ |
| C-18 | sqlite3RefillIndex()でインデックス構築 | E-01 (4469行目) | ○ |
| C-19 | sqlite3ChangeCookie()でスキーマ更新 | E-01 (4470行目) | ○ |
| C-20 | カバリングインデックスのisCoveringフラグ | E-01 (4301行目) | ○ |
| C-21 | WITHOUT ROWID時PRIMARY KEY列を追加 | E-01 (4273-4287行目) | ○ |
| C-22 | 機能No.12として定義 | E-07 | ○ |
| C-23 | インデックス構築時間はテーブル行数に比例 | **根拠なし** | △ |
| C-24 | sqlite3RefillIndex()でソート処理を伴う | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- sqlite3RefillIndex()関数の詳細実装（本レポートでは呼び出しのみ確認）
  - 候補：build.c内の関数定義を詳細解析
- パフォーマンス特性の定量データ
  - 候補：SQLite公式ベンチマーク / テスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本的な動作説明（コードから直接確認可能）
- 1: 中リスク - パフォーマンス要件（推測に基づく記述）
- 0: 低リスク - エラー処理（コードから確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] sqlite3RefillIndex()の実装詳細を確認
- [ ] 式インデックス（expression index）の動作を実機検証
- [ ] 部分インデックス（partial index）のWHERE句評価を確認
- [ ] 大規模テーブルでのインデックス構築時間を計測
