---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：13-DROP_INDEX処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（auto_vacuum時の動作）**：詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/build.c` 4590-4655行目 sqlite3DropIndex()関数
- E-02: `src/build.c` 19行目 ファイルヘッダーコメント（DROP INDEXの記載）
- E-03: `src/build.c` 3357行目 DROP INDEX関連コメント
- E-04: `src/build.c` 3359-3377行目 sqlite3ClearStatTables()関数
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.13の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DROP INDEXはbuild.cで実装される | E-02 | ○ |
| C-02 | sqlite3DropIndex()がエントリーポイント | E-01 | ○ |
| C-03 | メモリアロケーションチェックが最初に実行 | E-01 (4596-4598行目) | ○ |
| C-04 | sqlite3FindIndex()でインデックス検索 | E-01 (4606行目) | ○ |
| C-05 | IF EXISTS時はエラーを抑制 | E-01 (4608-4613行目) | ○ |
| C-06 | インデックス不存在時checkSchema=1 | E-01 (4614行目) | ○ |
| C-07 | 制約インデックスは削除不可 | E-01 (4617-4620行目) | ○ |
| C-08 | idxType != SQLITE_IDXTYPE_APPDEFでチェック | E-01 (4617行目) | ○ |
| C-09 | 認証チェックはSQLITE_DELETE | E-01 (4629行目) | ○ |
| C-10 | 認証チェックはSQLITE_DROP_INDEX | E-01 (4633行目) | ○ |
| C-11 | TEMP時はSQLITE_DROP_TEMP_INDEX | E-01 (4632行目) | ○ |
| C-12 | sqlite3BeginWriteOperation()で書き込み開始 | E-01 (4642行目) | ○ |
| C-13 | DELETE FROM sqlite_schemaで削除 | E-01 (4643-4646行目) | ○ |
| C-14 | sqlite3ClearStatTables()で統計削除 | E-01 (4647行目), E-04 | ○ |
| C-15 | 統計削除は"idx"タイプで実行 | E-01 (4647行目) | ○ |
| C-16 | sqlite3ChangeCookie()でスキーマ更新 | E-01 (4648行目) | ○ |
| C-17 | destroyRootPage()でB-Tree破棄 | E-01 (4649行目) | ○ |
| C-18 | OP_DropIndex命令が生成される | E-01 (4650行目) | ○ |
| C-19 | 機能No.13として定義 | E-05 | ○ |
| C-20 | auto_vacuumモードでページ再編成発生 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- auto_vacuumモード時の詳細動作
  - 候補：btree.c / pager.c 内のauto_vacuum関連コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本的な動作説明（コードから直接確認可能）
- 1: 中リスク - パフォーマンス要件（推測に基づく記述）
- 0: 低リスク - エラー処理（コードから確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] destroyRootPage()の実装詳細を確認
- [ ] auto_vacuumモード時のページ再編成動作を検証
- [ ] 制約インデックス削除時のエラーメッセージを実機確認
